-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = 'auxilliary'
M.relevantDevice = nil

function round(num, numDecimalPlaces)
  return tonumber(string.format("%." .. (numDecimalPlaces or 0) .. "f", num))
end

local function init()
	for x = 1000, 7001, 200 do
		electrics.values["rpm_" .. tostring(x)] = 0
	end
	
	for y = 0, 9 do
		electrics.values["speed_1_" .. tostring(y)] = 0
	end
	for y = 0, 9 do
		electrics.values["speed_10_" .. tostring(y)] = 0
	end
	for y = 0, 9 do
		electrics.values["speed_100_" .. tostring(y)] = 0
	end
end

local function updateGFX(dt)

    local vals = M.values
	
	local wspd = round(electrics.values["wheelspeed"]*2.237,0)
	
	for x = 1000, 7001, 200 do
		if electrics.values["rpm"] >= x then
			electrics.values["rpm_" .. tostring(x)] = 1
		else
			electrics.values["rpm_" .. tostring(x)] = 0
		end
	end
	
	for y = 0, 9 do
		if wspd % 10 >= y and wspd % 10 < y+1 then
			electrics.values["speed_1_" .. tostring(y)] = 1
		else
			electrics.values["speed_1_" .. tostring(y)] = 0
		end
	end
	for y = 0, 90, 10 do
		if wspd % 100 >= y and wspd % 100 < y+10 then
			electrics.values["speed_10_" .. tostring(math.floor(y/10))] = 1
		else
			electrics.values["speed_10_" .. tostring(math.floor(y/10))] = 0
		end
	end
	for y = 0, 900, 100 do
		if wspd % 1000 >= y and wspd % 1000 < y+100 then
			electrics.values["speed_100_" .. string.gsub(tostring(y),"0","")] = 1
		else
			electrics.values["speed_100_" .. string.gsub(tostring(y),"0","")] = 0
		end
	end
	if wspd < 10 then electrics.values["speed_10_0"] = 0 end
end

M.init = init
M.updateGFX = updateGFX

return M