angular.module('gaugesScreen', [])

  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0];
    var navDimensions = [];

    var gauge = { gears: {} };
    var tacho = {  };
    var infoDisplay = {};
    var roots = {};
    var electrics = {lights:{} };
    var gagues = {fuel:{},temp:{}};


    var speedoInitialised = true;
    var currentGear = '';

    var ready = false;

    var unit = "metric";
    var unitspeedConv = 2.23694;


    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
        console.log("onSVGLoaded");
      svg = $element[0].children[0].children[0];

	  gauge.speedValue0 = hu('#speed_0', svg);
	  gauge.speedValue00 = hu('#speed_00', svg);
	  gauge.speedValue000 = hu('#speed_000', svg);
	  gauge.speedUnits = hu('#speed_unit_txt', svg);

      // speedometer
      gauge.gears.P = hu('#gear_P', svg);
      gauge.gears.R = hu('#gear_R', svg);
      gauge.gears.N = hu('#gear_N', svg);
      gauge.gears.D = hu('#gear_D', svg);
	  gauge.gears["M1"] = hu('#gear_M1', svg);
      gauge.gears["M2"] = hu('#gear_M2', svg);
      gauge.gears["M3"] = hu('#gear_M3', svg);
      gauge.gears["M4"] = hu('#gear_M4', svg);
      gauge.gears["M5"] = hu('#gear_M5', svg);
      gauge.gears["M6"] = hu('#gear_M6', svg);
	  
	  gauge.gears["S1"] = hu('#gear_S1', svg);
      gauge.gears["S2"] = hu('#gear_S2', svg);
      gauge.gears["S3"] = hu('#gear_S3', svg);
      gauge.gears["S4"] = hu('#gear_S4', svg);
      gauge.gears["S5"] = hu('#gear_S5', svg);
      gauge.gears["S6"] = hu('#gear_S6', svg);	 


      electrics.mode_txt = hu("#mode_txt", electrics.root);
      electrics.mode_txt.text("ready")
		
      electrics.root = hu('#electrics', svg);

      ready = true;
    }


    function fixClock(v, fill="0"){
      return (v<10)? fill+v : v;
    }

    function updateGearIndicator(data) {
      // only update when gear is changed
      if (currentGear !== data.electrics.gear) {
        currentGear = data.electrics.gear;
        if(data.powertrain.gearbox.type === "automaticGearbox"){//auto
          for (var key in gauge.gears) {
            gauge.gears[key].n.style.display = (key === data.electrics.gear)?"inline":"none";
          }
        } else {//other (manual,seq)
          for (var key in gauge.gears) {
            gauge.gears[key].n.style.display = "none";
          }
          gauge.gears = {}; //remove ref, so we don't iterate over it again
        }
      }
    }
	
	function updateSpeedDisplays(data){
		var spdTxt = (data.electrics.wheelspeed * unitspeedConv).toFixed(0);
			if (data.electrics.wheelspeed * unitspeedConv < 9) {
				gauge.speedValue0.text(spdTxt);
				gauge.speedValue00.text("");
				gauge.speedValue000.text("");
			} else if (data.electrics.wheelspeed * unitspeedConv > 9 && data.electrics.wheelspeed * unitspeedConv < 99.5) {
				gauge.speedValue0.text("");
				gauge.speedValue00.text(spdTxt);
				gauge.speedValue000.text("");
			} else if (data.electrics.wheelspeed * unitspeedConv >= 99.5){
				gauge.speedValue0.text("");
				gauge.speedValue00.text("");
				gauge.speedValue000.text(spdTxt);
			} else {
				gauge.speedValue00.text("ERR");
			}
	}	
	
	function updateSpeedUnits(data) {
      if(data.unit == "metric"){
		  gauge.speedUnits.text("KM/H");
		  unitspeedConv = 3.6;
	  } else {
		  gauge.speedUnits.text("MPH");
		  unitspeedConv = 2.23694;
	  }
    }

    function limitVal(min, val,max){
        return Math.min(Math.max(min,val), max);
    }

	$window.updateMode = (data) => {
      if(!ready){
        console.log("calling updateMode while svg not fully loaded");
        setTimeout(function(){ $window.updateMode(data) }, 100);
        return;
      }
	  
		electrics.mode_txt.text(data.txt);
	}

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      if(!ready){
        console.log("calling setup while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }

      //console.log("setup",data);

    }


    function setElec(val, state, key){
      if( val === undefined || val === null){console.error("setElec: svg element not found", key); return;}
      if( state === undefined || state === null){console.error("setElec: state not found", key);val.n.style.display = "none"; return;}
      var cssState = (state===true || state>0.1)?"inline":"none";
	  val.n.style.display = cssState;
      //val.n.setAttribute("opacity", (state || state>0.1)?1.0:0.3)
    }

    $window.updateElectrics = (data) => {
      for(var k in electrics.lights){
        setElec(electrics.lights[k], data.electrics[k], k);
      }
    }


    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
        // console.log(data);

        // Update PRNDS display
        updateGearIndicator(data);
        updateSpeedDisplays(data);
        updateSpeedUnits(data);
        // Update Speed displays
        updateElectrics(data);
      }
    }
    //ready = true;
  });