-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local gear_A = 0
local gearIndex = 0

local function onInit()
  electrics.values['disp_P'] = 0
  electrics.values['disp_R'] = 0
  electrics.values['disp_Ra'] = 0
  electrics.values['disp_N'] = 0
  electrics.values['disp_Na'] = 0
  electrics.values['disp_D'] = 0
  electrics.values['disp_M'] = 0 -- الوضع الجديد للمانول
end

local function reset()
  onInit()
end

local function updateGFX(dt)
  gearIndex = electrics.values.gearIndex or 0
  gear_A = electrics.values['gear_A'] or 0

  -- Reverse Manual
  if gearIndex < -0.5 then
    electrics.values['disp_R'] = 1
  else
    electrics.values['disp_R'] = 0
  end

  -- Neutral (ما يشتغل مع P)
  if gearIndex >= -0.5 and gearIndex < 0.5 and gear_A >= 0.05 then
    electrics.values['disp_N'] = 1
  else
    electrics.values['disp_N'] = 0
  end

  -- Manual Mode (يشمل كل النمر من 1 إلى 7)
  if gearIndex >= 0.5 then
    electrics.values['disp_M'] = 1
  else
    electrics.values['disp_M'] = 0
  end

  -- Park Auto
  if gear_A < 0.05 then
    electrics.values['disp_P'] = 1
  else
    electrics.values['disp_P'] = 0
  end

  -- Reverse Auto
  if gear_A >= 0.05 and gear_A < 0.15 then
    electrics.values['disp_Ra'] = 1
  else
    electrics.values['disp_Ra'] = 0
  end

  -- Neutral Auto
  if gear_A >= 0.15 and gear_A < 0.25 then
    electrics.values['disp_Na'] = 1
  else
    electrics.values['disp_Na'] = 0
  end

  -- Drive Auto
  if gear_A >= 0.25 and gear_A < 0.35 then
    electrics.values['disp_D'] = 1
    -- إلغاء أي مؤشر مانول أثناء القيادة الأوتوماتيكية
    electrics.values['disp_M'] = 0
  else
    electrics.values['disp_D'] = 0
  end
end

-- public interface
M.onInit    = onInit
M.reset     = reset
M.updateGFX = updateGFX

return M
