angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window) {
  var units = {
    uiUnitLength: "imperial",  // نحدد الوحدة imperial افتراضياً
    uiUnitConsumptionRate: "imperial",
    uiUnitDate: "ger",
    uiUnitEnergy: "imperial",
    uiUnitPower: "hp",
    uiUnitPressure: "bar",
    uiUnitTemperature: "c",
    uiUnitTorque: "imperial",
    uiUnitVolume: "l",
    uiUnitWeight: "kg"
  };

  $scope.data = {
    speedVal: 0,
    speedUnit: 'MPH',
    gear: 'P',
    consumptionVal: '',
    consumptionUnit: '',
    odo: ''
  };

  $window.setup = (setupData) => {
    for (let key in setupData) {
      if (typeof key === "string" && key.startsWith("uiUnit")) {
        units[key] = setupData[key];
      }
    }

    // نحدد وحدة السرعة دائماً MPH للكورفيت
    $scope.data.speedUnit = "MPH";

    if (units.uiUnitConsumptionRate === "metric") {
      $scope.data.consumptionUnit = "l/100km";
    } else {
      $scope.data.consumptionUnit = "mpg";
      var markOne = document.getElementById('markOne');
      if (markOne) markOne.textContent = "30";
      var markTwo = document.getElementById('markTwo');
      if (markTwo) markTwo.textContent = "20";
      var markThree = document.getElementById('markThree');
      if (markThree) markThree.textContent = "10";
      var markFour = document.getElementById('markFour');
      if (markFour) markFour.textContent = "0";
    }
  };

  $window.updateData = (data) => {
    $scope.$evalAsync(() => {
      if (data.electrics && data.electrics.wheelspeed !== undefined) {
        // تحويل السرعة من m/s إلى mph يدوياً
        let speedMph = (data.electrics.wheelspeed * 2.23694).toFixed(0);
        $scope.data.speedVal = speedMph;
      }

      if (data.electrics && data.electrics.gear !== undefined) {
        let gear = data.electrics.gear;
        // نعرض الحرف فقط من النمرات مثل S1 أو M2
        if (typeof gear === "string") {
          $scope.data.gear = gear.replace(/\d+/g, ''); // إزالة الأرقام
        } else if (gear === -1) {
          $scope.data.gear = "R";
        } else if (gear === 0) {
          $scope.data.gear = "N";
        } else {
          $scope.data.gear = gear;
        }
      }

      if (data.customModules && data.customModules.combustionEngineData) {
        let val = data.customModules.combustionEngineData.averageFuelConsumption * 1e-5;
        let conso = UiUnits.consumptionRate(val);
        if (conso.val === "n/a") {
          $scope.data.consumptionVal = "---";
        } else {
          $scope.data.consumptionVal = conso.val.toFixed(1);
        }
      }

      if (data.electrics && data.electrics.odometer) {
        let val = data.electrics.odometer;
        // تحويل الأودوميتر إلى الميل أيضاً
        val *= 0.0006215; // متر إلى ميل
        val = Math.min(999999, val);
        $scope.data.odo = val.toFixed(0) + "mi";
      } else {
        $scope.data.odo = "";
      }
    });
  };
});
