local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

--Created by Inn0centJok3r

local needleSmoother = newTemporalSmoothingNonLinear(13)
local needleSmootherOff = newExponentialSmoothing(40) 
local gaugeType
local ignition = 0
local readyForStartup = false
local timer = 0
local wheelspeed = 0
local needlePos = 0
local engineOffSmoothen = 0

local function lerp(a,b,t) 
    return a * (1-t) + b * t 
end

local function clamp(min, max, val)
	if val < min then
		val = min
	elseif max < val then
		val = max
	end
	return val
end

local function updateGFX(dt) 
    if electrics.values["wheelspeed"] == nil then 
        electrics.values["innocent_custom_wheelspeed"] = 0
        electrics.values.acmrs4SpeedoLow = 0
        electrics.values.acmrs4SpeedoHigh = 0
        electrics.values.acmrs4Speedo = 0
        return
    end
    
    ignition = electrics.values["ignitionLevel"]
    wheelspeed = electrics.values["wheelspeed"]
    
    if ignition < 2 and not readyForStartup then
        readyForStartup = true
        timer = 0
    end

    if gaugeType == "ice" then
        if readyForStartup and ignition >= 2 then
            timer = timer + dt
            if timer < 1.0 then
                needlePos = math.min(needlePos + 80 * dt, 85) -- Ускоренное движение
            elseif timer >= 1.0 and timer < 2.4 then
                needlePos = math.max(needlePos - 80 * dt, 0) -- Ускоренное движение
            elseif timer >= 2.4 and timer < 3 then
                needlePos = wheelspeed
            else
                needlePos = 0
                timer = 0
                readyForStartup = false
            end
            electrics.values["innocent_custom_wheelspeed"] = needlePos
        else
            if needlePos ~= 0 and timer ~= 0 and readyForStartup then 
                needlePos = 0
                timer = 0
                readyForStartup = false
            end
            if ignition >= 2 then
                electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(wheelspeed, dt)
                engineOffSmoothen = needleSmootherOff:get(wheelspeed, dt)
            else
                engineOffSmoothen = needleSmootherOff:get(0, dt)
                electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(engineOffSmoothen, dt)
            end
        end
    end
    
    -- Объединяем обе переменные в одну для корректной работы обоих указателей
    local finalSpeedoValue = electrics.values["innocent_custom_wheelspeed"]
    electrics.values.acmrs4SpeedoLow = finalSpeedoValue
    electrics.values.acmrs4SpeedoHigh = 20 / 1.6 + (finalSpeedoValue / 2)
    if finalSpeedoValue < 60 / 2.4 then 
        electrics.values.acmrs4Speedo = electrics.values.acmrs4SpeedoLow  
    else
        electrics.values.acmrs4Speedo = electrics.values.acmrs4SpeedoHigh
    end	
end

local function init(jbeamData)
    electrics.values["innocent_custom_wheelspeed"] = 0
    electrics.values.acmrs4SpeedoLow = 0
    electrics.values.acmrs4SpeedoHigh = 0
    electrics.values.acmrs4Speedo = 0
    gaugeType = jbeamData.gaugeType or "ice"
    wheelspeed = 0
    timer = 0
    needlePos = 0
    engineOffSmoothen = 0
    readyForStartup = false
end 

M.updateGFX = updateGFX
M.init = init
M.onInit = init
M.onReset = init

return M