-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

-- Reset the electric values for all wheels and actions
local function onReset()
  electrics.values['lifter_F'] = 0
  electrics.values['lifter_F_input'] = 0
  electrics.values['lifter_FR'] = 0
  electrics.values['lifter_FR_input'] = 0
  electrics.values['lifter_R'] = 0
  electrics.values['lifter_R_input'] = 0
  electrics.values['lifter_RR'] = 0
  electrics.values['lifter_RR_input'] = 0
  electrics.values['shoot'] = 0
end

-- Helper function to update the lifter values for a specific wheel
local function updateLifterValue(lifterKey, inputKey, dt)
  electrics.values[lifterKey] = math.min(1, math.max(0, electrics.values[lifterKey] + electrics.values[inputKey] * dt * 0.2))
end

-- Update the graphics and lifter values for all wheels
local function updateGFX(dt) -- ms
  -- Update lifter values for each wheel
  updateLifterValue('lifter_F', 'lifter_F_input', dt)
  updateLifterValue('lifter_FR', 'lifter_FR_input', dt)
  updateLifterValue('lifter_R', 'lifter_R_input', dt)
  updateLifterValue('lifter_RR', 'lifter_RR_input', dt)
end

-- Adjust the lifter values for each wheel (front left, front right, rear left, rear right)
local function liftWheel(wheel, value)
  if wheel == "F" then
    electrics.values.lifter_F_input = value
  elseif wheel == "FR" then
    electrics.values.lifter_FR_input = value
  elseif wheel == "R" then
    electrics.values.lifter_R_input = value
  elseif wheel == "RR" then
    electrics.values.lifter_RR_input = value
  end
end

-- Public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.liftWheel = liftWheel

return M
