-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M, device = {}
local engine = nil
--Сглаживание приборов
local batterygaugeSmoother = newExponentialSmoothing(128)
local watergaugeSmoother = newExponentialSmoothing(128)
local oilgaugeSmoother = newExponentialSmoothing(128)
local fuelgaugeSmoother = newExponentialSmoothing(66)
local hazardStalkSmoother = newExponentialSmoothing(16)
local ignitionKeySmoother = newExponentialSmoothing(16)
--Сглаживание тумблеров и кнопок
local intLightSmoother = newExponentialSmoothing(8)
local intDoorwayFSmoother = newExponentialSmoothing(8)
local intDoorwayRSmoother = newExponentialSmoothing(8)
local extDoorwayFSmoother = newExponentialSmoothing(8)
local extDoorwayRSmoother = newExponentialSmoothing(8)
local serviceLightSmoother = newExponentialSmoothing(8)
local rooffanFSWSmoother = newExponentialSmoothing(8)
local rooffanRSWSmoother = newExponentialSmoothing(8)
local rooffanFModeSmoother = newExponentialSmoothing(8)
local rooffanRModeSmoother = newExponentialSmoothing(8)
local susRDSWSmoother = newExponentialSmoothing(8)
local susURSWSmoother = newExponentialSmoothing(8)
local suspensionLockSmoother = newExponentialSmoothing(8)
local masterSwitchSWSmoother = newExponentialSmoothing(8)
local kneelSWSmoother = newExponentialSmoothing(8)
local engineStopSmoother = newExponentialSmoothing(8)

--Лючки через пропы
local openableFuelHatchSmoother = newExponentialSmoothing(64)
local openableCoolantHatchSmoother = newExponentialSmoothing(64)
local openableRouteAdvisorHatchLSmoother = newExponentialSmoothing(64)
local openableRouteAdvisorHatchRSmoother = newExponentialSmoothing(64)
--Звуки


local function onInit()
	for k, node in pairs (v.data.nodes) do
		if node.name == "sc2" then sidepanelnode = k end
		if node.name == "gp2r" then dashboardnode = k end
	end
	
	local engines = powertrain.getDevicesByCategory("engine")

	if type(engines) == "table" and type(engines[1]) == "table" then
		engine = engines[1]
	end
	--lights thing
	electrics.values.highlight = 0
	electrics.values.highlight_input = 0
	electrics.values.taillight = 0
	electrics.values.cornering_L = 0
	electrics.values.cornering_R = 0
	electrics.values.boardingScreen = 0
	M.onReset()
end

local function onReset()
	electrics.values.oilPressure = 0
	electrics.values.oilVolume = 0
	--Свет
	electrics.values.interiorlight = 0
	electrics.values.interiorDoorwayF = 0
	electrics.values.interiorDoorwayR = 0
	electrics.values.exteriorDoorwayF = 0
	electrics.values.exteriorDoorwayR = 0
	electrics.values.serviceSL = 0
	--Свет (тумблеры)
	electrics.values.interiorlightSW = 0
	electrics.values.interiorDoorwayFSW = 0
	electrics.values.interiorDoorwayRSW = 0
	electrics.values.exteriorDoorwayFSW = 0
	electrics.values.exteriorDoorwayRSW = 0
	electrics.values.serviceSLSW = 0
	--Свет (сглаживание тумблеров)
	electrics.values.intLightSmooth = 0
	electrics.values.intDoorwayFSmooth = 0
	electrics.values.intDoorwayRSmooth = 0
	electrics.values.extDoorwayFSmooth = 0
	electrics.values.extDoorwayRSmooth = 0
	electrics.values.serviceLightSmooth = 0
	--Вентиляторы
	electrics.values.rooffanF = 0
	electrics.values.rooffanR = 0
	electrics.values.rooffanFMode = 1
	electrics.values.rooffanRMode = 1
	electrics.values.rooffanFSW = 0
	electrics.values.rooffanRSW = 0
	--Вентиляторы (сглаживание тумблеров)
	electrics.values.rooffanFSWSmooth = 0
	electrics.values.rooffanRSWSmooth = 0
	electrics.values.rooffanFModeSmooth = 0
	electrics.values.rooffanRModeSmooth = 0
	--Подвеска (кнопки)
	electrics.values.susRDSW = 0
	electrics.values.susURSW = 0
	electrics.values.kneelSW = 0
	--Подвеска (сглаживание кнопок)
	electrics.values.susRDSWSmooth = 0
	electrics.values.susURSWSmooth = 0
	electrics.values.kneelSWSmooth = 0
	--Приборы
	electrics.values.gauge_fuel = 0
	electrics.values.gauge_battery = 0
	electrics.values.gauge_water = 0
	electrics.values.gauge_oil = 0
	electrics.values.gauge_kpa = 0
	electrics.values.gauge_kpaMax = 0
	--Еще больше переменных
	electrics.values.waterOvh = 0
	electrics.values.handbrake_ind = 0
	electrics.values.testval = 90
	electrics.values.hazard_stalk = 0
	electrics.values.ignkey_smooth = 0
	electrics.values.suspensionLock = 0
	electrics.values.suspensionLockSmooth = 0
	electrics.values.boardingScreen = 0
	electrics.values.asrdash = 0
	--Лючки
	electrics.values.openablefuelhatch = 0
	electrics.values.openablefuelhatchSmooth = 0
	electrics.values.openablecoolanthatch = 0
	electrics.values.openablecoolanthatchSmooth = 0
	electrics.values.openableRADL = 0
	electrics.values.openableRADR = 0
	electrics.values.openableRADLSmooth = 0
	electrics.values.openableRADRSmooth = 0
	--Сервисная панель
	electrics.values.masterSwitch = 1
	electrics.values.masterSwitchSWSmooth = 1
	electrics.values.engineStopSmooth = 0
	electrics.values.engineStopSW = 0
	--Таймер
	electrics.values.masterTimer = 2
	electrics.values.busTimer = 1
	--Для селектора АКПП
	electrics.values.gear_test = 0
end

local function updateGFX(dt)
	--ЛЮЧКИ ЧЕРЕЗ ПРОПЫ--
	electrics.values.openablefuelhatchSmooth = electrics.values.openablefuelhatch
	electrics.values.openablefuelhatchSmooth	= openableFuelHatchSmoother:get(electrics.values['openablefuelhatchSmooth'])
	electrics.values.openablecoolanthatchSmooth = electrics.values.openablecoolanthatch
	electrics.values.openablecoolanthatchSmooth	= openableCoolantHatchSmoother:get(electrics.values['openablecoolanthatchSmooth'])
	electrics.values.openableRADLSmooth = electrics.values.openableRADL
	electrics.values.openableRADLSmooth	= openableRouteAdvisorHatchLSmoother:get(electrics.values['openableRADLSmooth'])
	electrics.values.openableRADRSmooth = electrics.values.openableRADR
	electrics.values.openableRADRSmooth	= openableRouteAdvisorHatchRSmoother:get(electrics.values['openableRADRSmooth'])
	--СИСТЕМЫ--
	--Перегрев воды--
	electrics.values.waterOvh = electrics.values.watertemp > 110 and 1 or 0
	--Перенаправление индикатора ручника--
	electrics.values.handbrake_ind = electrics.values.masterSwitch >= 1 and electrics.values.parkingbrake >= 1 and 1 or 0
	--Симуляция давления масла--
	if electrics.values.masterSwitch >= 1 then
	electrics.values.oilVolume = engine.oilVolume
	electrics.values.oilPressure = (((electrics.values.oilVolume / 25) * (electrics.values.oiltemp / 210)) + electrics.values.rpm / 22000) end
	--Вольтаж батарей (временно)--
	electrics.values.gauge_battery = electrics.values.masterSwitch > 0 and (electrics.values.rpm <= 500 and 0.35 or 0.5) or 0
	--ПРИБОРКА--
	--Перенаправляем и обнуляем--
	if electrics.values.masterSwitch <=0 then
		electrics.values.gauge_fuel = 0
		electrics.values.gauge_water = 60
		electrics.values.gauge_oil = 0
		electrics.values.gauge_kpa = 0
		electrics.values.gauge_kpaMax = 0
	else
		electrics.values.gauge_fuel = electrics.values.fuel
		electrics.values.gauge_water = electrics.values.watertemp
		electrics.values.gauge_oil = electrics.values.oilPressure
		electrics.values.gauge_kpa = electrics.values.airpressure
		electrics.values.gauge_kpaMax = electrics.values.airpressure
	end
	--Сглаживание--
	electrics.values.gauge_battery = batterygaugeSmoother:get(electrics.values['gauge_battery'])
	electrics.values.gauge_water   = watergaugeSmoother:get(electrics.values['gauge_water'])
	electrics.values.gauge_oil = oilgaugeSmoother:get(electrics.values['gauge_oil'])
	electrics.values.gauge_fuel    = fuelgaugeSmoother:get(electrics.values['gauge_fuel'])

	--Проверяем включено ли питание--
	if electrics.values.masterSwitch >= 1 then
		electrics.values.interiorlight    = electrics.values.interiorlightSW    >= 1 and 1 or 0
		electrics.values.interiorDoorwayF = electrics.values.interiorDoorwayFSW >= 1 and 1 or 0
		electrics.values.interiorDoorwayR = electrics.values.interiorDoorwayRSW >= 1 and 1 or 0
		electrics.values.exteriorDoorwayF = electrics.values.exteriorDoorwayFSW >= 1 and 1 or 0
		electrics.values.exteriorDoorwayR = electrics.values.exteriorDoorwayRSW >= 1 and 1 or 0
		electrics.values.serviceSL        = electrics.values.serviceSLSW        >= 1 and 1 or 0
		electrics.values.rooffanF = electrics.values.rooffanFSW >= 1 and electrics.values.rooffanF + electrics.values.rooffanFMode * dt or electrics.values.rooffanF
		electrics.values.rooffanR = electrics.values.rooffanRSW >= 1 and electrics.values.rooffanR + electrics.values.rooffanRMode * dt or electrics.values.rooffanR
	else
		electrics.values.interiorlight    = 0
		electrics.values.interiorDoorwayF = 0
		electrics.values.interiorDoorwayR = 0
		electrics.values.exteriorDoorwayF = 0
		electrics.values.exteriorDoorwayR = 0
		electrics.values.serviceSL = 0
	end

	--Обнуление вентиляторов--
	if electrics.values.rooffanF >=360 then electrics.values.rooffanF = 0 end
	if electrics.values.rooffanR >=360 then electrics.values.rooffanR = 0 end
	
	--Освещение поворотов--
	electrics.values.cornering_R = electrics.values.highbeam == 1 and electrics.values.signal_right_input == 1 and 1 or 0
	electrics.values.cornering_L = electrics.values.highbeam == 1 and electrics.values.signal_left_input == 1 and 1 or 0
	
	--Перенаправление стокового света--
	if electrics.values.masterSwitch == 0 then electrics.values.highlight = 0 else electrics.values.highlight = electrics.values.highlight_input end
	
	if electrics.values.masterSwitch == 1 and electrics.values.lights_state >= 2 then electrics.values.taillight = 1 else electrics.values.taillight = 0 end
	if electrics.values.masterSwitch == 0 then electrics.values.brakelight = 0 else electrics.values.brakelight = electrics.values.brake end

	
	--Переключатель аварийки--
	if electrics.values.hazard_enabled == 1 then electrics.values.hazard_stalk = 1 else electrics.values.hazard_stalk = 0 end
	electrics.values.hazard_stalk    = hazardStalkSmoother:get(electrics.values['hazard_stalk'])
	--Ключ зажигания--
	electrics.values.ignkey_smooth = electrics.values.ignitionLevel
	electrics.values.ignkey_smooth	= ignitionKeySmoother:get(electrics.values['ignkey_smooth'])
	--Наружний дисплей--
	electrics.values.boardingScreen = electrics.values.dooropen == 1 and electrics.values.masterSwitch >=1 and 1 or 0


	
	--ЗВУКИ--
	--switchUp--

end

-- public interface
M.onInit    = onInit
M.onReset   = onReset
M.updateGFX = updateGFX

return M