angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function ($scope, $element, $window) {
  const vm = this;
  let svg = null;

  const elements = {};

  vm.onSVGLoaded = function () {
    svg = $element[0].querySelector('div[ng-include] svg');
    if (!svg) return;

    elements.speedTextGroup  = svg.querySelector('#speed_txt');
    elements.gearGroup       = svg.querySelector('#gear_txt');
    elements.odoGroup        = svg.querySelector('#odo_txt');
    elements.remRangeGroup   = svg.querySelector('#remrange_txt');
    elements.timeGroup       = svg.querySelector('#time_txt');
    elements.tempGroup       = svg.querySelector('#tempENV_txt');
    elements.modeNameGroup   = svg.querySelector('#modeName_txt');
    elements.tempDangerText  = svg.getElementById('temp_danger_txt');
	elements.fuelAvgGroup    = svg.getElementById('fuelavg_txt');
	
	elements.rpmNeedle = svg.getElementById('main_rpm_line');


    elements.signalL         = svg.getElementById('signal_L');
    elements.signalR         = svg.getElementById('signal_R');
    elements.lowbeam         = svg.getElementById('low_img');
    elements.highbeam        = svg.getElementById('high_img');
    elements.autohold        = svg.getElementById('ah_img');
    elements.autoholdstatus  = svg.getElementById('ah_status_img');
    elements.parkingbrake    = svg.getElementById('park_img');
    elements.abs             = svg.getElementById('abs_img');
    elements.checkengine     = svg.getElementById('check_img');
    elements.esp             = svg.getElementById('track_img');
    elements.lowfuel         = svg.getElementById('fuel_img');
    elements.hightemp        = svg.getElementById('temp_img');
	
	elements.fuelFillPath = svg.getElementById('fuel_fill');
	elements.tempFillPath = svg.getElementById('temp_fill');
	
	elements.brakeTempFL = svg.querySelector('#fl_t');
	elements.brakeTempFR = svg.querySelector('#fr_t');
	elements.brakeTempRL = svg.querySelector('#rl_t');
	elements.brakeTempRR = svg.querySelector('#rr_t');
	
	elements.pressureFL = svg.querySelector('#fl_p');
	elements.pressureFR = svg.querySelector('#fr_p');
	elements.pressureRL = svg.querySelector('#rl_p');
	elements.pressureRR = svg.querySelector('#rr_p');


  };

  function updateTextElement(group, txt) {
    if (!group) return false;

    const text = group.tagName === 'text' ? group : group.querySelector('text');
    const target = text?.querySelector('tspan') || text || group;
    if (!target) return false;

    if (target.textContent !== txt) {
      target.textContent = txt;
      return true;
    }
    return false;
  }

  function updateIndicator(key, isOn) {
    const el = elements[key];
    if (!el) return;
    el.style.display = isOn ? 'inline' : 'none';
  }
  
  function updateBrakeTemperature(group, temperature) {
    if (!group) return;
    const formatted = `${Math.round(temperature)}°C`;
    if (updateTextElement(group, formatted)) {
      const text = group.tagName === 'text' ? group : group.querySelector('text');
      const t = text?.querySelector('tspan') || text;
      if (!t) return;
      t.setAttribute('fill', temperature > 450 ? '#ff0000' : temperature > 350 ? '#ff9900' : '#ffffff');
    }
  }

  function updateTireTemperatures(data) {
    if (!svg || !data?.electrics?.wheelThermals) return;
    const thermals = data.electrics.wheelThermals;
    updateBrakeTemperature(elements.brakeTempFL, thermals.FL?.brakeSurfaceTemperature || 0);
    updateBrakeTemperature(elements.brakeTempFR, thermals.FR?.brakeSurfaceTemperature || 0);
    updateBrakeTemperature(elements.brakeTempRL, thermals.RL?.brakeSurfaceTemperature || 0);
    updateBrakeTemperature(elements.brakeTempRR, thermals.RR?.brakeSurfaceTemperature || 0);
  }

  function updateTirePressure(group, pressure) {
    if (!group) return;
    const formatted = `${pressure.toFixed(1)} bar`;
    if (updateTextElement(group, formatted)) {
      const text = group.tagName === 'text' ? group : group.querySelector('text');
      const t = text?.querySelector('tspan') || text;
      if (!t) return;
      t.setAttribute('fill', pressure < 0.5 || pressure > 2.5 ? '#ff0000' : '#ffffff');
    }
  }
  
  function updateTirePressures(pressures) {
    updateTirePressure(elements.pressureFL, pressures.FL / 100 || 0);
    updateTirePressure(elements.pressureFR, pressures.FR / 100 || 0);
    updateTirePressure(elements.pressureRL, pressures.RL / 100 || 0);
    updateTirePressure(elements.pressureRR, pressures.RR / 100 || 0);
  }

  $window.updateData = function (data) {
    if (!svg || !data) return;

    const speed     = (data.electrics?.wheelspeed || 0) * 3.6;
    const gear      = data.electrics?.gear || 'N';
    const gearIdx   = data.electrics?.gearIndex || 0;
    const odometer  = Math.round(data.electrics?.andronisk_odometer || 0);
    const trip      = (data.electrics?.trip || 0) * 0.001;
    const rem       = Math.floor(data.customModules?.combustionEngineData?.remainingRange || 0);
    const tStr      = data.customModules?.environmentData?.time ?? '';
    const tempEnv   = data.customModules?.environmentData?.temperatureEnv;
    const watertemp = data.electrics?.watertemp ?? 0;
	const fuelConsumption = data.customModules.combustionEngineData.averageFuelConsumption || 0;
	const lowbeamOn  = !!data.electrics?.lowbeam || !!data.electrics?.highbeam;
	const highbeamOn = !!data.electrics?.highbeam;

    updateTextElement(elements.speedTextGroup, speed.toFixed(0));
updateTextElement(
  elements.gearGroup,
  gear === 'D' ? `D${gearIdx}` :
  (gear === 'R' || gearIdx === -1) ? 'R' : gear
);
    updateTextElement(elements.odoGroup, `${odometer} km`);
    updateTextElement(elements.remRangeGroup, rem < 10 ? ' --- km' : `${rem} km`);
	updateTextElement(elements.fuelAvgGroup, fuelConsumption.toFixed(1));

    if (tStr && elements.timeGroup) {
      const hhmm = tStr.split(':').slice(0,2).join(':');
      updateTextElement(elements.timeGroup, hhmm);
    }

    if (tempEnv !== undefined && elements.tempGroup)
      updateTextElement(elements.tempGroup, `${Math.round(tempEnv)} °C`);

    updateIndicator('signalL',     		 !!data.electrics?.signal_L);
    updateIndicator('signalR',     		 !!data.electrics?.signal_R);
	updateIndicator('lowbeam',     		 lowbeamOn);
	updateIndicator('highbeam',    		 highbeamOn);
    updateIndicator('autohold',    		 !!data.electrics?.autohold);
    updateIndicator('autoholdstatus',    !!data.electrics?.autoholdInd);
    updateIndicator('parkingbrake',      !!data.electrics?.parkingbrake);
    updateIndicator('abs',               !!data.electrics?.abs);
    updateIndicator('checkengine',       !!data.electrics?.checkengine);
    updateIndicator('esp',               !!data.electrics?.esp);
	
if (elements.rpmNeedle && typeof data.electrics?.rpmTacho === 'number') {
  const rpm = data.electrics.rpmTacho;
  const angle = Math.max(-120, Math.min(120, ((rpm - 4000) / 4000) * 120));
  elements.rpmNeedle.setAttribute('transform', `rotate(${angle}, 1024, 492.033)`);
}

// РИСУЕМ ЗАЛИВКУ ТОПЛИВА

if (elements.fuelFillPath && typeof data.electrics?.fuel === 'number') {
  const fuel = Math.max(0, Math.min(1, data.electrics.fuel));

  const cx = 1023.343;
  const cy = 492.10202;
  const r = 350.2;

  const startDeg = 31.774;
  const endDeg = -19.696;
  const angle = startDeg + (endDeg - startDeg) * fuel;

  const startRad = (Math.PI / 180) * startDeg;
  const endRad = (Math.PI / 180) * angle;

  const x1 = cx + r * Math.cos(startRad);
  const y1 = cy + r * Math.sin(startRad);
  const x2 = cx + r * Math.cos(endRad);
  const y2 = cy + r * Math.sin(endRad);

  const largeArcFlag = (Math.abs(endDeg - startDeg) > 180) ? 1 : 0;

  const d = `M ${x1},${y1} A ${r},${r} 0 ${largeArcFlag} 0 ${x2},${y2} L ${cx},${cy} Z`;

  elements.fuelFillPath.setAttribute('d', d);
}

// РИСУЕМ ЗАЛИВКУ ТЕМПЕРАТУРЫ

if (elements.tempFillPath && typeof watertemp === 'number') {
  const cx = 1023.343;
  const cy = 492.10202;
  const r = 350.2;

  const tempMin = 50;
  const tempMax = 130;
  const startDeg = 148;
  const endDeg = 200;

  const clampedTemp = Math.max(tempMin, Math.min(tempMax, watertemp));
  const angleDeg = startDeg + (endDeg - startDeg) * ((clampedTemp - tempMin) / (tempMax - tempMin));

  const startRad = (Math.PI / 180) * startDeg;
  const endRad = (Math.PI / 180) * angleDeg;

  const x1 = cx + r * Math.cos(startRad);
  const y1 = cy + r * Math.sin(startRad);
  const x2 = cx + r * Math.cos(endRad);
  const y2 = cy + r * Math.sin(endRad);

  const largeArcFlag = (Math.abs(endDeg - startDeg) > 180) ? 1 : 0;

  const d = `M ${x1},${y1} A ${r},${r} 0 ${largeArcFlag} 1 ${x2},${y2} L ${cx},${cy} Z`;

  elements.tempFillPath.setAttribute('d', d);
}

    updateTireTemperatures(data);
    updateTirePressures(data.customModules?.tireData?.pressures || { FL: 0, FR: 0, RL: 0, RR: 0 });

  };

  $window.updateMode = function (data) {
    if (!data?.modeName) return;
    if (updateTextElement(elements.modeNameGroup, data.modeName.toUpperCase()) && data.modeColor) {
      const text = elements.modeNameGroup.tagName === 'text' ?
                   elements.modeNameGroup : elements.modeNameGroup.querySelector('text');
      (text.querySelector('tspan') || text).setAttribute('fill', data.modeColor);
    }
  };

  $window.updateMap = function () {};
  $window.map = new bngNavigator({
    container       : '#mapContainer',
    backgroundRgb   : [85,85,85],
    roadColors      : ['#D8D8D8FF','#969678FF','#967864FF'],
    rotate          : true,
    scale           : 2,
    offsetX         : 1024,
    offsetY         : 538,
    pitch           : 0,
    speedPitch      : 0,
    hideBootscreen  : true,
  });
});
