local M = {}

local saveInterval = 5
local saveTimer = 0
local odometerValue = 0

local function getSavePath()
  local vehicleFolder = string.sub(v.vehicleDirectory, 10, -2)
  return "settings/andronisk_odometer/" .. vehicleFolder .. ".json"
end

local function saveOdometer()
  jsonWriteFile(getSavePath(), { odometer = odometerValue }, true)
end

local function loadOdometer()
  local data = jsonReadFile(getSavePath())
  if data and type(data.odometer) == "number" then
    odometerValue = data.odometer              -- фикс: устанавливаем значение
    electrics.values.andronisk_odometer = odometerValue
  end
end

local function updateGFX(dt)
  saveTimer = saveTimer + dt

  local speed = electrics.values.wheelspeed or 0
  if speed > 0.5 and speed < 600 and (electrics.values.engineRunning or 0) > 0.5 then
    odometerValue = odometerValue + (speed * dt * 0.001) -- метры в километры
    electrics.values.andronisk_odometer = odometerValue
  end

  if saveTimer >= saveInterval then
    saveOdometer()
    saveTimer = 0
  end
end

local function onInit()
  loadOdometer()
end

-- API
M.onInit = onInit
M.updateGFX = updateGFX
M.getValue = function() return odometerValue end
M.setValue = function(v) odometerValue = v or 0 end
M.saveOdometer = saveOdometer

return M
