--author ACM BEAMNG 
--If you want to use my script in your mod, please contact the personal messages of the VK group. https://vk.com/acm_beamng

local M = {}
local timer_F = 0
local timer_R = 0
local delay = 2.5

local function ctrlR()
    electrics.values.lamp_fl = 0
    electrics.values.lamp_fr = 0
    electrics.values.lamp_rl = 0
    electrics.values.lamp_rr = 0
    timer_F = -1
    timer_R = -1
end

local function R()
    electrics.values.lamp_fl = 0
    electrics.values.lamp_fr = 0
    electrics.values.lamp_rl = 0
    electrics.values.lamp_rr = 0
    timer_F = -1
    timer_R = -1
end 

local function updateGFX(dt)
    if electrics.values.ignitionLevel >= 1 then
        local anyFrontDoorOpen = electrics.values.doorFLCoupler_notAttached == 1 or electrics.values.doorFRCoupler_notAttached == 1
        local anyRearDoorOpen = electrics.values.doorRLCoupler_notAttached == 1 or electrics.values.doorRRCoupler_notAttached == 1
        local mainTrigger = electrics.values.tlamp_main == 1
        
        if timer_F >= 0 then
            if anyFrontDoorOpen then
                timer_F = delay
            else
                timer_F = timer_F - dt
            end
        end
        
        if timer_R >= 0 then
            if anyRearDoorOpen then
                timer_R = delay 
            else
                timer_R = timer_R - dt
            end
        end
        
        if electrics.values.tlamp_fl == 1 or anyFrontDoorOpen or mainTrigger or (timer_F > 0 and timer_F <= delay) then 
            electrics.values.lamp_fl = 1
        else
            electrics.values.lamp_fl = 0
            timer_F = 0
        end
        
        if electrics.values.tlamp_fr == 1 or anyFrontDoorOpen or mainTrigger or (timer_F > 0 and timer_F <= delay) then 
            electrics.values.lamp_fr = 1
        else
            electrics.values.lamp_fr = 0
        end        
        
        if electrics.values.tlamp_rl == 1 or anyRearDoorOpen or mainTrigger or (timer_R > 0 and timer_R <= delay) then
            electrics.values.lamp_rl = 1
        else
            electrics.values.lamp_rl = 0
            timer_R = 0
        end
        
        if electrics.values.tlamp_rr == 1 or anyRearDoorOpen or mainTrigger or (timer_R > 0 and timer_R <= delay) then
            electrics.values.lamp_rr = 1
        else
            electrics.values.lamp_rr = 0
        end
    else
        R()
    end
end

-- public interface
M.onInit    = ctrlR
M.onReset   = R
M.updateGFX = updateGFX

return M