local M = {}

M.lastActive = 0
M.alarmTriggered = false
M.alarmStartTime = 0
M.isAlarmPlaying = false
M.nextAlarmTime = 0
M.hazardsControlledByAlarm = false
M.hazardsStartTime = 0
M.initialLoad = true
M.lastIgnitionLevel = 3

local function playAlarm()
    if not obj then
        return
    end

    obj:createSFXSource("/vehicles/a4b5/sounds/alarm.mp3", "AudioClosest3D", "alarmSound", -1)
    obj:playSFXOnce("alarmSound", 471, 2, 1)
    M.nextAlarmTime = os.clock() + 1.4
end

local function stopAlarmSequence()
    if not M.isAlarmPlaying then
        return
    end

    log('D', 'alarm', string.format("Stopping alarm sequence - Hazard state: %d", electrics.values.hazard))
    
    if electrics.values.ignitionLevel == 0 then
        obj:queueLuaCommand("electrics.setIgnitionLevel(1)")
    end

    if electrics.values.hazard == 1 then
        log('D', 'alarm', "Turning off hazards")
        electrics.toggle_warn_signal()
    end
    
    obj:queueLuaCommand("electrics.setIgnitionLevel(0)")
    
    M.hazardsControlledByAlarm = false
    M.isAlarmPlaying = false
    M.nextAlarmTime = 0
    
    log('D', 'alarm', string.format("Alarm sequence stopped - Final hazard state: %d", electrics.values.hazard))
end

function M.init(jbeamData)
    electrics.values.alarmSystemActive = 0
    electrics.values.alarmSoundActive = 0
    M.hazardsControlledByAlarm = false
    M.initialLoad = true
    return true
end

function M.reset()
    M.lastActive = os.time()
    M.alarmTriggered = false
    electrics.values.alarmSystemActive = 0
    electrics.values.alarmSoundActive = 0
    
    if M.hazardsControlledByAlarm and electrics.values.hazard == 1 then
        electrics.toggle_warn_signal()
    end
    M.hazardsControlledByAlarm = false
    
    stopAlarmSequence()

    if M.initialLoad then
        obj:queueLuaCommand("electrics.setIgnitionLevel(0)")
        M.initialLoad = false
    else
        obj:queueLuaCommand("electrics.setIgnitionLevel(" .. M.lastIgnitionLevel .. ")")
    end
end

function M.updateGFX(dt)
    if not obj then
        return
    end

    if electrics.values.ignitionLevel ~= nil then
        M.lastIgnitionLevel = electrics.values.ignitionLevel
    end

    local speed = obj:getVelocity():length()

    if electrics.values.ignitionLevel == 0 then
        electrics.values.alarmSystemActive = 1
    end

    if speed < 0.1 and electrics.values.ignitionLevel > 0 then
        local timeStopped = os.time() - M.lastActive
        if timeStopped >= 120 then
            obj:queueLuaCommand("electrics.setIgnitionLevel(0)")
            electrics.values.alarmSystemActive = 1
        end
    else
        M.lastActive = os.time()
    end

    if electrics.values.alarmSystemActive == 1 and not M.alarmTriggered then
        if speed > 0.8 then
            M.alarmTriggered = true
            M.alarmStartTime = os.time()
            electrics.values.alarmSoundActive = 1
            M.isAlarmPlaying = true

            obj:queueLuaCommand("electrics.setIgnitionLevel(1)")
            M.hazardsStartTime = os.time() + 1 
            
            playAlarm()
        end
    end

    if M.isAlarmPlaying and electrics.values.alarmSoundActive == 1 then
        if electrics.values.ignitionLevel < 2 then
            obj:queueLuaCommand("electrics.setIgnitionLevel(1)")
        end

        if M.hazardsStartTime > 0 and os.time() >= M.hazardsStartTime then
            if electrics.values.hazard ~= 1 then
                electrics.toggle_warn_signal()
                M.hazardsControlledByAlarm = true
            end
            M.hazardsStartTime = 0
        end
        
        if os.clock() >= M.nextAlarmTime then
            playAlarm()
        end

        if electrics.values.ignitionLevel > 1 then
            M.alarmTriggered = false
            electrics.values.alarmSystemActive = 0
            electrics.values.alarmSoundActive = 0
            stopAlarmSequence()
        end
    end

    if M.alarmTriggered and os.time() - M.alarmStartTime >= 60 then
        M.alarmTriggered = false
        electrics.values.alarmSoundActive = 0
        obj:queueLuaCommand("electrics.setIgnitionLevel(0)")
        stopAlarmSequence()
    end

    if electrics.values.alarmSoundActive == 0 then
        stopAlarmSequence()
    end

    if electrics.values.ignitionLevel > 0 and electrics.values.alarmSystemActive == 1 and not M.alarmTriggered then
        M.alarmTriggered = false
        electrics.values.alarmSystemActive = 0
        electrics.values.alarmSoundActive = 0
        stopAlarmSequence()
    end
end

return M