-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local clamp = clamp

function updateOpen(input, currentValue, dt)
  return clamp((currentValue + input * dt), -1, 0)
end
local function onReset()
  electrics.values['openWindowFR'] = 0
  electrics.values['open_window_FR_input'] = 0
  electrics.values['openR'] = 0
  electrics.values['open_kozy_r_input'] = 0
   electrics.values['openL'] = 0
  electrics.values['open_kozy_l_input'] = 0
    electrics.values['openWindowFL'] = 0
  electrics.values['open_window_FL_input'] = 0
    electrics.values['openWindowRL'] = 0
  electrics.values['open_window_RL_input'] = 0
    electrics.values['openWindowRR'] = 0
  electrics.values['open_window_RR_input'] = 0
end

local function updateGFX(dt)
  if electrics.values.open_kozy_l_input ~= 0 then electrics.values.openL = updateOpen(electrics.values.open_kozy_l_input, electrics.values.openL, 0.55*dt) end
  if electrics.values.open_kozy_r_input ~= 0 then electrics.values.openR = updateOpen(electrics.values.open_kozy_r_input, electrics.values.openR, 0.55*dt) end
    if electrics.values.open_window_FR_input ~= 0 then electrics.values.openWindowFR = updateOpen(electrics.values.open_window_FR_input, electrics.values.openWindowFR, 0.355*dt) end
    if electrics.values.open_window_FL_input ~= 0 then electrics.values.openWindowFL = updateOpen(electrics.values.open_window_FL_input, electrics.values.openWindowFL, 0.355*dt) end
    if electrics.values.open_window_RL_input ~= 0 then electrics.values.openWindowRL = updateOpen(electrics.values.open_window_RL_input, electrics.values.openWindowRL, 0.355*dt) end
    if electrics.values.open_window_RR_input ~= 0 then electrics.values.openWindowRR = updateOpen(electrics.values.open_window_RR_input, electrics.values.openWindowRR, 0.355*dt) end
	
	end

local function open_kozy_R(value) electrics.values.open_kozy_r_input = -value end
local function close_kozy_R(value) electrics.values.open_kozy_r_input = value end
local function open_kozy_L(value) electrics.values.open_kozy_l_input = -value end
local function close_kozy_L(value) electrics.values.open_kozy_l_input = value end
local function open_window_FR(value) electrics.values.open_window_FR_input = -value end
local function close_window_FR(value) electrics.values.open_window_FR_input = value end
local function open_window_FL(value) electrics.values.open_window_FL_input = -value end
local function close_window_FL(value) electrics.values.open_window_FL_input = value end
local function open_window_RL(value) electrics.values.open_window_RL_input = -value end
local function close_window_RL(value) electrics.values.open_window_RL_input = value end
local function open_window_RR(value) electrics.values.open_window_RR_input = -value end
local function close_window_RR(value) electrics.values.open_window_RR_input = value end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.open_kozy_R = open_kozy_R
M.close_kozy_R = close_kozy_R
M.open_kozy_L = open_kozy_L
M.close_kozy_L = close_kozy_L
M.open_window_FR = open_window_FR
M.close_window_FR = close_window_FR
M.open_window_FL = open_window_FL
M.close_window_FL = close_window_FL
M.open_window_RL = open_window_RL
M.close_window_RL = close_window_RL
M.open_window_RR = open_window_RR
M.close_window_RR = close_window_RR
return M
