local M = {}
M.type = "auxiliary"

local engine
local twoStepLoopName
local twoStepMaxVolume, twoStepVolumeCoef
local twoStepVolume = 1
local twoStepLoopsActive = {}
local twoStepTimer = 0
local twoStepLoops = {}
local endNodeIDPairs

local function clampValue(value, inMin, inMax, outMin, outMax)
  if value < inMin then
    value = inMin
  elseif value > inMax then
    value = inMax
  end
  local result = (value - inMin) / (inMax - inMin) * (outMax - outMin) + outMin
  return result
end

local function getExhaustEndNodes(engine, endNodeIDPairs)
  local exhaustEndNodes = engine.thermals.exhaustEndNodes

  if #exhaustEndNodes > 0 then
    endNodeIDPairs = {}
    for _, v in pairs(exhaustEndNodes) do
      table.insert(endNodeIDPairs, v.finish)
    end
  else
    endNodeIDPairs = {{engine.engineNodeID, engine.engineNodeID}}
  end

  return endNodeIDPairs
end

local function updateGFX(dt)

  if (engine.isTempRevLimiterActive and engine.revLimiterActive) then
    twoStepTimer = 0.2
  else
    twoStepTimer = math.max(twoStepTimer - dt, 0)
  end

  twoStepVolume = clampValue(twoStepTimer, 0.0, 0.2, 0.0, 1.0)

  if twoStepTimer > 0.0 then
    for i = 1, #endNodeIDPairs do
      if twoStepLoops[i] == nil then
        twoStepLoops[i] = obj:createSFXSource2(twoStepLoopName, "AudioDefaultLoop3D", "twoStepLoop", endNodeIDPairs[i], 0)
      end
      obj:setVolumePitchCT(twoStepLoops[i], twoStepVolume * (twoStepMaxVolume * twoStepVolumeCoef), 1, 1, 0)
      if (not twoStepLoopsActive[i] or twoStepLoopsActive[i] == nil) then
        obj:cutSFX(twoStepLoops[i])
        obj:playSFX(twoStepLoops[i])
        twoStepLoopsActive[i] = true
      end
    end
  end

  if twoStepTimer <= 0.0 then
    for i = 1, #endNodeIDPairs do
      if twoStepLoops[i] then
        obj:cutSFX(twoStepLoops[i])
        obj:stopSFX(twoStepLoops[i] or -1)
      end
      twoStepLoopsActive[i] = false
    end
  end

  -- print(endNodeIDPairs[2])

end

local function init(jbeamData)
  engine = powertrain.getDevice(jbeamData.engineName)
  endNodeIDPairs = getExhaustEndNodes(engine, endNodeIDPairs)
  twoStepLoopName = jbeamData.twoStepLoopName or "art/sound/golfiv_turbo/twostep.wav"
  twoStepMaxVolume = jbeamData.twoStepMaxVolume or 5
  twoStepVolumeCoef = jbeamData.twoStepVolumeCoef or 1
end

M.init = init
M.updateGFX = updateGFX

return M
