-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local hillStartData = {}
local hillStartTimer = 0
local hillStartModeEnabled = true
local hillStartActive = false
local hillStartEnabled = false
local clutchCheck = function()
    return electrics.values.clutch < 0.7
end

local function zeitADASUpdate(dt)
    if electrics.values.gearboxMode == "arcade" or not hillStartEnabled or not hillStartModeEnabled then return end

    local evals = electrics.values
    if not hillStartActive then
        local _, pitch = obj:getRollPitchYaw()
        if evals.wheelspeed <= 0.2 and evals.brake >= 0.1 and evals.throttle == 0 and pitch >= hillStartData.pitchThreshold then
            evals.brakeOverride = 0.5
            hillStartActive = true
            hillStartTimer = 0
        end
    else
        if evals.brake_input == 0 then
            hillStartTimer = hillStartTimer + dt
            if hillStartTimer > hillStartData.brakeHoldTime or clutchCheck() then
                evals.brakeOverride = nil
                hillStartActive = false
            end
        end
    end
end

local function initLastStage()
    local gearbox = powertrain.getDevice("gearbox")
    if gearbox and gearbox.type and gearbox.type == "dctGearbox" then
        clutchCheck = function()
            return gearbox.clutchRatio1 > 0.4
        end
    end
end

local function init(jbeamData)
    hillStartEnabled = next(jbeamData) ~= nil
    hillStartData = jbeamData
end

local function setGlobalActive(bool)
    hillStartEnabled = bool
    if not hillStartEnabled then
        electrics.values.brakeOverride = nil
    end
end

local function setParameters(params)
    hillStartModeEnabled = params.isEnabled
    if not hillStartModeEnabled then
        electrics.values.brakeOverride = nil
    end
end

M.initLastStage = initLastStage
M.setParameters = setParameters
M.setGlobalActive = setGlobalActive
M.zeitADASUpdate = zeitADASUpdate
M.init = init

return M
