-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local enabled = false
local htmlTexture = require("htmlTexture")
local updateFPS = 2000
local data = {}
local htmlTextures = {
    left="headlightL",
    right="headlightR"
}

local function zeitADASUpdate(dt)
    if not enabled then return end
end

local function createHTMLTextures(name, suffixes, htmlPath, size)
    htmlTextures.left = name..suffixes[1]
    htmlTextures.right = name..suffixes[2]

    if not htmlTextures.left or not htmlTextures.right then
      log("E", "matrixLED", "Got no material name for the texture(s), can't display anything...")
      M.updateGFX = nop
      return false
    else
      if htmlPath then
        htmlTexture.create(htmlTextures.left, htmlPath, size, size, updateFPS, "automatic")
        htmlTexture.create(htmlTextures.right, htmlPath, size, size, updateFPS, "automatic")
      else
        log("E", "matrixLED", "Got no html path for the textures, can't display anything...")
        M.updateGFX = nop
        return false
      end
    end

    return true
end

local function init(jbeamData)
    enabled = next(jbeamData) ~= nil
    data = jbeamData

    local htmlPath = "local://local/vehicles/common/zeitADAS/matrix.html"
    if createHTMLTextures(data.materialName or "headlight", data.suffixes or {"L","R"}, htmlPath, data.size or 512) then
        local config = {
            numSegX = data.numSeg[1],
            numSegY = data.numSeg[2],
            origLightCookie = "local://local/"..data.origLightCookie,
            size = data.size
        }

        htmlTexture.call(htmlTextures.left, "setup", config)
        htmlTexture.call(htmlTextures.right, "setup", config)
    end
end

M.zeitADASUpdate = zeitADASUpdate
M.init = init

return M