-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"

local engine
local popcornLoopName
local popcornMaxVolume, popcornVolumeCoef
local popcornVolume = 1
local popcornLoopsActive = {}
local popcornTimer = 0
local popcornLoops = {}
local endNodeIDPairs

local function clampValue(value, inMin, inMax, outMin, outMax)
  if value < inMin then
    value = inMin
  elseif value > inMax then
    value = inMax
  end
  local result = (value - inMin) / (inMax - inMin) * (outMax - outMin) + outMin
  return result
end

local function getExhaustEndNodes(engine, endNodeIDPairs)
  local exhaustEndNodes = engine.thermals.exhaustEndNodes

  if #exhaustEndNodes > 0 then
    endNodeIDPairs = {}
    for _, v in pairs(exhaustEndNodes) do
      table.insert(endNodeIDPairs, v.finish)
    end
  else
    endNodeIDPairs = {{engine.engineNodeID, engine.engineNodeID}}
  end

  return endNodeIDPairs
end

local function updateGFX(dt)

  if engine.maxRPM - engine.outputRPM < 100 then
    popcornTimer = 0.2
  else
    popcornTimer = math.max(popcornTimer - dt, 0)
  end

  popcornVolume = clampValue(popcornTimer, 0.0, 0.2, 0.0, 1.0)

  if popcornTimer > 0.0 then
    for i = 1, #endNodeIDPairs do
      if popcornLoops[i] == nil then
        popcornLoops[i] = obj:createSFXSource2(popcornLoopName, "AudioDefaultLoop3D", "popcornLoop", endNodeIDPairs[i], 0)
      end
      obj:setVolumePitchCT(popcornLoops[i], popcornVolume * (popcornMaxVolume * popcornVolumeCoef), 1, 1, 0)
      if (not popcornLoopsActive[i] or popcornLoopsActive[i] == nil) then
        obj:cutSFX(popcornLoops[i])
        obj:playSFX(popcornLoops[i])
        popcornLoopsActive[i] = true
      end
    end
  end

  if popcornTimer <= 0.0 then
    for i = 1, #endNodeIDPairs do
      if popcornLoops[i] then
        obj:cutSFX(popcornLoops[i])
        obj:stopSFX(popcornLoops[i] or -1)
      end
      popcornLoopsActive[i] = false
    end
  end

  -- print(endNodeIDPairs[2])

end

local function init(jbeamData)
  engine = powertrain.getDevice(jbeamData.engineName)
  endNodeIDPairs = getExhaustEndNodes(engine, endNodeIDPairs)
  popcornLoopName = jbeamData.popcornLoopName or "art/sound/golfiv_turbo/popcorn.wav"
  popcornMaxVolume = jbeamData.popcornMaxVolume or 5
  popcornVolumeCoef = jbeamData.popcornVolumeCoef or 1
end

M.init = init
M.updateGFX = updateGFX

return M
