

angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window) {
  var unit = null;
  $scope.data = {}
  // overwriting plain javascript function so we can access from within the controller
  $window.setup = (data) => {
    unit = data.unit;
  }

  $window.updateData = (data) => {
    $scope.$evalAsync(function() {
      // We need access to the efficiency bar svg element so that we can animate it
      var eff = document.getElementById("efficiency");

      if(!eff){return;} //html not ready yet

      value = data.customModules.combustionEngineData.fuelDisplay;
      // dash array needs to be the same as the circumference of the circle (radius * 2 * PI)
      eff.style.strokeDasharray = 342

      if (value > 0) {
        // We need to add the value to the negative circumference of the circle so that we can fill up the bar
        eff.style.strokeDashoffset = -342 + value.toFixed(2) * 23
      }
      else {
        eff.style.strokeDashoffset = -342 + value.toFixed(2) * 23
      }

      if (data.electrics.gear === -1) {
        $scope.data.gear = "R";
      }
      else if (data.electrics.gear === 0) {
        $scope.data.gear = "N";
      }
      else {
        $scope.data.gear = data.electrics.gear;
      }

      $scope.data.time = data.time;

      // checking if metric gauge cluster is being used
      if (unit === "metric") {
               $scope.data.speedVal = (data.electrics.wheelspeed * 2.23694).toFixed(0);
                $scope.data.speedUnit = "mph";
        $scope.data.temp = (data.customModules.environmentData.temperatureEnv * 1.8 + 32).toFixed(0) + "°F";
                if (data.customModules.combustionEngineData.averageFuelConsumption === 0) {
                    $scope.data.consumptionVal = "---";
                }
                else {
                    $scope.data.consumptionVal = (235 / data.customModules.combustionEngineData.averageFuelConsumption).toFixed(1);
                }
        $scope.data.consumptionUnit = "mpg";
      }
      else {
        $scope.data.speedVal = (data.electrics.wheelspeed * 2.23694).toFixed(0);
                $scope.data.speedUnit = "mph";
        $scope.data.temp = (data.customModules.environmentData.temperatureEnv * 1.8 + 32).toFixed(0) + "°F";
                if (data.customModules.combustionEngineData.averageFuelConsumption === 0) {
                    $scope.data.consumptionVal = "---";
                }
                else {
                    $scope.data.consumptionVal = (235 / data.customModules.combustionEngineData.averageFuelConsumption).toFixed(1);
                }
        $scope.data.consumptionUnit = "mpg";
        // A bit ugly but need to set the markers on the SVG for imperial or metric units
      }
    })
  }

  beamng.sendActiveObjectLua('controller.getControllerSafe("etkGauges").uiReady()');
});