ScriptName RichAuthorityVendorScript Extends Actor

ObjectReference Property TraderChest Auto
RichAuthorityPlayerScript Property PlayerInstance Auto

Event OnInit()
	RichAuthorityPlayerScript.DebugTrace("Actor was summoned >> " + Self as String)
EndEvent

Event OnActivate(ObjectReference ActionRef)
	RichAuthorityPlayerScript.DebugTrace("Activated by reference >> " + ActionRef as String)
	If (ActionRef == Game.GetForm(0x14) as ObjectReference)
		; refresh trader and chest-items
		PlayerInstance = (ActionRef as Actor) as RichAuthorityPlayerScript
		PlayerInstance.ProcessTrader(Self, True)
		PlayerInstance.ProcessChest(TraderChest, True, True)
		Self.RegisterForMenuOpenCloseEvent(PlayerInstance.BarterMenuName)
		; begin barter
		RichAuthorityPlayerScript.DebugTrace("Call ShowBarterMenu >> " + Self as String + " / " + TraderChest as String)
		Self.ShowBarterMenu()
	EndIf
EndEvent

Event OnMenuOpenCloseEvent(String MenuName, Bool Opening)
	If (Opening)
		; refresh chest, credits only
		PlayerInstance.ProcessChest(TraderChest, True, False)
		Self.UnregisterForAllMenuOpenCloseEvents()
	EndIf
EndEvent
