ScriptName RichAuthorityPlayerScript Extends Actor

; filled on game load
MiscObject Property Credits Auto
Int Property HalfCreditsAmount Auto
ObjectReference[] Property AuthorityChests Auto
Int[] Property AuthorityTraders Auto
; menu names
String Property DialogueMenuName = "DialogueMenu" Auto Hidden
String Property BarterMenuName = "BarterMenu" Auto Hidden
; temp data
ObjectReference[] Property CurrentReferences Auto
Actor Property CurrentSummonedActor Auto

;/ GLOBAL FUNCTIONS /;

Function AttachToPlayer() Global
	Utility.Wait(0.25)
	; attach only once
	Actor PlayerActor = Game.GetForm(0x14) as Actor
	If (PlayerActor as RichAuthorityPlayerScript == None)
		DebugTrace("AttachToPlayer > Player has no script / ExecuteConsole")
		Debug.ExecuteConsole("Player.AttachPapyrusScript RichAuthorityPlayerScript")
	Else
		DebugTrace("AttachToPlayer > Player has script / Perform nothing")
	EndIf
EndFunction

Function CallRichAuthority() Global
	; define records
	Actor Player = Game.GetForm(0x14) as Actor
	Location PlayerLoc = Player.GetCurrentLocation()
	ActorBase VendorBase = Game.GetForm(0x11E3AE) as ActorBase
	RichAuthorityPlayerScript PlayerInstance = Player as RichAuthorityPlayerScript
	; safety check
	If (PlayerInstance.CurrentSummonedActor as Bool)
		DebugTrace("Call Return / Player already has summoned actor")
		Return
	EndIf
	; place vendor
	DebugTrace("Call PlaceActorAtMe >> " + Player as String + " / " + PlayerLoc as String + " / " + VendorBase as String)
	Actor Vendor = Player.PlaceActorAtMe(VendorBase, 0, PlayerLoc, False, False, False, None, True)
	PlayerInstance.CurrentSummonedActor = Vendor
	; attach vendor script
	String VendorID = Utility.IntToHex(Vendor.GetFormID())
	String ConsoleCommand = VendorID + ".AttachPapyrusScript RichAuthorityVendorScript"
	DebugTrace("Call ExecuteConsole >> " + ConsoleCommand)
	Debug.ExecuteConsole(ConsoleCommand)
	; set chest property
	While (Vendor as RichAuthorityVendorScript == None)
		Utility.Wait(0.1)
		DebugTrace("Waiting for vendor script launch")
	EndWhile
	ObjectReference VendorChest = Game.GetForm(0x11E3A7) as ObjectReference
	(Vendor as RichAuthorityVendorScript).TraderChest = VendorChest
	; wait and delete
	Utility.Wait(10.0)
	DebugTrace("Call Disable/Delete >> " + Vendor)
	PlayerInstance.CurrentSummonedActor = None
	Vendor.Disable(False)
	Vendor.Delete()
EndFunction

Function DebugTrace(String Text) Global
	String LogName = "RichAuthorityDebug"
	If Debug.OpenUserLog(LogName)
		Debug.TraceUser(LogName, "User log opened with no issues", 0)
	EndIf
	Debug.TraceUser(LogName, Text, 0)
EndFunction

;/ LOCAL FUNCTIONS /;

Event OnInit()
	DebugTrace("OnInit > Maintenance")
	Maintenance()
EndEvent

Event OnPlayerLoadGame()
	DebugTrace("OnPlayerLoadGame > Maintenance")
	Maintenance()
EndEvent

Function Maintenance()
	; re-register menus
	Self.UnregisterForAllMenuOpenCloseEvents()
	Self.RegisterForMenuOpenCloseEvent(DialogueMenuName)
	Self.RegisterForMenuOpenCloseEvent(BarterMenuName)
	; set credits
	Credits = Game.GetForm(0xF) as MiscObject
	HalfCreditsAmount = 500000
	; register chests
	AuthorityChests = New ObjectReference[7]
	AuthorityChests[0] = Game.GetForm(0x11E3A7) as ObjectReference ; The Den
	AuthorityChests[1] = Game.GetForm(0x22E53B) as ObjectReference ; The Well
	AuthorityChests[2] = Game.GetForm(0x09DBA1) as ObjectReference ; Cydonia
	AuthorityChests[3] = Game.GetForm(0x15B107) as ObjectReference ; Neon
	AuthorityChests[4] = Game.GetForm(0x1AF6CF) as ObjectReference ; Akila
	AuthorityChests[5] = Game.GetForm(0x133BFA) as ObjectReference ; The Key
	AuthorityChests[6] = Game.GetForm(0x1FA553) as ObjectReference ; HopeTown
	; register traders
	AuthorityTraders = New Int[7]
	AuthorityTraders[0] = 0x11E3AD ; The Den
	AuthorityTraders[1] = 0x0137B2 ; The Well
	AuthorityTraders[2] = 0x09DBA2 ; Cydonia
	AuthorityTraders[3] = 0x115442 ; Neon
	AuthorityTraders[4] = 0x214684 ; Akila
	AuthorityTraders[5] = 0x01539C ; The Key
	AuthorityTraders[6] = 0x2A80D9 ; HopeTown
EndFunction

Event OnMenuOpenCloseEvent(String MenuName, Bool Opening)
	If (MenuName == DialogueMenuName)
		If (Opening)
			CurrentReferences = FindReferences()
			If (CurrentReferences as Bool)
				ProcessTrader(CurrentReferences[0], Opening)
				ProcessChest(CurrentReferences[1], True, True)
			EndIf
		Else
			If (CurrentReferences as Bool)
				ProcessTrader(CurrentReferences[0], Opening)
				CurrentReferences = None
			EndIf
		EndIf
	ElseIf (MenuName == BarterMenuName)
		If (CurrentReferences as Bool)
			ProcessChest(CurrentReferences[1], Opening, False)
		EndIf
	EndIf
EndEvent

Function ProcessTrader(ObjectReference Trader, Bool Opening)
	If (Trader as Bool)
		DebugTrace("ProcessTrader > " + Trader as String + " / " + Opening as String)
		If (Opening)
			; process trader > open
			Trader.RemoveItem(Credits, Trader.GetItemCount(Credits), True, None)
			Trader.AddItem(Credits, HalfCreditsAmount, True)
			DebugTrace("Milestone Trader A")
		Else
			; process trader > close
			Utility.Wait(1.0)
			Trader.RemoveItem(Credits, Trader.GetItemCount(Credits), True, None)
			DebugTrace("Milestone Trader B")
		EndIf
	EndIf
EndFunction

Function ProcessChest(ObjectReference Chest, Bool Partial, Bool Option)
	If (Chest as Bool)
		DebugTrace("ProcessChest > " + Chest as String + " / " + Partial as String + " / " + Option as String)
		If (Partial)
			; process partial
			; Option is true > Items only
			; Option is false > Credits only
			If (Option)
				Chest.RemoveAllItems(None, False, False)
				Chest.Reset(Chest)
			Else
				Chest.RemoveItem(Credits, Chest.GetItemCount(Credits), True, None)
				Chest.AddItem(Credits, HalfCreditsAmount, True)
			EndIf
			DebugTrace("Milestone Chest A")
		Else
			; process merged
			Chest.RemoveAllItems(None, False, False)
			Chest.Reset(Chest)
			Chest.RemoveItem(Credits, Chest.GetItemCount(Credits), True, None)
			Chest.AddItem(Credits, HalfCreditsAmount, True)
			DebugTrace("Milestone Chest B")
		EndIf
	EndIf
EndFunction

ObjectReference[] Function FindReferences()
	ObjectReference[] Result = New ObjectReference[2]
	Int Index = AuthorityTraders.Length
	While (Index > 0)
		Index -= 1
		ObjectReference Trader = Game.GetForm(AuthorityTraders[Index]) as ObjectReference
		If (Trader as Bool) && GetInSameCell(Self, Trader)
			Result[0] = Trader
			Result[1] = AuthorityChests[Index]
			Return Result
		EndIf
	EndWhile
	Return None
EndFunction

Bool Function GetInSameCell(ObjectReference A, ObjectReference B)
	Cell ACell = A.GetParentCell()
	Cell BCell = B.GetParentCell()
	Return (ACell as Bool) && (BCell as Bool) && (ACell == BCell)
EndFunction
