ScriptName SummonShipServicesPlayerScript Extends Actor

Actor Property CurrentSummonedActor = None Auto Hidden

;/ GLOBAL FUNCTIONS /;

Function AttachToPlayer() Global
	Utility.Wait(0.25)
	; attach only once
	Actor PlayerActor = Game.GetForm(0x14) as Actor
	If (PlayerActor as SummonShipServicesPlayerScript == None)
		DebugTrace("AttachToPlayer > Player has no script / ExecuteConsole")
		Debug.ExecuteConsole("Player.AttachPapyrusScript SummonShipServicesPlayerScript")
	Else
		DebugTrace("AttachToPlayer > Player has script / Perform nothing")
	EndIf
EndFunction

Function CallShipServices(Int HangarModeVar, Int BuildShopVar) Global
	; define records
	Actor Player = Game.GetForm(0x14) as Actor
	Location PlayerLoc = Player.GetCurrentLocation()
	ActorBase VendorBase = Game.GetForm(0x206704) as ActorBase
	SummonShipServicesPlayerScript PlayerInstance = Player as SummonShipServicesPlayerScript
	; safety check
	If (PlayerInstance.CurrentSummonedActor as Bool)
		DebugTrace("Call Return / Player already has summoned actor")
		Return
	EndIf
	; place vendor
	DebugTrace("Call PlaceActorAtMe >> " + Player as String + " / " + PlayerLoc as String + " / " + VendorBase as String)
	Actor Vendor = Player.PlaceActorAtMe(VendorBase, 0, PlayerLoc, False, False, False, None, True)
	PlayerInstance.CurrentSummonedActor = Vendor
	; attach vendor script
	String VendorID = Utility.IntToHex(Vendor.GetFormID())
	String ConsoleCommand = VendorID + ".AttachPapyrusScript SummonShipServicesVendorScript"
	DebugTrace("Call ExecuteConsole >> " + ConsoleCommand)
	Debug.ExecuteConsole(ConsoleCommand)
	; get and remember credits
	MiscObject Credits = Game.GetForm(0xF) as MiscObject
	ObjectReference VendorChest = Game.GetForm(0x12DF03) as ObjectReference
	Int OldCreditsCount = VendorChest.GetItemCount(Credits)
	DebugTrace("Old credits amount >> " + OldCreditsCount as String + " / Vendor mode >> " + HangarModeVar as String + ";" + BuildShopVar as String)
	; set credits and mode
	VendorChest.RemoveItem(Credits, OldCreditsCount, True, None)
	VendorChest.AddItem(Credits, 1000000, True)
	While (Vendor as SummonShipServicesVendorScript == None)
		Utility.Wait(0.1)
		DebugTrace("Waiting for vendor script launch")
	EndWhile
	(Vendor as SummonShipServicesVendorScript).HangarMode = HangarModeVar
	(Vendor as SummonShipServicesVendorScript).BuildShop = BuildShopVar as Bool
	; wait and delete
	Utility.Wait(10.0)
	DebugTrace("Call Disable/Delete >> " + Vendor)
	PlayerInstance.CurrentSummonedActor = None
	Vendor.Disable(False)
	Vendor.Delete()
	; restore credits
	Int NewCreditsCount = VendorChest.GetItemCount(Credits)
	DebugTrace("New credits amount >> " + NewCreditsCount as String)
	VendorChest.RemoveItem(Credits, NewCreditsCount, True, None)
	VendorChest.AddItem(Credits, OldCreditsCount, True)
EndFunction

ObjectReference Function GetLandingMarker() Global
	; easy way
	SQ_PlayerShipScript PlayerShipQuest = (Game.GetForm(0x174A2) as Quest) as SQ_PlayerShipScript
	ObjectReference LandingMarkerA = PlayerShipQuest.PlayerShipLandingMarker.GetReference()
	If (LandingMarkerA as Bool)
		DebugTrace("GetLandingMarker Milestone A")
		Return LandingMarkerA
	EndIf
	; a bit advanced
	SpaceshipReference PlayerShipA = PlayerShipQuest.PlayerShip.GetShipReference()
	ObjectReference LandingMarkerB = PlayerShipA.GetLinkedRef(PlayerShipQuest.LandingMarkerKeyword)
	If (LandingMarkerB as Bool)
		DebugTrace("GetLandingMarker Milestone B")
		Return LandingMarkerB
	EndIf
	; alias issue?
	Actor Player = Game.GetForm(0x14) as Actor
	SpaceshipReference PlayerShipB = Player.GetCurrentShipRef()
	ObjectReference LandingMarkerC = PlayerShipB.GetLinkedRef(Game.GetForm(0x1940B) as Keyword)
	If (LandingMarkerC as Bool)
		DebugTrace("GetLandingMarker Milestone C")
		Return LandingMarkerC
	EndIf
	; this should never happen
	DebugTrace("GetLandingMarker Milestone D")
	Return (Player as ObjectReference)
EndFunction

Function DebugTrace(String Text) Global
	String LogName = "SummonShipServicesDebug"
	If Debug.OpenUserLog(LogName)
		Debug.TraceUser(LogName, "User log opened with no issues", 0)
	EndIf
	Debug.TraceUser(LogName, Text, 0)
EndFunction
