Scriptname ChangeYourOutfit_PlayerAliasScript Extends ReferenceAlias

Quest Property OutfitQuest Auto
FormList Property PlayerCurrentEquipped Auto
FormList Property ArmorKeywordList Auto Const
GlobalVariable Property ChangeYourOutfit_EventLock Auto Const

Event OnItemEquipped(Form akBaseObject, ObjectReference akReference)
    ; if ChangeYourOutfit_EventLock.GetValueInt() == 1
        if IsEquippable(akBaseObject)
            if !PlayerCurrentEquipped.HasForm(akBaseObject)
                PlayerCurrentEquipped.AddForm(akBaseObject)
                Debug.Trace("[ChangeYourOutfit]: <FromEvent> Added to Player Equipped FormList -> " + akBaseObject)
            endif
        endif
    ; endif
EndEvent

Event OnItemUnequipped(Form akBaseObject, ObjectReference akReference)
    ; if ChangeYourOutfit_EventLock.GetValueInt() == 1
        if IsEquippable(akBaseObject)
            if PlayerCurrentEquipped.HasForm(akBaseObject)
                PlayerCurrentEquipped.RemoveAddedForm(akBaseObject)
                Debug.Trace("[ChangeYourOutfit]: <FromEvent> Removed from Player Equipped FormList -> " + akBaseObject)
            endif
        endif
    ; endif
EndEvent

bool Function IsEquippable(Form akBaseObject)
    int count = ArmorKeywordList.GetSize()
    int i = 0
    While i < count
        Keyword kw = ArmorKeywordList.GetAt(i) as Keyword
        if akBaseObject.HasKeyword(kw)
            return true
        endif
        i += 1
    EndWhile
    return false
EndFunction






