#pragma once

//#include "sfse/GameTypes.h"

///////////////////////////////////////////////////////////  CLASSES  ///////////////////////////////////////////////////////////

namespace RE
{

	//0x6874cb0	v1.10.32 MenuCursor = shows where the cursor current is (0x54, 0x58, X Y coords, resolution, etc.)

    class ProcessListsCustom // Starfield.exe + 0x6329B98 in v1.10.32
    {
    public:
		[[nodiscard]] static ProcessListsCustom* GetSingleton()
        {
			REL::Relocation<ProcessListsCustom**> singleton{ REL::ID(878338) };
            return *singleton;
        }

		uint8_t                unk01[0x44];
		bool				   bGlobalDetectionOn;
		uint8_t                unk02[0x13];
        RE::BSTArray<uint32_t> highActorProcessHandles;
        RE::BSTArray<uint32_t> ActorProcessHandles68; // low, middleHigh, middleLow ??
        RE::BSTArray<uint32_t> ActorProcessHandles78;
        RE::BSTArray<uint32_t> ActorProcessHandles88;
    };

	static_assert(offsetof(ProcessListsCustom, bGlobalDetectionOn) == 0x44);
	static_assert(offsetof(ProcessListsCustom, highActorProcessHandles) == 0x58);
	static_assert(offsetof(ProcessListsCustom, ActorProcessHandles68) == 0x68);
	static_assert(offsetof(ProcessListsCustom, ActorProcessHandles78) == 0x78);
	static_assert(offsetof(ProcessListsCustom, ActorProcessHandles88) == 0x88);
	
    inline static void LookupREFRByHandle(uint32_t& handleIn, RE::NiPointer<RE::TESObjectREFR>& refOut)
    {
        if (handleIn && !refOut) {
            REL::Relocation<uintptr_t> funcPtr{ REL::ID(72986) }; // Starfield.exe+0x129172C           v1.9.71.
            uintptr_t                  addr = funcPtr.address();
            const auto func = reinterpret_cast<void (*)(uint32_t&, RE::NiPointer<RE::TESObjectREFR>&)>(addr);
            return func(handleIn, refOut);
        }
        else {
            LogError("function parameter error");
        }
    }

    inline static RE::TESObjectREFR* GetReferenceByHandle(uint32_t nativeHandle)
    {
        if (nativeHandle <= 0 || nativeHandle > UINT32_MAX)
            return nullptr;
        RE::TESObjectREFR*               foundRef = nullptr;
        RE::NiPointer<RE::TESObjectREFR> refPtr   = RE::NiPointer<RE::TESObjectREFR>(foundRef);
        LookupREFRByHandle(nativeHandle, refPtr);
        foundRef = refPtr.get();
        if (foundRef != nullptr)
            return foundRef;
        return nullptr;
    }

    class MainCustom  // Starfield.exe + 0x6889110 in v1.12.36
    {
    public:
		virtual ~MainCustom();  // 00

        [[nodiscard]] static MainCustom* GetSingleton()
        {
			REL::Relocation<MainCustom**> singleton{ REL::ID(881027) };
            return *singleton;
        }

        BSTArrayCustom<RE::BSTTuple<float, uint32_t>> sortedVisibleHighActorHandles; // 08
		uint8_t                                       unk[0x430];
		bool                                          bIsGameMenuPaused;

    };

    static_assert(offsetof(MainCustom, sortedVisibleHighActorHandles) == 0x08);
	static_assert(offsetof(MainCustom, bIsGameMenuPaused) == 0x448);

	class TESCustom  // Starfield.exe + 0x6329B98 in v1.10.32
	{
	public:
		[[nodiscard]] static TESCustom* GetSingleton()
		{
			REL::Relocation<TESCustom**> singleton{ REL::ID(881024) };	// 0x6889100 in v1.12.36
			return *singleton;
		}

		struct LoadedCellDBCustom
		{
			std::uint64_t       unk00;	// BSResource2::TEntryType<0,LoadedCellDB::DBTraits,BSResource2::DBDefaultStreamPolicy>
			std::uint8_t unk00_unk28[0x28];
			RE::TESObjectCELL* cell;
		};
		static_assert(offsetof(LoadedCellDBCustom, cell) == 0x30);

		std::uint8_t  unk00_unk24[0x24];
		std::uint32_t unk24;
		std::uint32_t unk28;
		uintptr_t loadedCellDB;
		std::uint8_t                       unk30_unkE8[0xB0];
		RE::TESObjectCELL*                 interiorCell;
	};

	static_assert(offsetof(TESCustom, unk24) == 0x24);
	static_assert(offsetof(TESCustom, loadedCellDB) == 0x30);
	static_assert(offsetof(TESCustom, interiorCell) == 0xE8);

    class BSFadeNode
    {
    public:
		SF_RTTI_VTABLE(BSFadeNode);


        uintptr_t unk01;
        uint32_t  unk02;
        uint32_t  flags;
        char      willlookintolater[107];
        float     scale;
    };

    static_assert(offsetof(BSFadeNode, scale) == 0x7C);
	static_assert(offsetof(BSFadeNode, flags) == 0xC);

    class __declspec(novtable) ExtraInstanceData : public RE::BSExtraData // 00
    {
    public:
        static constexpr auto RTTI{ RE::RTTI::ExtraInstanceData };
        static constexpr auto VTABLE{ RE::VTABLE::ExtraInstanceData };
        static constexpr auto TYPE{ RE::ExtraDataType::kInstanceData };

        ExtraInstanceData();
        ExtraInstanceData(const RE::TESBoundObject* a_base, RE::BSTSmartPointer<RE::TBO_InstanceData> a_data);

        // members
        const RE::TESBoundObject*                 base{ nullptr }; // 18
        RE::BSTSmartPointer<RE::TBO_InstanceData> data;            // 20
    };

	class __declspec(novtable) ExtraDroppedItemList : public RE::BSExtraData
	{
	public:
		static constexpr auto RTTI{ RE::RTTI::ExtraDroppedItemList };
		static constexpr auto VTABLE{ RE::VTABLE::ExtraDroppedItemList };
		static constexpr auto TYPE{ RE::ExtraDataType::kDroppedItemList };

		// members
		uint32_t itemHandle;
	};

    class GameVMCustom  // (890878 Starfield.exe + 0x6956dd8 in v1.12.36 -> GameVM, not pointer)
    {
    public:
		[[nodiscard]] static GameVMCustom* GetSingleton()
        {
			REL::Relocation<GameVMCustom**> singleton{ REL::ID(878371) };  // 0x6670898 in v1.12.36
            return *singleton;
        }

        uint64_t                       unk[27];
        RE::BSScript::IVirtualMachine* virtualMechine; // 0xD8
		uint8_t                          unk2[10];
		RE::BSScript::IMemoryPagePolicy* memPolicy;	// unverified
    };

    static_assert(offsetof(GameVMCustom, virtualMechine) == 0xD8);
	static_assert(offsetof(GameVMCustom, memPolicy) == 0xF0);

    class TaskQueueInterface
    {
    public:
        [[nodiscard]] static uintptr_t GetSingleton()
        {
            REL::Relocation<uintptr_t> singleton{ REL::ID(891179) }; // 0x8975EC0 in v.1.12.36
            return singleton.address();
        }
    };

    class BGSSaveLoadManagerCustom  // 
    {
    public:
		[[nodiscard]] static BGSSaveLoadManagerCustom* GetSingleton()
        {
			REL::Relocation<BGSSaveLoadManagerCustom**> singleton{ REL::ID(880997) };  // 0x6888e50 in v1.12.36
            return *singleton;
        }

        uint8_t unk[0x40];
        uint64_t currentPlayerID;       // valid only after a save is loaded AND the pause menu is opened then clicked on "Load" afterward ??
        uint32_t unk044;
        uint32_t unk048;
        uint32_t loading;       // 0 = not, 64 or 256 of loading ?

        [[nodiscard]] bool IsSaveGameLoading()      // untested
        {
            return (this->GetSingleton()->loading != 0);
        }
    };

    static_assert(offsetof(BGSSaveLoadManagerCustom, currentPlayerID) == 0x40);
	static_assert(offsetof(BGSSaveLoadManagerCustom, loading) == 0x50);

        class __declspec(novtable) BGSObjectInstanceExtra : public RE::BSExtraData
    {
    public:
        static constexpr auto RTTI{ RE::RTTI::BGSObjectInstanceExtra };
        static constexpr auto VTABLE{ RE::VTABLE::BGSObjectInstanceExtra };
        static constexpr auto TYPE{ RE::ExtraDataType::kObjectInstance };

        // members
        std::uint32_t modCount{ 0 }; // 1C
        // const RE::BSTArray<RE::BGSMod::Attachment::Mod> mods;            // 20
        void* mods;
    };

	class __declspec(novtable) ExtraPersistentCell : public RE::BSExtraData
	{
	public:
		static constexpr auto RTTI{ RE::RTTI::ExtraPersistentCell };
		static constexpr auto VTABLE{ RE::VTABLE::ExtraPersistentCell };
		static constexpr auto TYPE{ RE::ExtraDataType::kPersistentCell };

		// members
		RE::TESObjectCELL* extraCell;  // 18
	};
	static_assert(offsetof(ExtraPersistentCell, extraCell) == 0x18);		

    class __declspec(novtable) ExtraPromotedRef : public RE::BSExtraData
    {
    public:
        static constexpr auto RTTI{ RE::RTTI::ExtraPromotedRef };
        static constexpr auto VTABLE{ RE::VTABLE::ExtraPromotedRef };
        static constexpr auto TYPE{ RE::ExtraDataType::kPromotedRef };

        // members
        unsigned long long promoterStorage; // 18    - this points to the first promoter RE::TESForm*
    };

    static_assert(sizeof(ExtraPromotedRef) == 0x20);

	class __declspec(novtable) ExtraHeadingTarget : public RE::BSExtraData
	{
	public:
		static constexpr auto RTTI{ RE::RTTI::ExtraHeadingTarget };
		static constexpr auto VTABLE{ RE::VTABLE::ExtraHeadingTarget };
		static constexpr auto TYPE{ RE::ExtraDataType::kHeadingTarget };

		// members
		uint32_t targetHandle;  // 18
	};

	static_assert(sizeof(ExtraHeadingTarget) == 0x20);

    class __declspec(novtable) ExtraLeveledCreature : public RE::BSExtraData
    {
    public:
        static constexpr auto RTTI{ RE::RTTI::ExtraLeveledCreature };
        static constexpr auto VTABLE{ RE::VTABLE::ExtraLeveledCreature };
        static constexpr auto TYPE{ RE::ExtraDataType::kLeveledCreature };

        // members
        RE::TESNPC* leveledActorBase;
    };

    class __declspec(novtable) ExtraTextDisplayData : public RE::BSExtraData
    {
    public:
        static constexpr auto RTTI{ RE::RTTI::ExtraTextDisplayData };
        static constexpr auto VTABLE{ RE::VTABLE::ExtraTextDisplayData };
        static constexpr auto TYPE{ RE::ExtraDataType::kTextDisplayData };

        // members
        RE::BSFixedString displayName; // 18
        std::uint64_t     unk2{ 0 };
        std::uint64_t     unk3{ 0 };
        std::uint64_t     unk4{ 0 };
        std::uint64_t     unk5{ 0 };
        std::uint16_t     unk6{ 0 }; // customNameLength{ 0 }; // 4C
    };

    class ExtraGroupedPackin : public RE::BSExtraData
    {
    public:
        static constexpr auto RTTI{ RE::RTTI::ExtraGroupedPackin };
        static constexpr auto VTABLE{ RE::VTABLE::ExtraGroupedPackin };
        static constexpr auto TYPE{ RE::ExtraDataType::kGroupedPackin };

        std::uint64_t  pad1;
        std::uint64_t  pad2;
        std::uint64_t  pad3;
        std::uint64_t  pad4;
        std::uint64_t  pad5;
        RE::BGSPackIn* groupedPackIn; // 40
        //...
    };

    class ExtraSourcePackin : public RE::BSExtraData
    {
    public:
        static constexpr auto RTTI{ RE::RTTI::ExtraSourcePackIn };
        static constexpr auto VTABLE{ RE::VTABLE::ExtraSourcePackIn };
        static constexpr auto TYPE{ RE::ExtraDataType::kSourcePackIn };

        RE::BGSPackIn* sourcePackIn; // 18
    };

    static_assert(sizeof(ExtraSourcePackin) == 0x20);

	/*
	class __declspec(novtable) BGSBaseAlias
	{
	public:
		static constexpr auto        RTTI{ RE::RTTI::ExtraReferenceHandles };
		static constexpr auto        VTABLE{ RE::VTABLE::ExtraReferenceHandles };
		inline static constexpr auto FORMTYPE = 219;

		// members
		std::uint64_t     pad;
		RE::BSFixedString aliasName;  // 08
		RE::TESQuest*     owningQuest;
		std::uint32_t     flags;
		std::uint32_t     unk1C;
		std::uint32_t     aliasIndex;
		std::uint32_t     unk24;
		std::uint64_t     unk28;  // loc ref type for BGSLocAlias ?
		std::uint64_t     unk30;
		std::uint64_t     unk38;
		RE::BGSKeyword*   refAliasLocationKeyword;
	};
	static_assert(offsetof(BGSBaseAlias, aliasIndex) == 0x20);
	static_assert(offsetof(BGSBaseAlias, refAliasLocationKeyword) == 0x40);
	static_assert(sizeof(BGSBaseAlias) == 0x48);

	class __declspec(novtable) BGSRefAlias : public BGSBaseAlias
	{
	public:
		static constexpr auto RTTI{ RE::RTTI::BGSRefAlias };
		static constexpr auto VTABLE{ RE::VTABLE::BGSRefAlias };
	};

	class __declspec(novtable) BGSLocAlias : public BGSBaseAlias
	{
	public:
		static constexpr auto RTTI{ RE::RTTI::BGSLocAlias };
		static constexpr auto VTABLE{ RE::VTABLE::BGSLocAlias };
	};

	class __declspec(novtable) BGSRefCollectionAlias : public BGSBaseAlias
	{
	public:
		static constexpr auto RTTI{ RE::RTTI::BGSRefCollectionAlias };
		static constexpr auto VTABLE{ RE::VTABLE::BGSRefCollectionAlias };
	};
	*/

    struct AliasData
    {
    public:
        RE::NiPointer<RE::TESForm>       owningQuestForm; // should be NiPointer for CommonLibSF's BSTArray
        RE::BGSBaseAlias*           thisAlias;
        BSTArrayCustom<RE::TESPackage*>* packages;
    };

    static_assert(sizeof(AliasData) == 0x18);

    class __declspec(novtable) ExtraAliasInstanceArray : public RE::BSExtraData
    {
    public:
        static constexpr auto RTTI{ RE::RTTI::ExtraAliasInstanceArray };
        static constexpr auto VTABLE{ RE::VTABLE::ExtraAliasInstanceArray };
        static constexpr auto TYPE{ RE::ExtraDataType::kAliasInstanceArray };

        // members
        BSTArrayCustom<AliasData> aliasDataArray; // 18
    };

	class __declspec(novtable) ExtraBlueprintPartOriginData : public RE::BSExtraData
	{
	public:
		static constexpr auto RTTI{ RE::RTTI::ExtraBlueprintPartOriginData };
		static constexpr auto VTABLE{ RE::VTABLE::ExtraBlueprintPartOriginData };
		static constexpr auto TYPE{ RE::ExtraDataType::kBlueprintPartOriginData };

	};

	class __declspec(novtable) ExtraLinkedRef : public RE::BSExtraData
	{
	public:
		static constexpr auto RTTI{ RE::RTTI::ExtraLinkedRef };
		static constexpr auto VTABLE{ RE::VTABLE::ExtraLinkedRef };
		static constexpr auto TYPE{ RE::ExtraDataType::kLinkedRef };

		// members
		uint64_t pad[2];  // 18
		RE::BGSKeyword* linkKeyword;
	};
	static_assert(offsetof(ExtraLinkedRef, linkKeyword) == 0x28);

    namespace Custom
    {
        class MagicItem : public RE::TESBoundObject, public RE::TESFullName, public RE::BGSKeywordForm
        {
        public:
            // members
            BSTArrayCustom<RE::EffectItem*> effectList;
        };

        static_assert(offsetof(MagicItem, effectList) == 0x128);

        class __declspec(novtable) ActiveEffect : public RE::BSIntrusiveRefCounted
        {
        public:
            static constexpr auto RTTI{ RE::RTTI::ActiveEffect };
            static constexpr auto VTABLE{ RE::VTABLE::ActiveEffect };

            uint64_t           unk[10];
            RE::Custom::MagicItem* sourceEffect; // sourceEffect can be Spell, Object Effect or Potion
            uint64_t           unk60;
            RE::TESForm*       sourceItem; // sourceItem could be an Armor for example if sourceEffect is an Object Effect (EnchantmentItem; ENCH)
            uint64_t           pad01;
            uint64_t           unk50;
            float              elapsedTime;
            float              duration;
            float              magnitude;
        };

        static_assert(offsetof(ActiveEffect, sourceEffect) == 0x58);
        static_assert(offsetof(ActiveEffect, sourceItem) == 0x68);
        static_assert(offsetof(ActiveEffect, elapsedTime) == 0x80);
        static_assert(offsetof(ActiveEffect, duration) == 0x84);
        static_assert(offsetof(ActiveEffect, magnitude) == 0x88);

        class ActiveEffectList
        {
        public:
            // members
            uint64_t                      unk1;
            BSTArrayCustom<ActiveEffect*> data; // 08
        };

        static_assert(sizeof(ActiveEffectList) == 0x18);
    }  

	// MY ADDON (from f4se)
	class BSString
	{
	public:
		BSString() :
			m_data(NULL), m_dataLen(0), m_bufLen(0) {}
		~BSString()
		{
			if (m_data) {
				RE::MemoryManager::GetSingleton()->Free(m_data, false);
				m_data = nullptr;
				m_dataLen = 0;
				m_bufLen = 0;
			}
		};

		[[nodiscard]] const char* Get(void)  // MY ADDON
		{
			return m_data ? m_data : "";
		};

	private:
		char* m_data;     // 00
		uint16_t   m_dataLen;  // 08
		uint16_t m_bufLen;   // 0A
		uint16_t   pad0C;      // 0C
	};

	class BGSStoryTellerCustom  // Starfield.exe + 0x6876488 in v1.12.36
	{
	public:
		[[nodiscard]] static BGSStoryTellerCustom* GetSingleton()
		{
			REL::Relocation<BGSStoryTellerCustom**> singleton{ REL::ID(878850) };
			return *singleton;
		}

		// (handy: https://github.com/powerof3/CommonLibSSE/blob/dev/include/RE/B/BGSStoryTeller.h)

		uint64_t                      unk01[7];			// locations here in some strange data structures
		BSTArrayCustom<RE::TESQuest*>  queuedToStart;	// not sure about the purpose of these arrays (i.e. really queuedToStart) but seems likely
		BSTArrayCustom<RE::TESQuest*> runningQuests;	// many quests are here, probably all running quests
		BSTArrayCustom<RE::TESQuest*>  queuedToStop;
		uint64_t                       pad01[2];
		BSTArrayCustom<RE::TESQuest*>  unk01Quests;
		BSTArrayCustom<RE::TESQuest*>  unk02Quests;
		uint8_t                       pad02[128];
		//BSTHashMap<std::uint32_t, BSTArrayCustom<BSTTuple<std::uint32_t, std::uint32_t>>*> questStageWaitMap;
	};

	static_assert(offsetof(BGSStoryTellerCustom, queuedToStart) == 0x38);
	static_assert(offsetof(BGSStoryTellerCustom, runningQuests) == 0x48);
	static_assert(offsetof(BGSStoryTellerCustom, unk01Quests) == 0x78);
	static_assert(offsetof(BGSStoryTellerCustom, unk02Quests) == 0x88);
	//static_assert(offsetof(BGSStoryTellerCustom, questStageWaitMap) == 0x118);


	// verified on v1.12.30
	class UICellRenderer_InventoryItemCustom
	{
	public:
		// members
		uint64_t           pad[24];
		RE::TESObjectREFR* inventoryitemRef;  // C0

		RE::TESObjectREFR* GetInventoryItemRef()		// SEH exceptions
		{
			try {
				auto thisAddr = reinterpret_cast<unsigned long long*>(this);
				if (!thisAddr)
					return nullptr;
				auto itemRefAddrAddr = *thisAddr + 0xC0;
				auto itemRefAddrPtr = reinterpret_cast<unsigned long long*>(itemRefAddrAddr);
				if (!itemRefAddrPtr)
					return nullptr;
				auto itemRefAddr = *itemRefAddrPtr;
				auto itemRef = reinterpret_cast<RE::TESObjectREFR*>(itemRefAddr);
				return itemRef;
			} catch (...) {
				LogError("exception");
			}
			return nullptr;
		}
	};

	static_assert(offsetof(UICellRenderer_InventoryItemCustom, inventoryitemRef) == 0xC0);

	class WeaponsCraftingMenuCustom : public RE::IMenu
	{
	public:
		// members
		uint64_t pad[346];
		uint16_t pad02[2];

		UICellRenderer_InventoryItemCustom* GetInventoryItem()
		{
			return reinterpret_cast<UICellRenderer_InventoryItemCustom*>((reinterpret_cast<unsigned long long>(this) + 0xCA0));
		}
	};

	class ArmorCraftingMenuCustom : public RE::IMenu
	{
	public:
		// members
		uint64_t pad[346];
		uint16_t pad02[2];

		UICellRenderer_InventoryItemCustom* GetInventoryItem()
		{
			auto item = reinterpret_cast<UICellRenderer_InventoryItemCustom*>((reinterpret_cast<unsigned long long>(this) + 0xC90));
			return item;
		}
	};

	class PlayerAutoAimActorEventClass  // Starfield.exe + 0x065421F0 in v1.10.32.
	{
	public:
		[[nodiscard]] static PlayerAutoAimActorEventClass* GetSingleton()
		{
			REL::Relocation<PlayerAutoAimActorEventClass**> singleton{ REL::ID(881118) };
			return *singleton;
		}

		struct EventData
		{
			
			uint32_t           targetHandle;     // works only on player teammates??
			uint64_t           unk[3];           // BSFadeNode* at 20
			RE::BSFadeNode*    target3D;		 // always valid
			uint64_t           unk2[10];
			RE::BGSLocation*   currentLocation;
			uint64_t           unk3[7];
			RE::TESRace*       race;  // always points to HumanRace, even when there's no autoaimTargetRef. Player.GetRace() maybe ??
			uint64_t           unk4[2];
			RE::TESObjectREFR* autoaimTargetRef;  // valid as long as activatable (including MovableStatic so not necessarily "activatable"), otherwise nullptr; should match GetCrosshairRef

		};
		static_assert(offsetof(EventData, target3D) == 0x20);
		static_assert(offsetof(EventData, currentLocation) == 0x78);
		static_assert(offsetof(EventData, race) == 0xB8);
		static_assert(offsetof(EventData, autoaimTargetRef) == 0xD0);

		EventData* data;
	};

	static_assert(offsetof(PlayerAutoAimActorEventClass, data) == 0x00);

	class NEW_REFR_DATA
	{
	public:
		static constexpr auto RTTI{ RTTI::NEW_REFR_DATA };
		static constexpr auto VTABLE{ VTABLE::NEW_REFR_DATA };

		NEW_REFR_DATA()
		{
			stl::emplace_vtable(this);
		}

		[[nodiscard]] bool SetInitiallyDisabled(bool bSet)
		{
			auto addr = reinterpret_cast<uintptr_t>(this);
			auto flag = reinterpret_cast<bool*>(addr + 0x8E);
			if (flag) {
				*flag = bSet;
				return true;
			}
			return false;
		}

		// members
		uintptr_t           vTable;
		RE::NiPoint3A       position;
		RE::NiPoint3        rotation;
		RE::TESBoundObject* baseObject{ nullptr };  // NEW_REFR_DATA[6]
		RE::TESObjectCELL*  cell{ nullptr };
		RE::TESWorldSpace*  world{ nullptr };
		RE::TESObjectREFR*  ref{ nullptr };
		void*               extraPrimitive{ nullptr };  // NEW_REFR_DATA[10]
		void*               unk58{ nullptr };
		int*                unk60{ nullptr };  // NEW_REFR_DATA[12]
		void*               unk68{ nullptr };
		uintptr_t           unk702[7]{ 0 };
	};
	static_assert(offsetof(NEW_REFR_DATA, baseObject) == 0x30);
	static_assert(offsetof(NEW_REFR_DATA, world) == 0x40);
	static_assert(sizeof(NEW_REFR_DATA) == 0xB0);

	struct TimeGlobals	// Starfield.exe + 0x682DAA0 in v1.14.70
	{
	public:

		[[nodiscard]] static TimeGlobals* GetSingleton()
		{
			REL::Relocation<TimeGlobals**> singleton{ REL::ID(878435) };
			return *singleton;
		}

		[[nodiscard]] float GetGameUT() const  // universal time (compared to local, see GetLocalTime)
		{
			if (this->GameHour)
				return this->GameHour->value;
			return -1.00f;
		}

		[[nodiscard]] float GetGameYear() const
		{
			if (this->GameHour)
				return this->GameYear->value + 2000.0f;		// 2330
			return -1.00f;
		}

		[[nodiscard]] float GetGameMonth() const
		{
			if (this->GameHour)
				return this->GameMonth->value;
			return -1.00f;
		}

		[[nodiscard]] float GetGameDay() const
		{
			if (this->GameHour)
				return this->GameDay->value;
			return -1.00f;
		}

		[[nodiscard]] float GetGameHour() const
		{
			if (this->GameHour)
				return this->GameHour->value;
			return -1.00f;
		}

		[[nodiscard]] float GetGameDaysPassed() const
		{
			if (this->GameHour)
				return this->GameDaysPassed->value;
			return -1.00f;
		}

		[[nodiscard]] std::pair<int, int> GetDayUniversalTime() const
		{
			std::pair<int, int> Result;
			auto                fUniversalTime = GetGameHour();
			if (fUniversalTime == -1.00f) {
				Result.first = -1.00f;
				Result.second = -1.00f;
			} else {
				int iHour = static_cast<int>(fUniversalTime);
				//int iMinute = static_cast<int>((fUniversalTime - iHour) * 60);
				int iMinute = static_cast<int>(round((fUniversalTime - static_cast<float>(iHour)) * 60.0f));
				Result.first = iHour;
				Result.second = iMinute;
			}
			return Result;
		}

		uint32_t pad00_08[2];
		RE::TESGlobal* GameYear;
		RE::TESGlobal* GameMonth;
		RE::TESGlobal* GameDay;
		RE::TESGlobal* GameHour;
		RE::TESGlobal* GameDaysPassed;
		RE::TESGlobal* TimeScale;
	};
	static_assert(offsetof(TimeGlobals, TimeScale) == 0x30);
	static_assert(sizeof(TimeGlobals) == 0x38);

} // namespace Classes
