#pragma once

class LKIniWrite
{
public:
    // LKIniWrite(const char* szFileName);
    // void WInt(const char* szSection, const char* szKey, int iValue);
    // void WFloat(const char* szSection, const char* szKey, float fltValue);
    // void WBool(const char* szSection, const char* szKey, bool bolValue);
    // void WStr(const char* szSection, const char* szKey, const char* szValue);

    LKIniWrite(const char* szFileName)
    {
        memset(m_szFileName, 0x00, 255);
        memcpy(m_szFileName, szFileName, strlen(szFileName));
    }

    void WInt(const char* Section, const char* Key, int iValue)
    {
        char chValue[255];
        sprintf_s(chValue, "%d", iValue);
        WritePrivateProfileString(CA2CT(Section), CA2CT(Key), CA2CT(chValue), CA2CT(m_szFileName));
    }

    void WFloat(const char* Section, const char* Key, float fValue)
    {
        char chValue[255];
        sprintf_s(chValue, "%f", fValue);
        WritePrivateProfileString(CA2CT(Section), CA2CT(Key), CA2CT(chValue), CA2CT(m_szFileName));
    }

    void WBool(const char* Section, const char* Key, bool bValue)
    {
        char chValue[255];
        sprintf_s(chValue, "%s", bValue ? "1" : "0");
        WritePrivateProfileString(CA2CT(Section), CA2CT(Key), CA2CT(chValue), CA2CT(m_szFileName));
    }

    void WStr(const char* Section, const char* Key, const char* chValue) { WritePrivateProfileString(CA2CT(Section), CA2CT(Key), CA2CT(chValue), CA2CT(m_szFileName)); }

private:
    char m_szFileName[255];
};

class LKIniRead
{
public:
    // LKIniRead(const char* szFileName);
    // int         RInt(const char* szSection, const char* szKey, int iDefaultValue);
    // float       RFloat(const char* szSection, const char* szKey, float fltDefaultValue);
    // bool        RBool(const char* szSection, const char* szKey, bool bolDefaultValue);
    // const char* RStr(const char* szSection, const char* szKey, const const char* szDefaultValue);

    LKIniRead(const char* szFileName)
    {
        memset(m_szFileName, 0x00, 255);
        memcpy(m_szFileName, szFileName, strlen(szFileName));
    }

    inline int RInt(const char* Section, const char* Key, int iDefValue)
    {
        int iValue = GetPrivateProfileInt(Section, Key, iDefValue, m_szFileName);
        return iValue;
    }

    inline float RFloat(const char* Section, const char* Key, float fDefValue)
    {
        char  out[255];
        char  def[255];
        float fValue;
        sprintf_s(def, "%f", fDefValue);
        GetPrivateProfileString(Section, Key, def, out, 255, m_szFileName);
        fValue = static_cast<float>(atof(out));
        return fValue;
    }

    inline bool RBool(const char* Section, const char* Key, bool bDefValue)
    {
        char out[255];
        char def[255];
        bool bValue;
        sprintf_s(def, "%s", bDefValue ? "1" : "0");
        GetPrivateProfileString(Section, Key, def, out, 255, m_szFileName);
        bValue = (strcmp(out, "1") == 0 || strcmp(out, "True") == 0 || strcmp(out, "true") == 0) ? 1 : 0;
        return bValue;
    }

    inline const char* RStr(const char* Section, const char* Key, const char* chDefValue)
    {
        char* c   = new char[10000];
        LPSTR out = c;
        memset(out, 0, 10000);
        GetPrivateProfileString(Section, Key, chDefValue, out, 10000, m_szFileName);
        return out;
    }

private:
    char m_szFileName[255];
};

inline static bool DoesIniExist(std::string FileName, std::string bOptionalSubfolder = "")
{
    if (FileName.empty())
        return false;
    std::string pt1 = ".\\Data\\SFSE\\Plugins\\";
    if (!bOptionalSubfolder.empty())
        pt1 = bOptionalSubfolder;
    std::string pt2  = FileName.c_str();
    std::string pt3  = ".ini";
    const auto  path = pt1 + pt2 + pt3;
    if (std::filesystem::exists(path.c_str()) == true) {
        return true;
    }
    return false;
}

inline static bool WriteIni(std::string FileName, std::string Section, std::string Key, std::string Value, std::string bOptionalSubfolder = "")
{
    if (FileName.empty() || Section.empty() || Key.empty())
        return false;
    std::string pt1 = ".\\Data\\SFSE\\Plugins\\";
    if (!bOptionalSubfolder.empty())
        pt1 = bOptionalSubfolder;
    std::string pt2  = FileName.c_str();
    std::string pt3  = ".ini";
    const auto  path = pt1 + pt2 + pt3;
    LKIniWrite  iniWriter(path.c_str());
    iniWriter.WStr(Section.c_str(), Key.c_str(), Value.c_str());
    if (std::filesystem::exists(path.c_str()) == true) {
        LKIniRead   INI(path.c_str());
        std::string theString = INI.RStr(Section.c_str(), Key.c_str(), Value.c_str());
        if (strcmp(theString.c_str(), Value.c_str()) == 0) {
            return true;
        }
    }
    return false;
}

inline static std::string ReadIni(std::string FileName, std::string Section, std::string Key, std::string bOptionalSubfolder = "")
{
    if (FileName.empty() || Section.empty() || Key.empty())
        return "";
    std::string DefValue = "";
    std::string pt1      = ".\\Data\\SFSE\\Plugins\\";
    if (!bOptionalSubfolder.empty())
        pt1 = bOptionalSubfolder;
    std::string pt2  = FileName.c_str();
    std::string pt3  = ".ini";
    const auto  path = pt1 + pt2 + pt3;
    if (std::filesystem::exists(path.c_str()) == false) {
        return "";
    }
    LKIniRead   INI(path.c_str());
    std::string ReturnString = INI.RStr(Section.c_str(), Key.c_str(), DefValue.c_str());
    if (ReturnString.empty() || ReturnString.length() == 0) {
        return "";
    }
    return ReturnString;
}

inline static std::vector<std::string> GetINISectionNames(std::string FilePath, std::string FileName)
{
	std::vector<std::string> Sections;
	if (FilePath.empty() || FileName.empty())
		return Sections;
	std::error_code error;
	auto            theSize = std::filesystem::file_size(FilePath, error);
	if (error)
		return Sections;
	std::string FullPath = FilePath + FileName;
	if (!std::filesystem::exists(FullPath.c_str()) || !std::filesystem::is_regular_file(FullPath.c_str()))
		return Sections;
	char SectionBuf[10000];
	int  l = 0;
	int  nSize = 10001;
	GetPrivateProfileSectionNames(SectionBuf, 10000, FullPath.c_str());
	for (int i = 0; i < nSize; ++i) {
		if (SectionBuf[i] == '\0') {
			if (i > l) {
				std::string s = &SectionBuf[l];
				//LogInfo("found section [" + s + "] in INI [" + FileName + "]");
				Sections.push_back(s);
			} else if (i == l)
				break;
			l = i + 1;
		}
	}
	return Sections;
}

inline static bool DoesFileExistEx(std::string FilePath, std::string FileName)
{
	if (FilePath.empty() || FileName.empty())
		return false;
	std::error_code error;
	auto            theSize = std::filesystem::file_size(FilePath, error);
	if (error)
		return false;
	std::string FullPath = FilePath + FileName;
	if (std::filesystem::exists(FullPath.c_str()) == true && std::filesystem::is_regular_file(FullPath.c_str()) == true)
		return true;
	return false;
}

inline static bool DoesIniExistEx(std::string FilePath, std::string FileName)
{
	if (FilePath.empty() || FileName.empty())
		return false;
	std::error_code error;
	auto            theSize = std::filesystem::file_size(FilePath, error);
	if (error)
		return false;
	std::string FullPath = FilePath + FileName + ".ini";
	if (std::filesystem::exists(FullPath.c_str()) == true) {
		return true;
	}
	return false;
}

inline static bool WriteIniEx(std::string FilePath, std::string FileName, std::string Section, std::string Key, std::string Value)
{
	if (FilePath.empty() || FileName.empty() || Section.empty() || Key.empty())
		return false;
	std::string FullPath = FilePath + FileName + ".ini";
	LKIniWrite  iniWriter(FullPath.c_str());
	iniWriter.WStr(Section.c_str(), Key.c_str(), Value.c_str());
	if (std::filesystem::exists(FullPath.c_str()) == true) {
		LKIniRead   INI(FullPath.c_str());
		std::string theString = INI.RStr(Section.c_str(), Key.c_str(), Value.c_str());
		if (strcmp(theString.c_str(), Value.c_str()) == 0) {
			return true;
		}
	}
	return false;
}

inline static std::string ReadIniEx(std::string FilePath, std::string FileName, std::string Section, std::string Key)
{
	if (FilePath.empty() || FileName.empty() || Section.empty() || Key.empty())
		return "";
	std::string FullPath = FilePath + FileName + ".ini";
	std::string DefValue = "";
	if (std::filesystem::exists(FullPath.c_str()) == false) {
		return "";
	}
	LKIniRead   INI(FullPath.c_str());
	std::string ReturnString = INI.RStr(Section.c_str(), Key.c_str(), DefValue.c_str());
	if (ReturnString.empty() || ReturnString.length() <= 0) {
		return "";
	}
	return ReturnString;
}

/*
inline static std::string GetStarfieldName()
{
    std::string sStarfieldName = ReadIni("SFSE", "Loader", "RuntimeName", ".\\Data\\SFSE\\");
    if (sStarfieldName.empty() == false) {
        LogInfo("detected custom Starfield name [" + sStarfieldName + "] in SFSE.ini.");
    }
    else
        sStarfieldName = "Starfield.exe";
    // LogInfo("detected default Starfield.exe name");
    return sStarfieldName;
}
*/

inline static RE::Actor* GetLastShowLooksMenuTarget()		// target NPC SLM is called on
{
	REL::Relocation<uintptr_t> ptr{ REL::ID(880607) };  // 0x68881a0 in v1.12.36
	uintptr_t                  ptrAddr = ptr.address();
	auto                       ActorPtr = reinterpret_cast<RE::Actor**>(ptrAddr);
	if (ActorPtr && *ActorPtr)
		return *ActorPtr;
	return nullptr;
}

inline static RE::Actor* GetLastShowLooksMenuTargetEx()
{
	auto slmTarget = GetLastShowLooksMenuTarget();
	if (slmTarget) {
		for (auto& i : RE::VTABLE::PlayerCharacter) {
			if (i.address() == *reinterpret_cast<uintptr_t*>(slmTarget))
				return slmTarget;
		}
		for (auto& i : RE::VTABLE::Actor) {
			if (i.address() == *reinterpret_cast<uintptr_t*>(slmTarget))
				return slmTarget;
		}
	}
	return nullptr;
}

inline static RE::TESObjectREFR* GetCrosshairRef(RE::PlayerCharacter* PlayerCharPassThru = nullptr)
{   // should match PlayerAutoAimActorEventClass autoaimTargetRef
	if (!PlayerCharPassThru)
		PlayerCharPassThru = RE::PlayerCharacter::GetSingleton();
	/*
	auto refPtr = reinterpret_cast<RE::TESObjectREFR**>(reinterpret_cast<uintptr_t>(PlayerCharPassThru) + 0xF80);
	if (refPtr)
		return *refPtr;
	*/
	// new design in v1.14.70
	try {
		auto crosshairRef = PlayerCharPassThru->crosshairRef;
		if (crosshairRef)
			return crosshairRef;
	} catch (...) {
		;
	}
	return nullptr;
}

/*
inline static RE::TESObjectREFR* GetCrosshairRefEx(RE::PlayerCharacter* PlayerCharPassThru = nullptr)
{
	
	// use PlayerAutoAimActorEventClass target3D then find the TESObjectREFR which has this 3D

}
*/

inline static std::string GetCurrentTimeAndDate(bool bFileNameSupport = false)
{
    using namespace std::chrono;
    auto               now  = system_clock::now();
    auto               ms   = duration_cast<milliseconds>(now.time_since_epoch()) % 1000;
    auto               time = system_clock::to_time_t(now);
    std::tm            bt   = *std::localtime(&time);
    std::ostringstream oss;
    if (!bFileNameSupport)
        oss << std::put_time(&bt, "%F %H:%M:%S"); // format: 2023-11-26 9:51:00
    else
        oss << std::put_time(&bt, "%F_%H-%M-%S");                  // format: 2023-11-26_9-51-00
    oss << '.' << std::setfill('0') << std::setw(5) << ms.count(); // format: 2023-11-26_9-51-00.000
    return oss.str();
}

inline static std::string GetFormIDAsHex(RE::TESForm* paramForm, bool beNice = true)
{
    if (!paramForm)
        return "";
    std::string s = "";
    s             = std::format("{:x}", paramForm->GetFormID());
    if (s.empty())
        return "";
    if (!beNice)
        return s;
    std::transform(s.begin(), s.end(), s.begin(), [](unsigned char c) -> char { return static_cast<char>(::toupper(c)); });
    std::stringstream ss;
    ss << std::setw(8) << std::setfill('0') << s;
    std::string s2 = ss.str();
    return s2;
}

template <class T>
inline static std::string GetNumericDataVectorAsStr(std::vector<T> vec, int iMode)
{  // iMode: 0 = int, 1 = hex, 2 = hexFormID
	if (vec.size() == 0)
		return "";
	std::string s;
	if (iMode == 0) {
		for (auto& it : vec) {
			if (s.size() > 0)
				s = s + ", " + std::to_string(it);
			else
				s = std::to_string(it);
		}
	} else if (iMode == 1) {
		for (auto& it : vec) {
			std::stringstream ss;
			ss << std::hex << it;
			if (s.size() > 0)
				s = s + ", " + ss.str();
			else
				s = ss.str();
		}
	} else if (iMode == 2) {
		for (auto& it : vec) {
			std::stringstream ss;
			ss << std::hex << std::setw(8) << std::setfill('0') << it;
			if (s.size() > 0)
				s = s + ", " + ss.str();
			else
				s = ss.str();
		}
	} else if (iMode == 3) {
		for (auto& it : vec) {
			std::stringstream ss;
			ss << std::hex << std::setw(8) << std::setfill('0') << it;
			if (s.size() > 0)
				s = s + ", " + ss.str();
			else
				s = ss.str();
			std::transform(s.begin(), s.end(), s.begin(), [](unsigned char c) -> char { return static_cast<char>(::toupper(c)); });
		}
	}
	return s;
}

inline static std::string GetUIntFormIDAsHex(uint32_t formID, bool beNice = true)
{
    if (formID == 0)
        return "";
	std::string s = std::format("{:x}", formID);
    if (s.empty())
        return "";
    if (!beNice)
        return s;
    std::transform(s.begin(), s.end(), s.begin(), [](unsigned char c) -> char { return static_cast<char>(::toupper(c)); });
    std::stringstream ss;
    ss << std::setw(8) << std::setfill('0') << s;
    std::string s2 = ss.str();
    return s2;
}

inline static std::uint32_t GetHexFormIDAsUInt(std::string hexFormID)
{
	if (hexFormID.empty())
		return 0;
	unsigned int FormID = 0;
	try {
		FormID = std::stoul(hexFormID, nullptr, 16);
	} catch (...) {
		LogError("std::stoul exception thrown for input String: " + hexFormID + ". Returning 0.");
		return 0;
	}
	return FormID;
}

inline static std::string GetAddressAsHex(unsigned long long address, bool bAsOffset = false)
{
    if (address <= 0)
        return "";
    std::string s;
    if (bAsOffset) {
        auto offset = address - StarfieldBaseAddress;
        if (offset <= 0) {
            LogError("calculated offset <= 0 --> [" + std::to_string(offset) + "]");
        }
        else {
            s = std::format("{:x}", offset);
            if (s.empty())
                return "";
            std::transform(s.begin(), s.end(), s.begin(), [](unsigned char c) -> char { return static_cast<char>(::toupper(c)); });
            s = "Starfield.exe + 0x" + s;
            return s;
        }
    }
    s = std::format("{:x}", address);
    if (s.empty())
        return "";
    std::transform(s.begin(), s.end(), s.begin(), [](unsigned char c) -> char { return static_cast<char>(::toupper(c)); });
    return s;
}

template <typename T>
inline static std::string GetObjectAddressAsHex(T* form, bool bAsOffset = false)
{
    if (!form)
        return "";
    return GetAddressAsHex(reinterpret_cast<unsigned long long>(form), bAsOffset);
}

inline static std::string ToUpperStr(std::string str)
{
    std::transform(str.begin(), str.end(), str.begin(), [](unsigned char c) -> char { return static_cast<char>(::toupper(c)); });
    return str;
}

inline static std::string ToLowerStr(std::string str)
{
    std::transform(str.begin(), str.end(), str.begin(), [](unsigned char c) -> char { return static_cast<char>(::tolower(c)); });
    return str;
}

inline static std::string ByteAsString(BYTE theByte)
{
    std::string s = std::format("{:x}", theByte);
    if (s.length() == 0) {
        return "!!!ERROR!!!";
    }
    else
        std::transform(s.begin(), s.end(), s.begin(), [](unsigned char c) -> char { return static_cast<char>(::toupper(c)); });
    if (s.length() == 0) {
        return "!!!ERROR!!!";
    }
    return s;
}

inline static bool IsActorReference(unsigned long long* unverifiedFormAddress, bool bAllowPlayerActor = true)
{
    if (!unverifiedFormAddress)
        return false;
    for (auto& i : RE::VTABLE::PlayerCharacter) {
		if (i.address() == *unverifiedFormAddress) {
			if (bAllowPlayerActor)
				return true;
			else
				return false;
		}            
    }
    for (auto& i : RE::VTABLE::Actor) {
        if (i.address() == *unverifiedFormAddress)
            return true;
    }
    // for (auto& i : RE::VTABLE::TESObjectREFR) {
    //     if (i.address() == *unverifiedFormAddress)
    //         return true;
    // }
    return false;
}

inline static std::vector<RE::Actor*> GetPhotoModeActors()  // SEH exceptions
{
	std::vector<RE::Actor*> Result;
	if (RE::UI::GetSingleton()->IsMenuOpen("PhotoModeMenu") == false)
		return Result;
	try {
		REL::Relocation<uintptr_t> reloc{ REL::ID(1616252) };  // 0x64F7AA0 in v1.12.36
		auto                       singleton = reloc.address();
		auto                       size = *reinterpret_cast<int*>(singleton);
		if (size == 0)
			return Result;
		auto startAddr = *reinterpret_cast<uintptr_t*>(singleton + 0x8);
		auto currentAddr = startAddr;
		for (int i = 0; i < size; i++) {
			auto actorPtr = reinterpret_cast<RE::Actor**>(currentAddr);
			currentAddr = currentAddr + 0x40;
			if (!actorPtr || !*actorPtr)
				continue;
			auto actor = *actorPtr;
			if (!IsActorReference(reinterpret_cast<uintptr_t*>(actor), true))
				continue;
			 Result.push_back(actor);
		}
	} catch (...) {
		std::vector<RE::Actor*> emptyArray;
		return emptyArray;
	}
	return Result;
}

inline static bool IsObjectReference(unsigned long long* unverifiedFormAddress, bool bAllowActors, bool bAllowPlayerActor)
{
	if (bAllowActors && IsActorReference(unverifiedFormAddress, bAllowPlayerActor))
		return true;
	for (auto& i : RE::VTABLE::TESObjectREFR) {
		if (i.address() == *unverifiedFormAddress)
			return true;
	}
	// for (auto& i : RE::VTABLE::TESObjectREFR) {
	//     if (i.address() == *unverifiedFormAddress)
	//         return true;
	// }
	return false;
}

inline static bool IsTESPackedFile(unsigned long long* unverifiedFormAddress)
{
    if (!unverifiedFormAddress)
        return false;
    for (auto& i : RE::VTABLE::TESPackedFile) {
        if (i.address() == *unverifiedFormAddress)
            return true;
    }
    return false;
}

inline static bool IsTESWorldSpace(unsigned long long* unverifiedFormAddress)
{
	if (!unverifiedFormAddress)
		return false;
	for (auto& i : RE::VTABLE::TESWorldSpace) {
		if (i.address() == *unverifiedFormAddress)
			return true;
	}
	return false;
}

inline static bool IsTESObjectCELL(unsigned long long* unverifiedFormAddress)
{
	if (!unverifiedFormAddress)
		return false;
	for (auto& i : RE::VTABLE::TESObjectCELL) {
		if (i.address() == *unverifiedFormAddress)
			return true;
	}
	return false;
}

inline static int GetRandomInt(int min, int max)
{
	std::random_device                 rd;               // obtain a random number from hardware
	std::mt19937                       gen(rd());        // seed the generator
	std::uniform_int_distribution<int> distr(min, max);  // define the range
	for (int n = 0; n < max; ++n)
		distr(gen);
	return distr(gen);
}

template <typename T>
inline static BSTArrayCustom<T>* GetAsBSTArrayCustom(RE::BSTArray<T>* arr)
{
    if (!arr)
        return nullptr;
    return reinterpret_cast<BSTArrayCustom<T>*>(arr);
}

inline static std::string GetFormEditorID(RE::TESForm* paramForm)
{
    std::string sEditorID;
    if (paramForm)
        sEditorID = paramForm->GetFormEditorID();
    return sEditorID;
}

inline static std::string GetTESFullNameNative(RE::TESForm* theForm)
{
	if (!theForm) {
		LogError("theForm is nullptr");
		return "";
	}
	REL::Relocation<uintptr_t> ptr{ REL::ID(86218) };  // 0x1529F30 in v1.13.61
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<const char* (*)(RE::TESForm*)>(addr);
	auto result = func(theForm);
	if (!result)
		return "";
	return result;
}

inline static std::string GetTESFullName(RE::TESForm* theForm)
{
    if (!theForm) {
        LogError("theForm is nullptr");
        return "";
    }
    auto FullName = Runtime_DynamicCast<RE::TESForm, RE::TESFullName>(theForm);
	if (FullName != nullptr) {
		auto chFullName = FullName->GetFullName();
		if (chFullName && !std::string(chFullName).empty())
			return chFullName;
	}
	std::string sFullName = GetTESFullNameNative(theForm);
	if (!sFullName.empty())
		return sFullName;
    // LogError("function ended unexpectedly.");
    return "";
}

inline static bool SetTESFullName(RE::TESForm* theForm, std::string sName)
{
	if (!theForm)
		return false;
	auto fullName = Runtime_DynamicCast<RE::TESForm, RE::TESFullName>(theForm);
	if (!fullName)
		return false;
	fullName->fullName = sName;
	return true;
}

inline static std::string GetBasicFormData(RE::TESForm* theForm, bool bFormType = false, bool bModIndex = false, bool bFULLName = false, bool bEditorID = false)
{
    if (!theForm)
        return "!!! ERROR: nullptr form !!!";
    std::string sResult = "[" + GetAddressAsHex(reinterpret_cast<unsigned long long>(theForm)) + " | " + GetUIntFormIDAsHex(theForm->formID);
    if (bFormType) {
        auto sFormType = std::to_string(theForm->GetFormType());
        if (sFormType.empty())
            sResult = sResult + " | {unknown_type}";
        else
            sResult = sResult + " | " + sFormType;
    }
    if (bModIndex) {
		std::string sModIndex = std::to_string(theForm->loadOrderIndex) + "|0x" + ToUpperStr(std::format("{:x}", theForm->loadOrderIndex));
        if (sModIndex.size() < 3)
            sResult = sResult + " | {unknown_modindex}";
        else
            sResult = sResult + " | " + sModIndex;
    } 
    if (bFULLName) {
        std::string sFULLName = GetTESFullName(theForm);
        if (sFULLName.empty())
            sResult = sResult + " | {unnamed}";
        else
            sResult = sResult + " | " + sFULLName;
    }
    if (bEditorID) {
        std::string sEditorID = GetFormEditorID(theForm);
        if (sEditorID.empty())
            sResult = sResult + " | {no_edid}";
        else
            sResult = sResult + " | " + sEditorID;
    }
    sResult = sResult + "]";
    return sResult;
}

inline static std::vector<BYTE> ReadBytes(unsigned long long TargetAddress, int ByteCount)
{
	std::vector<BYTE> Result;
	BYTE* TargetAddressBytePtr = reinterpret_cast<BYTE*>(TargetAddress);
	if (!TargetAddressBytePtr) {
		LogError("TargetAddressBytePtr is nullptr");
		return Result;
	}
	BYTE* bytePtr = reinterpret_cast<BYTE*>(TargetAddress);
	if (!bytePtr) {
		LogError("(TargetAddress) bytePtr is nullptr");
		return Result;
	}
	auto byteAddress = TargetAddress;
	BYTE oneByte = 1;
	bool bError = false;
	for (BYTE i = 0; i < ByteCount; i++) {
		LogDebug("   (TargetAddress) Looping at (" + std::to_string(i) + ")");
		BYTE* byteValPtr = reinterpret_cast<BYTE*>(byteAddress);
		BYTE  originalBytePtrValue = 0;
		if (!byteValPtr) {
			LogError("   (TargetAddress) original Byte ptr at (" + std::to_string(i) + ") is nullptr.");
			return Result;
		} else
			originalBytePtrValue = *byteValPtr;
		Result.push_back(*byteValPtr);
		byteAddress = byteAddress + oneByte;
	}
	return Result;
}

inline static bool ReadCompareBytes(std::vector<BYTE> BytesToCompareWith, unsigned long long TargetAddress, bool bDoNotTreatAsError = false)
{
	LogDebug("scanning bytes starting at address [" + GetAddressAsHex(TargetAddress, true) + "]");
    BYTE* TargetAddressBytePtr = reinterpret_cast<BYTE*>(TargetAddress);
    if (!TargetAddressBytePtr) {
        LogError("TargetAddressBytePtr is nullptr");
        return false;
    }
    if (BytesToCompareWith.size() == 0) {
        LogError("BytesToCompareWith.size == 0");
        return false;
    }
    LogDebug("sizeof(BytesToCompareWith) is: " + std::to_string(BytesToCompareWith.size()));
    BYTE* bytePtr = reinterpret_cast<BYTE*>(TargetAddress);
    if (!bytePtr) {
        LogError("(TargetAddress) bytePtr is nullptr");
        return false;
    }
    auto byteAddress = TargetAddress;
    BYTE oneByte     = 1;
    bool bError      = false;
    for (BYTE i = 0; i < BytesToCompareWith.size(); i++) {
        LogDebug("   (TargetAddress) Looping at (" + std::to_string(i) + ")");
        BYTE* byteValPtr           = reinterpret_cast<BYTE*>(byteAddress);
        BYTE  originalBytePtrValue = 0;
        if (!byteValPtr) {
            LogError("   (TargetAddress) original Byte ptr at (" + std::to_string(i) + ") is nullptr.");
            return false;
        }
        else
            originalBytePtrValue = *byteValPtr;
        BYTE data[] = { BytesToCompareWith.at(i) };
        if (*byteValPtr != BytesToCompareWith.at(i)) {
            bError = true;
            if (!bDoNotTreatAsError) {
                LogError("   (TargetAddress) original Byte value at (" + std::to_string(i) + ") [" + ByteAsString(*byteValPtr) + "] is not equal to byte to compare with ["
                         + ByteAsString(BytesToCompareWith.at(i)) + "]");
            }
            else {
                LogDebug("   (TargetAddress) original Byte value at (" + std::to_string(i) + ") [" + ByteAsString(*byteValPtr) + "] is not equal to byte to compare with ["
                         + ByteAsString(BytesToCompareWith.at(i)) + "]");
            }
        }
        else {
            LogDebug("   (TargetAddress) original Byte value at (" + std::to_string(i) + ") [" + ByteAsString(*byteValPtr) + "] is equal to byte to compare with ["
                     + ByteAsString(BytesToCompareWith.at(i)) + "]");
        }
        byteAddress = byteAddress + oneByte;
    }
    return (bError == false);
}

inline static bool WriteBytes(std::vector<BYTE> BytesToWrite, unsigned long long TargetAddress)
{
    BYTE* TargetAddressBytePtr = reinterpret_cast<BYTE*>(TargetAddress);
    if (!TargetAddressBytePtr) {
        LogError("TargetAddressBytePtr is nullptr");
        return false;
    }
    if (BytesToWrite.size() == 0) {
        LogError("BytesToWrite.size == 0");
        return false;
    }
    LogDebug("sizeof(BytesToWrite) is: " + std::to_string(BytesToWrite.size()));
    BYTE* bytePtr = reinterpret_cast<BYTE*>(TargetAddress);
    if (!bytePtr) {
        LogError("(TargetAddress) bytePtr is nullptr.");
        return false;
    }
    else
        LogDebug("(TargetAddress) bytePtr starting value is [" + ByteAsString(*bytePtr) + "]. Proceeding...");

    LogDebug("VirtualProtect init 01.");
    DWORD Protection;
    if (VirtualProtect(TargetAddressBytePtr, 200, PAGE_EXECUTE_READWRITE, &Protection) == false) {
        LogError("VirtualProtect error 01.");
        return false;
    }
    else
        LogDebug("VirtualProtect complete 01. Proceeding...");

    auto byteAddress = TargetAddress;
    BYTE oneByte     = 1;
    for (BYTE i = 0; i < BytesToWrite.size(); i++) {
        LogDebug("   (TargetAddress) Looping at (" + std::to_string(i) + ")");
        BYTE* byteValPtr           = reinterpret_cast<BYTE*>(byteAddress);
        BYTE  originalBytePtrValue = 0;
        if (!byteValPtr) {
            LogError("   (TargetAddress) original Byte ptr at (" + std::to_string(i) + ") is nullptr.");
            return false;
        }
        else
            originalBytePtrValue = *byteValPtr;
        BYTE data[] = { BytesToWrite.at(i) };
        memmove(byteValPtr, &data, oneByte);
        byteAddress = byteAddress + oneByte;
        LogDebug("   (TargetAddress) original Byte value at (" + std::to_string(i) + ") changed from [" + ByteAsString(originalBytePtrValue) + "] to new Byte value ["
                 + ByteAsString(*byteValPtr) + "]");
    }
    LogDebug("VirtualProtect init 02.");
    if (VirtualProtect(TargetAddressBytePtr, 200, Protection, &Protection) == false) {
        LogError("VirtualProtect error 02.");
        return false;
    }
    LogDebug("VirtualProtect complete 02. Proceeding...");
    LogDebug("patching done.");
    return true;
}

inline static std::string GetBSButtonCodeName(RE::BS_BUTTON_CODE buttonCode)
{
	if (buttonCode == RE::BS_BUTTON_CODE::kBackspace)
		return "Backspace";
	if (buttonCode == RE::BS_BUTTON_CODE::kTab)
		return "Tab";
	if (buttonCode == RE::BS_BUTTON_CODE::kEnter)
		return "Enter";
	if (buttonCode == RE::BS_BUTTON_CODE::kCapsLock)
		return "Caps Lock";
	if (buttonCode == RE::BS_BUTTON_CODE::kEscape)
		return "Escape";
	if (buttonCode == RE::BS_BUTTON_CODE::kSpace)
		return "Space";
	if (buttonCode == RE::BS_BUTTON_CODE::kPageUp)
		return "Page Up";
	if (buttonCode == RE::BS_BUTTON_CODE::kPageDown)
		return "Page Down";
	if (buttonCode == RE::BS_BUTTON_CODE::kEnd)
		return "End";
	if (buttonCode == RE::BS_BUTTON_CODE::kHome)
		return "Home";
	if (buttonCode == RE::BS_BUTTON_CODE::kLeft)
		return "Left";
	if (buttonCode == RE::BS_BUTTON_CODE::kUp)
		return "Up";
	if (buttonCode == RE::BS_BUTTON_CODE::kRight)
		return "Right";
	if (buttonCode == RE::BS_BUTTON_CODE::kDown)
		return "Down";
	if (buttonCode == RE::BS_BUTTON_CODE::kInsert)
		return "Insert";
	if (buttonCode == RE::BS_BUTTON_CODE::kDelete)
		return "Delete";
	if (buttonCode == RE::BS_BUTTON_CODE::k0)
		return "0";
	if (buttonCode == RE::BS_BUTTON_CODE::k1)
		return "1";
	if (buttonCode == RE::BS_BUTTON_CODE::k2)
		return "2";
	if (buttonCode == RE::BS_BUTTON_CODE::k3)
		return "3";
	if (buttonCode == RE::BS_BUTTON_CODE::k4)
		return "4";
	if (buttonCode == RE::BS_BUTTON_CODE::k5)
		return "5";
	if (buttonCode == RE::BS_BUTTON_CODE::k6)
		return "6";
	if (buttonCode == RE::BS_BUTTON_CODE::k7)
		return "7";
	if (buttonCode == RE::BS_BUTTON_CODE::k8)
		return "8";
	if (buttonCode == RE::BS_BUTTON_CODE::k9)
		return "9";
	if (buttonCode == RE::BS_BUTTON_CODE::kA)
		return "A";
	if (buttonCode == RE::BS_BUTTON_CODE::kB)
		return "B";
	if (buttonCode == RE::BS_BUTTON_CODE::kC)
		return "C";
	if (buttonCode == RE::BS_BUTTON_CODE::kD)
		return "D";
	if (buttonCode == RE::BS_BUTTON_CODE::kE)
		return "E";
	if (buttonCode == RE::BS_BUTTON_CODE::kF)
		return "F";
	if (buttonCode == RE::BS_BUTTON_CODE::kG)
		return "G";
	if (buttonCode == RE::BS_BUTTON_CODE::kH)
		return "H";
	if (buttonCode == RE::BS_BUTTON_CODE::kI)
		return "I";
	if (buttonCode == RE::BS_BUTTON_CODE::kJ)
		return "J";
	if (buttonCode == RE::BS_BUTTON_CODE::kK)
		return "K";
	if (buttonCode == RE::BS_BUTTON_CODE::kL)
		return "L";
	if (buttonCode == RE::BS_BUTTON_CODE::kM)
		return "M";
	if (buttonCode == RE::BS_BUTTON_CODE::kN)
		return "N";
	if (buttonCode == RE::BS_BUTTON_CODE::kO)
		return "O";
	if (buttonCode == RE::BS_BUTTON_CODE::kP)
		return "P";
	if (buttonCode == RE::BS_BUTTON_CODE::kQ)
		return "Q";
	if (buttonCode == RE::BS_BUTTON_CODE::kR)
		return "R";
	if (buttonCode == RE::BS_BUTTON_CODE::kS)
		return "S";
	if (buttonCode == RE::BS_BUTTON_CODE::kT)
		return "T";
	if (buttonCode == RE::BS_BUTTON_CODE::kU)
		return "U";
	if (buttonCode == RE::BS_BUTTON_CODE::kV)
		return "V";
	if (buttonCode == RE::BS_BUTTON_CODE::kW)
		return "W";
	if (buttonCode == RE::BS_BUTTON_CODE::kX)
		return "X";
	if (buttonCode == RE::BS_BUTTON_CODE::kY)
		return "Y";
	if (buttonCode == RE::BS_BUTTON_CODE::kZ)
		return "Z";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x5B))
		return "Left Windows";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x5C))
		return "Right Windows";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x5D))
		return "Applications";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x5F))
		return "Computer Sleep";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_0)
		return "Numpad 0";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_1)
		return "Numpad 1";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_2)
		return "Numpad 2";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_3)
		return "Numpad 3";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_4)
		return "Numpad 4";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_5)
		return "Numpad 5";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_6)
		return "Numpad 6";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_7)
		return "Numpad 7";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_8)
		return "Numpad 8";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_9)
		return "Numpad 9";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_Multiply)
		return "Numpad Multiply";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_Plus)
		return "Numpad Plus";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_Minus)
		return "Numpad Minus";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_Period)
		return "Numpad Period";
	if (buttonCode == RE::BS_BUTTON_CODE::kNumpad_Divide)
		return "Numpad Divide";
	if (buttonCode == RE::BS_BUTTON_CODE::kF1)
		return "F1";
	if (buttonCode == RE::BS_BUTTON_CODE::kF2)
		return "F2";
	if (buttonCode == RE::BS_BUTTON_CODE::kF3)
		return "F3";
	if (buttonCode == RE::BS_BUTTON_CODE::kF4)
		return "F4";
	if (buttonCode == RE::BS_BUTTON_CODE::kF5)
		return "F5";
	if (buttonCode == RE::BS_BUTTON_CODE::kF6)
		return "F6";
	if (buttonCode == RE::BS_BUTTON_CODE::kF7)
		return "F7";
	if (buttonCode == RE::BS_BUTTON_CODE::kF8)
		return "F8";
	if (buttonCode == RE::BS_BUTTON_CODE::kF9)
		return "F9";
	if (buttonCode == RE::BS_BUTTON_CODE::kF10)
		return "F10";
	if (buttonCode == RE::BS_BUTTON_CODE::kF11)
		return "F11";
	if (buttonCode == RE::BS_BUTTON_CODE::kF12)
		return "F12";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x7C))
		return "F13";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x7D))
		return "F14";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x7E))
		return "F15";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x7F))
		return "F16";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x80))
		return "F17";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x81))
		return "F18";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x82))
		return "F19";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x83))
		return "F20";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x84))
		return "F21";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x85))
		return "F22";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x86))
		return "F23";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x87))
		return "F24";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x90))
		return "Num Lock";
	if (buttonCode == static_cast<RE::BS_BUTTON_CODE>(0x91))
		return "Scroll Lock";
	if (buttonCode == RE::BS_BUTTON_CODE::kSemicolon)
		return "Semicolon";
	if (buttonCode == RE::BS_BUTTON_CODE::kComma)
		return "Comma";
	if (buttonCode == RE::BS_BUTTON_CODE::kEquals)
		return "Equals";
	if (buttonCode == RE::BS_BUTTON_CODE::kMinus)
		return "Minus";
	if (buttonCode == RE::BS_BUTTON_CODE::kPeriod)
		return "Period";
	if (buttonCode == RE::BS_BUTTON_CODE::kDivide)
		return "Divide";
	if (buttonCode == RE::BS_BUTTON_CODE::kLBracket)
		return "Left Bracket";
	if (buttonCode == RE::BS_BUTTON_CODE::kBackslash)
		return "Backslash";
	if (buttonCode == RE::BS_BUTTON_CODE::kRBracket)
		return "Right Bracket";
	if (buttonCode == RE::BS_BUTTON_CODE::kApostrophe)
		return "Apostrophe";
	if (buttonCode == RE::BS_BUTTON_CODE::kLShift)
		return "Left Shift";
	if (buttonCode == RE::BS_BUTTON_CODE::kRShift)
		return "Right Shift";
	if (buttonCode == RE::BS_BUTTON_CODE::kLControl)
		return "Left Control";
	if (buttonCode == RE::BS_BUTTON_CODE::kRControl)
		return "Right Control";
	if (buttonCode == RE::BS_BUTTON_CODE::kLAlt)
		return "Left Alt";
	if (buttonCode == RE::BS_BUTTON_CODE::kRAlt)
		return "Right Alt";
	if (buttonCode == RE::BS_BUTTON_CODE::kBrowserBack)
		return "Browser Back";
	if (buttonCode == RE::BS_BUTTON_CODE::kBrowserForward)
		return "Browser Forward";
	if (buttonCode == RE::BS_BUTTON_CODE::kBrowserRefresh)
		return "Browser Refresh";
	if (buttonCode == RE::BS_BUTTON_CODE::kBrowserStop)
		return "Browser Stop";
	if (buttonCode == RE::BS_BUTTON_CODE::kBrowserSearch)
		return "Browser Search";
	if (buttonCode == RE::BS_BUTTON_CODE::kBrowserFavorites)
		return "Browser Favorites";
	if (buttonCode == RE::BS_BUTTON_CODE::kBrowserStartAndHome)
		return "Browser Start and Home";
	if (buttonCode == RE::BS_BUTTON_CODE::kVolumeMute)
		return "Volume Mute";
	if (buttonCode == RE::BS_BUTTON_CODE::kVolumeDown)
		return "Volume Down";
	if (buttonCode == RE::BS_BUTTON_CODE::kVolumeUp)
		return "Volume Up";
	if (buttonCode == RE::BS_BUTTON_CODE::kGamepad)
		return "Gamepad";
	if (buttonCode == RE::BS_BUTTON_CODE::kDPAD_Up)
		return "DPAD Up";
	if (buttonCode == RE::BS_BUTTON_CODE::kDPAD_Down)
		return "DPAD Down";
	if (buttonCode == RE::BS_BUTTON_CODE::kDPAD_Left)
		return "DPAD Left";
	if (buttonCode == RE::BS_BUTTON_CODE::kDPAD_Right)
		return "DPAD Right";
	if (buttonCode == RE::BS_BUTTON_CODE::kLTrigger)
		return "Left Trigger";
	if (buttonCode == RE::BS_BUTTON_CODE::kRTrigger)
		return "Right Trigger";
	if (buttonCode == RE::BS_BUTTON_CODE::kSelect)
		return "Select";
	if (buttonCode == RE::BS_BUTTON_CODE::kLStick)
		return "Left Stick";
	if (buttonCode == RE::BS_BUTTON_CODE::kRStick)
		return "Right Stick";
	if (buttonCode == RE::BS_BUTTON_CODE::kLShoulder)
		return "Left Shoulder";
	if (buttonCode == RE::BS_BUTTON_CODE::kRShoulder)
		return "Right Shoulder";
	if (buttonCode == RE::BS_BUTTON_CODE::kAButton)
		return "A Button";
	if (buttonCode == RE::BS_BUTTON_CODE::kBButton)
		return "B Button";
	if (buttonCode == RE::BS_BUTTON_CODE::kXButton)
		return "X Button";
	if (buttonCode == RE::BS_BUTTON_CODE::kYButton)
		return "Y Button";
	return "";
}

inline static bool IsMouseWheelOrMovement(int iKeyCode)
{
	return iKeyCode == SFSE::InputMap::kMacro_MouseWheelDown || iKeyCode == SFSE::InputMap::kMacro_MouseWheelUp || iKeyCode == SFSE::InputMap::kMacro_MouseMove;
}

inline static std::string GetKeyNameByKeyCode(int iKeyCode, int iDeviceIndex, RE::BSInputDevice* keyboardDevicePassThru = nullptr, RE::BSInputDevice* mouseDevicePassThru = nullptr, RE::BSInputDevice* gamepadDevicePassThru = nullptr)
{
	if (iKeyCode < 0 || iDeviceIndex < 0 || iDeviceIndex > 2)
		return "";
	RE::BSInputDevice* keyHolderDevice = nullptr;
	if (iKeyCode < SFSE::InputMap::kMacro_MouseButtonOffset) {
		keyHolderDevice = keyboardDevicePassThru;
		if (!keyHolderDevice)
			keyHolderDevice = RE::BSInputDeviceManager::GetSingleton()->devices[0];
	}
	else if (IsMouseWheelOrMovement(iKeyCode) || iKeyCode >= SFSE::InputMap::kMacro_MouseButtonOffset && iKeyCode < SFSE::InputMap::kMacro_GamepadOffset) {
		keyHolderDevice = mouseDevicePassThru;
		if (!keyHolderDevice)
			keyHolderDevice = RE::BSInputDeviceManager::GetSingleton()->devices[1];
	} else if (iKeyCode >= SFSE::InputMap::kMacro_GamepadOffset) {
		keyHolderDevice = gamepadDevicePassThru;
		if (!keyHolderDevice)
			keyHolderDevice = RE::BSInputDeviceManager::GetSingleton()->devices[2];
	}
	if (!keyHolderDevice) {
		LogError("keyHolderDevice is nullptr");
		return "";
	}
	if (!IsMouseWheelOrMovement(iKeyCode)) {
		if (iDeviceIndex == 1)  // mouse device
			iKeyCode = iKeyCode - SFSE::InputMap::kMacro_MouseButtonOffset;
		else if (iDeviceIndex == 2)
			iKeyCode = iKeyCode - SFSE::InputMap::kMacro_GamepadOffset;
	}
	for (auto& button : keyHolderDevice->buttonNameIDMap) {
		if (button.Value == iKeyCode)
			return button.Key.c_str();
	}
	return GetBSButtonCodeName(static_cast<RE::BS_BUTTON_CODE>(iKeyCode));
}

inline static std::string GetControlNameByKeyCode(int iKeyCode, int iDeviceIndex, int iControlMappingIndex = -1, RE::ControlMap* ControlMapPassThru = nullptr)
{
	if (iKeyCode < 0 || iDeviceIndex < 0 || iDeviceIndex > 2 || iControlMappingIndex > static_cast<int>(RE::UserEvents::CONTROL_MAP::kMax))
		return "";
	if (!ControlMapPassThru)
		ControlMapPassThru = RE::ControlMap::GetSingleton();
	auto ControlMaps = ControlMapPassThru->controlMaps;
	if (!ControlMaps) {
		LogError("ControlMaps is nullptr");
		return "";
	}
	int iMinControlMappingIndex = 0;
	int iMaxControlMappingIndex = static_cast<int>(RE::UserEvents::CONTROL_MAP::kMax);
	if (iControlMappingIndex >= 0) {
		iMinControlMappingIndex = iControlMappingIndex;
		iMaxControlMappingIndex = iControlMappingIndex;
	}
	for (int o = iMinControlMappingIndex; o <= iMaxControlMappingIndex; o++) {
		auto gameControlMap = ControlMaps[o];
		if (!gameControlMap) {
			LogError("gameControlMap at (" + std::to_string(o) + ") is nullptr");
			continue;
		}
		auto controlMappings = gameControlMap->deviceMappings;
		if (!controlMappings) {
			LogError("controlMappings at (" + std::to_string(o) + ") is nullptr");
			continue;
		}
		if (!IsMouseWheelOrMovement(iKeyCode)) {
			if (iDeviceIndex == 1)		// mouse device
				iKeyCode = iKeyCode - SFSE::InputMap::kMacro_MouseButtonOffset;
			else if (iDeviceIndex == 2)
				iKeyCode = iKeyCode - SFSE::InputMap::kMacro_GamepadOffset;
		}		
		for (auto& mapping : controlMappings[iDeviceIndex]) {
			if (mapping.inputKey == iKeyCode)
				return mapping.eventID.c_str();
		}
	}
	return "";
}

inline static void DumpControlMapInfo(bool bDumpMemoryAddresses, RE::BSInputDeviceManager* inputDeviceManagerPassThru = nullptr, RE::ControlMap* ControlMapPassThru = nullptr)
{
	if (!inputDeviceManagerPassThru)
		inputDeviceManagerPassThru = RE::BSInputDeviceManager::GetSingleton();
	if (!ControlMapPassThru)
		ControlMapPassThru = RE::ControlMap::GetSingleton();

	auto keyboardDevice = inputDeviceManagerPassThru->devices[0];
	if (!keyboardDevice) {
		LogError("keyboardDevice is nullptr");
		return;
	}
	if (bDumpMemoryAddresses) {
		LogInfo("keyboardDevice: " + GetObjectAddressAsHex(keyboardDevice));
	}
	auto mouseDevice = inputDeviceManagerPassThru->devices[1];
	if (!mouseDevice) {
		LogError("mouseDevice is nullptr");
		return;
	}
	if (bDumpMemoryAddresses) {
		LogInfo("mouseDevice: " + GetObjectAddressAsHex(mouseDevice));
	}
	auto gamepadDevice = inputDeviceManagerPassThru->devices[2];
	if (!gamepadDevice) {
		LogError("gamepadDevice is nullptr");
		return;
	}
	if (bDumpMemoryAddresses) {
		LogInfo("gamepadDevice: " + GetObjectAddressAsHex(gamepadDevice));
	}
	auto gamepadDeviceDebug = inputDeviceManagerPassThru->devices[3];
	if (!gamepadDeviceDebug) {
		LogError("gamepadDeviceDebug is nullptr");
		return;
	}
	if (bDumpMemoryAddresses) {
		LogInfo("gamepadDeviceDebug: " + GetObjectAddressAsHex(gamepadDeviceDebug));
	}
	auto virtualKeyboardDevice = inputDeviceManagerPassThru->devices[4];
	if (!virtualKeyboardDevice) {
		LogError("virtualKeyboardDevice is nullptr");
		return;
	}
	if (bDumpMemoryAddresses) {
		LogInfo("virtualKeyboardDevice: " + GetObjectAddressAsHex(virtualKeyboardDevice));
	}
	auto ControlMapSingleton = RE::ControlMap::GetSingleton();
	if (!ControlMapSingleton) {
		LogError("ControlMapSingleton is nullptr");
		return;
	}
	if (bDumpMemoryAddresses) {
		LogInfo("ControlMapSingleton: " + GetObjectAddressAsHex(ControlMapSingleton));
	}
	RE::BSInputDevice* device = nullptr;
	std::string        sDeviceButtonsDevice;
	std::string        sButtonsNameIDMap;
	for (int o = 0; o < 3; o++) {
		if (o == 0) {
			sDeviceButtonsDevice = "[DeviceButtonsDevice: Keyboard]";
			sButtonsNameIDMap = "[ButtonsNameIDMap: Keyboard]";
			device = keyboardDevice;
		}
		if (o == 1) {
			sDeviceButtonsDevice = "[DeviceButtonsDevice: Mouse]";
			sButtonsNameIDMap = "[ButtonsNameIDMap: Mouse]";
			device = mouseDevice;
		}
		if (o == 2) {
			sDeviceButtonsDevice = "[DeviceButtonsDevice: Gamepad]";
			sButtonsNameIDMap = "[ButtonsNameIDMap: Gamepad]";
			device = gamepadDevice;
		}
		int i = 0;
		for (auto& controlkeys : device->deviceButtons) {
			auto controlkey = controlkeys.Value;
			if (controlkey) {
				LogInfo(sDeviceButtonsDevice + " (" + std::to_string(i) + ") | [KeyCode: " + std::to_string(controlkeys.Key) + "] | [Name: " + controlkey->name.c_str() + "] [HeldTime: " + std::to_string(controlkey->heldDownSecs) + "]");
			} else {
				LogError(sDeviceButtonsDevice + " (" + std::to_string(i) + ") | controlkey is nullptr");
			}
			i = i + 1;
		}
		int j = 0;
		for (auto& controlkeys : device->buttonNameIDMap) {
			auto controlkey = controlkeys.Value;
			if (controlkey) {
				LogInfo(sButtonsNameIDMap + " (" + std::to_string(j) + ") | [Name: " + controlkeys.Key.c_str() + "] | [KeyCode: " + std::to_string(controlkeys.Value) + "]");
			} else {
				LogError(sButtonsNameIDMap + " (" + std::to_string(j) + ") | controlkey is nullptr");
			}
			j = j + 1;
		}
	}
	for (int o = 0; o <= static_cast<int>(RE::UserEvents::CONTROL_MAP::kMax); o++) {
		auto ControlMaps = ControlMapSingleton->controlMaps;
		if (!ControlMaps) {
			LogError("ControlMaps at (" + std::to_string(o) + ") is nullptr");
			continue;
		} else {
			if (bDumpMemoryAddresses) {
				LogInfo("ControlMaps at (" + std::to_string(o) + ") " + GetObjectAddressAsHex(ControlMaps));
			}
		}
		auto gameControlMap = ControlMaps[o];
		if (!gameControlMap) {
			LogError("gameControlMap at (" + std::to_string(o) + ") is nullptr");
			continue;
		} else {
			if (bDumpMemoryAddresses) {
				LogInfo("gameControlMap at (" + std::to_string(o) + ") " + GetObjectAddressAsHex(gameControlMap));
			}
		}
		auto controlMappings = gameControlMap->deviceMappings;
		if (!controlMappings) {
			LogError("controlMappings at (" + std::to_string(o) + ") is nullptr");
			continue;
		} else {
			if (bDumpMemoryAddresses) {
				LogInfo("controlMappings at (" + std::to_string(o) + ") " + GetObjectAddressAsHex(controlMappings));
			}
		}
		std::string sControlMapping = "[ControlMapping: " + std::to_string(o) + "]";
		for (int k = 0; k < controlMappings->size(); k++) {
			auto arr = GetAsBSTArrayCustom(controlMappings);
			if (arr) {
				auto& mapping = arr->at(k);
				LogInfo(sControlMapping + " (" + std::to_string(k) + ") | [MappingName: " + mapping.eventID.c_str() + "] | [MappingKeyCode: " + std::to_string(mapping.inputKey) + "]");
			} else {
				LogError(sControlMapping + " (" + std::to_string(k) + ") | arr is nullptr");
			}
		}
	}
}

inline static bool IsGameMenuPaused(uintptr_t funcAddr = 0)
{
	if (funcAddr == 0) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(172731) };  // 0x2C1CC70 in v1.12.36
		funcAddr = ptr.address();
	}
	const auto func = reinterpret_cast<uintptr_t (*)()>(funcAddr);
	return (func() != 0);
}

inline static int32_t GetLeveledCharacterModifier(RE::TESObjectREFR* theRef)
{	// vanilla code returns 4 if the ref has no ExtraLevCreaModifier ("Difficulty" value in ConsoleLog of GetLevel)
	if (!theRef)
		return -1;
	auto extra = theRef->extraDataList.get();
	if (!extra)
		return -1;
	REL::Relocation<uintptr_t> ptr{ REL::ID(1720709) };  // 0x1467C88 in v1.13.61
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<int32_t (*)(RE::ExtraDataList*)>(addr);
	return func(extra);
}

inline static int32_t GetLevel(RE::Actor* theActor) {
	if (!theActor)
		return 0;
	auto BaseActor = (RE::TESNPC*)theActor->GetBaseObject();
	if (!BaseActor)
		return 0;
	return static_cast<int32_t>(BaseActor->GetLevel());
}

/*
inline static uint16_t GetLevel(RE::Actor* theActor)		// Papyrus (seems to CTD during Loading Menu after going back to MainMenu then exiting)
{
	if (!theActor)
		return 0;
	REL::Relocation<uintptr_t> ptr{ REL::ID(170250) };  // 0x2B80020 in v1.13.61
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<uint16_t (*)(uintptr_t, uint32_t, RE::Actor*)>(addr);
	return func(0, 0, theActor);
}
*/

inline static RE::Actor* GetDialogueTarget(RE::Actor* theActor)
{
	if (!theActor)
		return nullptr;
	REL::Relocation<uintptr_t> ptr{ REL::ID(170434) };  // 0x2B1DA80 in v1.12.36
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<RE::Actor* (*)(uintptr_t, uintptr_t, RE::Actor*)>(addr);
	auto                       result = func(0, 0, theActor);
	LogDebug("result --> " + GetBasicFormData(result) + " | params: theActor " + GetBasicFormData(theActor));
	return result;
}

inline static bool MoveTo(RE::TESObjectREFR* movedRef, RE::TESObjectREFR* moveToTargetRef, double param05, double param06,
                          double param07) // param01 = REL::ID 891179    0x8975EC0 1.12.36     ; param02 = 0x109E
{
	if (!movedRef)
		return false;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(149852) }; // 0x2575EB4 in v1.12.36
    uintptr_t                  addr  = funcPtr.address();
    const auto                 func  = reinterpret_cast<void (*)(uintptr_t, int, RE::TESObjectREFR*, RE::TESObjectREFR*, double, double, double)>(addr);
    auto                       queue = RE::TaskQueueInterface::GetSingleton();
    REL::Relocation<uintptr_t> bQueuePtr{ REL::ID(881136) }; // 0x6889230 in v1.12.36
    uintptr_t                  bQueueAddr  = bQueuePtr.address();
    auto                       bQueue      = reinterpret_cast<int*>(bQueueAddr);
    int                        bQueue_Init = 0;
    if (bQueue)
        bQueue_Init = *bQueue;
    LogDebug("result --> complete | params: movedRef [" + GetObjectAddressAsHex(movedRef) + "], moveToTargetRef [" + GetObjectAddressAsHex(moveToTargetRef) + "] | x ["
             + std::to_string(param05) + "], y [" + std::to_string(param06) + "], z [" + std::to_string(param07) + "] | other data --> queue [" + GetAddressAsHex(queue)
             + "], bQueueAddr [" + GetAddressAsHex(bQueueAddr) + "], bQueue_Init [" + std::to_string(bQueue_Init) + "]");
    func(queue, 4254, movedRef, moveToTargetRef, param05, param06, param07);
    if (bQueue)
        *bQueue = 1;
	return true;
}

/*	does not seem to work
inline static bool SetAngle(RE::TESObjectREFR* theRef, char chAxis, double dAngle)  // param01 = REL::ID 891179    0x8975EC0 1.12.36     ; param02 = 0x109E
{
	if (!theRef)
		return false;
	if (chAxis == 'x')
		chAxis = 'X';
	else if (chAxis == 'y')
		chAxis = 'Y';
	else if (chAxis == 'Z')
		chAxis = 'Z';
	if (chAxis != 'X' && chAxis != 'Y' && chAxis != 'Z')
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(149852) };  // 0x2575EB4 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<void (*)(uintptr_t, int, RE::TESObjectREFR*, char, double)>(addr);
	auto                       queue = RE::TaskQueueInterface::GetSingleton();
	REL::Relocation<uintptr_t> bQueuePtr{ REL::ID(881136) };  // 0x6889230 in v1.12.36
	uintptr_t                  bQueueAddr = bQueuePtr.address();
	auto                       bQueue = reinterpret_cast<int*>(bQueueAddr);
	int                        bQueue_Init = 0;
	if (bQueue)
		bQueue_Init = *bQueue;
	func(queue, 4105, theRef, chAxis, dAngle);
	if (bQueue)
		*bQueue = 1;
	return true;
}
*/

inline static uint32_t* PlaceReferenceAt(uint32_t* outHandle, RE::TESObjectREFR* targetRef, RE::TESForm* baseObject, int a4, int a5, int a6, uint32_t extraRefHandleOut, char a8)
{
	if (!outHandle || !targetRef || !baseObject)
		return nullptr;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(110024) };  // 0x1B2D398 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uint32_t* (*)(uint32_t*, RE::TESObjectREFR*, RE::TESForm*, int, int, int, uint32_t, char)>(addr);
	return func(outHandle, targetRef, baseObject, a4, a5, a6, extraRefHandleOut, a8);
}

inline static std::string GetLocalizedString(std::string str) {
	if (str.empty())
		return "";
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(34124) };  // 0x597A7C  in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	RE::BSFixedString          Result; 
	const auto                 func = reinterpret_cast<RE::BSFixedString* (*)(RE::BSFixedString*, const char*)>(addr);
	func(&Result, str.c_str());
	if (!&Result)
		return "";
	return Result.c_str();
}

inline static uint8_t IsTrue2(RE::BGSConditionForm* theConditionForm, RE::Actor* theSubjectActor, RE::Actor* theTargetActor)
{
	if (!theConditionForm || !theSubjectActor || !theTargetActor)
		return 0;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(100877) };  // 0x18AF338 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uint8_t (*)(RE::BGSConditionForm*, RE::Actor*, RE::Actor*)>(addr);
	return func(theConditionForm, theSubjectActor, theTargetActor);
}

inline static bool ActivateRef(RE::TESObjectREFR* activatedRef, RE::TESObjectREFR* actionRef, bool bDefaultProcessingOnly)
{
	if (!activatedRef || !actionRef)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(172378) };  // 0x2C59B60 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto func = reinterpret_cast<bool (*)(uintptr_t, uint32_t, RE::TESObjectREFR*, RE::TESObjectREFR*, bool)>(addr);
	return func(0, 0, activatedRef, actionRef, bDefaultProcessingOnly);
}

inline static bool ActivateRefNative(RE::TESObjectREFR* activatedRef, RE::TESObjectREFR* actionRef)		// untested!!!
{
	if (!activatedRef || !actionRef)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(106374) };  // 0x1A6E1A8 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(RE::TESObjectREFR*, RE::TESObjectREFR*)>(addr);
	return func(activatedRef, actionRef);
}

inline static bool SetLookAt_Papyrus(RE::Actor* theActor, RE::TESObjectREFR* theTargetReference, bool abPathingLookAt = false)  // should check for running AI process, Is3DLoaded
{
	if (!theActor || !theTargetReference)
		return false;
	auto theExtraList = theActor->extraDataList.get();
	if (!theExtraList)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(170503) };  // 0x1422408 in v1.12.36	(2C3CB20 in 1.14.70)
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(RE::BSScript::IVirtualMachine*, unsigned int, RE::Actor*, RE::TESObjectREFR*, char)>(addr);
	func(nullptr, 0, theActor, theTargetReference, abPathingLookAt);
	return true;
}

inline static bool SetLookAtByExtra(RE::ExtraDataList* theExtraList, uint32_t targetReferenceHandle)  // should check for running AI process, Is3DLoaded
{
	if (!theExtraList || targetReferenceHandle == 0)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(83487) };  // 0x1422408 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(RE::ExtraDataList*, uint32_t)>(addr);
	func(theExtraList, targetReferenceHandle);
	return true;
}

inline static bool SetLookAt(RE::Actor* theActor, uint32_t targetReferenceHandle)  // should check for running AI process, Is3DLoaded
{
	if (!theActor || targetReferenceHandle == 0)
		return false;
	auto theExtraList = theActor->extraDataList.get();
	if (!theExtraList)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(83487) };  // 0x1422408 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(RE::ExtraDataList*, uint32_t)>(addr);
	func(theExtraList, targetReferenceHandle);
	return true;
}

inline static bool ClearLookAt(RE::Actor* theActor)
{
	if (!theActor)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(170416) };  // 0x2C35A60 in v1.14.70
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(uintptr_t, uintptr_t, RE::Actor*)>(addr);
	func(0, 0, theActor);
	return true;
}

inline static bool StopLook(RE::TESObjectREFR* theReference)
{
	if (!theReference)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(110196) };  // 0x1AE011C in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<char (*)(uintptr_t, uintptr_t, RE::TESObjectREFR*)>(addr);
	func(0, 0, theReference);
	return true;
}

inline static bool SetTemporaryReference(RE::TESObjectREFR* theRef, bool bSet)
{
	if (!theRef)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(106946) };  // 0x1A3E588 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<void (*)(RE::TESObjectREFR*, bool)>(addr);
	int64_t                    unk = 0;
	func(theRef, bSet);
	LogDebug("result --> complete | params: theRef " + GetBasicFormData(theRef));
	return true;
}

inline static bool IsTemporaryReference(RE::TESObjectREFR* theRef)
{
	if (theRef && (theRef->formChangeFlags & 0x00000001) == 1)
		return true;
	return false;
}

inline static RE::BGSVoiceType* GetVoiceType(RE::Actor* theActor) {
	if (!theActor)
		return nullptr;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(106683) };  // 0x1A80668 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<RE::BGSVoiceType* (*)(RE::Actor*, bool)>(addr);
	return func(theActor, false);
}

inline static bool Is3DLoaded(RE::TESObjectREFR* theRef)
{
    if (!theRef)
        return false;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(172492) }; // 0x2BFF210 in v1.12.36
    uintptr_t                  addr   = funcPtr.address();
    const auto                 func   = reinterpret_cast<bool (*)(int64_t, int64_t, RE::TESObjectREFR**)>(addr);
    int64_t                    unk    = 0;
    auto                       result = func(unk, unk, &theRef);
    LogDebug("result --> " + std::to_string(result) + " | params: theRef " + GetBasicFormData(theRef));
    return (result != 0);
}

inline static bool SetModelVisible(RE::TESObjectREFR* theRef, bool bVisible)
{
	// previously: inline static bool RenderModel(RE::TESObjectREFR* theRef, bool bRender)
	if (!theRef)
		return false;
	uintptr_t                  out3D = 0;
	uintptr_t*                 out3DPtr = &out3D;
	theRef->Get3D(out3DPtr, false);
	if (!out3DPtr)
		return false;
	auto model = reinterpret_cast<RE::BSFadeNode*>(*out3DPtr);
	if (!model)
		return false;
	REL::Relocation<uintptr_t> ptr{ REL::ID(210228) };  // Starfield.exe + 372E1B8 (1.13.63)
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<void (*)(RE::BSFadeNode*, bool)>(addr);
	func(model, !bVisible);		// intentional, this native function technically acts like "Hide3DModel"
	return true;
}

inline static bool AddKeywordToLocation(RE::BGSLocation* theLocation, RE::BGSKeyword* theKeyword)		// untested
{
	if (!theLocation || !theKeyword)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(104525) };  // Starfield.exe + 196CB40 v1.12.30
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<void (*)(RE::BGSLocation*, RE::BGSKeyword*)>(addr);
	func(theLocation, theKeyword);
	return true;
}

inline static bool AddKeywordToReference(RE::TESObjectREFR* theRef, RE::BGSKeyword* theKeyword)  // untested
{
	if (!theRef || !theKeyword)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(172382) };  // Starfield.exe + 2C5A5C0 v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(uintptr_t, uint32_t, RE::TESObjectREFR**, RE::BGSKeyword*)>(addr);
	func(0, 0, &theRef, theKeyword);
	return true;
}

inline static bool RemoveKeywordFromReference(RE::TESObjectREFR* theRef, RE::BGSKeyword* theKeyword)  // untested
{
	if (!theRef || !theKeyword)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(172538) };  // Starfield.exe + 2C7E8E0 v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(uintptr_t, uint32_t, RE::TESObjectREFR**, RE::BGSKeyword*)>(addr);
	func(0, 0, &theRef, theKeyword);
	return true;
}

inline static float GetHeadingAngle(RE::TESObjectREFR* subjectRef, RE::TESObjectREFR* targetRef)
{
	if (!subjectRef || !targetRef)
		return -999.0f;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(172443) };  // 0x2C6BA40 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<float (*)(uintptr_t, uint32_t, RE::TESObjectREFR*, RE::TESObjectREFR*)>(addr);
	return func(0, 0, subjectRef, targetRef);
}

inline static float GetCameraHeadingAngle(RE::TESObjectREFR* theRef, uintptr_t funcAddr = 0)
{
	if (!theRef)
		return -999.0f;
	if (funcAddr == 0) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(1537024) };  // 0x2BCCF70 in v1.13.61
		funcAddr = funcPtr.address();
	}
	const auto func = reinterpret_cast<float (*)(uintptr_t, uint32_t, uintptr_t, RE::TESObjectREFR*)>(funcAddr);
	return func(0, 0, 0, theRef);
}

inline static bool IsReferenceVisibleOnCamera(RE::TESObjectREFR* theRef, uintptr_t funcAddr = 0)
{
	if (theRef) {
		auto CameraHeadingAngle = GetCameraHeadingAngle(theRef, funcAddr);
		if (CameraHeadingAngle < 0)
			CameraHeadingAngle = abs(CameraHeadingAngle);
		return CameraHeadingAngle <= 50.0f;
	}
	return false;
}

inline static bool CurrentFurnitureHasKeyword(RE::Actor* theActor, RE::BGSKeyword* theKeyword)
{
	if (!theActor || !theKeyword)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(108550) };  // 0x1AEA298 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<char (*)(RE::Actor**, RE::BGSKeyword*, uintptr_t, int*)>(addr);
	int                        Result = 0;
	func(&theActor, theKeyword, 0, &Result);
	return Result != 0;
}

inline static bool AddPerk(RE::Actor* theActor, RE::BGSPerk* thePerk, bool bNotify = false)
{
	if (!theActor || !thePerk)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(170403) };  // 0x2B18A40 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(uintptr_t, uint32_t, RE::Actor*, RE::BGSPerk*, bool)>(addr);
	func(0, 0, theActor, thePerk, bNotify);
	return true;
}

inline static bool HasPerk(RE::Actor* theActor, RE::BGSPerk* thePerk)
{
	if (!theActor || !thePerk)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(170461) };  // 0x2B1FA10 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(uintptr_t, uint32_t, RE::Actor*, RE::BGSPerk*)>(addr);
	return func(0, 0, theActor, thePerk);
}

inline static bool RemovePerk(RE::Actor* theActor, RE::BGSPerk* thePerk)
{
	if (!theActor || !thePerk)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(151200) };  // 0x25EDE84 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(RE::Actor*, RE::BGSPerk*, BYTE)>(addr);
	func(theActor, thePerk, 5);
	return true;
}

inline static int AddPerkToAll(std::vector<RE::Actor*> theActors, RE::BGSPerk* thePerk)
{
	if (theActors.empty() || !thePerk)
		return -1;
	int Result = 0;
	for (auto& it : theActors) {
		if (it && !HasPerk(it, thePerk)) {
			AddPerk(it, thePerk);
			Result = Result + 1;
		}
	}
	return Result;
}

inline static int RemovePerkFromAll(std::vector<RE::Actor*> theActors, RE::BGSPerk* thePerk)
{
	if (theActors.empty() || !thePerk)
		return -1;
	int Result = 0;
	for (auto& it : theActors) {
		if (it && HasPerk(it, thePerk)) {
			RemovePerk(it, thePerk);
			Result = Result + 1;
		}
	}
	return Result;
}

inline static std::string GetReferenceName(RE::TESObjectREFR* theRef)
{
	if (!theRef) {
		LogError("theRef is nullptr");
		return "";
	}
	std::string Name;
	auto&       extraDataList = theRef->extraDataList;
	if (extraDataList) {
		auto extraTextData = extraDataList->GetByType(RE::ExtraDataType::kTextDisplayData);
		if (extraTextData) {
			RE::ExtraTextDisplayData* TextData = (RE::ExtraTextDisplayData*)extraTextData;
			if (TextData) {
				auto& BSDisplayName = TextData->displayName;
				if (BSDisplayName.empty() == false) {
					Name = BSDisplayName.c_str();
				}
			}
		}
	}
	if (Name.empty()) {
		Name = GetTESFullName(theRef->GetBaseObject());
	}
	return Name;
}

inline static std::string GetOverrideName(RE::TESObjectREFR* theRef)
{
	if (!theRef) {
		LogError("theRef is nullptr");
		return "";
	}
	auto extraList = theRef->extraDataList.get();
	if (extraList) {
		auto textData = (RE::ExtraTextDisplayData*)extraList->GetByType(RE::ExtraDataType::kTextDisplayData);
		if (textData) {
			std::string sDisplayName = textData->displayName.c_str();
			if (!sDisplayName.empty())
				return sDisplayName;
		}
	}
	return "";
}

inline static std::string GetInventoryItemName(RE::ExtraDataList* extraData, RE::TESBoundObject* boundObject, bool bReturnIfOnlyOverrideName = false)
{
	if (!extraData || !!boundObject)
		return "";
	std::string Name;
	auto        extraTextData = extraData->GetByType(RE::ExtraDataType::kTextDisplayData);
	if (extraTextData) {
		RE::ExtraTextDisplayData* TextData = (RE::ExtraTextDisplayData*)extraData;
		if (TextData) {
			auto& BSDisplayName = TextData->displayName;
			if (BSDisplayName.empty() == false) {
				Name = BSDisplayName.c_str();
			}
		}
	}
	if (Name.empty() && !bReturnIfOnlyOverrideName) {
		Name = GetTESFullName(boundObject);
	}
	return Name;
}

inline static bool SetDisplayName(RE::ExtraDataList* dataList, const char* chName)
// CreateExtraTextDisplayData is at REL::ID 82935 0x140568C (1.12.36)
{
	if (!dataList || !chName)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(83539) };  // Starfield.exe + 14250CC v1.12.30
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<void (*)(RE::ExtraDataList*, const char*)>(addr);
	func(dataList, chName);
	return true;
}

inline static bool SetReferenceName(RE::TESObjectREFR* theRef, std::string sName)
{
	if (!theRef)
		return false;
	auto extraList = theRef->extraDataList.get();
	if (!extraList)
		return false;
	if (sName.empty()) {
		auto baseForm = theRef->GetBaseObject();
		if (!baseForm)
			return false;
		auto fullName = Runtime_DynamicCast<RE::TESForm, RE::TESFullName>(baseForm);
		if (!fullName)
			return false;
		SetDisplayName(extraList, fullName->GetFullName());
	} else {
		SetDisplayName(extraList, sName.c_str());
	}
	return true;
}

inline static bool SetDisplayNameOnFirstUnnamedItemInInventoryWithBase(RE::TESObjectREFR* theInventoryRef, RE::TESForm* theItemBaseForm, std::string OverrideName)
{
	if (!theInventoryRef || !theItemBaseForm)
		return false;
	auto inventory = theInventoryRef->inventoryList.lock_read().operator->();
	if (!inventory)
		return false;
	for (uint32_t i = 0; i < inventory->data.size(); i++) {
		for (uint32_t j = 0; j < inventory->data[i].stacks.size(); j++) {
			auto& ItemBoundObj = inventory->data[i].object;
			if (!ItemBoundObj || ItemBoundObj->formID != theItemBaseForm->formID)
				continue;
			auto  Extra = inventory->data[i].stacks[j].extra.get();
			if (Extra && GetInventoryItemName(Extra, ItemBoundObj, true).empty()) {
				SetDisplayName(Extra, OverrideName.c_str());
				return true;
			}
		}
	}
	return false;
}

inline static void DumpPapyrusStacks()
{
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(110456) };  // 0x1AFC448 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<char (*)()>(addr);
	func();
}

inline static bool IsStageDone(RE::TESQuest* theQuest, uint16_t uStage)
{
    if (!theQuest)
        return false;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(112585) }; // 0x1B07BFC in v1.10.32.
    uintptr_t                  addr = funcPtr.address();
    const auto func = reinterpret_cast<bool (*)(RE::TESQuest*, uint16_t)>(addr);
    auto result = func(theQuest, uStage);
    LogDebug("result --> " + std::to_string(result) + " | params: theQuest " + GetBasicFormData(theQuest) + ", uStage [" + std::to_string(uStage) + "]");
    return result;
}

inline static bool SetForceSneak(RE::Actor* theActor, bool bForceSneak)
{
	if (!theActor)
		return false;
	auto actorAddr = reinterpret_cast<uintptr_t>(theActor);
	auto actorstateAddr = reinterpret_cast<unsigned int*>(actorAddr + 0xF8);
	//LogInfo("actorAddr = " + GetAddressAsHex(actorAddr));
	//LogInfo("actorstateAddr = " + GetAddressAsHex(actorAddr + 0xF0));
	if (!actorstateAddr)
		return false;
	if (bForceSneak)
		*actorstateAddr = *actorstateAddr | 0x8000000;
	else
		*actorstateAddr = *actorstateAddr & 0xf7ffffff;
	return true;
}

inline static bool IsSneaking(RE::Actor* theActor)
{
	if (!theActor)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(151014) };  // 0x247EDB8 in v1.10.32.
	uintptr_t                  addr = funcPtr.address();
	const auto func = reinterpret_cast<bool (*)(RE::Actor*)>(addr);
	return func(theActor);
}

inline static float GetActorValuePercent(RE::Actor* theActor, RE::ActorValueInfo* actorValue)
{
	if (!theActor || !actorValue)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(108598) };  // 0x1A94008 in v1.12.32.
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<char (*)(RE::Actor**, RE::ActorValueInfo*, int64_t, float*)>(addr);
	int64_t                    unk = 0;
	float                      out = 0;
	auto                       Result = func(&theActor, actorValue, unk, &out);
	if (!out)
		return 0;
	return out;
}

inline static void EnableMenus(bool bEnable)
{
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(170823) };  //     Starfield.exe + 2B40160 (v1.12.32)
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(int64_t, int64_t, int64_t, char)>(addr);
	int64_t                    unk = 0;
	auto                       Result = func(unk, unk, unk, bEnable);
}

inline static bool AreMenusEnabled(RE::UI* UIPassThru = nullptr) {
	RE::UI* UI = nullptr;
	if (UIPassThru)
		UI = UIPassThru;
	else
		UI = RE::UI::GetSingleton();
	if (UI && UI->areMenusEnabled)
		return true;
	return false;
}

inline static void EnableDetection(bool bEnable)
{
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(170822) };  //     Starfield.exe + 2B40120 (v1.12.32)
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(int64_t, int64_t, int64_t, char)>(addr);
	int64_t                    unk = 0;
	auto                       Result = func(unk, unk, unk, bEnable);
}

/*
inline static void ForceStopQuest(RE::TESQuest* theQuest, bool Param01, bool Param02)
{
	if (!theQuest)
		return;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(112658) };  // 0x1B8A634 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto func = reinterpret_cast<uintptr_t (*)(RE::TESQuest*, bool, bool)>(addr);
	auto                       result = func(theQuest, Param01, Param02);
	LogDebug("result --> " + std::to_string(result) + " | params: theQuest " + GetBasicFormData(theQuest) + ", Param01 [" + std::to_string(Param01) + "], Param02 [" + std::to_string(Param02) + "]");
	REL::Relocation<uintptr_t> bQueuePtr{ REL::ID(881136) };  // 0x6889230 in v1.12.36
	uintptr_t                  bQueueAddr = bQueuePtr.address();
	auto                       bQueue = reinterpret_cast<int*>(bQueueAddr);
	if (bQueue)
		*bQueue = 1;
}
*/

inline static bool StopQuest(RE::TESQuest* theQuest, bool bForceStop = false) {
	if (!theQuest || !bForceStop && (theQuest->data.flags & 1) == 0)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(112658) };  // 0x1B8A634 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(RE::TESQuest*, bool, bool)>(addr);
	auto                       result = func(theQuest, false, true);
	LogDebug("result --> " + std::to_string(result) + " | params: theQuest " + GetBasicFormData(theQuest));
	REL::Relocation<uintptr_t> bQueuePtr{ REL::ID(881136) };  // 0x6889230 in v1.12.36
	uintptr_t                  bQueueAddr = bQueuePtr.address();
	auto                       bQueue = reinterpret_cast<int*>(bQueueAddr);
	if (bQueue)
		*bQueue = 1;
	return true;
}

inline static bool ClearAllAliases(RE::TESQuest* theQuest)
{
	if (!theQuest)
		return false;
	REL::Relocation<uintptr_t> bQueuePtr{ REL::ID(881136) };  // 0x6889230 in v1.12.36
	uintptr_t                  bQueueAddr = bQueuePtr.address();
	auto                       bQueue = reinterpret_cast<int*>(bQueueAddr);
	if (bQueue)
		*bQueue = 1;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(112476) };  // 0x1B7331C in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(RE::TESQuest*)>(addr);
	auto                       result = func(theQuest);
	LogDebug("result --> " + std::to_string(result) + " | params: theQuest " + GetBasicFormData(theQuest));
	return true;
}

inline static bool IsTalking(RE::Actor* theActor)
{
    if (!theActor)
        return false;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(170285) }; // 0x2B09E60 in v1.12.36
    uintptr_t                  addr   = funcPtr.address();
    const auto                 func   = reinterpret_cast<bool (*)(int64_t, int64_t, RE::Actor*)>(addr);
    int64_t                    unk    = 0;
    auto                       result = func(unk, unk, theActor);
    LogDebug("result --> [" + std::to_string((result != 0)) + "] | params: theActor " + GetBasicFormData(theActor));
    return (result != 0);
}

inline static bool UpdateAppearance(RE::Actor* theActor, bool param02, uint32_t flags, bool bRace)
{
    if (!theActor)
        return false;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(151216) }; // 0x25EEA00 in v1.12.36
    uintptr_t                  addr = funcPtr.address();
    const auto                 func = reinterpret_cast<void (*)(RE::Actor*, bool, uint32_t, bool)>(addr);
    LogDebug("result --> complete | params: theActor " + GetBasicFormData(theActor) + ", param02 [" + std::to_string(param02) + "], flags [" + std::to_string(param02)
             + "], bRace [" + std::to_string(bRace) + "]");
    func(theActor, param02, flags, bRace);
	return true;
}

inline static bool UpdateChargenAppearance(RE::Actor* theActor)
{
    if (!theActor)
        return false;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(146273) }; // 0x243B804 in v1.12.36
    uintptr_t                  addr = funcPtr.address();
    const auto                 func = reinterpret_cast<void (*)(RE::Actor*)>(addr);
    LogDebug("result --> complete | params: theActor " + GetBasicFormData(theActor));
    func(theActor);
	return true;
}

inline static bool SetSkinTone(RE::Actor* theActor, uint8_t skinToneIndex)
{
	if (!theActor || skinToneIndex > 8)
        return false;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(146270) }; // 0x243B3CC in v1.12.36
    uintptr_t                  addr = funcPtr.address();
    const auto                 func = reinterpret_cast<void (*)(RE::Actor*, uint8_t)>(addr);
    LogDebug("result --> complete | params: theActor " + GetBasicFormData(theActor) + ", skinToneIndex [" + std::to_string(skinToneIndex) + "]");
    func(theActor, skinToneIndex);
	return true;
}

inline static int GetSkinTone(RE::Actor* theActor)
{
	if (!theActor)
		return -1;
	auto baseForm = theActor->GetBaseObject();
	if (!baseForm)
		return -1;
	auto baseNPC = (RE::TESNPC*)baseForm;
	if (!baseNPC)
		return -1;
	/*
	auto skinTonePtr = reinterpret_cast<std::uint8_t*>(reinterpret_cast<uintptr_t>(baseNPC) + 0x3F8);	// v1.13.61
	if (!skinTonePtr || *skinTonePtr > 8)
		return -1;
	return static_cast<int>(*skinTonePtr);
	*/
	try {		// new design in v1.14.70
		auto index = baseNPC->skinToneIndex;
		if (index > 8)
			return -1;
		return static_cast<int>(index);
	}
	catch (...) {
		;
	}
	return -1;
}

inline static bool DrawWeapon(RE::Actor* theActor)
{
    if (!theActor)
        return false;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(170420) }; // 0x2B1B830 in v1.12.36
    uintptr_t                  addr   = funcPtr.address();
    const auto                 func   = reinterpret_cast<uintptr_t (*)(int64_t, int64_t, RE::Actor*)>(addr);
    int64_t                    unk    = 0;
    LogDebug("result --> complete | params: theActor " + GetBasicFormData(theActor));
    func(unk, unk, theActor);
	return true;
}

inline static bool SheatheWeapon(RE::Actor* theActor)
{
	if (!theActor)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(170516) };  // 0x2B99B60 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(int64_t, int64_t, RE::Actor*)>(addr);
	int64_t                    unk = 0;
	LogDebug("result --> complete | params: theActor " + GetBasicFormData(theActor));
	func(unk, unk, theActor);
	return true;
}

inline static bool EvaluatePackage(RE::Actor* theActor, bool bResetAI)
{
	if (!theActor || theActor->formID == 0x14)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(150640) };  // 0x25C39BC in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<void (*)(RE::Actor*, bool, bool)>(addr);
	func(theActor, false, bResetAI);
	return true;
}

inline static int EvaluatePackageForAll(std::vector<RE::Actor*> theActors, bool bResetAI)
{
	if (theActors.empty())
		return -1;
	int Result = 0;
	for (auto& it : theActors) {
		if (!it)
			continue;
		if (EvaluatePackage(it, bResetAI))
			Result = Result + 1;
	}
	return Result;
}

inline static bool EnableAI(RE::Actor* theActor, bool bEnable, bool bPauseVoice = false)
{
	if (!theActor)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(151304) };  // 0x269D58C in v1.14.70
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<void (*)(RE::Actor*, bool, bool)>(addr);
	func(theActor, bEnable, bPauseVoice);
	return true;
}

inline static bool IsPlayerInCombat(RE::PlayerCharacter* PlayerCharacterPassThru = nullptr)
{	// in 1.14.70, it is: return *(param_1 + 0x1123) & 1;
	if (!PlayerCharacterPassThru)
		PlayerCharacterPassThru = RE::PlayerCharacter::GetSingleton();
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(153894) };  // 0x27920A4 in v1.14.70
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(RE::PlayerCharacter*)>(addr);
	return func(PlayerCharacterPassThru);
}

inline static bool IsUnconscious(RE::Actor* theActor)	// untested
{
	if (theActor) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(170287) };  // 0x2C24AF0 in v1.14.70
		uintptr_t                  addr = funcPtr.address();
		const auto                 func = reinterpret_cast<uint32_t (*)(uintptr_t, uintptr_t, RE::Actor*)>(addr);
		return func(0, 0, theActor) != 0;
	}
	return false;
}

// Is theDetected detected by theDetecter?
inline static bool IsDetectedBy(RE::Actor* theDetected, RE::Actor* theDetecter)
{
	if (!theDetected || !theDetecter)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(170476) };  // 0x2B1FCF0 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(uintptr_t, uint32_t, RE::Actor*, RE::Actor*)>(addr);
	return func(0, 0, theDetected, theDetecter);
}

inline static bool HasDetectionLOS(RE::Actor* theSource, RE::Actor* theTarget)
{
	if (!theSource || !theTarget)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(170456) };  // 0x2B1F260 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(uintptr_t, uint32_t, RE::Actor*, RE::Actor*)>(addr);
	return func(0, 0, theSource, theTarget);
}

inline static float GetKnockStateEnum(RE::Actor* theActor)
{
	if (!theActor)
		return -1.0f;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(108758) };  // 0x1A9B9F0 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(RE::Actor**, int64_t, int64_t, float*)>(addr);
	float                      fOut = 0.0f;
	float*                     fOutPtr = &fOut;
	auto                       result = func(&theActor, 0, 0, fOutPtr);
	if (fOutPtr)
		return *fOutPtr;
	return 0.0f;
}

inline static float LocationHasKeyword(RE::TESObjectREFR* theRef, RE::BGSKeyword* theKeyword)
{
	if (!theRef || !theKeyword)
		return -1.0f;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(109127) };  // 0x1B12F58 in v1.14.70
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(RE::TESObjectREFR**, int64_t, int64_t, float*)>(addr);
	float                      fOut = 0.0f;
	float*                     fOutPtr = &fOut;
	auto                       result = func(&theRef, 0, 0, fOutPtr);
	if (fOutPtr)
		return *fOutPtr;
	return 0.0f;
}

inline static float GetActorGunState(RE::Actor* theActor)
{
	if (!theActor)
		return -1.0f;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(108590) };  // 0x1A93B54 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(RE::Actor**, int64_t, int64_t, float*)>(addr);
	float                      fOut = 0.0f;
	float*                     fOutPtr = &fOut;
	auto                       result = func(&theActor, 0, 0, fOutPtr);
	if (fOutPtr)
		return *fOutPtr;
	return 0.0f;
}

inline static float GetInIronSights(RE::Actor* theActor)
{
	if (!theActor)
		return -1.0f;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(108704) };  // 0x1AF189C in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(RE::Actor**, int64_t, int64_t, float*)>(addr);
	float                      fOut = 0.0f;
	float*                     fOutPtr = &fOut;
	auto                       result = func(&theActor, 0, 0, fOutPtr);
	if (fOutPtr)
		return *fOutPtr;
	return 0.0f;
}

inline static float IsInVehicle(RE::Actor* theActor)
{
	if (!theActor)
		return -1.0f;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(2157099) };  // 0x1AFF450 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(RE::Actor**, int64_t, int64_t, float*)>(addr);
	float                      fOut = 0.0f;
	float*                     fOutPtr = &fOut;
	auto                       result = func(&theActor, 0, 0, fOutPtr);
	if (fOutPtr)
		return *fOutPtr;
	return 0.0f;
}

inline static RE::TESObjectREFR* GetCurrentFurniture(RE::Actor* theActor)
{
	if (theActor && theActor->currentProcess && theActor->currentProcess->middleHigh && theActor->currentProcess->middleHigh->currentFurnitureHandle)
		return RE::GetReferenceByHandle(theActor->currentProcess->middleHigh->currentFurnitureHandle);
	return nullptr;
}

inline static RE::TESObjectREFR* GetFurnitureUsing(RE::Actor* theActor)
{
	if (theActor) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(170441) };  // 0x2C39090 in v1.14.74
		uintptr_t                  addr = funcPtr.address();
		const auto                 func = reinterpret_cast<RE::TESObjectREFR* (*)(uintptr_t, uint32_t, RE::Actor*)>(addr);
		return func(0, 0, theActor);
	}
	return nullptr;
}

inline static RE::NEW_REFR_DATA* CreateNewREFRData(RE::NEW_REFR_DATA* NewREFRDataOut, RE::TESBoundObject* baseObject, RE::NiPoint3* position, RE::NiPoint3* rotation, RE::TESObjectCELL* cell, RE::TESWorldSpace* world, uintptr_t a7, uintptr_t a8, uintptr_t a9, char a10, char a11, int* a12, uintptr_t a13, char a14, char a15, char a16, char a17)
//inline static RE::NEW_REFR_DATA CreateNewREFRData(RE::NEW_REFR_DATA NewREFRDataOut, RE::TESBoundObject* baseObject, RE::NiPoint3* position, RE::NiPoint3* rotation, RE::TESObjectCELL* cell, RE::TESWorldSpace* world)
{                                                          // result = NewREFRDataOut (not as pointer)
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(79271) };  // 0x13B75A0 in v1.14.70
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<RE::NEW_REFR_DATA* (*)(RE::NEW_REFR_DATA*, RE::TESBoundObject*, RE::NiPoint3*, RE::NiPoint3*, RE::TESObjectCELL*, RE::TESWorldSpace*, uintptr_t, uintptr_t, uintptr_t, char, char, int*, uintptr_t, char, char, char, char)>(addr);
	//const auto func = reinterpret_cast<RE::NEW_REFR_DATA (*)(RE::NEW_REFR_DATA, RE::TESBoundObject*, RE::NiPoint3*, RE::NiPoint3*, RE::TESObjectCELL*, RE::TESWorldSpace*, uintptr_t, uintptr_t)>(addr);
	//return func(NewREFRDataOut, baseObject, position, rotation, cell, world, 0, 0);
	return func(NewREFRDataOut, baseObject, position, rotation, cell, world, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17);
}

inline static uint32_t* CreateReference(RE::TESDataHandler* dataHandler, uint32_t* createdRefHandleOut, RE::NEW_REFR_DATA& NewREFRData)
{
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(85126) };  // 0x14EDBB0 in v1.14.70
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uint32_t* (*)(RE::TESDataHandler*, uint32_t*, RE::NEW_REFR_DATA&)>(addr);
	return func(dataHandler, createdRefHandleOut, NewREFRData);
}

inline static float GetWidth(RE::TESObjectREFR* theRef) {
	if (theRef) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(172476) };  // 0x2D1A650 in v1.14.70
		uintptr_t                  addr = funcPtr.address();
		const auto                 func = reinterpret_cast<float (*)(uintptr_t, uintptr_t, RE::TESObjectREFR*)>(addr);
		return func(0, 0, theRef);
	}
	return -1.00f;
}

inline static float GetHeight(RE::TESObjectREFR* theRef)
{
	if (theRef) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(172444) };  // 0x2D13FF0 in v1.14.70
		uintptr_t                  addr = funcPtr.address();
		const auto                 func = reinterpret_cast<float (*)(uintptr_t, uintptr_t, RE::TESObjectREFR*)>(addr);
		return func(0, 0, theRef);
	}
	return -1.00f;
}

inline static float GetLength(RE::TESObjectREFR* theRef)
{
	if (theRef) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(172449) };  // 0x2D143B0 in v1.14.70
		uintptr_t                  addr = funcPtr.address();
		const auto                 func = reinterpret_cast<float (*)(uintptr_t, uintptr_t, RE::TESObjectREFR*)>(addr);
		return func(0, 0, theRef);
	}
	return -1.00f;
}

inline static bool Enable(RE::TESObjectREFR* theRef, bool bResetInventory)
{
	if (theRef) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(106485) };  // 0x1A877FC in v1.14.70
		uintptr_t                  addr = funcPtr.address();
		const auto                 func = reinterpret_cast<void (*)(RE::TESObjectREFR*, bool)>(addr);
		func(theRef, bResetInventory);
		return true;
	}
	return false;
}

inline static bool Enable_Console(RE::TESObjectREFR* theRef)
{
	if (theRef) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(109213) };  // 0x1B15E50 in v1.14.70
		uintptr_t                  addr = funcPtr.address();
		const auto                 func = reinterpret_cast<void (*)(RE::TESObjectREFR*)>(addr);
		func(theRef);
		return true;
	}
	return false;
}

inline static uint32_t GetFormIDSafe(RE::TESForm* theForm) {
	if (!theForm)
		return 0;
	auto addr = reinterpret_cast<uintptr_t>(theForm);
	auto formID = reinterpret_cast<uint32_t*>(addr + 0x28);
	if (formID)
		return *formID;
	return 0;
}

inline static uint32_t GetNativeHandleSafe(RE::TESForm* theForm)
{
	if (!theForm)
		return 0;
	auto addr = reinterpret_cast<uintptr_t>(theForm);
	auto formID = reinterpret_cast<uint32_t*>(addr + 0x24);
	if (formID)
		return *formID;
	return 0;
}

inline static bool PlayMenuSound(std::string soundName, double volume)
{
	if (soundName.empty())
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(167344) };  // 0x2A7DE60 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto func = reinterpret_cast<int* (*)(int*, const char*, uintptr_t, double)>(addr);
	REL::Relocation<uintptr_t> unkPtr{ REL::ID(295589) };  // 0x42EB948 in v1.13.61
	uintptr_t                  unk = unkPtr.address();
	int                        soundIDOut = 0;
	func(&soundIDOut, soundName.c_str(), unk, volume);
	return true;
}

inline static bool IsMovingForward(RE::Actor* theActor)
{
	if (theActor && static_cast<bool>(theActor->actorState1.movingForward))
		return true;
	return false;
}

inline static bool IsMovingBackward(RE::Actor* theActor)
{
	if (theActor && static_cast<bool>(theActor->actorState1.movingBack))
		return true;
	return false;
}

inline static bool IsMovingLeft(RE::Actor* theActor)
{
	if (theActor && static_cast<bool>(theActor->actorState1.movingLeft))
		return true;
	return false;
}

inline static bool IsMovingRight(RE::Actor* theActor)
{
	if (theActor && static_cast<bool>(theActor->actorState1.movingRight))
		return true;
	return false;
}

inline static bool IsJumping(RE::Actor* theActor)
{
	if (!theActor)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(150985) };  // Starfield.exe + 0x25DAD1C v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(RE::Actor*)>(addr);
	return func(theActor);
}

inline static bool IsOverencumbered(RE::Actor* theActor)
{
	if (!theActor)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(150999) };  // Starfield.exe + 0x25DB580 v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(RE::Actor*)>(addr);
	return func(theActor);
}

inline static bool AreHostileActorsNear()
{
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(171035) };  // 0x29ECFC0 in v1.10.32
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)()>(addr);
	return func();
}

inline static bool IsInScene(RE::Actor* theActor, uintptr_t funcAddr = 0)
{
	if (theActor) {
		if (funcAddr == 0) {
			REL::Relocation<uintptr_t> funcPtr{ REL::ID(170275) };  // 0x2C24720 in v1.14.70
			funcAddr = funcPtr.address();
		}
		const auto func = reinterpret_cast<bool (*)(uintptr_t, uintptr_t, RE::Actor*)>(funcAddr);
		return func(0, 0, theActor);
	}
	return false;
}

inline static bool IsSwimming(RE::Actor* theActor)
{
	if (theActor && static_cast<bool>(theActor->actorState1.swimming))
		return true;
	return false;
}

inline static bool IsInWater(RE::Actor* theActor)
{
	if (theActor && theActor->boolBits.any(RE::Actor::BOOL_BITS::kInWater))
		return true;
	return false;
}

inline static bool IsInCombatSearch(RE::Actor* theActor)
{
	if (theActor && theActor->boolBits.any(RE::Actor::BOOL_BITS::kSearchingInCombat))
		return true;
	return false;
}

inline static bool IsMurderAlarmed(RE::Actor* theActor)
{
	if (theActor && theActor->boolBits.any(RE::Actor::BOOL_BITS::kMurderAlarm))
		return true;
	return false;
}

inline static bool IsParalyzed(RE::Actor* theActor)
{
	if (theActor && theActor->boolBits.any(RE::Actor::BOOL_BITS::kParalyzed))
		return true;
	return false;
}

inline static bool DoesAffectStealthMeter(RE::Actor* theActor)
{
	if (theActor && theActor->formID != 0x14 && !theActor->boolFlags.any(RE::Actor::BOOL_FLAGS::kDoNotShowOnStealthMeter))
		return true;
	return false;
}

inline static bool IsUnderwater(RE::Actor* theActor)
{
	if (theActor && theActor->boolFlags.any(RE::Actor::BOOL_FLAGS::kUnderwater))
		return true;
	return false;
}

inline static bool IsWalking(RE::Actor* theActor)
{
	if (theActor && static_cast<bool>(theActor->actorState1.walking))
		return true;
	return false;
}

inline static bool IsStaggered(RE::Actor* theActor)
{
	if (theActor && static_cast<bool>(theActor->actorState2.staggered))
		return true;
	return false;
}

inline static RE::BSFadeNode* Get3DModel(RE::TESObjectREFR* theRef) {
	if (!theRef)
		return nullptr;
	uintptr_t  out3D = 0;
	uintptr_t* out3DPtr = &out3D;
	theRef->Get3D(out3DPtr, false);
	if (out3DPtr) {
		auto model = reinterpret_cast<RE::BSFadeNode*>(*out3DPtr);
		if (model) {
			return model;
		}
	}
	return nullptr;
}

inline static RE::BSFadeNode* GetFadeNode(RE::TESObjectREFR* theRef, bool bNoLock = false)
{
	if (!theRef)
		return nullptr;
	RE::BSFadeNode* Result = nullptr;
	try {
	//	LogInfo("getting 3d for " + GetObjectAddressAsHex(theRef));
		if (!bNoLock)
			Result = reinterpret_cast<RE::BSFadeNode*>(theRef->loadedData.lock_read().operator*()->data3D);
		else {
			auto a1 = reinterpret_cast<uintptr_t>(theRef);
			a1 = a1 + 0xB8;
			auto a2 = reinterpret_cast<uintptr_t*>(a1);
			if (!a2 || *a2 == 0)
				return nullptr;
			Result = reinterpret_cast<RE::BSFadeNode*>(*a2);
		}
	}
	catch (...) {
	//	LogInfo("exception while getting 3d for " + GetObjectAddressAsHex(theRef));		// if we're not in the game world yet
		return nullptr;
	}
	if (Result) {
	//	LogInfo("returning 3d [" + GetObjectAddressAsHex(Result) + "] for " + GetObjectAddressAsHex(theRef));
		return Result;
	}
	//LogInfo("returning nullptr after attempting to get 3d for " + GetObjectAddressAsHex(theRef));
	return nullptr;
}

inline static int GetVehicleCameraState(RE::PlayerCamera* PlayerCamPassThru = nullptr)
{
	if (!PlayerCamPassThru)
		PlayerCamPassThru = RE::PlayerCamera::GetSingleton();
	auto camState = PlayerCamPassThru->currentState;
	if (camState) {
		return camState->zoomState;
	}
	return false;
}

inline static bool IsWeaponDrawn(RE::Actor* theActor)
{
    if (!theActor)
        return false;
    unsigned long long theActorAddr   = reinterpret_cast<unsigned long long>(theActor);
    //uint32_t*          WeaponStatePtr = reinterpret_cast<uint32_t*>(theActorAddr + 0xF4); // since v1.10.31.
	uint32_t* WeaponStatePtr = reinterpret_cast<uint32_t*>(theActorAddr + 0xFC);  // since v1.14.70
    if (!WeaponStatePtr)
        return false;
    auto WeaponState = static_cast<int>(*WeaponStatePtr & 7);
    LogDebug("result --> [" + std::to_string((WeaponState <= 3 && WeaponState >= 1)) + "] | params: theActor " + GetBasicFormData(theActor));
    return (WeaponState <= 3 && WeaponState >= 1);
}

inline static int IsInDialogueWithPlayerConsole(RE::TESObjectREFR** theRef, uintptr_t unk01, uintptr_t unk02, uint32_t* out) // Console version
{
    if (!theRef || !*theRef || !out)
        return -1;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(108949) }; // 0x1A891C4 in v1.12.32
    uintptr_t                  addr      = funcPtr.address();
    const auto                 func      = reinterpret_cast<bool (*)(RE::TESObjectREFR**, int64_t, int64_t, uint32_t*)>(addr);
    int64_t                    unk       = 0;
    auto                       result    = func(theRef, unk, unk, out);
    auto                       outResult = 0;
    if (out)
        outResult = *out;
    LogDebug("result --> [" + std::to_string(result) + " | outResult: " + std::to_string(outResult) + "] theRef [" + GetFormIDAsHex(*theRef) + "]");
    return (outResult != 0);
}

inline static bool IsInDialogueWithPlayerInternal(RE::TESObjectREFR* theRef)
{
    if (!theRef)
        return -1;
    uint32_t out    = 0;
    auto     Result = IsInDialogueWithPlayerConsole(&theRef, 0, 0, &out);
    return (Result == 1);
}

inline static RE::Actor* GetPlayerDialogueTarget()
{
    if (RE::MainCustom::GetSingleton()->sortedVisibleHighActorHandles.size() > 0) {
        for (uint32_t i = 0; i < RE::MainCustom::GetSingleton()->sortedVisibleHighActorHandles.size(); i++) {
            auto handle = RE::MainCustom::GetSingleton()->sortedVisibleHighActorHandles.at(i).second;
            if (handle > 1 && handle <= UINT32_MAX) {
                auto Ref = RE::GetReferenceByHandle(handle);
                if (!Ref)
                    continue;
                if (Ref->formID == 0x14)
                    continue;
                if (!IsInDialogueWithPlayerInternal(Ref))
                    continue;
                auto actorRef = (RE::Actor*)Ref;
                if (!actorRef)
                    continue;
                LogDebug("result --> " + GetBasicFormData(actorRef));
                return actorRef;
            }
        }
    }
    LogDebug("result --> nullptr");
    return nullptr;
}

inline static RE::BGSPlanet::PlanetData* GetCurrentPlanet(RE::TESObjectREFR* theRef)  // REL::ID (172436)
{
	if (!theRef)
		return nullptr;
	REL::Relocation<uintptr_t> ptr{ REL::ID(172436) };  // Starfield.exe + 2C67E90 (1.36.61)
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<RE::BGSPlanet::PlanetData* (*)(uintptr_t, uintptr_t, RE::TESObjectREFR*)>(addr);
	uintptr_t                  unk = 0;
	return func(unk, unk, theRef);
}

template <typename first_type, typename tuple_type, size_t... index>
auto to_vector_in(const tuple_type& t, std::index_sequence<index...>)
{
	return std::vector<first_type>{
		std::get<index>(t)...
	};
}

template <typename first_type, typename... others>
auto to_vector(const std::tuple<first_type, others...>& t)
{
	typedef typename std::remove_reference<decltype(t)>::type tuple_type;

	constexpr auto s =
		std::tuple_size<tuple_type>::value;

	return to_vector_in<first_type, tuple_type>(t, std::make_index_sequence<s>{});
}

inline static std::tuple<int, int, int, int, int, int, int> GetGameDate(RE::Sky* SkyPassThru = nullptr, RE::TimeGlobals* TimeGlobalsPassThru = nullptr)
{
	if (!SkyPassThru)
		SkyPassThru = RE::Sky::GetSingleton();
	if (!TimeGlobalsPassThru)
		TimeGlobalsPassThru = RE::TimeGlobals::GetSingleton();
	std::tuple<int, int, int, int, int, int, int> Result;
	std::get<0>(Result) = TimeGlobalsPassThru->GetGameYear();
	std::get<1>(Result) = TimeGlobalsPassThru->GetGameMonth();
	std::get<2>(Result) = TimeGlobalsPassThru->GetGameDay();
	std::pair<int, int> DayAndMinuteLocal = SkyPassThru->GetDayLocalTime();
	std::get<3>(Result) = DayAndMinuteLocal.first;
	std::get<4>(Result) = DayAndMinuteLocal.second;
	std::pair<int, int> DayAndMinuteUT = TimeGlobalsPassThru->GetDayUniversalTime();
	std::get<5>(Result) = DayAndMinuteUT.first;
	std::get<6>(Result) = DayAndMinuteUT.second;
	return Result;
}

inline static float GetDayLength(RE::BGSPlanet::PlanetData* thePlanet) {	// can return infinite
	if (thePlanet) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(167865) };  // 0x2B53370 in v1.14.70
		auto                       addr = funcPtr.address();
		const auto                 func = reinterpret_cast<float (*)(uintptr_t, uintptr_t, RE::BGSPlanet::PlanetData*)>(addr);
		return func(0, 0, thePlanet);
	}
	return -1.00f;
}

inline static float GetUTHourPerLocalDay(RE::BGSPlanet::Manager* PlanetContentManagerPassThru = nullptr, RE::PlayerCharacter* PlayerCharPassThru = nullptr, RE::BGSPlanet::PlanetData* PlayerCurrentPlanetPassThru = nullptr)  // only works on the player's current planet (as per vanilla design)
{
	uint32_t PlanetFormID = 0;
	if (!PlayerCurrentPlanetPassThru) {
		if (!PlanetContentManagerPassThru)
			PlanetContentManagerPassThru = RE::BGSPlanet::Manager::GetSingleton();
		PlanetFormID = PlanetContentManagerPassThru->GetCurrentPlanetFormID();
		if (PlanetFormID == 0) {
			if (!PlayerCharPassThru)
				PlayerCharPassThru = RE::PlayerCharacter::GetSingleton();
			PlayerCurrentPlanetPassThru = GetCurrentPlanet(PlayerCharPassThru);
		}
	}
	if (PlayerCurrentPlanetPassThru)
		PlanetFormID = PlayerCurrentPlanetPassThru->formID;
	if (PlanetFormID != 0) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(95246) };  // 0x17E5C50 in v1.14.70
		auto                       addr = funcPtr.address();
		const auto                 func = reinterpret_cast<float (*)(uint32_t, char)>(addr);
		return func(PlanetFormID, 0);
	}
	return -1.00f;
}

inline static float GetUTHourPerLocalHour(bool bIgnorefMaxUTHourPerLocalHourGameSetting, RE::BGSPlanet::Manager* PlanetContentManagerPassThru = nullptr, RE::PlayerCharacter* PlayerCharPassThru = nullptr)
{
	auto fUTHourPerLocalDay = GetUTHourPerLocalDay(PlanetContentManagerPassThru, PlayerCharPassThru);
	if (fUTHourPerLocalDay == -1.00f)
		return -1.00f;
	float fUTHourPerLocalHour = fUTHourPerLocalDay / 24.0f;
	if (!bIgnorefMaxUTHourPerLocalHourGameSetting) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(851348) };  // 0x667AC88 in v1.14.70
		auto                       addr = ptr.address();
		auto                       fMaxUTHourPerLocalHour = reinterpret_cast<float*>(addr);
		if (!fMaxUTHourPerLocalHour)
			return -1.00f;
		if (fUTHourPerLocalHour > *fMaxUTHourPerLocalHour)
			return *fMaxUTHourPerLocalHour;
	}
	return fUTHourPerLocalHour;
}

inline static RE::TESObjectMISC* GetLooseMod(RE::BGSMod::Attachment::Mod* theMod) {
	if (!theMod)
		return nullptr;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(101697) };  // 0x193F2E8 in v1.14.70
	auto addr = funcPtr.address();
	const auto                 func = reinterpret_cast<RE::TESObjectMISC* (*)(RE::BGSMod::Attachment::Mod*)>(addr);
	return func(theMod);
}

inline static RE::TESWorldSpace* GetWorldSpace(RE::TESObjectREFR* theRef, uintptr_t funcAddr = 0)
{
	if (theRef) {
		if (funcAddr == 0) {
			REL::Relocation<uintptr_t> funcPtr{ REL::ID(172302) };  // 0x2CEFAE0 in v1.14.70
			funcAddr = funcPtr.address();
		}
		const auto func = reinterpret_cast<RE::TESWorldSpace* (*)(uintptr_t, uintptr_t, RE::TESObjectREFR*)>(funcAddr);
		return func(0, 0, theRef);
	}
	return nullptr;
}

inline static RE::TESWorldSpace* GetParentWorldSpaceCustom(RE::TESObjectREFR* theRef, uintptr_t funcAddr)
{
	if (theRef && funcAddr != 0) {
		const auto func = reinterpret_cast<RE::TESWorldSpace* (*)(RE::TESObjectREFR*)>(funcAddr);
		return func(theRef);
	}
	return nullptr;
}

inline static bool HasKeyword(RE::TESForm* theForm, RE::BGSKeyword* theKeyword)
{
    if (!theForm || !theKeyword)
        return false;
    auto KeywordForm = Runtime_DynamicCast<RE::TESForm, RE::BGSKeywordForm>(theForm);
    if (!KeywordForm)
        return false;
    for (uint32_t i = 0; i < KeywordForm->GetNumKeywords(); i++) {
        if (KeywordForm->keywords[i] && KeywordForm->keywords[i]->formID == theKeyword->formID) {
            LogDebug("result --> [true] | params: theForm " + GetBasicFormData(theForm) + ", theKeyword " + GetBasicFormData(theKeyword));
            return true;
        }
    }
    LogDebug("result --> [false] | params: theForm " + GetBasicFormData(theForm) + ", theKeyword " + GetBasicFormData(theKeyword));
    return false;
}

inline static bool AddKeywordToForm(RE::TESForm* theForm, RE::BGSKeyword* theKeyword)
{
	if (!theForm || !theKeyword)
		return false;
	if (HasKeyword(theForm, theKeyword))
		return false;
	auto KeywordForm = Runtime_DynamicCast<RE::TESForm, RE::BGSKeywordForm>(theForm);
	if (!KeywordForm)
		return false;
	KeywordForm->keywords.push_back(theKeyword);
	return HasKeyword(theForm, theKeyword);
}

inline static bool RemoveKeywordFromForm(RE::TESForm* theForm, RE::BGSKeyword* theKeyword)
{
	if (!theForm || !theKeyword)
		return false;
	auto KeywordForm = Runtime_DynamicCast<RE::TESForm, RE::BGSKeywordForm>(theForm);
	if (!KeywordForm)
		return false;
	auto iter = std::find(KeywordForm->keywords.begin(), KeywordForm->keywords.end(), theKeyword);
	if (iter != KeywordForm->keywords.end()) {
		KeywordForm->keywords.erase(iter);
		return true;
	}
	return false;
}

inline static RE::TESObjectREFR* GetExtraTeleportDestination(RE::TESObjectREFR* theRef)		// untested
{
	if (!theRef)
		return 0;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(83318) };  // 0x1469B90 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(RE::TESObjectREFR*)>(addr);
	auto                       result = func(theRef);
	if (result == 0)
		return nullptr;
	auto ptr = reinterpret_cast<uint32_t*>(result + 0x8);
	if (!ptr)
		return nullptr;
	return RE::GetReferenceByHandle(*ptr);
}

inline static float GetWorldReferenceScale()
{
	REL::Relocation<uintptr_t> ptr{ REL::ID(877646) };  // 0x6578D9C in v1.12.36
	uintptr_t                  addr = ptr.address();
	auto                       fGlobalScale = reinterpret_cast<float*>(addr);
	if (fGlobalScale && *fGlobalScale)
		return *fGlobalScale;
	return -1.00f;
}

inline static bool GetGraphVariableBool(RE::TESObjectREFR* theRef, std::string sVar)
{
    if (!theRef || sVar.empty())
        return false;		// changed from -1 to false
    auto                       graphManager = (RE::IAnimationGraphManagerHolder*)theRef;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(118424) }; // 0x1D30930 in v1.12.36
    uintptr_t                  addr = funcPtr.address();
    const auto                 func = reinterpret_cast<bool (*)(RE::IAnimationGraphManagerHolder*, RE::BSFixedString*, bool*)>(addr);
    RE::BSFixedString          bsVar(sVar);
    bool                       out    = 0;
    auto                       result = func(graphManager, &bsVar, &out);
    LogDebug("result --> [" + std::to_string(result) + " | outResult: " + std::to_string(out) + "] | params: theRef " + GetBasicFormData(theRef) + ", sVar [" + sVar + "]");
    return out;
}

inline static bool WornHasKeyword(RE::Actor* theActor, RE::BGSKeyword* theKeyword) // v1.3
{
    if (!theActor || !theKeyword)
        return false;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(106992) };
    uintptr_t                  addr = funcPtr.address();
    const auto                 func = reinterpret_cast<int (*)(RE::Actor*, RE::BGSKeyword*)>(addr);
    auto result = func(theActor, theKeyword);
    LogDebug("result --> [" + std::to_string(result) + "] | params: theActor " + GetBasicFormData(theActor) + ", theKeyword " + GetBasicFormData(theKeyword));
    return result;
}

inline static float GetDistance(RE::TESObjectREFR* theRef01, RE::TESObjectREFR* theRef02, uintptr_t funcAddr = 0) // v1.9
{
    if (!theRef01 || !theRef02)
        return false;
	if (funcAddr == 0) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(106562) };  // 0x1A245C8 in v1.12.36
		funcAddr = funcPtr.address();
	}
    const auto func = reinterpret_cast<float (*)(RE::TESObjectREFR*, RE::TESObjectREFR*, bool)>(funcAddr);
    auto result = func(theRef01, theRef02, false);
    LogDebug("result --> [" + std::to_string(result) + "] | params: theRef01 " + GetBasicFormData(theRef01) + ", theRef02 " + GetBasicFormData(theRef02));
    return result;
}

inline static bool ChangeAnimArchetype(RE::Actor* theActor, RE::BGSKeyword* animKeyword)
{
    if (!theActor || !animKeyword)
        return false;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(150497) }; // 0x25BA0DC in v1.12.36
    uintptr_t                  addr   = funcPtr.address();
    const auto                 func   = reinterpret_cast<uintptr_t (*)(RE::Actor*, RE::BGSKeyword*)>(addr);
    int64_t                    unk    = 0;
    auto                       result = func(theActor, animKeyword);
    LogDebug("result --> " + std::to_string((result != 0)) + " | params: theRef01 " + GetBasicFormData(theActor) + ", animKeyword " + GetBasicFormData(animKeyword));
    return (result != 0);
}

inline static float GetScale(RE::TESObjectREFR* theRef) // v1.1
{
    if (!theRef)
        return 0;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(106658) }; // 0x1A27A6C in v1.12.36
    uintptr_t                  addr   = funcPtr.address();
    const auto                 func   = reinterpret_cast<float (*)(RE::TESObjectREFR*)>(addr);
    int64_t                    unk    = 0;
    auto                       result = func(theRef);
    LogDebug("result --> [" + std::to_string(result) + "] | params: theRef " + GetBasicFormData(theRef));
    return result;
}

inline static float GetAngle(RE::TESObjectREFR* theRef, char chAxis) // v1.9
{
    if (!theRef)
        return 0;
    /*
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(108606) }; // 0x1A94518 in v1.12.36
    uintptr_t                  addr   = funcPtr.address();
    const auto                  func   = reinterpret_cast<char (*)(RE::TESObjectREFR**, uint64_t, uint64_t, float*)>(addr);
    uint64_t                    unk    = 0;
    float                       out    = 0.0f;
    uint64_t                    axis   = 0;
    if (chAxis == 'x' || chAxis == 'X')
        axis = 0x58;
    else if (chAxis == 'y' || chAxis == 'Y')
        axis = 0x59;
    else if (chAxis == 'z' || chAxis == 'Z')
        axis = 0x5A;
    else {
        std::string sAxis = std::string(1, chAxis);
        LogError("unknown chAxis [" + sAxis + "], cannot GetAngle");
        return 0.00f;
    }
    auto result = func(&theRef, axis, unk, &out);
    if (bVerboseLogging)
        LogInfo("theRef " + GetBasicFormData(theRef) + " | GetAngle = " + std::to_string(result) + " | out [" + std::to_string(out) + "]");
    return out;
     */
    std::string sAxis  = std::string(1, chAxis);
    float       angle  = 0.0f;
    float       result = 0.0f;
    int         axis   = 0;
    if (chAxis == 'x' || chAxis == 'X')
        angle = theRef->data.angle.x;
    else if (chAxis == 'y' || chAxis == 'Y')
        angle = theRef->data.angle.y;
    else if (chAxis == 'z' || chAxis == 'Z')
        angle = theRef->data.angle.z;
    else {
        LogError("unknown chAxis [" + sAxis + "], cannot GetAngle");
        return 0.00f;
    }
    try {
        result = angle / static_cast<float>(0.0174532925);
    }
    catch (...) {
        LogError("exception when getting angle '" + sAxis + "' for actor [" + GetObjectAddressAsHex(theRef) + "] for angle [" + std::to_string(angle) + "]");
        return 0.00f;
    }
    LogDebug("result --> " + std::to_string(result) + " | params: theRef " + GetBasicFormData(theRef) + ", chAxis '" + chAxis + "' = " + std::to_string(result) + " | other data: angle [" + std::to_string(angle) + "]");
    return result;
}

inline static bool SetAngle(RE::TESObjectREFR* theRef, char chAxis, float fAngle)  // v1.9
{
	if (!theRef)
		return false;
	std::string sAxis = std::string(1, chAxis);
	try {
		if (chAxis == 'x' || chAxis == 'X') {
			theRef->data.angle.x = fAngle * static_cast<float>(0.0174532925);
		} else if (chAxis == 'y' || chAxis == 'Y') {
			theRef->data.angle.y = fAngle * static_cast<float>(0.0174532925);
		} else if (chAxis == 'z' || chAxis == 'Z') {
			theRef->data.angle.z = fAngle * static_cast<float>(0.0174532925);
		} else {
			LogError("unknown chAxis [" + sAxis + "], cannot SetAngle");
			return false;
		}
	} catch (...) {
		LogError("exception when SetAngle '" + sAxis + "' for actor [" + GetObjectAddressAsHex(theRef) + "] for fAngle [" + std::to_string(fAngle) + "]");
		return false;
	}
	return true;
}

inline static RE::TESClass* GetClass(RE::TESNPC* theActor)
{
    if (!theActor)
        return nullptr;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(171597) }; // 0x2B8C070 in v1.12.36
    uintptr_t                  addr   = funcPtr.address();
    const auto                 func   = reinterpret_cast<RE::TESClass* (*)(int64_t, int64_t, RE::TESNPC*)>(addr);
    int64_t                    unk    = 0;
    auto                       result = func(unk, unk, theActor);
    LogDebug("result --> " + GetBasicFormData(result) + " | params: theActor " + GetBasicFormData(theActor));
    return result;
}

inline static RE::TESRace* GetRace(RE::TESNPC* theActorBase, uintptr_t funcAddress = 0)
{
    if (!theActorBase)
        return nullptr;
	if (funcAddress == 0) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(171601) };  // 0x2B8C0C0 in v1.12.36
		funcAddress = funcPtr.address();
	}    
    const auto                 func = reinterpret_cast<RE::TESRace* (*)(int64_t, int64_t, RE::TESNPC*)>(funcAddress);
    int64_t                    unk    = 0;
    auto                       result = func(unk, unk, theActorBase);
    LogDebug("result --> " + GetBasicFormData(result) + " | params: theActorBase " + GetBasicFormData(theActorBase));
    return result;
}

inline static bool IsFlashlightOn()
{                                                                   // v1.1     // returns whether the flashlight is supposed to be on/off, not whether the actual light node exists
    const REL::Relocation<std::uintptr_t> reloc{ REL::ID(881141) }; // 0x6889242 in v1.12.36
    uintptr_t                             addr    = reloc.address();
    const auto                            bytePtr = reinterpret_cast<BYTE*>(addr);
    bool                                  result  = (bytePtr && *bytePtr == 1);
    LogDebug("result --> " + std::to_string(result));
    return result;
}

inline static bool SetFlashlightState(RE::TESObjectREFR* akRef, bool bOn) // v1.1
{
    if (!akRef)
        return false;
    REL::Relocation<uintptr_t> funcPtr{ REL::ID(153762) }; // 0x26D3A34 in v1.12.36
    uintptr_t                  addr   = funcPtr.address();
    const auto                 func   = reinterpret_cast<uintptr_t (*)(RE::TESObjectREFR*, bool)>(addr);
    int64_t                    unk    = 0;
    auto                       result = func(akRef, bOn);
    LogDebug("result --> [" + std::to_string(result) + "] | params: akRef " + GetBasicFormData(akRef) + ", bOn [" + std::to_string(bOn) + "]");
	return true;
}

inline static bool IsSpacesuitHelmetVisible(RE::Actor* theActor)  // convenience functions...
{
	if (theActor && GetGraphVariableBool(theActor, "bHelmetIsVisible"))
		return true;
	return false;
}

inline static bool IsSpacesuitHelmetLightOn(RE::Actor* theActor)
{
	if (!theActor)
		return false;
	if (theActor->formID != 0x14)
		return (GetGraphVariableBool(theActor, "bHelmetIsVisible") && GetGraphVariableBool(theActor, "bHelmetLightIsOn"));
	if (GetGraphVariableBool(theActor, "bHelmetIsVisible"))
		return GetGraphVariableBool(theActor, "bHelmetLightIsOn");
	return IsFlashlightOn();
}

inline static BYTE GetWeaponState(RE::Actor* theActor) // v1.1
{
    if (!theActor)
        return false;
    unsigned long long theActorAddr   = reinterpret_cast<unsigned long long>(theActor);
    //BYTE*              WeaponStatePtr = reinterpret_cast<BYTE*>(theActorAddr + 0xF7);
	BYTE* WeaponStatePtr = reinterpret_cast<BYTE*>(theActorAddr + 0xFF);	// since v1.14.70
    BYTE               result         = 0;
    if (WeaponStatePtr)
        result = *WeaponStatePtr;
    LogDebug("result --> [" + std::to_string(result) + "] | params: theActor " + GetBasicFormData(theActor));
    return result;
}

/*
inline static bool IsTESNPC(unsigned long long* unverifiedFormAddress)
{
    if (!unverifiedFormAddress)
        return false;
    for (auto& i : RE::VTABLE::TESActorBase) {
        if (i.address() == *unverifiedFormAddress)
            return true;
    }
    for (auto& i : RE::VTABLE::TESNPC) {
        if (i.address() == *unverifiedFormAddress)
            return true;
    }
    return false;
}
*/

inline static bool IsMenuActor(unsigned long long* unverifiedFormAddress) // v1.3
{
    if (!unverifiedFormAddress)
        return false;
    for (auto& i : RE::VTABLE::MenuActor) {
        if (i.address() == *unverifiedFormAddress) {
            LogDebug("result --> [true] | params: unverifiedFormAddress " + GetObjectAddressAsHex(unverifiedFormAddress));
            return true;
        }
    }
    LogDebug("result --> [false] | params: unverifiedFormAddress " + GetObjectAddressAsHex(unverifiedFormAddress));
    return false;
}

/*
inline static bool IsPlayerTeammate(RE::Actor* theActor)
{
    if (theActor && theActor->boolBits.any(RE::Actor::BOOL_BITS::kPlayerTeammate)) {
        LogDebug("result --> [true] | params: theActor " + GetBasicFormData(theActor));
        return true;
    }
    LogDebug("result --> [false] | params: theActor " + GetBasicFormData(theActor));
    return false;
}
*/

inline static bool IsPlayerTeammate(RE::Actor* theActor, uintptr_t funcAddr = 0)
{  // REL::ID 170280
	if (theActor) {
		if (funcAddr == 0) {
			REL::Relocation<uintptr_t> funcPtr{ REL::ID(170280) };  // 0x2B80700 in v1.13.61
			funcAddr = funcPtr.address();
		}
		const auto func = reinterpret_cast<bool (*)(int64_t, int64_t, RE::Actor*)>(funcAddr);
		return func(0, 0, theActor);
	}
	return false;
}

inline static bool SetPlayerTeammate(RE::Actor* theActor, bool bTeammate, bool bCanDoFavor, bool bGivePlayerXP = false)
{
	if (!theActor)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(151302) };  // 0x2665BE8 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<void (*)(RE::Actor*, bool, bool, bool)>(addr);
	REL::Relocation<uintptr_t> bQueuePtr{ REL::ID(881136) };  // 0x6889230 in v1.12.36
	uintptr_t                  bQueueAddr = bQueuePtr.address();
	auto                       bQueue = reinterpret_cast<int*>(bQueueAddr);
	int                        bQueue_Init = 0;
	func(theActor, bTeammate, bCanDoFavor, bGivePlayerXP);
	if (bQueue)
		*bQueue = 1;
	return true;
}

inline static std::vector<RE::Actor*> GetHighActors()
{
	std::vector<RE::Actor*> Result;
	auto                    processLists = RE::ProcessListsCustom::GetSingleton();
	if (!processLists)
		return Result;
	auto actorHandles = GetAsBSTArrayCustom(&processLists->highActorProcessHandles);
	if (!actorHandles)
		return Result;
	if (actorHandles->size() == 0)
		return Result;
	for (uint32_t i = 0; i < actorHandles->size(); i++) {
		auto handle = actorHandles->at(i);
		if (handle > 1 && handle <= UINT32_MAX) {
			auto Ref = RE::GetReferenceByHandle(handle);
			if (!Ref || Ref->formID == 0x14 || Ref->GetSavedFormType() != static_cast<int>(RE::FormType::kACHR))
				continue;
			Result.push_back((RE::Actor*)Ref);
		}
	}
	return Result;
}

inline static bool IsHighActor(uint32_t nativeHandle, RE::ProcessListsCustom* ProcessListsCustomPassThru = nullptr)
{
	if (!ProcessListsCustomPassThru)
		ProcessListsCustomPassThru = RE::ProcessListsCustom::GetSingleton();
	for (auto& i : ProcessListsCustomPassThru->highActorProcessHandles) {
		if (nativeHandle == i) {
			//	LogInfo(" --> handle (" + std::to_string(nativeHandle) + "|" + GetUIntFormIDAsHex(nativeHandle) + ") is high");
			return true;
		}
	}
	//LogInfo(" --> handle (" + std::to_string(nativeHandle) + "|" + GetUIntFormIDAsHex(nativeHandle) + ") is NOT high");
	return false;
}

inline static bool IsSortedHighActor(uint32_t nativeHandle, RE::MainCustom* MainCustomPassThru = nullptr)
{
	if (!MainCustomPassThru)
		MainCustomPassThru = RE::MainCustom::GetSingleton();
	for (auto& i : MainCustomPassThru->sortedVisibleHighActorHandles) {
		if (nativeHandle == i.second) {
		//	LogInfo(" --> handle (" + std::to_string(nativeHandle) + "|" + GetUIntFormIDAsHex(nativeHandle) + ") is sorted high");
			return true;
		}
	}
	//LogInfo(" --> handle (" + std::to_string(nativeHandle) + "|" + GetUIntFormIDAsHex(nativeHandle) + ") is NOT sorted high");
	return false;
}

inline static std::vector<RE::Actor*> GetSortedHighActors()
{
	std::vector<RE::Actor*> Result;
	auto                    main = RE::MainCustom::GetSingleton();
	if (!main)
		return Result;
	if (main->sortedVisibleHighActorHandles.size() == 0)
		return Result;
	for (uint32_t i = 0; i < main->sortedVisibleHighActorHandles.size(); i++) {
		auto handle = main->sortedVisibleHighActorHandles.at(i).second;
		if (handle > 1 && handle <= UINT32_MAX) {
			auto Ref = RE::GetReferenceByHandle(handle);
			if (!Ref || Ref->formID == 0x14 || Ref->GetSavedFormType() != static_cast<int>(RE::FormType::kACHR))
				continue;
			Result.push_back((RE::Actor*)Ref);
		}
	}
	return Result;
}

inline static std::vector<RE::Actor*> GetVisibleActors()
{
	std::vector<RE::Actor*> Result;
	auto highActors = GetHighActors();
	if (highActors.size() == 0)
		return Result;
	auto PlayerChar = RE::PlayerCharacter::GetSingleton();
	if (RE::PlayerCamera::GetSingleton()->IsInFirstPerson() == false)
		highActors.push_back(PlayerChar);
	for (auto& it : highActors) {
		auto hasLOS = HasDetectionLOS(PlayerChar, it);
		if (!hasLOS)
			continue;
		Result.push_back(it);
	}
	return Result;
}

inline static std::vector<RE::Actor*> GetPlayerTeammates(bool bLoadedOnly, RE::ProcessListsCustom* ProcessListsPassThru = nullptr)  // bLoadedOnly does no longer relies on Is3DLoaded
{
    std::vector<RE::Actor*> teammates;
    RE::ProcessListsCustom* ProcessListsSingleton = nullptr;
    if (ProcessListsPassThru)
        ProcessListsSingleton = ProcessListsPassThru;
    else
        ProcessListsSingleton = RE::ProcessListsCustom::GetSingleton();
    if (!ProcessListsSingleton) {
        LogError("ProcessListsSingleton is nullptr");
        return teammates;
    }
    if (ProcessListsSingleton->highActorProcessHandles.size() == 0) {
        LogError("highActorProcessHandles.size == 0");
        return teammates;
    }
    for (uint32_t i = 0; i < ProcessListsSingleton->highActorProcessHandles.size(); i++) {
        if (ProcessListsSingleton->highActorProcessHandles[i] > 1 && ProcessListsSingleton->highActorProcessHandles[i] <= UINT32_MAX) {
            auto Ref = RE::GetReferenceByHandle(ProcessListsSingleton->highActorProcessHandles[i]);
            if (!Ref) {
            //    LogError("Ref (handle: " + std::to_string(ProcessListsSingleton->highActorProcessHandles[i]) + ") is nullptr");
                continue;
            }
            auto actorRef = (RE::Actor*)Ref;
            if (!actorRef) {
            //    LogError("actorRef (handle: " + std::to_string(ProcessListsSingleton->highActorProcessHandles[i]) + ") is nullptr");
                continue;
            }
            if (IsPlayerTeammate(actorRef)) {
				if (!bLoadedOnly || bLoadedOnly && GetFadeNode(actorRef)) {
                    LogDebug("->found follower " + GetBasicFormData(actorRef));
                    teammates.push_back(actorRef);
                }
            }
        }
    }
    LogDebug("result --> [" + std::to_string(teammates.size()) + " teammates] | ProcessListsPassThru [" + GetObjectAddressAsHex(ProcessListsPassThru) + "]");
    return teammates;
}

inline static RE::Actor* GetCurrentCompanionActor(RE::ProcessListsCustom* ProcessListsPassThru = nullptr, RE::TESFaction* CurrentCompanionFactionPassThru = nullptr)
{
	if (!ProcessListsPassThru)
		ProcessListsPassThru = RE::ProcessListsCustom::GetSingleton();
	if (!ProcessListsPassThru)
		return nullptr;
	if (!CurrentCompanionFactionPassThru)
		CurrentCompanionFactionPassThru = (RE::TESFaction*)RE::TESForm::LookupByID(0x23C01);
	if (!CurrentCompanionFactionPassThru)
		return nullptr;
	auto teammates = GetPlayerTeammates(true, ProcessListsPassThru);
	for (auto& i : teammates) {
		if (i && i->IsInFaction(CurrentCompanionFactionPassThru))
			return i;
	}
	return nullptr;
}

inline static RE::TESObjectREFR* GetPlayerHomeSpaceship()
{
	/*
    uintptr_t   baseAddr     = (uintptr_t)GetModuleHandle("Starfield.exe"); // vanilla, non-CLib
    uintptr_t   relativeAddr = baseAddr + 0x2A5DBA0;        // v1.9.67.
    const auto  func         = reinterpret_cast<RE::TESObjectREFR* (*)()>(relativeAddr);
    return func();
    */
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(171075) };
	uintptr_t                  addr = funcPtr.address();
	uintptr_t                  out = 0;
	const auto                 func = reinterpret_cast<RE::TESObjectREFR** (*)(uintptr_t*)>(addr);
	func(&out);
	if (out == 0)
		return nullptr;
	return reinterpret_cast<RE::TESObjectREFR*>(out);
}

inline static bool IsReferenceOnPlayerHomeSpaceShip(RE::TESObjectREFR* theRef, RE::TESObjectREFR* HomeshipPassThru = nullptr)
{
	if (!theRef)
		return false;
	auto CurrentSpaceship = theRef->GetSpaceship();
	if (!HomeshipPassThru)
		HomeshipPassThru = GetPlayerHomeSpaceship();
	return CurrentSpaceship && CurrentSpaceship == HomeshipPassThru;
}

inline static RE::NiPoint3 GetOffset(RE::NiPoint3 point1, RE::NiPoint3 point2) {
	auto Offset = point1 - point2;
	if (point2.x > point1.x)
		Offset.x = std::abs(Offset.x);
	else if (point2.x < point1.x)
		Offset.x = -Offset.x;
	if (point2.y > point1.y)
		Offset.y = std::abs(Offset.y);
	else if (point2.y < point1.y)
		Offset.y = -Offset.y;
	if (point2.z > point1.z)
		Offset.z = std::abs(Offset.z);
	else if (point2.z < point1.z)
		Offset.z = -Offset.z;
	return Offset;
}

inline static std::size_t GetHandleFromObject(void* src, std::uint32_t typeID)
{
	RE::BSScript::IVirtualMachine* registry = RE::GameVMCustom::GetSingleton()->virtualMechine;
	auto                           policy = &registry->GetObjectHandlePolicy();
	return policy->GetHandleForObject(typeID, (void*)src);
	//return 0;
}
inline static void* GetObjectFromHandle(std::size_t handle, std::uint32_t typeID)
{
	RE::BSScript::IVirtualMachine* registry = RE::GameVMCustom::GetSingleton()->virtualMechine;
	auto                           policy = &registry->GetObjectHandlePolicy();
	if (handle == policy->EmptyHandle()) {
		return NULL;
	}
	return policy->GetObjectForHandle(typeID, handle);
	//return nullptr;
}

template <class... Args>
inline bool CallPapyrusFunctionStatic(std::string scriptName, std::string functionName, RE::BSScript::IVirtualMachine* VMPassThru = nullptr, Args&&... a_args)
{
	if (scriptName.empty() || functionName.empty())
		return false;
	if (!VMPassThru)
		VMPassThru = RE::GameVMCustom::GetSingleton()->virtualMechine;
	if (!VMPassThru)
		return false;
	VMPassThru->DispatchStaticCall(scriptName, functionName, nullptr, 0, std::forward<Args>(a_args)...);
	return true;
}

template <class... Args>
inline bool CallPapyrusFunction(uint64_t papyrusObjectHandle, std::string scriptName, std::string functionName, RE::BSScript::IVirtualMachine* VMPassThru = nullptr, Args&&... a_args)
{
	if (papyrusObjectHandle == 0 || scriptName.empty() || functionName.empty())
		return false;
	if (!VMPassThru)
		VMPassThru = RE::GameVMCustom::GetSingleton()->virtualMechine;
	if (!VMPassThru)
		return false;
	VMPassThru->DispatchMethodCall(papyrusObjectHandle, scriptName, functionName, nullptr, 0, std::forward<Args>(a_args)...);
	return true;
}

template <class... Args>
inline bool CallPapyrusFunctionThenCall(uint64_t papyrusObjectHandle, RE::BSTSmartPointer<RE::BSScript::IStackCallbackFunctor>& callback, std::string scriptName, std::string functionName, RE::BSScript::IVirtualMachine* VMPassThru = nullptr, Args&&... a_args)
{
	if (papyrusObjectHandle == 0 || scriptName.empty() || functionName.empty())
		return false;
	if (!VMPassThru)
		VMPassThru = RE::GameVMCustom::GetSingleton()->virtualMechine;
	if (!VMPassThru)
		return false;
	VMPassThru->DispatchMethodCall(papyrusObjectHandle, scriptName, functionName, callback, 0, std::forward<Args>(a_args)...);
	return true;
}

inline static bool IsAnyCompanionTalking()
{
    auto companions = GetPlayerTeammates(true);
    if (companions.size() > 0) {
        for (uint32_t i = 0; i < companions.size(); i++)
            if (IsTalking(companions.at(i))) {
                LogDebug("result --> [true] | other data: " + GetBasicFormData(companions.at(i)) + " is talking");
                return true;
            }

    }
    LogDebug("result --> [false]");
    return false;
}

inline static std::vector<RE::Actor*> GetActorsDetectedBy(RE::Actor* theActor, bool bMustHaveLOS)
{
	std::vector<RE::Actor*> Result;
	if (!theActor)
		return Result;
	auto highActors = GetHighActors();
	if (highActors.size() == 0)
		return Result;
	highActors.push_back(RE::PlayerCharacter::GetSingleton());
	for (auto& it : highActors) {
		auto detected = IsDetectedBy(it, theActor);
		if (!detected)
			continue;
		if (!bMustHaveLOS || bMustHaveLOS && HasDetectionLOS(theActor, it))
			Result.push_back(it);
	}
	return Result;
}

inline static std::vector<RE::Actor*> GetActorsDetecting(RE::Actor* theActor, bool bMustHaveLOS)
{
	std::vector<RE::Actor*> Result;
	if (!theActor)
		return Result;
	auto highActors = GetHighActors();
	if (highActors.size() == 0)
		return Result;
	highActors.push_back(RE::PlayerCharacter::GetSingleton());
	for (auto& it : highActors) {
		auto detected = IsDetectedBy(theActor, it);
		if (!detected)
			continue;
		if (!bMustHaveLOS || bMustHaveLOS && HasDetectionLOS(it, theActor))
			Result.push_back(it);
	}
	return Result;
}

inline static RE::TESPackedFile* LookupTESFileByName(std::string PluginName, int* pluginType)
{
    if (!pluginType) {
        LogError("pluginType is nullptr");
        return nullptr;
    }
    RE::TESDataHandler* dataHandler = RE::TESDataHandler::GetSingleton();
    if (!dataHandler) {
        LogError("dataHandler is nullptr");
        return nullptr;
    }
    std::vector<std::string> returnLines;
    for (uint32_t Index = 0; Index <= 2; Index++) {
        BSTArrayCustom<RE::TESPackedFile*>* theFiles = nullptr;
        if (Index == 0) {
            theFiles = reinterpret_cast<BSTArrayCustom<RE::TESPackedFile*>*>(&dataHandler->CompiledFileCollection.FileA);
        }
        else if (Index == 1) {
            theFiles = reinterpret_cast<BSTArrayCustom<RE::TESPackedFile*>*>(&dataHandler->CompiledFileCollection.SmallFileA);
        }
        else if (Index == 2) {
            theFiles = reinterpret_cast<BSTArrayCustom<RE::TESPackedFile*>*>(&dataHandler->CompiledFileCollection.MediumFileA);
        }
        if (!theFiles) {
            if (Index == 0) {
                LogWarning("theFiles (FileA) is nullptr, skipping this file array");
                continue;
            }
            else if (Index == 1) {
                LogWarning("theFiles (SmallFileA) is nullptr, skipping this file array");
                continue;
            }
            else if (Index == 2) {
                LogWarning("theFiles (MediumFileA) is nullptr, skipping this file array");
                continue;
            }
        }
        if (theFiles->size() <= 0) {
            if (Index == 0) {
                LogWarning("theFiles.size() (of FileA) <= 0, skipping this file array");
                continue;
            }
            else if (Index == 1) {
                LogWarning("theFiles.size() (of SmallFileA) <= 0, skipping this file array");
                continue;
            }
            else if (Index == 2) {
                LogWarning("theFiles.size() (of MediumFileA) <= 0, skipping this file array");
                continue;
            }
        }
        // LogInfo("beginning loop...");
        for (uint32_t i = 0; i < theFiles->size(); i++) {
            auto loopFile = theFiles->at(i);
            if (!loopFile) {
                LogError("loopFile at (" + std::to_string(i) + ") is nullptr, skipping plugin file");
                continue;
            }
            auto        filePath  = loopFile->filePath;
            std::string sFilePath;
            if (filePath) {
                sFilePath = filePath;
            }
            if (std::strcmp(ToLowerStr(sFilePath).c_str(), ToLowerStr(PluginName).c_str()) == 0) {
                if (Index == 0) {
                    *pluginType = 1;
                }
                else if (Index == 1) {
                    *pluginType = 2;
                }
                else if (Index == 2) {
                    *pluginType = 3;
                }
                LogDebug("result --> [" + GetObjectAddressAsHex(loopFile) + "] | params: PluginName [" + PluginName + "]");
                return loopFile;
            }
        }
    }
    LogError("result --> [nullptr] | params: PluginName [" + PluginName + "] | other data: no TESFile could be found with the specified name");
    return nullptr;
}

inline static RE::TESForm* GetFormFromFile(std::string sHexFormIDNoPrefix, std::string sFileName = "")
{
    if (sHexFormIDNoPrefix.empty()) {
        LogError("parameter sHexFormIDNoPrefix is empty. Returning nullptr.");
        return nullptr;
    }
    bool bStarfieldESM = false;
    if (sFileName.empty()) {
        sFileName = "Starfield.esm";
    }
    if (std::strcmp(sFileName.c_str(), "Starfield.esm") == 0)
        bStarfieldESM = true;
    auto Length = sHexFormIDNoPrefix.length();
    if (Length < 6) {
        std::stringstream ss;
        ss << std::setw(5) << std::setfill('0') << sHexFormIDNoPrefix;
        sHexFormIDNoPrefix = ss.str();
        LogDebug("this HexFormID's length < 6. Extended to 5. Result: " + sHexFormIDNoPrefix);
    }
    else {
        // check if input string is like "0000000005" (too long)
        // input string can be 8 digits if the ID is from Starfield.esm, so when it starts with "00"
        if (bStarfieldESM == false) {
            if (Length > 6) {
                LogError("this HexFormID's length > 6 [" + sHexFormIDNoPrefix
                         + "]. This is not supported format (length must be <= 6 if source plugin is not Starfield.esm). Returning nullptr.");
                return nullptr;
            }
        }
        else {
            // Starfield.esm: max 8 digits
            if (Length > 8) {
                LogError("this HexFormID's length > 8 [" + sHexFormIDNoPrefix
                         + "]. This is not supported format (length must be <= 8 if source plugin is Starfield.esm). Returning nullptr.");
                return nullptr;
            }
        }
    }
    int         pluginType = 0;
    std::string sPluginType;
    auto        PluginFile = LookupTESFileByName(sFileName, &pluginType);
    if (!PluginFile) {
        LogError("no PluginFile could be found with the name [" + sFileName + "]. Returning nullptr.");
        return nullptr;
    }
    if (pluginType <= 0 || pluginType > 3) {
        LogError("pluginType for TESFile found with the name [" + sFileName + "] is out of range. Returning nullptr.");
        return nullptr;
    }
    if (pluginType == 1)
        sPluginType = "Full";
    else if (pluginType == 2)
        sPluginType = "Small";
    else if (pluginType == 3)
        sPluginType = "Medium";

    unsigned int rawFormID = 0;
    try {
        rawFormID = std::stoul(sHexFormIDNoPrefix, nullptr, 16);
    }
    catch (...) {
        LogError("std::stoul exception thrown for input String: " + sHexFormIDNoPrefix + ". Returning nullptr.");
        return nullptr;
    }
    std::uint32_t FormID = 0;
    if (pluginType <= 2) {
        FormID = (PluginFile->cCompileIndex << 24) + (PluginFile->sSmallFileCompileIndex << 12) + rawFormID;
    }
    else if (pluginType == 3) {
        FormID = (PluginFile->cCompileIndex << 24) + (PluginFile->cCompileIndex2 << 16) + rawFormID;
    }
    if (FormID > 0 && FormID <= UINT32_MAX) {
        // LogInfo("   FormID [" + std::to_string(FormID) + " | " + GetUIntFormIDAsHex(FormID) + "] is withing range.");
        RE::TESForm* checkForm = RE::TESForm::LookupByID(FormID);
        if (checkForm) {
            LogDebug("   this FormID [" + std::to_string(FormID) + " | " + GetUIntFormIDAsHex(FormID) + "] defined in [" + sFileName + " | Type: " + sPluginType
                        + "] is withing range and points to a valid Form.");
            return checkForm;
        }
        else
            LogWarning("   this FormID [" + std::to_string(FormID) + " | " + GetUIntFormIDAsHex(FormID) + "] supposedly defined in [" + sFileName + " | Type: " + sPluginType
                       + "] is withing range but it does not point to a valid Form or this Form is an unloaded Reference. Returning nullptr.");
    }
    else
        LogError("   FormID [" + std::to_string(FormID) + " | " + GetUIntFormIDAsHex(FormID) + "] supposedly defined in [" + sFileName + " | Type: " + sPluginType
                 + "] is out of range. Returning nullptr.");
    return nullptr;
}

inline static std::vector<std::string> GetWordsInStringAsVector(std::string str)
{
	if (str.empty()) {
		std::vector<std::string> empty;
		return empty;
	}
	std::stringstream                  ss(str);
	std::istream_iterator<std::string> begin(ss);
	std::istream_iterator<std::string> end;
	std::vector<std::string>           strings(begin, end);
	std::copy(strings.begin(), strings.end(), std::ostream_iterator<std::string>(std::cout, "\n"));
	for (int i = 0; i < strings.size(); i++)
		LogDebug("adding word to strings: " + strings.at(i));
	LogDebug("strings.size = " + std::to_string(strings.size()));
	return strings;
}

inline static std::vector<std::string> GetCommandStringArguments(const char* dataPointer, bool bReferenceFunction = true, int offset = 8)
{
	if (bReferenceFunction) {
		auto                     dataAddress = std::uint64_t(dataPointer);
		auto                     dataOffset = (*reinterpret_cast<std::uint8_t*>(dataAddress) == 28 ? 6 : 2);
		auto                     resultSizeAddress = dataAddress + dataOffset + 2;
		auto                     resultSize = *reinterpret_cast<std::uint8_t*>(resultSizeAddress);
		std::vector<std::string> result(resultSize);
		std::uint64_t            bufferSizeAddress = resultSizeAddress + 2;
		std::uint8_t             bufferSize = 0;
		for (std::uint8_t indexA = 0; indexA < resultSize; indexA++) {
			bufferSize = *reinterpret_cast<std::uint8_t*>(bufferSizeAddress);
			std::vector<char> buffer(bufferSize);
			for (std::uint8_t indexB = 0; indexB < bufferSize; indexB++) {
				auto symbolAddress = bufferSizeAddress + 2 + indexB;
				auto symbol = *reinterpret_cast<char*>(symbolAddress);
				buffer[indexB] = symbol;
			}
			auto bufferData = std::string(buffer.data(), bufferSize);
			result[indexA] = bufferData;
			bufferSizeAddress += (2 + bufferSize);
		}
		return result;
	}
	std::vector<std::string> result;
	int offset2 = offset - 2;
	if (offset2 <= 0) {
		return result;
	}
	auto                       dataAddress = std::uint64_t(dataPointer);
	auto                       size = *reinterpret_cast<std::uint8_t*>(dataAddress + offset2);
	std::vector<unsigned char> buffer(150);
	for (std::uint8_t index = 0; index < size; index++) {
		auto symbAddress = dataAddress + offset + index;
		auto symb = *reinterpret_cast<unsigned char*>(symbAddress);
		buffer[index] = symb;
	}
	auto Value = reinterpret_cast<char*>(buffer.data());
	auto params = std::string(Value, size);
	return GetWordsInStringAsVector(params);
}

inline static std::string GetStringVectorAsString(std::vector<std::string> arr, bool bDelimWithWhitespaces = false)
{
	if (arr.size() == 0)
		return "";
	std::string s;
	/*
	for (uint32_t i = 0; i < arr.size(); i++) {

		LogInfo("s [" + s + "] at (" + std::to_string(i) + ")");

		if (i == 0)
			s = arr.at(i);
		else {
			if (!bDelimWithWhitespaces)
				s = s + ", " + arr.at(i);
			else
				s = s + " " + arr.at(i);
		}
			
	}
	return s;
	*/	
	std::string        sResult;
	std::ostringstream oss;
	if (!bDelimWithWhitespaces) {
		std::copy(arr.begin(), arr.end(), std::ostream_iterator<std::string>(oss, ", "));
		sResult = oss.str();
		if (sResult.size() > 2) {
			sResult = sResult.substr(0, sResult.size() - 2);
		}
	}
	else {
		std::copy(arr.begin(), arr.end(), std::ostream_iterator<std::string>(oss, " "));
		sResult = oss.str();
		if (sResult.size() > 1) {
			sResult = sResult.substr(0, sResult.size() - 1);
		}
	}
	return sResult;
}


template <class T>
inline static T* GetFormByHexFormID(std::string HexFormID, std::vector<int> validFormTypes) {
	if (HexFormID.empty())
		return nullptr;
	auto FormID = GetHexFormIDAsUInt(HexFormID);
	if (FormID == 0)
		return nullptr;
	auto Form = RE::TESForm::LookupByID(FormID);
	if (!Form)
		return nullptr;
	auto typedForm = reinterpret_cast<T*>(Form);
	if (!typedForm)
		return nullptr;
	auto formType = Form->GetSavedFormType();
	if (validFormTypes.size() == 0)
		return typedForm;
	else if (std::find(std::begin(validFormTypes), std::end(validFormTypes), formType) < validFormTypes.end())
		return typedForm;
	return nullptr;
}

inline static bool GetStringAsBool(std::string Str, bool* bOut) {
	if (!bOut || Str.empty())
		return false;
	if (std::strcmp(ToLowerStr(Str).c_str(), "true") == 0 || std::strcmp(ToLowerStr(Str).c_str(), "1") == 0) {
		*bOut = true;
		return true;
	} else if (std::strcmp(ToLowerStr(Str).c_str(), "false") == 0 || std::strcmp(ToLowerStr(Str).c_str(), "0") == 0) {
		*bOut = false;
		return true;
	}
	return false;
}

inline static bool GetStringAsInt(std::string Str, int* iOut)
{
	if (!iOut || Str.empty())
		return false;
	if (Str.find_first_not_of("-0123456789") != std::string::npos)
		return false;
	try {
		*iOut = std::stoi(Str);
		return true;
	}
	catch (...) {
		return false;
	}
	return false;
}

inline static bool GetStringAsFloat(std::string Str, float* fOut)
{
	if (!fOut || Str.empty())
		return false;
	if (Str.find_first_not_of("-.0123456789") != std::string::npos)
		return false;
	try {
		*fOut = std::stof(Str);
		return true;
	} catch (...) {
		return false;
	}
	return false;
}

namespace std
{
	inline static std::string to_string(std::chrono::system_clock::time_point timePoint)
	{
		return std::format("{0:%F %R %Z}", timePoint);
	}
}

template <class T>
inline static bool IsNumericDataInVector(T value, std::vector<T> vec)
{
	if (std::find(std::begin(vec), std::end(vec), value) < vec.end())
		return true;
	return false;
}

template <class T>
inline static bool IsAnyInVector(std::vector<T> vec1, std::vector<T> vec2)
{
	for (auto& it : vec1) {
		if (std::find(std::begin(vec2), std::end(vec2), it) < vec2.end())
			return true;
	}
	return false;
}

inline static std::vector<std::tuple<RE::TESQuest*, RE::BGSBaseAlias*, std::string>> GetAliases(RE::TESObjectREFR* ref)
{
	std::vector<std::tuple<RE::TESQuest*, RE::BGSBaseAlias*, std::string>> Aliases;
	if (!ref)
		return Aliases;
	auto extraList = ref->extraDataList.get();
	if (!extraList)
		return Aliases;
	RE::BSExtraData* Extra = extraList->GetByType(RE::ExtraDataType::kAliasInstanceArray);
	if (!Extra)
		return Aliases;
	RE::ExtraAliasInstanceArray* theExtra = (RE::ExtraAliasInstanceArray*)Extra;
	if (!theExtra)
		return Aliases;
	auto AliasDataArray = &theExtra->aliasDataArray;
	if (!AliasDataArray)
		return Aliases;
	for (auto& i : *AliasDataArray) {
		if (!i.owningQuestForm.get() || !i.thisAlias)
			continue;
		//if (std::find(std::begin(*AliasDataArray), std::end(*AliasDataArray), i.thisAlias) < AliasDataArray->end())
		//	continue;
		std::string AliasName;
		auto BSAliasName = &i.thisAlias->aliasName;
		if (BSAliasName) {
			AliasName = BSAliasName->c_str();
		}
		if (AliasName.empty())
			AliasName = "{unnamed}";
		std::tuple<RE::TESQuest*, RE::BGSBaseAlias*, std::string> tuple = std::make_tuple((RE::TESQuest*)i.owningQuestForm.get(), i.thisAlias, AliasName);
		Aliases.push_back(tuple);
	}
	return Aliases;
}

inline static std::vector<RE::TESQuest*> GetAliasHolderQuests(RE::TESObjectREFR* theRef)
{
	std::vector<RE::TESQuest*> Result;
	auto                       aliases = GetAliases(theRef);
	if (aliases.empty())
		return Result;
	for (auto& it : aliases) {
		auto quest = std::get<0>(it);
		if (!quest)
			continue;
		Result.push_back(quest);
	}
	return Result;
}

inline static bool HasAliasExtraInstanceData(RE::TESObjectREFR* ref) {
	if (!ref)
		return false;
	auto extraList = ref->extraDataList.get();
	if (!extraList)
		return false;
	RE::BSExtraData* Extra = extraList->GetByType(RE::ExtraDataType::kAliasInstanceArray);
	if (!Extra)
		return false;
	RE::ExtraAliasInstanceArray* theExtra = (RE::ExtraAliasInstanceArray*)Extra;
	if (!theExtra)
		return false;
	auto AliasDataArray = &theExtra->aliasDataArray;
	if (AliasDataArray && AliasDataArray->size() > 0)
		return true;
	return false;
}

inline static std::vector<RE::BGSMod::Attachment::Mod*> GetItemMods(void* omodarray, std::uint32_t omodcount, bool bExcludeModColls = true)		// SEH exceptions
{
	std::vector<RE::BGSMod::Attachment::Mod*> mods;
	if (!omodarray || omodcount == 0) {
		return mods;
	}
	auto addr = reinterpret_cast<unsigned long long>(omodarray);
	if (addr <= 10000000000 || addr >= StarfieldBaseAddress) {
		return mods;
	}
	LogDebug("called | omodarray [" + GetObjectAddressAsHex(omodarray) + "] | omodcount [" + std::to_string(omodcount) + "] | bExcludeModColls [" + std::to_string(bExcludeModColls) + "]");
	int iPad = 0x10;
	int iCurrPad = 0;
	for (uint32_t i = 0; i < omodcount; i++) {
		auto loopAddr = addr + iCurrPad;
		iCurrPad = iCurrPad + iPad;
		if (loopAddr <= 10000000000 || loopAddr >= StarfieldBaseAddress)
			continue;
		auto loopOmodAddrPtr = reinterpret_cast<unsigned long long*>(loopAddr);
		if (!loopOmodAddrPtr)
			continue;
		auto loopOmodAddr = *loopOmodAddrPtr;
		if (loopOmodAddr <= 10000000000 || loopOmodAddr >= StarfieldBaseAddress)
			continue;
		auto loopOmod = reinterpret_cast<RE::BGSMod::Attachment::Mod*>(loopOmodAddr);
		if (!loopOmod)
			continue;
		if (loopOmod->formID == 0 || loopOmod->GetSavedFormType() != 152)
			continue;
		auto formFlags = loopOmod->formFlags & 0xFF;
		if (formFlags == 137 && bExcludeModColls)
			continue;
		mods.push_back(loopOmod);
	}
	if (mods.size() > 0) {
		std::sort(mods.begin(), mods.end());
		mods.erase(std::unique(mods.begin(), mods.end()), mods.end());
	}
	return mods;
}

inline static std::vector<RE::BGSMod::Attachment::Mod*> GetObjectModsByExtra(RE::ExtraDataList* theExtra, bool bExcludeModColls)
{
	std::vector<RE::BGSMod::Attachment::Mod*> Result;
	if (!theExtra)
		return Result;
	auto extraObjectInstanceData = (RE::BGSObjectInstanceExtra*)theExtra->GetByType(RE::ExtraDataType::kObjectInstance);
	if (!extraObjectInstanceData)
		return Result;
	auto modCount = extraObjectInstanceData->modCount;
	if (modCount == 0)
		return Result;
	auto modArray = extraObjectInstanceData->mods;
	if (!modArray)
		return Result;
	return GetItemMods(modArray, modCount, bExcludeModColls);
}

inline static std::vector<RE::BGSMod::Attachment::Mod*> GetObjectMods(RE::TESObjectREFR* theRef, bool bExcludeModColls)
{
	std::vector<RE::BGSMod::Attachment::Mod*> Result;
	if (!theRef)
		return Result;
	auto baseForm = theRef->GetBaseObject();
	if (!baseForm)
		return Result;
	auto formType = baseForm->GetSavedFormType();
	if (formType != static_cast<int>(RE::FormType::kWEAP) && formType != static_cast<int>(RE::FormType::kARMO))
		return Result;
	auto extraList = theRef->extraDataList.get();
	if (!extraList)
		return Result;
	return GetObjectModsByExtra(extraList, bExcludeModColls);
}

inline static bool IsModCollection(RE::BGSMod::Attachment::Mod* theMod)
{
	return (theMod && (theMod->formFlags & 0xFF) == 137);
}

inline static bool IsLooseMod(RE::TESObjectMISC* theMiscMod)
{
	return (theMiscMod && (theMiscMod->formFlags & 0x80) != 0);
}

inline static RE::Scaleform::GFx::ASMovieRootBase* GetMenuRoot(RE::IMenu* theMenu)
{
    if (!theMenu)
        return nullptr;
    auto root = theMenu->uiMovie.get()->asMovieRoot.get();
    if (!root) {
        LogError("theMenu.root couldn't be found for IMenu at address: " + GetObjectAddressAsHex(theMenu));
        return nullptr;
    }
    LogDebug("result --> [" + GetObjectAddressAsHex(root) + "] | params: theMenu [" + GetObjectAddressAsHex(theMenu) + "]");
    return root;
}

inline static bool IsReferencePersistent(RE::TESObjectREFR* ref)
{
	if (!ref)
		return false;
	return ((ref->formFlags & 0x00000400) != 0);
}

inline static bool SetReferencePersistent(RE::TESObjectREFR* ref, bool bSet)
{
	if (!ref)
		return false;
	if (bSet)
		ref->formFlags |= 0x00000400;
	else
		ref->formFlags &= ~0x00000400;
	return true;
}

inline static int IsReferencePersistentByHexFormID(std::string HexFormID)
{
	std::vector<int> types = { static_cast<int>(RE::FormType::kREFR),
		static_cast<int>(RE::FormType::kACHR) };
	auto             ref = GetFormByHexFormID<RE::TESObjectREFR>(HexFormID, types);
	if (!ref)
		return -1;
	if (ref->formID == 0x14 || (ref->formFlags & 0x00000400) != 0)
		return 1;
	return 0;
}

inline static bool IsFormTypeFlora(RE::TESObjectREFR* ref)
{
	return ref && ref->GetBaseObject() && ref->GetBaseObject()->GetFormType() == RE::FormType::kFLOR;
}

inline static bool IsHarvested(RE::TESObjectREFR* ref)
{
	return IsFormTypeFlora(ref) && ((ref->formFlags & 0x00002000) != 0);
}

inline static std::vector<std::string> GetAllMenuNames() {
	std::vector<std::string> Result;
	Result.push_back("ArmorCraftingMenu");
	Result.push_back("BSMissionMenu");
	Result.push_back("BarterMenu");
	Result.push_back("BookMenu");
	Result.push_back("BoundaryMenu");
	Result.push_back("ChargenMenu");
	Result.push_back("Console");
	Result.push_back("ConsoleNativeUIMenu");
	Result.push_back("ContainerMenu");
	Result.push_back("CreditsMenu");
	Result.push_back("CursorMenu");
	Result.push_back("DataMenu");
	Result.push_back("DataSlateButtons");
	Result.push_back("DataSlateMenu");
	Result.push_back("DialogueMenu");
	Result.push_back("DocAcceptMenu");
	Result.push_back("DrugsCraftingMenu");
	Result.push_back("EndGameCreditsMenu");
	Result.push_back("FaderMenu");
	Result.push_back("FanfareMenu");
	Result.push_back("FavoritesMenu");
	Result.push_back("FoodCraftingMenu");
	Result.push_back("GalaxyStarMapMenu");
	Result.push_back("GenesisTerminalMenu");
	Result.push_back("HUDMenu");
	Result.push_back("HUDMessagesMenu");
	Result.push_back("IndustrialCraftingMenu");
	Result.push_back("InventoryMenu");
	Result.push_back("LoadingMenu");
	Result.push_back("MainMenu");
	Result.push_back("MarketplaceMenu");
	Result.push_back("MessageBoxMenu");
	Result.push_back("MissionBoard");
	Result.push_back("MonocleMenu");
	Result.push_back("PauseMenu");
	Result.push_back("PhotoGalleryMenu");
	Result.push_back("PhotoModeMenu");
	Result.push_back("PickpocketMenu");
	Result.push_back("PlayBinkMenu");
	Result.push_back("PowersMenu");
	Result.push_back("ResearchMenu");
	Result.push_back("ScopeMenu");
	Result.push_back("SecurityMenu");
	Result.push_back("ShipCrewAssignMenu");
	Result.push_back("ShipCrewMenu");
	Result.push_back("ShipRefuelMenu");
	Result.push_back("SitWaitMenu");
	Result.push_back("SkillsMenu");
	Result.push_back("SleepWaitMenu");
	Result.push_back("SpaceshipEditorMenu");
	Result.push_back("SpaceshipHudMenu");
	Result.push_back("StatusMenu");
	Result.push_back("StreamingInstallMenu");
	Result.push_back("TakeoffMenu");
	Result.push_back("TestMenu");
	Result.push_back("TextInputMenu");
	Result.push_back("TitleSequenceMenu");
	Result.push_back("WeaponGroupAssignmentMenu");
	Result.push_back("WeaponsCraftingMenu");
	Result.push_back("WorkshopBuilderMenu");
	Result.push_back("WorkshopMenu");
	Result.push_back("WorkshopQuickMenu");
	Result.push_back("WorkshopTargetMenu");
	Result.push_back("Workshop_BlueprintMenu");
	return Result;
}

inline static RE::IMenu* GetMenu(std::string sMenuName, RE::UI* UIPassThru = nullptr)
{
    if (sMenuName.empty())
        return nullptr;
    RE::IMenu* theMenu     = nullptr;
    RE::UI*       UI          = nullptr;
    if (UIPassThru)
        UI = UIPassThru;
    else
        UI = RE::UI::GetSingleton();
    auto menuPtr = &UI->menuStack;
	auto menuArray = GetAsBSTArrayCustom(menuPtr);
	for (uint32_t i = 0; i < menuArray->size(); i++) {
		auto menu = menuArray->at(i);
        if (!menu)
            continue;
        if (std::strcmp(menu->GetName(), sMenuName.c_str()) == 0) {
            theMenu = menu;
        }
    }
    if (!theMenu) {
        LogError("theMenu with sMenuName [" + sMenuName + "] is nullptr.");
        return nullptr;
    }
    LogDebug("result --> [" + GetObjectAddressAsHex(theMenu) + "] | params: sMenuName [" + sMenuName + "], UIPassThru [" + GetObjectAddressAsHex(UIPassThru) + "]");
    return theMenu;
}

inline static std::string GetConsoleSelectedText(RE::Scaleform::GFx::ASMovieRootBase* ConsoleRootPassThru = nullptr, RE::IMenu* ConsoleMenuPassThru = nullptr)
{
	if (!ConsoleRootPassThru)
		ConsoleRootPassThru = GetMenuRoot(GetMenu("Console"));
	if (!ConsoleRootPassThru)
		return "";
	if (!ConsoleMenuPassThru)
		ConsoleMenuPassThru = GetMenu("Console");
	if (!ConsoleMenuPassThru)
		return "";
	RE::Scaleform::GFx::Value* GFxValue1 = new RE::Scaleform::GFx::Value();
	if (GFxValue1 != nullptr && ConsoleRootPassThru->GetVariable(GFxValue1, "root1.AnimHolder_mc.Menu_mc.CurrentSelection.text") == true && GFxValue1->IsString() && GFxValue1->IsManagedValueCustom()) {
		auto ch = GFxValue1->_value.mstring;
		if (ch != nullptr) {
			auto ch2 = *ch;
			if (ch2 != nullptr)
				return ch2;
		}
	}
	return "";
}

inline static std::string GetAS3VariableAsString(std::string MenuName, std::string VarPath, RE::UI* UIPassThru = nullptr)
{
    if (MenuName.empty() || VarPath.empty())
        return "";
    auto theMenu = GetMenu(MenuName, UIPassThru);
    if (!theMenu) {
        LogError("theMenu is nullptr for MenuName: " + MenuName);
        return "";
    }
    auto menuRoot = GetMenuRoot(theMenu);
    if (!menuRoot) {
        LogError("menuRoot is nullptr for IMenu at address: " + GetAddressAsHex(reinterpret_cast<uintptr_t>(theMenu)));
        return "";
    }
    RE::Scaleform::GFx::Value* GFxValue = new RE::Scaleform::GFx::Value();
    if (!GFxValue) {
        LogError("GFxValue is nullptr");
        return "";
    }
    bool bVarFound = menuRoot->GetVariable(GFxValue, VarPath.c_str());
    if (!bVarFound) {
        LogError("bVarFound is false");
        return "";
    }
    std::string sValue;
    if (GFxValue->IsString()) {
        if (GFxValue->IsManagedValueCustom()) {
            auto ch = GFxValue->_value.mstring;
            if (!ch) {
                LogError("ch is nullptr");
            }
            else {
                auto ch2 = *ch;
                if (!ch2) {
                    LogError("ch2 is nullptr");
                }
                else {
                    sValue = ch2;
                }
            }
        }
        else {
            auto ch = GFxValue->_value.string;
            if (!ch) {
                LogError("ch is nullptr");
            }
            else {
                sValue = ch;
            }
        }
    }
    else if (GFxValue->IsStringW()) {
        auto ch = GFxValue->_value.wstring;
        if (!ch) {
            LogError("ch is nullptr");
        }
        else {
            std::ostringstream os;
            while (*ch != L'\0') {
                os << std::use_facet<std::ctype<wchar_t>>(std::locale()).narrow(*ch++, 'n');
            }
            sValue = os.str();
        }
    }
    else if (GFxValue->IsBoolean()) {
        auto ch = GFxValue->_value.boolean;
        if (ch == true)
            sValue = "True";
        else
            sValue = "False";
    }
    else if (GFxValue->IsInt()) {
        auto ch = GFxValue->_value.int32;
        sValue  = std::to_string(ch);
    }
    else if (GFxValue->IsUInt()) {
        auto ch = GFxValue->_value.uint32;
        sValue  = std::to_string(ch);
    }
    else if (GFxValue->IsNumber()) {
        auto ch = GFxValue->_value.number;
        sValue  = std::to_string(ch);
    }
    if (sValue.size() > 0) {
        return sValue;
    }
    LogError("returning empty string");
    return "";
}

inline static bool InvokeAS3Function(std::string MenuName, std::string FuncPathAndName, RE::UI* UIPassThru = nullptr)
{
	if (MenuName.empty() || FuncPathAndName.empty())
		return false;
	auto menuRoot = GetMenuRoot(GetMenu(MenuName, UIPassThru));
	if (!menuRoot)
		return false;
	bool bSuccess = menuRoot->Invoke(FuncPathAndName.c_str(), nullptr, nullptr);
	return bSuccess;
}

inline static bool SetAS3Variable(std::string MenuName, std::string VarPath, std::string NewValue, RE::UI* UIPassThru = nullptr)
{

	if (MenuName.empty() || VarPath.empty())
		return "";
	auto theMenu = GetMenu(MenuName, UIPassThru);
	if (!theMenu) {
		LogError("theMenu is nullptr for MenuName: " + MenuName);
		return "";
	}
	auto menuRoot = GetMenuRoot(theMenu);
	if (!menuRoot) {
		LogError("menuRoot is nullptr for IMenu at address: " + GetAddressAsHex(reinterpret_cast<uintptr_t>(theMenu)));
		return "";
	}
	RE::Scaleform::GFx::Value* GFxValue = new RE::Scaleform::GFx::Value();
	if (!GFxValue) {
		LogError("GFxValue is nullptr");
		return false;
	}
	bool bVarFound = menuRoot->GetVariable(GFxValue, VarPath.c_str());
	if (!bVarFound) {
		LogError("bVarFound is false");
		return false;
	}

	std::string                sOutput = "";
	std::string                sValueType = "";
	int                        iVarType = 0;

	if (GFxValue->IsString()) {
		if (GFxValue->IsManagedValueCustom()) {
			sValueType = "String (managed)";
			auto ch = GFxValue->_value.mstring;
			if (!ch) {
				LogError("ch is nullptr");
			} else {
				auto ch2 = *ch;
				if (!ch2) {
					LogError("ch2 is nullptr");
				} else {
					sOutput = ch2;
					iVarType = 1;
				}
			}
		} else {
			sValueType = "String (nonmanaged)";
			auto ch = GFxValue->_value.string;
			if (!ch) {
				LogError("ch is nullptr 02");
			} else {
				sOutput = ch;
				iVarType = 2;
			}
		}
	} else if (GFxValue->IsStringW()) {
		sValueType = "Wide String";
		auto ch = GFxValue->_value.wstring;
		if (!ch) {
			LogError("ch is nullptr 03");
			sOutput = "error: value couldn't be returned";
		} else {
			std::ostringstream os;
			while (*ch != L'\0') {
				os << std::use_facet<std::ctype<wchar_t>>(std::locale()).narrow(*ch++, 'n');
			}
			sOutput = os.str();
			iVarType = 3;
		}
	} else if (GFxValue->IsBoolean()) {
		auto ch = GFxValue->_value.boolean;
		if (ch == true)
			sOutput = "True";
		else
			sOutput = "False";
		sValueType = "Boolean";
		iVarType = 4;
	} else if (GFxValue->IsInt()) {
		auto ch = GFxValue->_value.int32;
		sOutput = std::to_string(ch);
		sValueType = "Int32";
		iVarType = 5;
	} else if (GFxValue->IsUInt()) {
		auto ch = GFxValue->_value.uint32;
		sOutput = std::to_string(ch);
		sValueType = "UInt32";
		iVarType = 6;
	} else if (GFxValue->IsNumber()) {
		auto ch = GFxValue->_value.number;
		sOutput = std::to_string(ch);
		sValueType = "Number";
		iVarType = 7;
	} else {
		if (GFxValue->IsObject()) {
			sValueType = "Object";
		} else if (GFxValue->IsArray()) {
			sValueType = "Array";
		} else if (GFxValue->IsDisplayObject()) {
			sValueType = "DisplayObject";
		} else if (GFxValue->IsUndefined()) {
			sValueType = "Undefined";
		} else {
			sValueType = "Unknown";
		}
		LogWarning("type [" + sValueType + "] is not implemented for value change");
	}
	
	if (sOutput.size() == 0) {
		LogError("sOutput.size == 0");
		return false;
	}

	bool        bValueChanged = false;

	if (iVarType > 0 && iVarType <= 7) {
		bool bInvalidNewValue = false;
		if (iVarType != 1 && iVarType != 2) {
			if (!NewValue.empty()) {
				NewValue.erase(std::remove_if(NewValue.begin(), NewValue.end(), [](char c) { return std::isspace(c); }), NewValue.end());
				std::transform(NewValue.begin(), NewValue.end(), NewValue.begin(), [](unsigned char c) -> char { return static_cast<char>(::tolower(c)); });
			}			
		}		
		if (iVarType == 1 || iVarType == 2) {
			RE::Scaleform::GFx::Value* NewGFxValue = new RE::Scaleform::GFx::Value();
			menuRoot->CreateString(NewGFxValue, NewValue.c_str());
			bValueChanged = menuRoot->SetVariableArray(RE::Scaleform::GFx::Movie::SetArrayType::kValue, VarPath.c_str(), 0, NewGFxValue, 1);
		} else if (iVarType == 5) {
			int32_t iNewValue = 0;
			if (NewValue.find_first_not_of("-0123456789") != std::string::npos) {
				bInvalidNewValue = true;
			} else {
				try {
					iNewValue = static_cast<int32_t>(std::stoi(NewValue));
				} catch (...) {
					LogError("std::stoi exception thrown for NewValue: " + NewValue);
					bInvalidNewValue = true;
				}
			}
			if (bInvalidNewValue == false) {
				RE::Scaleform::GFx::Value* NewGFxValue = new RE::Scaleform::GFx::Value();
				menuRoot->CreateObject(NewGFxValue);
				NewGFxValue->operator=(iNewValue);
				bValueChanged = menuRoot->SetVariableArray(RE::Scaleform::GFx::Movie::SetArrayType::kValue, VarPath.c_str(), 0, NewGFxValue, 1);
			}
		} else if (iVarType == 6) {
			uint32_t uNewValue = 0;
			if (NewValue.find_first_not_of("0123456789") != std::string::npos) {
				bInvalidNewValue = true;
			} else {
				try {
					uNewValue = static_cast<uint32_t>(std::stoul(NewValue));
				} catch (...) {
					LogError("std::stoul exception thrown for NewValue: " + NewValue);
					bInvalidNewValue = true;
				}
			}
			if (bInvalidNewValue == false) {
				RE::Scaleform::GFx::Value* NewGFxValue = new RE::Scaleform::GFx::Value();
				menuRoot->CreateObject(NewGFxValue);
				NewGFxValue->operator=(uNewValue);
				bValueChanged = menuRoot->SetVariableArray(RE::Scaleform::GFx::Movie::SetArrayType::kValue, VarPath.c_str(), 0, NewGFxValue, 1);
			}
		} else if (iVarType == 7) {
			double fNewValue = 0.0;
			if (NewValue.find_first_not_of("-.0123456789") != std::string::npos) {
				bInvalidNewValue = true;
			} else {
				try {
					fNewValue = std::stod(NewValue);
				} catch (...) {
					LogError("std::stod exception thrown for NewValue: " + NewValue);
					bInvalidNewValue = true;
				}
			}
			if (bInvalidNewValue == false) {
				RE::Scaleform::GFx::Value* NewGFxValue = new RE::Scaleform::GFx::Value();
				menuRoot->CreateObject(NewGFxValue);
				NewGFxValue->operator=(fNewValue);
				bValueChanged = menuRoot->SetVariableArray(RE::Scaleform::GFx::Movie::SetArrayType::kValue, VarPath.c_str(), 0, NewGFxValue, 1);
			}
		} else if (iVarType == 4) {
			/*
                bool bNewValue = false;
                if ((std::strcmp(NewValue.c_str(), "true") == 0) || (std::strcmp(NewValue.c_str(), "1") == 0)) {
                    logger::info("SetAS3Variable: info: setting bNewValue to True. Provided parameter is = {}", NewValue);
                    bNewValue = true;
                }
                else if ((std::strcmp(NewValue.c_str(), "false") == 0) || (std::strcmp(NewValue.c_str(), "0") == 0)) {
                    logger::info("SetAS3Variable: info: setting bNewValue to False. Provided parameter is = {}", NewValue);
                    bNewValue = false;
                }
                else {
                    logger::error("SetAS3Variable: error: invalid parameter NewValue for bNewValue. Provided parameter is = {}", NewValue);
                    bInvalidNewValue = true;
                }
                if (bInvalidNewValue == false) {
                    RE::Scaleform::GFx::Value* NewGFxValue = new RE::Scaleform::GFx::Value();
                    menuRoot->CreateObject(NewGFxValue);
                    if (bNewValue) {
                        NewGFxValue->operator=(true);
                        bSuccess = menuRoot->SetVariableArray(RE::Scaleform::GFx::Movie::SetArrayType::kValue, VarPathAndName.c_str(), 0, NewGFxValue, 1);
                    }
                    else {
                        auto vGFxValue = reinterpret_cast<Scaleform::GFx::Value*>(GFxValue);
                        if (!vGFxValue) {
                            sChangedValue = "error occured during processing the variable";
                        }
                        else {
                            vGFxValue->SetInt(0);
                            vGFxValue->SetBoolean(false);
                            if (vGFxValue->GetBool() == false) {
                                bSuccess = true;
                            }
                            else {
                                sChangedValue = "error: value couldn't be changed";
                            }
                        }
                    }

                }
                */
		}
		if (!bValueChanged) {
			if (iVarType == 4) {
				LogError("changing bool type is currently not implemented");
			} else if (bInvalidNewValue == false) {
				LogError("value couldn't be changed");
			} else {
				LogError("parameter was invalid for this type");
			}
		}
	} else {
		LogError("iVarType is out of range");
	}
	return bValueChanged;
}

inline static void ExecuteCommand(const char* asCommand)
{
	static REL::Relocation<void**> ConsoleRTTI{ REL::ID(808335) };
	using func_t = void (*)(const void*, const char*);
	REL::Relocation<func_t> func{ REL::ID(166307) };
	func(*ConsoleRTTI, asCommand);
}

inline static bool PlayIdleAction(RE::Actor* theActor, RE::BGSAction* theAction, RE::TESObjectREFR* theTargetRef = nullptr)
{
	if (!theActor || !theAction)
		return false;
	REL::Relocation<uintptr_t> ptr{ REL::ID(170485) };  // Starfield.exe + 0x2C3B870 v1.14.70
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<BYTE (*)(uintptr_t, uint32_t, RE::Actor*, RE::BGSAction*, RE::TESObjectREFR*)>(addr);
	return func(0, 0, theActor, theAction, theTargetRef);
}

inline static bool GetIsCreatedForm(RE::TESForm* theForm)
{
    if (!theForm)
        return false;
    return (theForm->formID >> (8 * 3)) == 0xFF;
}

inline static bool GetIsCreatedHexFormID(std::string hexFormID)
{
    if (hexFormID.size() < 2)
        return false;
    if ((hexFormID.at(0) == 'F' || hexFormID.at(0) == 'f') && (hexFormID.at(1) == 'F' || hexFormID.at(1) == 'f'))
        return true;
    return false;
}

inline static std::vector<RE::TESForm*> GetInventoryItems(RE::TESObjectREFR* theRef, bool bMustBeEquipped)
{
	std::vector<RE::TESForm*> Result;
	if (!theRef)
		return Result;
	auto inventory = theRef->inventoryList.lock_read().operator->();
	if (!inventory)
		return Result;
	for (uint32_t i = 0; i < inventory->data.size(); i++) {
		for (uint32_t j = 0; j < inventory->data[i].stacks.size(); j++) {
			auto& ItemBoundObj = inventory->data[i].object;
			if (ItemBoundObj && (!bMustBeEquipped || bMustBeEquipped && inventory->data[i].IsEquipped()))
				Result.push_back(ItemBoundObj);
		}
	}
	if (Result.size() > 0) {  // same TESForm can be in the array
		std::sort(Result.begin(), Result.end());
		Result.erase(std::unique(Result.begin(), Result.end()), Result.end());
	}
	return Result;
}

inline static std::string GetBasicReferenceData(RE::TESObjectREFR* theRef, bool bFormType = false, bool bModIndex = false, bool bReferenceName = false, bool bEditorID = false)
{
	if (!theRef)
		return "!!! ERROR: nullptr form !!!";
	std::string sResult = "[" + GetAddressAsHex(reinterpret_cast<unsigned long long>(theRef)) + " | " + GetUIntFormIDAsHex(theRef->formID);
	if (bFormType) {
		auto sFormType = std::to_string(theRef->GetSavedFormType());
		if (sFormType.empty())
			sResult = sResult + " | {unknown_type}";
		else
			sResult = sResult + " | " + sFormType;
	}
	if (bModIndex) {
		std::string sModIndex = std::to_string(theRef->loadOrderIndex) + "|0x" + ToUpperStr(std::format("{:x}", theRef->loadOrderIndex));
		if (sModIndex.size() < 3)
			sResult = sResult + " | {unknown_modindex}";
		else
			sResult = sResult + " | " + sModIndex;
	}
	if (bReferenceName) {
		std::string sReferenceName = GetReferenceName(theRef);
		if (sReferenceName.empty())
			sReferenceName = GetTESFullNameNative(theRef->GetBaseObject());
		if (sReferenceName.empty())
			sResult = sResult + " | {unnamed}";
		else
			sResult = sResult + " | " + sReferenceName;
	}
	if (bEditorID) {
		std::string sEditorID = GetFormEditorID(theRef);
		if (sEditorID.empty())
			sResult = sResult + " | {no_edid}";
		else
			sResult = sResult + " | " + sEditorID;
	}
	sResult = sResult + "]";
	return sResult;
}

inline static bool AreHostileActorsNearCustom(float fDistance, RE::Actor* theActor = nullptr, std::string* hostileActorDataOut = nullptr, float* hostileActorDistanceOut = nullptr)
{
	if (fDistance <= 0.0f)
		return false;
	if (!theActor)
		theActor = RE::PlayerCharacter::GetSingleton();
	auto HighActors = GetHighActors();
	for (auto& actor : HighActors) {
		if (!actor)
			continue;
		auto distance = GetDistance(theActor, actor);
		if (distance <= fDistance && actor->IsHostileToActor(theActor)) {
			if (hostileActorDataOut)
				*hostileActorDataOut = GetBasicReferenceData(actor, false, false, true);
			if (hostileActorDistanceOut)
				*hostileActorDistanceOut = distance;
			return true;
		}
	}
	return false;
}

inline static bool CanBePlacedInContainerByFormType(int theFormType) {
	REL::Relocation<uintptr_t> ptr{ REL::ID(85994) };  // Starfield.exe + 0x151F95C v1.13.63
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<bool (*)(int)>(addr);
	return func(theFormType);
}

inline static RE::TESObjectREFR* GetReference(RE::BGSRefAlias* theRefAlias) {
	if (!theRefAlias)
		return nullptr;
	REL::Relocation<uintptr_t> ptr{ REL::ID(170713) };  // Starfield.exe + 0x2BABD10 v1.13.63
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<RE::TESObjectREFR* (*)(uintptr_t, uintptr_t, RE::BGSRefAlias*)>(addr);
	return func(0, 0, theRefAlias);
}

inline static RE::TESObjectREFR* GetPlayerHomeshipPilotSeatRef(RE::TESQuest* SQ_PlayerShip = nullptr)
{  // SQ_PlayerShip "Aliases for the Player's Current Ship" [QUST:000174A2]
	if (!SQ_PlayerShip)
		SQ_PlayerShip = (RE::TESQuest*)RE::TESForm::LookupByID(0x000174A2);
	if (!SQ_PlayerShip) {
	//	LogError("SQ_PlayerShip is nullptr");
		return nullptr;
	}
	//LogInfo("SQ_PlayerShip is " + GetBasicFormData(SQ_PlayerShip));
	auto aliases = GetAsBSTArrayCustom(&SQ_PlayerShip->aliases);
	if (!aliases)
		return nullptr;
	//LogInfo("starting loop : size = " + std::to_string(aliases->size()));
	for (auto& i : *aliases) {
		auto alias = reinterpret_cast<RE::BGSBaseAlias*>(i);
	//	LogInfo("processing alias " + GetObjectAddressAsHex(alias));
		if (!alias || alias->aliasIndex != 3)  // RefAlias PlayerShipPilotSeat
			continue;
	//	LogInfo("calling GetReference for alias " + GetObjectAddressAsHex(alias));
		return GetReference((RE::BGSRefAlias*)alias);
	}
	//LogInfo("finished loop : size = " + std::to_string(aliases->size()));
	return nullptr;
}

inline static RE::BSFaceGenAnimationData* GetFaceGenAnimData(RE::Actor* theActor)
{
	if (!theActor)
		return nullptr;
	RE::BSFaceGenAnimationData* faceAnimNode = nullptr;
	try {
		auto currentProcess = theActor->currentProcess;
		if (!currentProcess)
			return nullptr;
		auto highProcess = currentProcess->middleHigh;
		if (!highProcess)
			return nullptr;
		auto faceDB = highProcess->faceDB;
		if (!faceDB)
			return nullptr;
		auto faceGenNode = faceDB->faceGenNode;
		if (!faceGenNode)
			return nullptr;
		faceAnimNode = faceGenNode->faceAnimNode;
		if (!faceAnimNode)
			return nullptr;
	} catch (...) {
		return nullptr;
	}
	return faceAnimNode;
}

inline static bool GetMorphMap(RE::Actor* theActor, std::vector<std::pair<std::string, float>>* resultOut)
{
	std::vector<std::pair<std::string, float>> Result;
	if (!theActor)
		return false;
	if (!resultOut)
		return false;
	RE::BSFaceGenAnimationData* faceAnimNode = GetFaceGenAnimData(theActor);
	if (!faceAnimNode)
		return false;
	Result.push_back(std::make_pair("browLowererL", faceAnimNode->browLowererL));
	Result.push_back(std::make_pair("browLowererR", faceAnimNode->browLowererR));
	Result.push_back(std::make_pair("cheekPuffL", faceAnimNode->cheekPuffL));
	Result.push_back(std::make_pair("cheekPuffR", faceAnimNode->cheekPuffR));
	Result.push_back(std::make_pair("cheekRaiseL", faceAnimNode->cheekRaiseL));
	Result.push_back(std::make_pair("cheekRaiseR", faceAnimNode->cheekRaiseR));
	Result.push_back(std::make_pair("cheekSuckL", faceAnimNode->cheekSuckL));
	Result.push_back(std::make_pair("cheekSuckR", faceAnimNode->cheekSuckR));
	Result.push_back(std::make_pair("chinRaise", faceAnimNode->chinRaise));
	Result.push_back(std::make_pair("chinRaiseUpperlipTweak", faceAnimNode->chinRaiseUpperlipTweak));
	Result.push_back(std::make_pair("c_eyeDown_eyeClosedL", faceAnimNode->c_eyeDown_eyeClosedL));
	Result.push_back(std::make_pair("c_eyeDown_eyeClosedR", faceAnimNode->c_eyeDown_eyeClosedR));
	Result.push_back(std::make_pair("c_eyeLeft_eyeClosedL", faceAnimNode->c_eyeLeft_eyeClosedL));
	Result.push_back(std::make_pair("c_eyeLeft_eyeClosedR", faceAnimNode->c_eyeLeft_eyeClosedR));
	Result.push_back(std::make_pair("c_eyeRight_eyeClosedL", faceAnimNode->c_eyeRight_eyeClosedL));
	Result.push_back(std::make_pair("c_eyeRight_eyeClosedR", faceAnimNode->c_eyeRight_eyeClosedR));
	Result.push_back(std::make_pair("c_eyeUp_eyeClosedL", faceAnimNode->c_eyeUp_eyeClosedL));
	Result.push_back(std::make_pair("c_eyeUp_eyeClosedR", faceAnimNode->c_eyeUp_eyeClosedR));
	Result.push_back(std::make_pair("c_eyesClosed50L", faceAnimNode->c_eyesClosed50L));
	Result.push_back(std::make_pair("c_eyesClosed50R", faceAnimNode->c_eyesClosed50R));
	Result.push_back(std::make_pair("c_JawDrop", faceAnimNode->c_JawDrop));
	Result.push_back(std::make_pair("c_squintL_cheekRaiserL", faceAnimNode->c_squintL_cheekRaiserL));
	Result.push_back(std::make_pair("c_squintR_cheekRaiserR", faceAnimNode->c_squintR_cheekRaiserR));
	Result.push_back(std::make_pair("dimplerL", faceAnimNode->dimplerL));
	Result.push_back(std::make_pair("dimplerR", faceAnimNode->dimplerR));
	Result.push_back(std::make_pair("eyeClosedL", faceAnimNode->eyeClosedL));
	Result.push_back(std::make_pair("eyeClosedR", faceAnimNode->eyeClosedR));
	Result.push_back(std::make_pair("eyeDown", faceAnimNode->eyeDown));
	Result.push_back(std::make_pair("eyeLeft", faceAnimNode->eyeLeft));
	Result.push_back(std::make_pair("eyeOpenL", faceAnimNode->eyeOpenL));
	Result.push_back(std::make_pair("eyeOpenR", faceAnimNode->eyeOpenR));
	Result.push_back(std::make_pair("eyeRight", faceAnimNode->eyeRight));
	Result.push_back(std::make_pair("eyeUp", faceAnimNode->eyeUp));
	Result.push_back(std::make_pair("innerBrowRaiseL", faceAnimNode->innerBrowRaiseL));
	Result.push_back(std::make_pair("innerBrowRaiseR", faceAnimNode->innerBrowRaiseR));
	Result.push_back(std::make_pair("jawClench", faceAnimNode->jawClench));
	Result.push_back(std::make_pair("jawLeft", faceAnimNode->jawLeft));
	Result.push_back(std::make_pair("jawOpen", faceAnimNode->jawOpen));
	Result.push_back(std::make_pair("jawRight", faceAnimNode->jawRight));
	Result.push_back(std::make_pair("jawThrust", faceAnimNode->jawThrust));
	Result.push_back(std::make_pair("lidTightenerL", faceAnimNode->lidTightenerL));
	Result.push_back(std::make_pair("lifTightenerR", faceAnimNode->lifTightenerR));
	Result.push_back(std::make_pair("lipCornerDepressL", faceAnimNode->lipCornerDepressL));
	Result.push_back(std::make_pair("lipCornerDepressR", faceAnimNode->lipCornerDepressR));
	Result.push_back(std::make_pair("lipCornerInL", faceAnimNode->lipCornerInL));
	Result.push_back(std::make_pair("lipCornerInR", faceAnimNode->lipCornerInR));
	Result.push_back(std::make_pair("lipCornerPullL", faceAnimNode->lipCornerPullL));
	Result.push_back(std::make_pair("lipCornerPullR", faceAnimNode->lipCornerPullR));
	Result.push_back(std::make_pair("lipPress", faceAnimNode->lipPress));
	Result.push_back(std::make_pair("lipPucker", faceAnimNode->lipPucker));
	Result.push_back(std::make_pair("lipStretchL", faceAnimNode->lipStretchL));
	Result.push_back(std::make_pair("lipStretchR", faceAnimNode->lipStretchR));
	Result.push_back(std::make_pair("lipTighten", faceAnimNode->lipTighten));
	Result.push_back(std::make_pair("lipZipperL", faceAnimNode->lipZipperL));
	Result.push_back(std::make_pair("lipZipperR", faceAnimNode->lipZipperR));
	Result.push_back(std::make_pair("lowerLipDepressL", faceAnimNode->lowerLipDepressL));
	Result.push_back(std::make_pair("lowerLipDepressR", faceAnimNode->lowerLipDepressR));
	Result.push_back(std::make_pair("lowerLipFunnel", faceAnimNode->lowerLipFunnel));
	Result.push_back(std::make_pair("lowerLipPuff", faceAnimNode->lowerLipPuff));
	Result.push_back(std::make_pair("lowerLipSuck", faceAnimNode->lowerLipSuck));
	Result.push_back(std::make_pair("lowerLipThickness", faceAnimNode->lowerLipThickness));
	Result.push_back(std::make_pair("lowerLipUpL", faceAnimNode->lowerLipUpL));
	Result.push_back(std::make_pair("lowerLipUpR", faceAnimNode->lowerLipUpR));
	Result.push_back(std::make_pair("nasolabialFurrowL", faceAnimNode->nasolabialFurrowL));
	Result.push_back(std::make_pair("nasolabialFurrowR", faceAnimNode->nasolabialFurrowR));
	Result.push_back(std::make_pair("neckFlexL", faceAnimNode->neckFlexL));
	Result.push_back(std::make_pair("neckFlexR", faceAnimNode->neckFlexR));
	Result.push_back(std::make_pair("noseDepressor", faceAnimNode->noseDepressor));
	Result.push_back(std::make_pair("noseWrinkleL", faceAnimNode->noseWrinkleL));
	Result.push_back(std::make_pair("noseWrinkleR", faceAnimNode->noseWrinkleR));
	Result.push_back(std::make_pair("nostrilCompressor", faceAnimNode->nostrilCompressor));
	Result.push_back(std::make_pair("nostrilDilator", faceAnimNode->nostrilDilator));
	Result.push_back(std::make_pair("outerBrowRaiseL", faceAnimNode->outerBrowRaiseL));
	Result.push_back(std::make_pair("outerBrowRaiseR", faceAnimNode->outerBrowRaiseR));
	Result.push_back(std::make_pair("sharpLipPullL", faceAnimNode->sharpLipPullL));
	Result.push_back(std::make_pair("sharpLipPullR", faceAnimNode->sharpLipPullR));
	Result.push_back(std::make_pair("squintL", faceAnimNode->squintL));
	Result.push_back(std::make_pair("squintR", faceAnimNode->squintR));
	Result.push_back(std::make_pair("swallow", faceAnimNode->swallow));
	Result.push_back(std::make_pair("upperLipDownL", faceAnimNode->upperLipDownL));
	Result.push_back(std::make_pair("upperLipDownR", faceAnimNode->upperLipDownR));
	Result.push_back(std::make_pair("upperLipFunnel", faceAnimNode->upperLipFunnel));
	Result.push_back(std::make_pair("upperLipPuff", faceAnimNode->upperLipPuff));
	Result.push_back(std::make_pair("upperLipRaiseL", faceAnimNode->upperLipRaiseL));
	Result.push_back(std::make_pair("upperLipRaiseR", faceAnimNode->upperLipRaiseR));
	Result.push_back(std::make_pair("upperLipSuck", faceAnimNode->upperLipSuck));
	Result.push_back(std::make_pair("upperLipThickness", faceAnimNode->upperLipThickness));
	Result.push_back(std::make_pair("tongueCurlDown", faceAnimNode->tongueCurlDown));
	Result.push_back(std::make_pair("tongueCurlUp", faceAnimNode->tongueCurlUp));
	Result.push_back(std::make_pair("tongueDown", faceAnimNode->tongueDown));
	Result.push_back(std::make_pair("tongueUp", faceAnimNode->tongueUp));
	Result.push_back(std::make_pair("tongueIn", faceAnimNode->tongueIn));
	Result.push_back(std::make_pair("tongueOut", faceAnimNode->tongueOut));
	Result.push_back(std::make_pair("tongueLeft", faceAnimNode->tongueLeft));
	Result.push_back(std::make_pair("tongueRight", faceAnimNode->tongueRight));
	Result.push_back(std::make_pair("tongueThick", faceAnimNode->tongueThick));
	Result.push_back(std::make_pair("tongueThinner", faceAnimNode->tongueThinner));
	Result.push_back(std::make_pair("LookDown", faceAnimNode->LookDown));
	Result.push_back(std::make_pair("LookUp", faceAnimNode->LookUp));
	Result.push_back(std::make_pair("LookRight", faceAnimNode->LookRight));
	Result.push_back(std::make_pair("LookLeft", faceAnimNode->LookLeft));
	*resultOut = Result;
	return true;
}

inline static bool GetFacialExpressionDataAsMorphMap(RE::BGSFacialExpressionData* theFacialExpression, std::vector<std::pair<std::string, float>>* resultOut)
{
	std::vector<std::pair<std::string, float>> Result;
	if (!theFacialExpression)
		return false;
	Result.push_back(std::make_pair("browLowererL", theFacialExpression->browLowererL));
	Result.push_back(std::make_pair("browLowererR", theFacialExpression->browLowererR));
	Result.push_back(std::make_pair("cheekPuffL", theFacialExpression->cheekPuffL));
	Result.push_back(std::make_pair("cheekPuffR", theFacialExpression->cheekPuffR));
	Result.push_back(std::make_pair("cheekRaiseL", theFacialExpression->cheekRaiseL));
	Result.push_back(std::make_pair("cheekRaiseR", theFacialExpression->cheekRaiseR));
	Result.push_back(std::make_pair("cheekSuckL", theFacialExpression->cheekSuckL));
	Result.push_back(std::make_pair("cheekSuckR", theFacialExpression->cheekSuckR));
	Result.push_back(std::make_pair("chinRaise", theFacialExpression->chinRaise));
	Result.push_back(std::make_pair("chinRaiseUpperlipTweak", theFacialExpression->chinRaiseUpperlipTweak));
	Result.push_back(std::make_pair("c_eyeDown_eyeClosedL", theFacialExpression->c_eyeDown_eyeClosedL));
	Result.push_back(std::make_pair("c_eyeDown_eyeClosedR", theFacialExpression->c_eyeDown_eyeClosedR));
	Result.push_back(std::make_pair("c_eyeLeft_eyeClosedL", theFacialExpression->c_eyeLeft_eyeClosedL));
	Result.push_back(std::make_pair("c_eyeLeft_eyeClosedR", theFacialExpression->c_eyeLeft_eyeClosedR));
	Result.push_back(std::make_pair("c_eyeRight_eyeClosedL", theFacialExpression->c_eyeRight_eyeClosedL));
	Result.push_back(std::make_pair("c_eyeRight_eyeClosedR", theFacialExpression->c_eyeRight_eyeClosedR));
	Result.push_back(std::make_pair("c_eyeUp_eyeClosedL", theFacialExpression->c_eyeUp_eyeClosedL));
	Result.push_back(std::make_pair("c_eyeUp_eyeClosedR", theFacialExpression->c_eyeUp_eyeClosedR));
	Result.push_back(std::make_pair("c_eyesClosed50L", theFacialExpression->c_eyesClosed50L));
	Result.push_back(std::make_pair("c_eyesClosed50R", theFacialExpression->c_eyesClosed50R));
	Result.push_back(std::make_pair("c_JawDrop", theFacialExpression->c_JawDrop));
	Result.push_back(std::make_pair("c_squintL_cheekRaiserL", theFacialExpression->c_squintL_cheekRaiserL));
	Result.push_back(std::make_pair("c_squintR_cheekRaiserR", theFacialExpression->c_squintR_cheekRaiserR));
	Result.push_back(std::make_pair("dimplerL", theFacialExpression->dimplerL));
	Result.push_back(std::make_pair("dimplerR", theFacialExpression->dimplerR));
	Result.push_back(std::make_pair("eyeClosedL", theFacialExpression->eyeClosedL));
	Result.push_back(std::make_pair("eyeClosedR", theFacialExpression->eyeClosedR));
	Result.push_back(std::make_pair("eyeDown", theFacialExpression->eyeDown));
	Result.push_back(std::make_pair("eyeLeft", theFacialExpression->eyeLeft));
	Result.push_back(std::make_pair("eyeOpenL", theFacialExpression->eyeOpenL));
	Result.push_back(std::make_pair("eyeOpenR", theFacialExpression->eyeOpenR));
	Result.push_back(std::make_pair("eyeRight", theFacialExpression->eyeRight));
	Result.push_back(std::make_pair("eyeUp", theFacialExpression->eyeUp));
	Result.push_back(std::make_pair("innerBrowRaiseL", theFacialExpression->innerBrowRaiseL));
	Result.push_back(std::make_pair("innerBrowRaiseR", theFacialExpression->innerBrowRaiseR));
	Result.push_back(std::make_pair("jawClench", theFacialExpression->jawClench));
	Result.push_back(std::make_pair("jawLeft", theFacialExpression->jawLeft));
	Result.push_back(std::make_pair("jawOpen", theFacialExpression->jawOpen));
	Result.push_back(std::make_pair("jawRight", theFacialExpression->jawRight));
	Result.push_back(std::make_pair("jawThrust", theFacialExpression->jawThrust));
	Result.push_back(std::make_pair("lidTightenerL", theFacialExpression->lidTightenerL));
	Result.push_back(std::make_pair("lifTightenerR", theFacialExpression->lifTightenerR));
	Result.push_back(std::make_pair("lipCornerDepressL", theFacialExpression->lipCornerDepressL));
	Result.push_back(std::make_pair("lipCornerDepressR", theFacialExpression->lipCornerDepressR));
	Result.push_back(std::make_pair("lipCornerInL", theFacialExpression->lipCornerInL));
	Result.push_back(std::make_pair("lipCornerInR", theFacialExpression->lipCornerInR));
	Result.push_back(std::make_pair("lipCornerPullL", theFacialExpression->lipCornerPullL));
	Result.push_back(std::make_pair("lipCornerPullR", theFacialExpression->lipCornerPullR));
	Result.push_back(std::make_pair("lipPress", theFacialExpression->lipPress));
	Result.push_back(std::make_pair("lipPucker", theFacialExpression->lipPucker));
	Result.push_back(std::make_pair("lipStretchL", theFacialExpression->lipStretchL));
	Result.push_back(std::make_pair("lipStretchR", theFacialExpression->lipStretchR));
	Result.push_back(std::make_pair("lipTighten", theFacialExpression->lipTighten));
	Result.push_back(std::make_pair("lipZipperL", theFacialExpression->lipZipperL));
	Result.push_back(std::make_pair("lipZipperR", theFacialExpression->lipZipperR));
	Result.push_back(std::make_pair("lowerLipDepressL", theFacialExpression->lowerLipDepressL));
	Result.push_back(std::make_pair("lowerLipDepressR", theFacialExpression->lowerLipDepressR));
	Result.push_back(std::make_pair("lowerLipFunnel", theFacialExpression->lowerLipFunnel));
	Result.push_back(std::make_pair("lowerLipPuff", theFacialExpression->lowerLipPuff));
	Result.push_back(std::make_pair("lowerLipSuck", theFacialExpression->lowerLipSuck));
	Result.push_back(std::make_pair("lowerLipThickness", theFacialExpression->lowerLipThickness));
	Result.push_back(std::make_pair("lowerLipUpL", theFacialExpression->lowerLipUpL));
	Result.push_back(std::make_pair("lowerLipUpR", theFacialExpression->lowerLipUpR));
	Result.push_back(std::make_pair("nasolabialFurrowL", theFacialExpression->nasolabialFurrowL));
	Result.push_back(std::make_pair("nasolabialFurrowR", theFacialExpression->nasolabialFurrowR));
	Result.push_back(std::make_pair("neckFlexL", theFacialExpression->neckFlexL));
	Result.push_back(std::make_pair("neckFlexR", theFacialExpression->neckFlexR));
	Result.push_back(std::make_pair("noseDepressor", theFacialExpression->noseDepressor));
	Result.push_back(std::make_pair("noseWrinkleL", theFacialExpression->noseWrinkleL));
	Result.push_back(std::make_pair("noseWrinkleR", theFacialExpression->noseWrinkleR));
	Result.push_back(std::make_pair("nostrilCompressor", theFacialExpression->nostrilCompressor));
	Result.push_back(std::make_pair("nostrilDilator", theFacialExpression->nostrilDilator));
	Result.push_back(std::make_pair("outerBrowRaiseL", theFacialExpression->outerBrowRaiseL));
	Result.push_back(std::make_pair("outerBrowRaiseR", theFacialExpression->outerBrowRaiseR));
	Result.push_back(std::make_pair("sharpLipPullL", theFacialExpression->sharpLipPullL));
	Result.push_back(std::make_pair("sharpLipPullR", theFacialExpression->sharpLipPullR));
	Result.push_back(std::make_pair("squintL", theFacialExpression->squintL));
	Result.push_back(std::make_pair("squintR", theFacialExpression->squintR));
	Result.push_back(std::make_pair("swallow", theFacialExpression->swallow));
	Result.push_back(std::make_pair("upperLipDownL", theFacialExpression->upperLipDownL));
	Result.push_back(std::make_pair("upperLipDownR", theFacialExpression->upperLipDownR));
	Result.push_back(std::make_pair("upperLipFunnel", theFacialExpression->upperLipFunnel));
	Result.push_back(std::make_pair("upperLipPuff", theFacialExpression->upperLipPuff));
	Result.push_back(std::make_pair("upperLipRaiseL", theFacialExpression->upperLipRaiseL));
	Result.push_back(std::make_pair("upperLipRaiseR", theFacialExpression->upperLipRaiseR));
	Result.push_back(std::make_pair("upperLipSuck", theFacialExpression->upperLipSuck));
	Result.push_back(std::make_pair("upperLipThickness", theFacialExpression->upperLipThickness));
	Result.push_back(std::make_pair("tongueCurlDown", theFacialExpression->tongueCurlDown));
	Result.push_back(std::make_pair("tongueCurlUp", theFacialExpression->tongueCurlUp));
	Result.push_back(std::make_pair("tongueDown", theFacialExpression->tongueDown));
	Result.push_back(std::make_pair("tongueUp", theFacialExpression->tongueUp));
	Result.push_back(std::make_pair("tongueIn", theFacialExpression->tongueIn));
	Result.push_back(std::make_pair("tongueOut", theFacialExpression->tongueOut));
	Result.push_back(std::make_pair("tongueLeft", theFacialExpression->tongueLeft));
	Result.push_back(std::make_pair("tongueRight", theFacialExpression->tongueRight));
	Result.push_back(std::make_pair("tongueThick", theFacialExpression->tongueThick));
	Result.push_back(std::make_pair("tongueThinner", theFacialExpression->tongueThinner));
	Result.push_back(std::make_pair("LookDown", theFacialExpression->LookDown));
	Result.push_back(std::make_pair("LookUp", theFacialExpression->LookUp));
	Result.push_back(std::make_pair("LookRight", theFacialExpression->LookRight));
	Result.push_back(std::make_pair("LookLeft", theFacialExpression->LookLeft));
	*resultOut = Result;
	return true;
}



inline static bool ExportMorphMap(RE::Actor* theActor)
{
	if (!theActor)
		return false;
	std::vector<std::pair<std::string, float>> morphMap;
	auto                                       bHasMorphMap = GetMorphMap(theActor, &morphMap);
	if (!bHasMorphMap)
		return false;
	if (morphMap.size() == 0)
		return false;
	std::string   fileName = "MorphMap_" + GetFormIDAsHex(theActor) + "_" + GetCurrentTimeAndDate(true) + ".txt";
	std::ofstream log(fileName, std::ios_base::app | std::ios_base::out);
	if (!log.is_open()) {
		LogError("std::ofstream error: !log.is_open()");
		return false;
	}
	if (log.fail()) {
		LogError("std::ofstream error: log.fail()");
		return false;
	}
	if (log.bad()) {
		LogError("std::ofstream error: log.bad()");
		return false;
	}
	std::string sBegin = "Morph Map   --->   '" + GetReferenceName(theActor) + "'  (" + GetFormIDAsHex(theActor) + ")";
	log << sBegin + "\n";
	int iCounter = 0;
	for (auto& it : morphMap) {
		log << "(" + std::to_string(iCounter) + ")   " + it.first + " = " + std::to_string(it.second) + "\n";
		iCounter = iCounter + 1;
	}
	log.close();
	return true;
}

inline static float GetMorphValue(RE::Actor* theActor, std::string morphName)
{
	if (!theActor || morphName.empty())
		return -1.00f;
	RE::BSFaceGenAnimationData* faceAnimNode = GetFaceGenAnimData(theActor);
	if (!faceAnimNode)
		return -1.00f;
	morphName = ToLowerStr(morphName);
	if (std::strcmp("browlowererl", morphName.c_str()) == 0)
		return faceAnimNode->browLowererL;
	if (std::strcmp("browlowererr", morphName.c_str()) == 0)
		return faceAnimNode->browLowererR;
	if (std::strcmp("cheekpuffl", morphName.c_str()) == 0)
		return faceAnimNode->cheekPuffL;
	if (std::strcmp("cheekpuffr", morphName.c_str()) == 0)
		return faceAnimNode->cheekPuffR;
	if (std::strcmp("cheekraisel", morphName.c_str()) == 0)
		return faceAnimNode->cheekRaiseL;
	if (std::strcmp("cheekraiser", morphName.c_str()) == 0)
		return faceAnimNode->cheekRaiseR;
	if (std::strcmp("cheeksuckl", morphName.c_str()) == 0)
		return faceAnimNode->cheekSuckL;
	if (std::strcmp("cheeksuckr", morphName.c_str()) == 0)
		return faceAnimNode->cheekSuckR;
	if (std::strcmp("chinraise", morphName.c_str()) == 0)
		return faceAnimNode->chinRaise;
	if (std::strcmp("chinraiseupperliptweak", morphName.c_str()) == 0)
		return faceAnimNode->chinRaiseUpperlipTweak;
	if (std::strcmp("c_eyedown_eyeclosedl", morphName.c_str()) == 0)
		return faceAnimNode->c_eyeDown_eyeClosedL;
	if (std::strcmp("c_eyedown_eyeclosedr", morphName.c_str()) == 0)
		return faceAnimNode->c_eyeDown_eyeClosedR;
	if (std::strcmp("c_eyeleft_eyeclosedl", morphName.c_str()) == 0)
		return faceAnimNode->c_eyeLeft_eyeClosedL;
	if (std::strcmp("c_eyeleft_eyeclosedr", morphName.c_str()) == 0)
		return faceAnimNode->c_eyeLeft_eyeClosedR;
	if (std::strcmp("c_eyeright_eyeclosedl", morphName.c_str()) == 0)
		return faceAnimNode->c_eyeRight_eyeClosedL;
	if (std::strcmp("c_eyeright_eyeclosedr", morphName.c_str()) == 0)
		return faceAnimNode->c_eyeRight_eyeClosedR;
	if (std::strcmp("c_eyeup_eyeclosedl", morphName.c_str()) == 0)
		return faceAnimNode->c_eyeUp_eyeClosedL;
	if (std::strcmp("c_eyeup_eyeclosedr", morphName.c_str()) == 0)
		return faceAnimNode->c_eyeUp_eyeClosedR;
	if (std::strcmp("c_eyesclosed50l", morphName.c_str()) == 0)
		return faceAnimNode->c_eyesClosed50L;
	if (std::strcmp("c_eyesclosed50r", morphName.c_str()) == 0)
		return faceAnimNode->c_eyesClosed50R;
	if (std::strcmp("c_jawdrop", morphName.c_str()) == 0)
		return faceAnimNode->c_JawDrop;
	if (std::strcmp("c_squintl_cheekraiserl", morphName.c_str()) == 0)
		return faceAnimNode->c_squintL_cheekRaiserL;
	if (std::strcmp("c_squintr_cheekraiserr", morphName.c_str()) == 0)
		return faceAnimNode->c_squintR_cheekRaiserR;
	if (std::strcmp("dimplerl", morphName.c_str()) == 0)
		return faceAnimNode->dimplerL;
	if (std::strcmp("dimplerr", morphName.c_str()) == 0)
		return faceAnimNode->dimplerR;
	if (std::strcmp("eyeclosedl", morphName.c_str()) == 0)
		return faceAnimNode->eyeClosedL;
	if (std::strcmp("eyeclosedr", morphName.c_str()) == 0)
		return faceAnimNode->eyeClosedR;
	if (std::strcmp("eyedown", morphName.c_str()) == 0)
		return faceAnimNode->eyeDown;
	if (std::strcmp("eyeleft", morphName.c_str()) == 0)
		return faceAnimNode->eyeLeft;
	if (std::strcmp("eyeopenl", morphName.c_str()) == 0)
		return faceAnimNode->eyeOpenL;
	if (std::strcmp("eyeopenr", morphName.c_str()) == 0)
		return faceAnimNode->eyeOpenR;
	if (std::strcmp("eyeright", morphName.c_str()) == 0)
		return faceAnimNode->eyeRight;
	if (std::strcmp("eyeup", morphName.c_str()) == 0)
		return faceAnimNode->eyeUp;
	if (std::strcmp("innerbrowraisel", morphName.c_str()) == 0)
		return faceAnimNode->innerBrowRaiseL;
	if (std::strcmp("innerbrowraiser", morphName.c_str()) == 0)
		return faceAnimNode->innerBrowRaiseR;
	if (std::strcmp("jawclench", morphName.c_str()) == 0)
		return faceAnimNode->jawClench;
	if (std::strcmp("jawleft", morphName.c_str()) == 0)
		return faceAnimNode->jawLeft;
	if (std::strcmp("jawopen", morphName.c_str()) == 0)
		return faceAnimNode->jawOpen;
	if (std::strcmp("jawright", morphName.c_str()) == 0)
		return faceAnimNode->jawRight;
	if (std::strcmp("jawthrust", morphName.c_str()) == 0)
		return faceAnimNode->jawThrust;
	if (std::strcmp("lidtightenerl", morphName.c_str()) == 0)
		return faceAnimNode->lidTightenerL;
	if (std::strcmp("lipcornerdepressl", morphName.c_str()) == 0)
		return faceAnimNode->lipCornerDepressL;
	if (std::strcmp("lipcornerdepressr", morphName.c_str()) == 0)
		return faceAnimNode->lipCornerDepressR;
	if (std::strcmp("lipcornerinl", morphName.c_str()) == 0)
		return faceAnimNode->lipCornerInL;
	if (std::strcmp("lipcornerinr", morphName.c_str()) == 0)
		return faceAnimNode->lipCornerInR;
	if (std::strcmp("lipcornerpulll", morphName.c_str()) == 0)
		return faceAnimNode->lipCornerPullL;
	if (std::strcmp("lipcornerpullr", morphName.c_str()) == 0)
		return faceAnimNode->lipCornerPullR;
	if (std::strcmp("lippress", morphName.c_str()) == 0)
		return faceAnimNode->lipPress;
	if (std::strcmp("lippucker", morphName.c_str()) == 0)
		return faceAnimNode->lipPucker;
	if (std::strcmp("lipstretchl", morphName.c_str()) == 0)
		return faceAnimNode->lipStretchL;
	if (std::strcmp("lipstretchr", morphName.c_str()) == 0)
		return faceAnimNode->lipStretchR;
	if (std::strcmp("liptighten", morphName.c_str()) == 0)
		return faceAnimNode->lipTighten;
	if (std::strcmp("lipzipperl", morphName.c_str()) == 0)
		return faceAnimNode->lipZipperL;
	if (std::strcmp("lipzipperr", morphName.c_str()) == 0)
		return faceAnimNode->lipZipperR;
	if (std::strcmp("lowerlipdepressl", morphName.c_str()) == 0)
		return faceAnimNode->lowerLipDepressL;
	if (std::strcmp("lowerlipdepressr", morphName.c_str()) == 0)
		return faceAnimNode->lowerLipDepressR;
	if (std::strcmp("lowerlipfunnel", morphName.c_str()) == 0)
		return faceAnimNode->lowerLipFunnel;
	if (std::strcmp("lowerlippuff", morphName.c_str()) == 0)
		return faceAnimNode->lowerLipPuff;
	if (std::strcmp("lowerlipsuck", morphName.c_str()) == 0)
		return faceAnimNode->lowerLipSuck;
	if (std::strcmp("lowerlipthickness", morphName.c_str()) == 0)
		return faceAnimNode->lowerLipThickness;
	if (std::strcmp("lowerlipupl", morphName.c_str()) == 0)
		return faceAnimNode->lowerLipUpL;
	if (std::strcmp("lowerlipupr", morphName.c_str()) == 0)
		return faceAnimNode->lowerLipUpR;
	if (std::strcmp("nasolabialfurrowl", morphName.c_str()) == 0)
		return faceAnimNode->nasolabialFurrowL;
	if (std::strcmp("nasolabialfurrowr", morphName.c_str()) == 0)
		return faceAnimNode->nasolabialFurrowR;
	if (std::strcmp("neckflexl", morphName.c_str()) == 0)
		return faceAnimNode->neckFlexL;
	if (std::strcmp("neckflexr", morphName.c_str()) == 0)
		return faceAnimNode->neckFlexR;
	if (std::strcmp("nosedepressor", morphName.c_str()) == 0)
		return faceAnimNode->noseDepressor;
	if (std::strcmp("nosewrinklel", morphName.c_str()) == 0)
		return faceAnimNode->noseWrinkleL;
	if (std::strcmp("nosewrinkler", morphName.c_str()) == 0)
		return faceAnimNode->noseWrinkleR;
	if (std::strcmp("nostrilcompressor", morphName.c_str()) == 0)
		return faceAnimNode->nostrilCompressor;
	if (std::strcmp("nostrildilator", morphName.c_str()) == 0)
		return faceAnimNode->nostrilDilator;
	if (std::strcmp("outerbrowraisel", morphName.c_str()) == 0)
		return faceAnimNode->outerBrowRaiseL;
	if (std::strcmp("outerbrowraiser", morphName.c_str()) == 0)
		return faceAnimNode->outerBrowRaiseR;
	if (std::strcmp("sharplippulll", morphName.c_str()) == 0)
		return faceAnimNode->sharpLipPullL;
	if (std::strcmp("sharplippullr", morphName.c_str()) == 0)
		return faceAnimNode->sharpLipPullR;
	if (std::strcmp("squintl", morphName.c_str()) == 0)
		return faceAnimNode->squintL;
	if (std::strcmp("squintr", morphName.c_str()) == 0)
		return faceAnimNode->squintR;
	if (std::strcmp("swallow", morphName.c_str()) == 0)
		return faceAnimNode->swallow;
	if (std::strcmp("upperlipdownl", morphName.c_str()) == 0)
		return faceAnimNode->upperLipDownL;
	if (std::strcmp("upperlipdownr", morphName.c_str()) == 0)
		return faceAnimNode->upperLipDownR;
	if (std::strcmp("upperlipfunnel", morphName.c_str()) == 0)
		return faceAnimNode->upperLipFunnel;
	if (std::strcmp("upperlippuff", morphName.c_str()) == 0)
		return faceAnimNode->upperLipPuff;
	if (std::strcmp("upperlipraisel", morphName.c_str()) == 0)
		return faceAnimNode->upperLipRaiseL;
	if (std::strcmp("upperlipraiser", morphName.c_str()) == 0)
		return faceAnimNode->upperLipRaiseR;
	if (std::strcmp("upperlipsuck", morphName.c_str()) == 0)
		return faceAnimNode->upperLipSuck;
	if (std::strcmp("upperlipthickness", morphName.c_str()) == 0)
		return faceAnimNode->upperLipThickness;
	if (std::strcmp("tonguecurldown", morphName.c_str()) == 0)
		return faceAnimNode->tongueCurlDown;
	if (std::strcmp("tonguecurlup", morphName.c_str()) == 0)
		return faceAnimNode->tongueCurlUp;
	if (std::strcmp("tonguedown", morphName.c_str()) == 0)
		return faceAnimNode->tongueDown;
	if (std::strcmp("tongueup", morphName.c_str()) == 0)
		return faceAnimNode->tongueUp;
	if (std::strcmp("tonguein", morphName.c_str()) == 0)
		return faceAnimNode->tongueIn;
	if (std::strcmp("tongueout", morphName.c_str()) == 0)
		return faceAnimNode->tongueOut;
	if (std::strcmp("tongueleft", morphName.c_str()) == 0)
		return faceAnimNode->tongueLeft;
	if (std::strcmp("tongueright", morphName.c_str()) == 0)
		return faceAnimNode->tongueRight;
	if (std::strcmp("tonguethick", morphName.c_str()) == 0)
		return faceAnimNode->tongueThick;
	if (std::strcmp("tonguethinner", morphName.c_str()) == 0)
		return faceAnimNode->tongueThinner;
	if (std::strcmp("lookdown", morphName.c_str()) == 0)
		return faceAnimNode->LookDown;
	if (std::strcmp("lookup", morphName.c_str()) == 0)
		return faceAnimNode->LookUp;
	if (std::strcmp("lookright", morphName.c_str()) == 0)
		return faceAnimNode->LookRight;
	if (std::strcmp("lookleft", morphName.c_str()) == 0)
		return faceAnimNode->LookLeft;
	return -1.00f;
}

inline static bool SetMorphValue(RE::Actor* theActor, std::string morphName, float morphValue)
{
	if (!theActor || morphName.empty() || morphValue < 0.00f || morphValue > 1.00f)
		return false;
	RE::BSFaceGenAnimationData* faceAnimNode = GetFaceGenAnimData(theActor);
	if (!faceAnimNode)
		return false;
	morphName = ToLowerStr(morphName);
	if (std::strcmp("browlowererl", morphName.c_str()) == 0) {
		faceAnimNode->browLowererL = morphValue;
		return true;
	}
	if (std::strcmp("browlowererr", morphName.c_str()) == 0) {
		faceAnimNode->browLowererR = morphValue;
		return true;
	}
	if (std::strcmp("cheekpuffl", morphName.c_str()) == 0) {
		faceAnimNode->cheekPuffL = morphValue;
		return true;
	}
	if (std::strcmp("cheekpuffr", morphName.c_str()) == 0) {
		faceAnimNode->cheekPuffR = morphValue;
		return true;
	}
	if (std::strcmp("cheekraisel", morphName.c_str()) == 0) {
		faceAnimNode->cheekRaiseL = morphValue;
		return true;
	}
	if (std::strcmp("cheekraiser", morphName.c_str()) == 0) {
		faceAnimNode->cheekRaiseR = morphValue;
		return true;
	}
	if (std::strcmp("cheeksuckl", morphName.c_str()) == 0) {
		faceAnimNode->cheekSuckL = morphValue;
		return true;
	}
	if (std::strcmp("cheeksuckr", morphName.c_str()) == 0) {
		faceAnimNode->cheekSuckR = morphValue;
		return true;
	}
	if (std::strcmp("chinraise", morphName.c_str()) == 0) {
		faceAnimNode->chinRaise = morphValue;
		return true;
	}
	if (std::strcmp("chinraiseupperliptweak", morphName.c_str()) == 0) {
		faceAnimNode->chinRaiseUpperlipTweak = morphValue;
		return true;
	}
	if (std::strcmp("c_eyedown_eyeclosedl", morphName.c_str()) == 0) {
		faceAnimNode->c_eyeDown_eyeClosedL = morphValue;
		return true;
	}
	if (std::strcmp("c_eyedown_eyeclosedr", morphName.c_str()) == 0) {
		faceAnimNode->c_eyeDown_eyeClosedR = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeleft_eyeclosedl", morphName.c_str()) == 0) {
		faceAnimNode->c_eyeLeft_eyeClosedL = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeleft_eyeclosedr", morphName.c_str()) == 0) {
		faceAnimNode->c_eyeLeft_eyeClosedR = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeright_eyeclosedl", morphName.c_str()) == 0) {
		faceAnimNode->c_eyeRight_eyeClosedL = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeright_eyeclosedr", morphName.c_str()) == 0) {
		faceAnimNode->c_eyeRight_eyeClosedR = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeup_eyeclosedl", morphName.c_str()) == 0) {
		faceAnimNode->c_eyeUp_eyeClosedL = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeup_eyeclosedr", morphName.c_str()) == 0) {
		faceAnimNode->c_eyeUp_eyeClosedR = morphValue;
		return true;
	}
	if (std::strcmp("c_eyesclosed50l", morphName.c_str()) == 0) {
		faceAnimNode->c_eyesClosed50L = morphValue;
		return true;
	}
	if (std::strcmp("c_eyesclosed50r", morphName.c_str()) == 0) {
		faceAnimNode->c_eyesClosed50R = morphValue;
		return true;
	}
	if (std::strcmp("c_jawdrop", morphName.c_str()) == 0) {
		faceAnimNode->c_JawDrop = morphValue;
		return true;
	}
	if (std::strcmp("c_squintl_cheekraiserl", morphName.c_str()) == 0) {
		faceAnimNode->c_squintL_cheekRaiserL = morphValue;
		return true;
	}
	if (std::strcmp("c_squintr_cheekraiserr", morphName.c_str()) == 0) {
		faceAnimNode->c_squintR_cheekRaiserR = morphValue;
		return true;
	}
	if (std::strcmp("dimplerl", morphName.c_str()) == 0) {
		faceAnimNode->dimplerL = morphValue;
		return true;
	}
	if (std::strcmp("dimplerr", morphName.c_str()) == 0) {
		faceAnimNode->dimplerR = morphValue;
		return true;
	}
	if (std::strcmp("eyeclosedl", morphName.c_str()) == 0) {
		faceAnimNode->eyeClosedL = morphValue;
		return true;
	}
	if (std::strcmp("eyeclosedr", morphName.c_str()) == 0) {
		faceAnimNode->eyeClosedR = morphValue;
		return true;
	}
	if (std::strcmp("eyedown", morphName.c_str()) == 0) {
		faceAnimNode->eyeDown = morphValue;
		return true;
	}
	if (std::strcmp("eyeleft", morphName.c_str()) == 0) {
		faceAnimNode->eyeLeft = morphValue;
		return true;
	}
	if (std::strcmp("eyeopenl", morphName.c_str()) == 0) {
		faceAnimNode->eyeOpenL = morphValue;
		return true;
	}
	if (std::strcmp("eyeopenr", morphName.c_str()) == 0) {
		faceAnimNode->eyeOpenR = morphValue;
		return true;
	}
	if (std::strcmp("eyeright", morphName.c_str()) == 0) {
		faceAnimNode->eyeRight = morphValue;
		return true;
	}
	if (std::strcmp("eyeup", morphName.c_str()) == 0) {
		faceAnimNode->eyeUp = morphValue;
		return true;
	}
	if (std::strcmp("innerbrowraisel", morphName.c_str()) == 0) {
		faceAnimNode->innerBrowRaiseL = morphValue;
		return true;
	}
	if (std::strcmp("innerbrowraiser", morphName.c_str()) == 0) {
		faceAnimNode->innerBrowRaiseR = morphValue;
		return true;
	}
	if (std::strcmp("jawclench", morphName.c_str()) == 0) {
		faceAnimNode->jawClench = morphValue;
		return true;
	}
	if (std::strcmp("jawleft", morphName.c_str()) == 0) {
		faceAnimNode->jawLeft = morphValue;
		return true;
	}
	if (std::strcmp("jawopen", morphName.c_str()) == 0) {
		faceAnimNode->jawOpen = morphValue;
		return true;
	}
	if (std::strcmp("jawright", morphName.c_str()) == 0) {
		faceAnimNode->jawRight = morphValue;
		return true;
	}
	if (std::strcmp("jawthrust", morphName.c_str()) == 0) {
		faceAnimNode->jawThrust = morphValue;
		return true;
	}
	if (std::strcmp("lidtightenerl", morphName.c_str()) == 0) {
		faceAnimNode->lidTightenerL = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerdepressl", morphName.c_str()) == 0) {
		faceAnimNode->lipCornerDepressL = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerdepressr", morphName.c_str()) == 0) {
		faceAnimNode->lipCornerDepressR = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerinl", morphName.c_str()) == 0) {
		faceAnimNode->lipCornerInL = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerinr", morphName.c_str()) == 0) {
		faceAnimNode->lipCornerInR = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerpulll", morphName.c_str()) == 0) {
		faceAnimNode->lipCornerPullL = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerpullr", morphName.c_str()) == 0) {
		faceAnimNode->lipCornerPullR = morphValue;
		return true;
	}
	if (std::strcmp("lippress", morphName.c_str()) == 0) {
		faceAnimNode->lipPress = morphValue;
		return true;
	}
	if (std::strcmp("lippucker", morphName.c_str()) == 0) {
		faceAnimNode->lipPucker = morphValue;
		return true;
	}
	if (std::strcmp("lipstretchl", morphName.c_str()) == 0) {
		faceAnimNode->lipStretchL = morphValue;
		return true;
	}
	if (std::strcmp("lipstretchr", morphName.c_str()) == 0) {
		faceAnimNode->lipStretchR = morphValue;
		return true;
	}
	if (std::strcmp("liptighten", morphName.c_str()) == 0) {
		faceAnimNode->lipTighten = morphValue;
		return true;
	}
	if (std::strcmp("lipzipperl", morphName.c_str()) == 0) {
		faceAnimNode->lipZipperL = morphValue;
		return true;
	}
	if (std::strcmp("lipzipperr", morphName.c_str()) == 0) {
		faceAnimNode->lipZipperR = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipdepressl", morphName.c_str()) == 0) {
		faceAnimNode->lowerLipDepressL = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipdepressr", morphName.c_str()) == 0) {
		faceAnimNode->lowerLipDepressR = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipfunnel", morphName.c_str()) == 0) {
		faceAnimNode->lowerLipFunnel = morphValue;
		return true;
	}
	if (std::strcmp("lowerlippuff", morphName.c_str()) == 0) {
		faceAnimNode->lowerLipPuff = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipsuck", morphName.c_str()) == 0) {
		faceAnimNode->lowerLipSuck = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipthickness", morphName.c_str()) == 0) {
		faceAnimNode->lowerLipThickness = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipupl", morphName.c_str()) == 0) {
		faceAnimNode->lowerLipUpL = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipupr", morphName.c_str()) == 0) {
		faceAnimNode->lowerLipUpR = morphValue;
		return true;
	}
	if (std::strcmp("nasolabialfurrowl", morphName.c_str()) == 0) {
		faceAnimNode->nasolabialFurrowL = morphValue;
		return true;
	}
	if (std::strcmp("nasolabialfurrowr", morphName.c_str()) == 0) {
		faceAnimNode->nasolabialFurrowR = morphValue;
		return true;
	}
	if (std::strcmp("neckflexl", morphName.c_str()) == 0) {
		faceAnimNode->neckFlexL = morphValue;
		return true;
	}
	if (std::strcmp("neckflexr", morphName.c_str()) == 0) {
		faceAnimNode->neckFlexR = morphValue;
		return true;
	}
	if (std::strcmp("nosedepressor", morphName.c_str()) == 0) {
		faceAnimNode->noseDepressor = morphValue;
		return true;
	}
	if (std::strcmp("nosewrinklel", morphName.c_str()) == 0) {
		faceAnimNode->noseWrinkleL = morphValue;
		return true;
	}
	if (std::strcmp("nosewrinkler", morphName.c_str()) == 0) {
		faceAnimNode->noseWrinkleR = morphValue;
		return true;
	}
	if (std::strcmp("nostrilcompressor", morphName.c_str()) == 0) {
		faceAnimNode->nostrilCompressor = morphValue;
		return true;
	}
	if (std::strcmp("nostrildilator", morphName.c_str()) == 0) {
		faceAnimNode->nostrilDilator = morphValue;
		return true;
	}
	if (std::strcmp("outerbrowraisel", morphName.c_str()) == 0) {
		faceAnimNode->outerBrowRaiseL = morphValue;
		return true;
	}
	if (std::strcmp("outerbrowraiser", morphName.c_str()) == 0) {
		faceAnimNode->outerBrowRaiseR = morphValue;
		return true;
	}
	if (std::strcmp("sharplippulll", morphName.c_str()) == 0) {
		faceAnimNode->sharpLipPullL = morphValue;
		return true;
	}
	if (std::strcmp("sharplippullr", morphName.c_str()) == 0) {
		faceAnimNode->sharpLipPullR = morphValue;
		return true;
	}
	if (std::strcmp("squintl", morphName.c_str()) == 0) {
		faceAnimNode->squintL = morphValue;
		return true;
	}
	if (std::strcmp("squintr", morphName.c_str()) == 0) {
		faceAnimNode->squintR = morphValue;
		return true;
	}
	if (std::strcmp("swallow", morphName.c_str()) == 0) {
		faceAnimNode->swallow = morphValue;
		return true;
	}
	if (std::strcmp("upperlipdownl", morphName.c_str()) == 0) {
		faceAnimNode->upperLipDownL = morphValue;
		return true;
	}
	if (std::strcmp("upperlipdownr", morphName.c_str()) == 0) {
		faceAnimNode->upperLipDownR = morphValue;
		return true;
	}
	if (std::strcmp("upperlipfunnel", morphName.c_str()) == 0) {
		faceAnimNode->upperLipFunnel = morphValue;
		return true;
	}
	if (std::strcmp("upperlippuff", morphName.c_str()) == 0) {
		faceAnimNode->upperLipPuff = morphValue;
		return true;
	}
	if (std::strcmp("upperlipraisel", morphName.c_str()) == 0) {
		faceAnimNode->upperLipRaiseL = morphValue;
		return true;
	}
	if (std::strcmp("upperlipraiser", morphName.c_str()) == 0) {
		faceAnimNode->upperLipRaiseR = morphValue;
		return true;
	}
	if (std::strcmp("upperlipsuck", morphName.c_str()) == 0) {
		faceAnimNode->upperLipSuck = morphValue;
		return true;
	}
	if (std::strcmp("upperlipthickness", morphName.c_str()) == 0) {
		faceAnimNode->upperLipThickness = morphValue;
		return true;
	}
	if (std::strcmp("tonguecurldown", morphName.c_str()) == 0) {
		faceAnimNode->tongueCurlDown = morphValue;
		return true;
	}
	if (std::strcmp("tonguecurlup", morphName.c_str()) == 0) {
		faceAnimNode->tongueCurlUp = morphValue;
		return true;
	}
	if (std::strcmp("tonguedown", morphName.c_str()) == 0) {
		faceAnimNode->tongueDown = morphValue;
		return true;
	}
	if (std::strcmp("tongueup", morphName.c_str()) == 0) {
		faceAnimNode->tongueUp = morphValue;
		return true;
	}
	if (std::strcmp("tonguein", morphName.c_str()) == 0) {
		faceAnimNode->tongueIn = morphValue;
		return true;
	}
	if (std::strcmp("tongueout", morphName.c_str()) == 0) {
		faceAnimNode->tongueOut = morphValue;
		return true;
	}
	if (std::strcmp("tongueleft", morphName.c_str()) == 0) {
		faceAnimNode->tongueLeft = morphValue;
		return true;
	}
	if (std::strcmp("tongueright", morphName.c_str()) == 0) {
		faceAnimNode->tongueRight = morphValue;
		return true;
	}
	if (std::strcmp("tonguethick", morphName.c_str()) == 0) {
		faceAnimNode->tongueThick = morphValue;
		return true;
	}
	if (std::strcmp("tonguethinner", morphName.c_str()) == 0) {
		faceAnimNode->tongueThinner = morphValue;
		return true;
	}
	if (std::strcmp("lookdown", morphName.c_str()) == 0) {
		faceAnimNode->LookDown = morphValue;
		return true;
	}
	if (std::strcmp("lookup", morphName.c_str()) == 0) {
		faceAnimNode->LookUp = morphValue;
		return true;
	}
	if (std::strcmp("lookright", morphName.c_str()) == 0) {
		faceAnimNode->LookRight = morphValue;
		return true;
	}
	if (std::strcmp("lookleft", morphName.c_str()) == 0) {
		faceAnimNode->LookLeft = morphValue;
		return true;
	}
	return false;
}

inline static bool ApplyFacialExpressionPhotoModeByMorphMap(RE::Actor* theActor, std::vector<std::pair<std::string, float>>* theMorphMap)
{
	if (!theActor || !theMorphMap || theMorphMap->size() < 100)
		return false;
	REL::Relocation<uintptr_t> ptr{ REL::ID(1536429) };  // Starfield.exe + 1BEA5C0 (1.12.36), 1C440F0 (1.13.63)
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<void (*)(float[100], RE::BSFadeNode*)>(addr);
	uintptr_t                  out3D = 0;
	uintptr_t*                 out3DPtr = &out3D;
	theActor->Get3D(out3DPtr, false);
	if (!out3DPtr)
		return false;
	auto model = reinterpret_cast<RE::BSFadeNode*>(*out3DPtr);
	if (!model)
		return false;
	float morphs[100]{};
	for (auto i = 0; i < theMorphMap->size(); i++) {
		morphs[i] = theMorphMap->at(i).second;
	}
	func(morphs, model);
	return true;
}

inline static std::vector<float> GetMorphValues(RE::Actor* theActor)
{
	std::vector<float> Result;
	if (!theActor)
		return Result;
	auto faceAnimNode = GetFaceGenAnimData(theActor);
	if (!faceAnimNode)
		return Result;
	Result.push_back(faceAnimNode->browLowererL);
	Result.push_back(faceAnimNode->browLowererR);
	Result.push_back(faceAnimNode->cheekPuffL);
	Result.push_back(faceAnimNode->cheekPuffR);
	Result.push_back(faceAnimNode->cheekRaiseL);
	Result.push_back(faceAnimNode->cheekRaiseR);
	Result.push_back(faceAnimNode->cheekSuckL);
	Result.push_back(faceAnimNode->cheekSuckR);
	Result.push_back(faceAnimNode->chinRaise);
	Result.push_back(faceAnimNode->chinRaiseUpperlipTweak);
	Result.push_back(faceAnimNode->c_eyeDown_eyeClosedL);
	Result.push_back(faceAnimNode->c_eyeDown_eyeClosedR);
	Result.push_back(faceAnimNode->c_eyeLeft_eyeClosedL);
	Result.push_back(faceAnimNode->c_eyeLeft_eyeClosedR);
	Result.push_back(faceAnimNode->c_eyeRight_eyeClosedL);
	Result.push_back(faceAnimNode->c_eyeRight_eyeClosedR);
	Result.push_back(faceAnimNode->c_eyeUp_eyeClosedL);
	Result.push_back(faceAnimNode->c_eyeUp_eyeClosedR);
	Result.push_back(faceAnimNode->c_eyesClosed50L);
	Result.push_back(faceAnimNode->c_eyesClosed50R);
	Result.push_back(faceAnimNode->c_JawDrop);
	Result.push_back(faceAnimNode->c_squintL_cheekRaiserL);
	Result.push_back(faceAnimNode->c_squintR_cheekRaiserR);
	Result.push_back(faceAnimNode->dimplerL);
	Result.push_back(faceAnimNode->dimplerR);
	Result.push_back(faceAnimNode->eyeClosedL);
	Result.push_back(faceAnimNode->eyeClosedR);
	Result.push_back(faceAnimNode->eyeDown);
	Result.push_back(faceAnimNode->eyeLeft);
	Result.push_back(faceAnimNode->eyeOpenL);
	Result.push_back(faceAnimNode->eyeOpenR);
	Result.push_back(faceAnimNode->eyeRight);
	Result.push_back(faceAnimNode->eyeUp);
	Result.push_back(faceAnimNode->innerBrowRaiseL);
	Result.push_back(faceAnimNode->innerBrowRaiseR);
	Result.push_back(faceAnimNode->jawClench);
	Result.push_back(faceAnimNode->jawLeft);
	Result.push_back(faceAnimNode->jawOpen);
	Result.push_back(faceAnimNode->jawRight);
	Result.push_back(faceAnimNode->jawThrust);
	Result.push_back(faceAnimNode->lidTightenerL);
	Result.push_back(faceAnimNode->lipCornerDepressL);
	Result.push_back(faceAnimNode->lipCornerDepressR);
	Result.push_back(faceAnimNode->lipCornerInL);
	Result.push_back(faceAnimNode->lipCornerInR);
	Result.push_back(faceAnimNode->lipCornerPullL);
	Result.push_back(faceAnimNode->lipCornerPullR);
	Result.push_back(faceAnimNode->lipPress);
	Result.push_back(faceAnimNode->lipPucker);
	Result.push_back(faceAnimNode->lipStretchL);
	Result.push_back(faceAnimNode->lipStretchR);
	Result.push_back(faceAnimNode->lipTighten);
	Result.push_back(faceAnimNode->lipZipperL);
	Result.push_back(faceAnimNode->lipZipperR);
	Result.push_back(faceAnimNode->lowerLipDepressL);
	Result.push_back(faceAnimNode->lowerLipDepressR);
	Result.push_back(faceAnimNode->lowerLipFunnel);
	Result.push_back(faceAnimNode->lowerLipPuff);
	Result.push_back(faceAnimNode->lowerLipSuck);
	Result.push_back(faceAnimNode->lowerLipThickness);
	Result.push_back(faceAnimNode->lowerLipUpL);
	Result.push_back(faceAnimNode->lowerLipUpR);
	Result.push_back(faceAnimNode->nasolabialFurrowL);
	Result.push_back(faceAnimNode->nasolabialFurrowR);
	Result.push_back(faceAnimNode->neckFlexL);
	Result.push_back(faceAnimNode->neckFlexR);
	Result.push_back(faceAnimNode->noseDepressor);
	Result.push_back(faceAnimNode->noseWrinkleL);
	Result.push_back(faceAnimNode->noseWrinkleR);
	Result.push_back(faceAnimNode->nostrilCompressor);
	Result.push_back(faceAnimNode->nostrilDilator);
	Result.push_back(faceAnimNode->outerBrowRaiseL);
	Result.push_back(faceAnimNode->outerBrowRaiseR);
	Result.push_back(faceAnimNode->sharpLipPullL);
	Result.push_back(faceAnimNode->sharpLipPullR);
	Result.push_back(faceAnimNode->squintL);
	Result.push_back(faceAnimNode->squintR);
	Result.push_back(faceAnimNode->swallow);
	Result.push_back(faceAnimNode->upperLipDownL);
	Result.push_back(faceAnimNode->upperLipDownR);
	Result.push_back(faceAnimNode->upperLipFunnel);
	Result.push_back(faceAnimNode->upperLipPuff);
	Result.push_back(faceAnimNode->upperLipRaiseL);
	Result.push_back(faceAnimNode->upperLipRaiseR);
	Result.push_back(faceAnimNode->upperLipSuck);
	Result.push_back(faceAnimNode->upperLipThickness);
	Result.push_back(faceAnimNode->tongueCurlDown);
	Result.push_back(faceAnimNode->tongueCurlUp);
	Result.push_back(faceAnimNode->tongueDown);
	Result.push_back(faceAnimNode->tongueUp);
	Result.push_back(faceAnimNode->tongueIn);
	Result.push_back(faceAnimNode->tongueOut);
	Result.push_back(faceAnimNode->tongueLeft);
	Result.push_back(faceAnimNode->tongueRight);
	Result.push_back(faceAnimNode->tongueThick);
	Result.push_back(faceAnimNode->tongueThinner);
	Result.push_back(faceAnimNode->LookDown);
	Result.push_back(faceAnimNode->LookUp);
	Result.push_back(faceAnimNode->LookRight);
	Result.push_back(faceAnimNode->LookLeft);
	return Result;
}

inline static bool CopyFacialExpression(RE::Actor* theActorToCopyFrom, RE::Actor* theActorToCopyTo)
{
	if (!theActorToCopyFrom || !theActorToCopyTo)
		return false;
	auto sourceFaceGenNode = GetFaceGenAnimData(theActorToCopyFrom);
	auto targetFaceGenNode = GetFaceGenAnimData(theActorToCopyTo);
	if (!sourceFaceGenNode || !targetFaceGenNode)
		return false;
	targetFaceGenNode->browLowererL = sourceFaceGenNode->browLowererL;
	targetFaceGenNode->browLowererR = sourceFaceGenNode->browLowererR;
	targetFaceGenNode->cheekPuffL = sourceFaceGenNode->cheekPuffL;
	targetFaceGenNode->cheekPuffR = sourceFaceGenNode->cheekPuffR;
	targetFaceGenNode->cheekRaiseL = sourceFaceGenNode->cheekRaiseL;
	targetFaceGenNode->cheekRaiseR = sourceFaceGenNode->cheekRaiseR;
	targetFaceGenNode->cheekSuckL = sourceFaceGenNode->cheekSuckL;
	targetFaceGenNode->cheekSuckR = sourceFaceGenNode->cheekSuckR;
	targetFaceGenNode->chinRaise = sourceFaceGenNode->chinRaise;
	targetFaceGenNode->chinRaiseUpperlipTweak = sourceFaceGenNode->chinRaiseUpperlipTweak;
	targetFaceGenNode->c_eyeDown_eyeClosedL = sourceFaceGenNode->c_eyeDown_eyeClosedL;
	targetFaceGenNode->c_eyeDown_eyeClosedR = sourceFaceGenNode->c_eyeDown_eyeClosedR;
	targetFaceGenNode->c_eyeLeft_eyeClosedL = sourceFaceGenNode->c_eyeLeft_eyeClosedL;
	targetFaceGenNode->c_eyeLeft_eyeClosedR = sourceFaceGenNode->c_eyeLeft_eyeClosedR;
	targetFaceGenNode->c_eyeRight_eyeClosedL = sourceFaceGenNode->c_eyeRight_eyeClosedL;
	targetFaceGenNode->c_eyeRight_eyeClosedR = sourceFaceGenNode->c_eyeRight_eyeClosedR;
	targetFaceGenNode->c_eyeUp_eyeClosedL = sourceFaceGenNode->c_eyeUp_eyeClosedL;
	targetFaceGenNode->c_eyeUp_eyeClosedR = sourceFaceGenNode->c_eyeUp_eyeClosedR;
	targetFaceGenNode->c_eyesClosed50L = sourceFaceGenNode->c_eyesClosed50L;
	targetFaceGenNode->c_eyesClosed50R = sourceFaceGenNode->c_eyesClosed50R;
	targetFaceGenNode->c_JawDrop = sourceFaceGenNode->c_JawDrop;
	targetFaceGenNode->c_squintL_cheekRaiserL = sourceFaceGenNode->c_squintL_cheekRaiserL;
	targetFaceGenNode->c_squintR_cheekRaiserR = sourceFaceGenNode->c_squintR_cheekRaiserR;
	targetFaceGenNode->dimplerL = sourceFaceGenNode->dimplerL;
	targetFaceGenNode->dimplerR = sourceFaceGenNode->dimplerR;
	targetFaceGenNode->eyeClosedL = sourceFaceGenNode->eyeClosedL;
	targetFaceGenNode->eyeClosedR = sourceFaceGenNode->eyeClosedR;
	targetFaceGenNode->eyeDown = sourceFaceGenNode->eyeDown;
	targetFaceGenNode->eyeLeft = sourceFaceGenNode->eyeLeft;
	targetFaceGenNode->eyeOpenL = sourceFaceGenNode->eyeOpenL;
	targetFaceGenNode->eyeOpenR = sourceFaceGenNode->eyeOpenR;
	targetFaceGenNode->eyeRight = sourceFaceGenNode->eyeRight;
	targetFaceGenNode->eyeUp = sourceFaceGenNode->eyeUp;
	targetFaceGenNode->innerBrowRaiseL = sourceFaceGenNode->innerBrowRaiseL;
	targetFaceGenNode->innerBrowRaiseR = sourceFaceGenNode->innerBrowRaiseR;
	targetFaceGenNode->jawClench = sourceFaceGenNode->jawClench;
	targetFaceGenNode->jawLeft = sourceFaceGenNode->jawLeft;
	targetFaceGenNode->jawOpen = sourceFaceGenNode->jawOpen;
	targetFaceGenNode->jawRight = sourceFaceGenNode->jawRight;
	targetFaceGenNode->jawThrust = sourceFaceGenNode->jawThrust;
	targetFaceGenNode->lidTightenerL = sourceFaceGenNode->lidTightenerL;
	targetFaceGenNode->lipCornerDepressL = sourceFaceGenNode->lipCornerDepressL;
	targetFaceGenNode->lipCornerDepressR = sourceFaceGenNode->lipCornerDepressR;
	targetFaceGenNode->lipCornerInL = sourceFaceGenNode->lipCornerInL;
	targetFaceGenNode->lipCornerInR = sourceFaceGenNode->lipCornerInR;
	targetFaceGenNode->lipCornerPullL = sourceFaceGenNode->lipCornerPullL;
	targetFaceGenNode->lipCornerPullR = sourceFaceGenNode->lipCornerPullR;
	targetFaceGenNode->lipPress = sourceFaceGenNode->lipPress;
	targetFaceGenNode->lipPucker = sourceFaceGenNode->lipPucker;
	targetFaceGenNode->lipStretchL = sourceFaceGenNode->lipStretchL;
	targetFaceGenNode->lipStretchR = sourceFaceGenNode->lipStretchR;
	targetFaceGenNode->lipTighten = sourceFaceGenNode->lipTighten;
	targetFaceGenNode->lipZipperL = sourceFaceGenNode->lipZipperL;
	targetFaceGenNode->lipZipperR = sourceFaceGenNode->lipZipperR;
	targetFaceGenNode->lowerLipDepressL = sourceFaceGenNode->lowerLipDepressL;
	targetFaceGenNode->lowerLipDepressR = sourceFaceGenNode->lowerLipDepressR;
	targetFaceGenNode->lowerLipFunnel = sourceFaceGenNode->lowerLipFunnel;
	targetFaceGenNode->lowerLipPuff = sourceFaceGenNode->lowerLipPuff;
	targetFaceGenNode->lowerLipSuck = sourceFaceGenNode->lowerLipSuck;
	targetFaceGenNode->lowerLipThickness = sourceFaceGenNode->lowerLipThickness;
	targetFaceGenNode->lowerLipUpL = sourceFaceGenNode->lowerLipUpL;
	targetFaceGenNode->lowerLipUpR = sourceFaceGenNode->lowerLipUpR;
	targetFaceGenNode->nasolabialFurrowL = sourceFaceGenNode->nasolabialFurrowL;
	targetFaceGenNode->nasolabialFurrowR = sourceFaceGenNode->nasolabialFurrowR;
	targetFaceGenNode->neckFlexL = sourceFaceGenNode->neckFlexL;
	targetFaceGenNode->neckFlexR = sourceFaceGenNode->neckFlexR;
	targetFaceGenNode->noseDepressor = sourceFaceGenNode->noseDepressor;
	targetFaceGenNode->noseWrinkleL = sourceFaceGenNode->noseWrinkleL;
	targetFaceGenNode->noseWrinkleR = sourceFaceGenNode->noseWrinkleR;
	targetFaceGenNode->nostrilCompressor = sourceFaceGenNode->nostrilCompressor;
	targetFaceGenNode->nostrilDilator = sourceFaceGenNode->nostrilDilator;
	targetFaceGenNode->outerBrowRaiseL = sourceFaceGenNode->outerBrowRaiseL;
	targetFaceGenNode->outerBrowRaiseR = sourceFaceGenNode->outerBrowRaiseR;
	targetFaceGenNode->sharpLipPullL = sourceFaceGenNode->sharpLipPullL;
	targetFaceGenNode->sharpLipPullR = sourceFaceGenNode->sharpLipPullR;
	targetFaceGenNode->squintL = sourceFaceGenNode->squintL;
	targetFaceGenNode->squintR = sourceFaceGenNode->squintR;
	targetFaceGenNode->swallow = sourceFaceGenNode->swallow;
	targetFaceGenNode->upperLipDownL = sourceFaceGenNode->upperLipDownL;
	targetFaceGenNode->upperLipDownR = sourceFaceGenNode->upperLipDownR;
	targetFaceGenNode->upperLipFunnel = sourceFaceGenNode->upperLipFunnel;
	targetFaceGenNode->upperLipPuff = sourceFaceGenNode->upperLipPuff;
	targetFaceGenNode->upperLipRaiseL = sourceFaceGenNode->upperLipRaiseL;
	targetFaceGenNode->upperLipRaiseR = sourceFaceGenNode->upperLipRaiseR;
	targetFaceGenNode->upperLipSuck = sourceFaceGenNode->upperLipSuck;
	targetFaceGenNode->upperLipThickness = sourceFaceGenNode->upperLipThickness;
	targetFaceGenNode->tongueCurlDown = sourceFaceGenNode->tongueCurlDown;
	targetFaceGenNode->tongueCurlUp = sourceFaceGenNode->tongueCurlUp;
	targetFaceGenNode->tongueDown = sourceFaceGenNode->tongueDown;
	targetFaceGenNode->tongueUp = sourceFaceGenNode->tongueUp;
	targetFaceGenNode->tongueIn = sourceFaceGenNode->tongueIn;
	targetFaceGenNode->tongueOut = sourceFaceGenNode->tongueOut;
	targetFaceGenNode->tongueLeft = sourceFaceGenNode->tongueLeft;
	targetFaceGenNode->tongueRight = sourceFaceGenNode->tongueRight;
	targetFaceGenNode->tongueThick = sourceFaceGenNode->tongueThick;
	targetFaceGenNode->tongueThinner = sourceFaceGenNode->tongueThinner;
	targetFaceGenNode->LookDown = sourceFaceGenNode->LookDown;
	targetFaceGenNode->LookUp = sourceFaceGenNode->LookUp;
	targetFaceGenNode->LookRight = sourceFaceGenNode->LookRight;
	targetFaceGenNode->LookLeft = sourceFaceGenNode->LookLeft;
	return true;
}

inline static bool ResetFacialExpression(RE::Actor* theActor)
{
	if (!theActor)
		return false;
	auto faceAnimNode = GetFaceGenAnimData(theActor);
	if (!faceAnimNode)
		return false;
	faceAnimNode->browLowererL = 0;
	faceAnimNode->browLowererR = 0;
	faceAnimNode->cheekPuffL = 0;
	faceAnimNode->cheekPuffR = 0;
	faceAnimNode->cheekRaiseL = 0;
	faceAnimNode->cheekRaiseR = 0;
	faceAnimNode->cheekSuckL = 0;
	faceAnimNode->cheekSuckR = 0;
	faceAnimNode->chinRaise = 0;
	faceAnimNode->chinRaiseUpperlipTweak = 0;
	faceAnimNode->c_eyeDown_eyeClosedL = 0;
	faceAnimNode->c_eyeDown_eyeClosedR = 0;
	faceAnimNode->c_eyeLeft_eyeClosedL = 0;
	faceAnimNode->c_eyeLeft_eyeClosedR = 0;
	faceAnimNode->c_eyeRight_eyeClosedL = 0;
	faceAnimNode->c_eyeRight_eyeClosedR = 0;
	faceAnimNode->c_eyeUp_eyeClosedL = 0;
	faceAnimNode->c_eyeUp_eyeClosedR = 0;
	faceAnimNode->c_eyesClosed50L = 0;
	faceAnimNode->c_eyesClosed50R = 0;
	faceAnimNode->c_JawDrop = 0;
	faceAnimNode->c_squintL_cheekRaiserL = 0;
	faceAnimNode->c_squintR_cheekRaiserR = 0;
	faceAnimNode->dimplerL = 0;
	faceAnimNode->dimplerR = 0;
	faceAnimNode->eyeClosedL = 0;
	faceAnimNode->eyeClosedR = 0;
	faceAnimNode->eyeDown = 0;
	faceAnimNode->eyeLeft = 0;
	faceAnimNode->eyeOpenL = 0;
	faceAnimNode->eyeOpenR = 0;
	faceAnimNode->eyeRight = 0;
	faceAnimNode->eyeUp = 0;
	faceAnimNode->innerBrowRaiseL = 0;
	faceAnimNode->innerBrowRaiseR = 0;
	faceAnimNode->jawClench = 0;
	faceAnimNode->jawLeft = 0;
	faceAnimNode->jawOpen = 0;
	faceAnimNode->jawRight = 0;
	faceAnimNode->jawThrust = 0;
	faceAnimNode->lidTightenerL = 0;
	faceAnimNode->lipCornerDepressL = 0;
	faceAnimNode->lipCornerDepressR = 0;
	faceAnimNode->lipCornerInL = 0;
	faceAnimNode->lipCornerInR = 0;
	faceAnimNode->lipCornerPullL = 0;
	faceAnimNode->lipCornerPullR = 0;
	faceAnimNode->lipPress = 0;
	faceAnimNode->lipPucker = 0;
	faceAnimNode->lipStretchL = 0;
	faceAnimNode->lipStretchR = 0;
	faceAnimNode->lipTighten = 0;
	faceAnimNode->lipZipperL = 0;
	faceAnimNode->lipZipperR = 0;
	faceAnimNode->lowerLipDepressL = 0;
	faceAnimNode->lowerLipDepressR = 0;
	faceAnimNode->lowerLipFunnel = 0;
	faceAnimNode->lowerLipPuff = 0;
	faceAnimNode->lowerLipSuck = 0;
	faceAnimNode->lowerLipThickness = 0;
	faceAnimNode->lowerLipUpL = 0;
	faceAnimNode->lowerLipUpR = 0;
	faceAnimNode->nasolabialFurrowL = 0;
	faceAnimNode->nasolabialFurrowR = 0;
	faceAnimNode->neckFlexL = 0;
	faceAnimNode->neckFlexR = 0;
	faceAnimNode->noseDepressor = 0;
	faceAnimNode->noseWrinkleL = 0;
	faceAnimNode->noseWrinkleR = 0;
	faceAnimNode->nostrilCompressor = 0;
	faceAnimNode->nostrilDilator = 0;
	faceAnimNode->outerBrowRaiseL = 0;
	faceAnimNode->outerBrowRaiseR = 0;
	faceAnimNode->sharpLipPullL = 0;
	faceAnimNode->sharpLipPullR = 0;
	faceAnimNode->squintL = 0;
	faceAnimNode->squintR = 0;
	faceAnimNode->swallow = 0;
	faceAnimNode->upperLipDownL = 0;
	faceAnimNode->upperLipDownR = 0;
	faceAnimNode->upperLipFunnel = 0;
	faceAnimNode->upperLipPuff = 0;
	faceAnimNode->upperLipRaiseL = 0;
	faceAnimNode->upperLipRaiseR = 0;
	faceAnimNode->upperLipSuck = 0;
	faceAnimNode->upperLipThickness = 0;
	faceAnimNode->tongueCurlDown = 0;
	faceAnimNode->tongueCurlUp = 0;
	faceAnimNode->tongueDown = 0;
	faceAnimNode->tongueUp = 0;
	faceAnimNode->tongueIn = 0;
	faceAnimNode->tongueOut = 0;
	faceAnimNode->tongueLeft = 0;
	faceAnimNode->tongueRight = 0;
	faceAnimNode->tongueThick = 0;
	faceAnimNode->tongueThinner = 0;
	faceAnimNode->LookDown = 0;
	faceAnimNode->LookUp = 0;
	faceAnimNode->LookRight = 0;
	faceAnimNode->LookLeft = 0;
	return true;
}

inline static std::vector<float> ReadFacialExpressionDataMorphValues(RE::BGSFacialExpressionData* theFacialExpression)
{
	std::vector<float> Result;
	if (!theFacialExpression)
		return Result;
	Result.push_back(theFacialExpression->browLowererL);
	Result.push_back(theFacialExpression->browLowererR);
	Result.push_back(theFacialExpression->cheekPuffL);
	Result.push_back(theFacialExpression->cheekPuffR);
	Result.push_back(theFacialExpression->cheekRaiseL);
	Result.push_back(theFacialExpression->cheekRaiseR);
	Result.push_back(theFacialExpression->cheekSuckL);
	Result.push_back(theFacialExpression->cheekSuckR);
	Result.push_back(theFacialExpression->chinRaise);
	Result.push_back(theFacialExpression->chinRaiseUpperlipTweak);
	Result.push_back(theFacialExpression->c_eyeDown_eyeClosedL);
	Result.push_back(theFacialExpression->c_eyeDown_eyeClosedR);
	Result.push_back(theFacialExpression->c_eyeLeft_eyeClosedL);
	Result.push_back(theFacialExpression->c_eyeLeft_eyeClosedR);
	Result.push_back(theFacialExpression->c_eyeRight_eyeClosedL);
	Result.push_back(theFacialExpression->c_eyeRight_eyeClosedR);
	Result.push_back(theFacialExpression->c_eyeUp_eyeClosedL);
	Result.push_back(theFacialExpression->c_eyeUp_eyeClosedR);
	Result.push_back(theFacialExpression->c_eyesClosed50L);
	Result.push_back(theFacialExpression->c_eyesClosed50R);
	Result.push_back(theFacialExpression->c_JawDrop);
	Result.push_back(theFacialExpression->c_squintL_cheekRaiserL);
	Result.push_back(theFacialExpression->c_squintR_cheekRaiserR);
	Result.push_back(theFacialExpression->dimplerL);
	Result.push_back(theFacialExpression->dimplerR);
	Result.push_back(theFacialExpression->eyeClosedL);
	Result.push_back(theFacialExpression->eyeClosedR);
	Result.push_back(theFacialExpression->eyeDown);
	Result.push_back(theFacialExpression->eyeLeft);
	Result.push_back(theFacialExpression->eyeOpenL);
	Result.push_back(theFacialExpression->eyeOpenR);
	Result.push_back(theFacialExpression->eyeRight);
	Result.push_back(theFacialExpression->eyeUp);
	Result.push_back(theFacialExpression->innerBrowRaiseL);
	Result.push_back(theFacialExpression->innerBrowRaiseR);
	Result.push_back(theFacialExpression->jawClench);
	Result.push_back(theFacialExpression->jawLeft);
	Result.push_back(theFacialExpression->jawOpen);
	Result.push_back(theFacialExpression->jawRight);
	Result.push_back(theFacialExpression->jawThrust);
	Result.push_back(theFacialExpression->lidTightenerL);
	Result.push_back(theFacialExpression->lipCornerDepressL);
	Result.push_back(theFacialExpression->lipCornerDepressR);
	Result.push_back(theFacialExpression->lipCornerInL);
	Result.push_back(theFacialExpression->lipCornerInR);
	Result.push_back(theFacialExpression->lipCornerPullL);
	Result.push_back(theFacialExpression->lipCornerPullR);
	Result.push_back(theFacialExpression->lipPress);
	Result.push_back(theFacialExpression->lipPucker);
	Result.push_back(theFacialExpression->lipStretchL);
	Result.push_back(theFacialExpression->lipStretchR);
	Result.push_back(theFacialExpression->lipTighten);
	Result.push_back(theFacialExpression->lipZipperL);
	Result.push_back(theFacialExpression->lipZipperR);
	Result.push_back(theFacialExpression->lowerLipDepressL);
	Result.push_back(theFacialExpression->lowerLipDepressR);
	Result.push_back(theFacialExpression->lowerLipFunnel);
	Result.push_back(theFacialExpression->lowerLipPuff);
	Result.push_back(theFacialExpression->lowerLipSuck);
	Result.push_back(theFacialExpression->lowerLipThickness);
	Result.push_back(theFacialExpression->lowerLipUpL);
	Result.push_back(theFacialExpression->lowerLipUpR);
	Result.push_back(theFacialExpression->nasolabialFurrowL);
	Result.push_back(theFacialExpression->nasolabialFurrowR);
	Result.push_back(theFacialExpression->neckFlexL);
	Result.push_back(theFacialExpression->neckFlexR);
	Result.push_back(theFacialExpression->noseDepressor);
	Result.push_back(theFacialExpression->noseWrinkleL);
	Result.push_back(theFacialExpression->noseWrinkleR);
	Result.push_back(theFacialExpression->nostrilCompressor);
	Result.push_back(theFacialExpression->nostrilDilator);
	Result.push_back(theFacialExpression->outerBrowRaiseL);
	Result.push_back(theFacialExpression->outerBrowRaiseR);
	Result.push_back(theFacialExpression->sharpLipPullL);
	Result.push_back(theFacialExpression->sharpLipPullR);
	Result.push_back(theFacialExpression->squintL);
	Result.push_back(theFacialExpression->squintR);
	Result.push_back(theFacialExpression->swallow);
	Result.push_back(theFacialExpression->upperLipDownL);
	Result.push_back(theFacialExpression->upperLipDownR);
	Result.push_back(theFacialExpression->upperLipFunnel);
	Result.push_back(theFacialExpression->upperLipPuff);
	Result.push_back(theFacialExpression->upperLipRaiseL);
	Result.push_back(theFacialExpression->upperLipRaiseR);
	Result.push_back(theFacialExpression->upperLipSuck);
	Result.push_back(theFacialExpression->upperLipThickness);
	Result.push_back(theFacialExpression->tongueCurlDown);
	Result.push_back(theFacialExpression->tongueCurlUp);
	Result.push_back(theFacialExpression->tongueDown);
	Result.push_back(theFacialExpression->tongueUp);
	Result.push_back(theFacialExpression->tongueIn);
	Result.push_back(theFacialExpression->tongueOut);
	Result.push_back(theFacialExpression->tongueLeft);
	Result.push_back(theFacialExpression->tongueRight);
	Result.push_back(theFacialExpression->tongueThick);
	Result.push_back(theFacialExpression->tongueThinner);
	Result.push_back(theFacialExpression->LookDown);
	Result.push_back(theFacialExpression->LookUp);
	Result.push_back(theFacialExpression->LookRight);
	Result.push_back(theFacialExpression->LookLeft);
	return Result;
}

inline static std::vector<std::string> ReadFacialExpressionDataMorphNames(RE::BGSFacialExpressionData* theFacialExpression)
{
	std::vector<std::string> Result;
	if (!theFacialExpression)
		return Result;
	Result.push_back("browLowererL");
	Result.push_back("browLowererR");
	Result.push_back("cheekPuffL");
	Result.push_back("cheekPuffR");
	Result.push_back("cheekRaiseL");
	Result.push_back("cheekRaiseR");
	Result.push_back("cheekSuckL");
	Result.push_back("cheekSuckR");
	Result.push_back("chinRaise");
	Result.push_back("chinRaiseUpperlipTweak");
	Result.push_back("c_eyeDown_eyeClosedL");
	Result.push_back("c_eyeDown_eyeClosedR");
	Result.push_back("c_eyeLeft_eyeClosedL");
	Result.push_back("c_eyeLeft_eyeClosedR");
	Result.push_back("c_eyeRight_eyeClosedL");
	Result.push_back("c_eyeRight_eyeClosedR");
	Result.push_back("c_eyeUp_eyeClosedL");
	Result.push_back("c_eyeUp_eyeClosedR");
	Result.push_back("c_eyesClosed50L");
	Result.push_back("c_eyesClosed50R");
	Result.push_back("c_JawDrop");
	Result.push_back("c_squintL_cheekRaiserL");
	Result.push_back("c_squintR_cheekRaiserR");
	Result.push_back("dimplerL");
	Result.push_back("dimplerR");
	Result.push_back("eyeClosedL");
	Result.push_back("eyeClosedR");
	Result.push_back("eyeDown");
	Result.push_back("eyeLeft");
	Result.push_back("eyeOpenL");
	Result.push_back("eyeOpenR");
	Result.push_back("eyeRight");
	Result.push_back("eyeUp");
	Result.push_back("innerBrowRaiseL");
	Result.push_back("innerBrowRaiseR");
	Result.push_back("jawClench");
	Result.push_back("jawLeft");
	Result.push_back("jawOpen");
	Result.push_back("jawRight");
	Result.push_back("jawThrust");
	Result.push_back("lidTightenerL");
	Result.push_back("lipCornerDepressL");
	Result.push_back("lipCornerDepressR");
	Result.push_back("lipCornerInL");
	Result.push_back("lipCornerInR");
	Result.push_back("lipCornerPullL");
	Result.push_back("lipCornerPullR");
	Result.push_back("lipPress");
	Result.push_back("lipPucker");
	Result.push_back("lipStretchL");
	Result.push_back("lipStretchR");
	Result.push_back("lipTighten");
	Result.push_back("lipZipperL");
	Result.push_back("lipZipperR");
	Result.push_back("lowerLipDepressL");
	Result.push_back("lowerLipDepressR");
	Result.push_back("lowerLipFunnel");
	Result.push_back("lowerLipPuff");
	Result.push_back("lowerLipSuck");
	Result.push_back("lowerLipThickness");
	Result.push_back("lowerLipUpL");
	Result.push_back("lowerLipUpR");
	Result.push_back("nasolabialFurrowL");
	Result.push_back("nasolabialFurrowR");
	Result.push_back("neckFlexL");
	Result.push_back("neckFlexR");
	Result.push_back("noseDepressor");
	Result.push_back("noseWrinkleL");
	Result.push_back("noseWrinkleR");
	Result.push_back("nostrilCompressor");
	Result.push_back("nostrilDilator");
	Result.push_back("outerBrowRaiseL");
	Result.push_back("outerBrowRaiseR");
	Result.push_back("sharpLipPullL");
	Result.push_back("sharpLipPullR");
	Result.push_back("squintL");
	Result.push_back("squintR");
	Result.push_back("swallow");
	Result.push_back("upperLipDownL");
	Result.push_back("upperLipDownR");
	Result.push_back("upperLipFunnel");
	Result.push_back("upperLipPuff");
	Result.push_back("upperLipRaiseL");
	Result.push_back("upperLipRaiseR");
	Result.push_back("upperLipSuck");
	Result.push_back("upperLipThickness");
	Result.push_back("tongueCurlDown");
	Result.push_back("tongueCurlUp");
	Result.push_back("tongueDown");
	Result.push_back("tongueUp");
	Result.push_back("tongueIn");
	Result.push_back("tongueOut");
	Result.push_back("tongueLeft");
	Result.push_back("tongueRight");
	Result.push_back("tongueThick");
	Result.push_back("tongueThinner");
	Result.push_back("LookDown");
	Result.push_back("LookUp");
	Result.push_back("LookRight");
	Result.push_back("LookLeft");
	return Result;
}

/*
inline static bool CallGlobalFunctionNoWait(std::string sScriptName, std::string sFunctionName)
{
	if (sScriptName.empty() || sFunctionName.empty())
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(172743) };  // 0x2C1DAD0 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	RE::BSScript::Variable var;
	const auto                 func = reinterpret_cast<uintptr_t (*)(RE::BSScript::IVirtualMachine*, std::uint32_t, uint64_t, RE::BSFixedString*, RE::BSFixedString*, RE::BSScript::Variable*)>(addr);
	RE::BSFixedString          bsScriptName = sScriptName;
	RE::BSFixedString          bsFunctionName = sFunctionName;
	func(RE::GameVMCustom::GetSingleton()->virtualMechine, 0, 0, &bsScriptName, &bsFunctionName, &var);
	return true;
}
*/

inline static RE::Script::SCRIPT_FUNCTION* GetFirstScriptCommand()
{
    // Starfield.exe + 64883C0 in v1.12.36 Script::SCRIPT_FUNCTION*
    static REL::Relocation<unsigned long long> FirstScriptCommand{ REL::ID(841467) };
    unsigned long long                         k = FirstScriptCommand.get();
    RE::Script::SCRIPT_FUNCTION*               j = reinterpret_cast<RE::Script::SCRIPT_FUNCTION*>(k);
    if (!j) {
        LogError("found command is nullptr");
        return nullptr;
    }
    else {
        LogDebug("found script command at " + GetObjectAddressAsHex(j, true));
        return j;
    }
    return nullptr;
}

inline static RE::Script::SCRIPT_FUNCTION* GetFirstConsoleCommand()
{
    // Starfield.exe + 0x0557F0D0 in v1.8.88.0 (REL::ID = 841465). Script::SCRIPT_FUNCTION*.
    static REL::Relocation<unsigned long long> FirstConsoleCommand{ REL::ID(841465) };
    unsigned long long                         k = FirstConsoleCommand.get();
    RE::Script::SCRIPT_FUNCTION*               j = reinterpret_cast<RE::Script::SCRIPT_FUNCTION*>(k);
    if (!j) {
        LogError("found command is nullptr");
        return nullptr;
    }
    else {
        LogDebug("found console command at " + GetObjectAddressAsHex(j, true));
        return j;
    }
    return nullptr;
}

inline static std::string GetFileNameWithoutExtension(std::string sFileName)
{
	if (sFileName.empty() == false) {
		std::string sFileName02 = "";
		sFileName02 = sFileName.substr(0, sFileName.find_last_of("/."));
		return sFileName02;
	}
	return "_x";
}

inline static std::vector<std::string> GetFileNamesInDirectory(std::string sOptionalFolder = "", bool TrimFileExtension = true)
{
	std::stringstream        ssFileName;
	std::string              sFileName = "";
	std::vector<std::string> sFileNames;
	std::string              path = ".\\Data\\F4SE\\Plugins\\";
	if (sOptionalFolder.empty() == false) {
		path = sOptionalFolder;
	}
	struct stat sb;
	for (const auto& entry : std::filesystem::directory_iterator(path)) {
		std::filesystem::path outfilename = entry.path();
		std::string           outfilename_str = outfilename.string();
		const char*           path = outfilename_str.c_str();
		if (stat(path, &sb) == 0 && !(sb.st_mode & S_IFDIR) && std::filesystem::is_directory(path) == false) {
			ssFileName << path << std::endl;
			sFileName = ssFileName.str();
			if (sFileName.empty() == false) {
				std::string fileExt = "";
				auto        pos = sFileName.find_last_of(".");
				auto        requiredSize = pos + 5;
				if (pos < requiredSize) {
					fileExt = sFileName.substr(pos, 5);
					if (std::strcmp(ToLowerStr(fileExt).c_str(), ".json") != 0) {
						sFileName = sFileName + ".json";
					}
				} else {
					sFileName = sFileName + ".json";
				}
				if (std::strcmp(fileExt.c_str(), ".json") == 0) {
					sFileName = sFileName.substr(sFileName.find_last_of("/\\") + 1);
					sFileName.erase(std::remove(sFileName.begin(), sFileName.end(), '\n'), sFileName.cend());
					sFileName.erase(std::remove(sFileName.begin(), sFileName.end(), '\0'), sFileName.cend());
					if (TrimFileExtension == true) {
						sFileName = GetFileNameWithoutExtension(sFileName);
					}
					sFileNames.push_back(sFileName);
				}
			}
		}
		sFileName = "";
	}
	return sFileNames;
}

inline static float GetAerialDistance(RE::TESObjectREFR* ref1, RE::TESObjectREFR* ref2)
{
    if (ref1 && ref2) {
        auto  loc1 = ref1->data.location;
        auto  loc2 = ref2->data.location;
        float x1   = loc1.x;
        float x2   = loc2.x;
        float y1   = loc1.y;
        float y2   = loc2.y;
        float z1   = loc1.z;
        float z2   = loc2.z;
        return std::sqrt(std::pow((x2 - x1), 2) + std::pow((y2 - y1), 2) + std::pow((z2 - z1), 2));
    }
    return -1;
}

inline static RE::TESNPC* GetLeveledActorBase(RE::Actor* theActor)
{
    if (!theActor)
        return nullptr;
    auto extraListSmPtr = &theActor->extraDataList;
    if (!extraListSmPtr)
        return nullptr;
    auto extraList = theActor->extraDataList.get();
    if (!extraList)
        return nullptr;
    RE::BSExtraData* Extra = extraList->GetByType(RE::ExtraDataType::kLeveledCreature);
    if (!Extra)
        return nullptr;
    RE::ExtraLeveledCreature* LeveledActorExtra = (RE::ExtraLeveledCreature*)Extra;
    if (!LeveledActorExtra)
        return nullptr;
    auto LA = LeveledActorExtra->leveledActorBase;
    if (LA != nullptr) {
        return LA;
    }
    return nullptr;
}

inline static RE::TESNPC* GetActorBase(RE::Actor* theActor)
{
    if (theActor && theActor->GetBaseObject()) {
        RE::TESNPC* theActorBase = (RE::TESNPC*)theActor->GetBaseObject();
        if (theActorBase)
            return theActorBase;
    }
    return nullptr;
}

inline static RE::TESNPC* GetFaceNPC(RE::TESNPC* theActorBase)
{
	/*
    if (!theActorBase)
        return nullptr;
    //auto faceNPCPtrAddr = reinterpret_cast<uintptr_t>(theActorBase) + 0x340;
	auto faceNPCPtrAddr = reinterpret_cast<uintptr_t>(theActorBase) + 0x348;	// since v1.14.70
    if (!faceNPCPtrAddr) {
        LogDebug("result --> [nullptr, no faceNPCPtrAddr] | params: theActorBase " + GetBasicFormData(theActorBase));
        return nullptr;
    }
    auto faceNPCAddrPtr = reinterpret_cast<uintptr_t*>(faceNPCPtrAddr);
    if (!faceNPCAddrPtr) {
        LogDebug("result --> [nullptr, no faceNPCAddrPtr] | params: theActorBase " + GetBasicFormData(theActorBase));
        return nullptr;
    }
    auto faceNPCAddr = *faceNPCAddrPtr;
    if (!faceNPCAddr) {
        LogDebug("result --> [nullptr, no faceNPCAddr] | params: theActorBase " + GetBasicFormData(theActorBase));
        return nullptr;
    }
    auto npc = reinterpret_cast<RE::TESNPC*>(faceNPCAddr);
    LogDebug("result --> " + GetBasicFormData(npc) + " | params: theActorBase " + GetBasicFormData(theActorBase));
    return npc;
	*/
	if (theActorBase) {  // new design since v1.14.70
		try {
			return theActorBase->faceNPC;
		} catch (...) {
			;
		}
	}
	return nullptr;
}

inline static RE::TESNPC* GetAppearanceSource(RE::Actor* theActor, bool* bIsTemplated = nullptr)
{
	if (!theActor)
		return nullptr;
	auto baseNPC = (RE::TESNPC*)theActor->GetBaseObject();
	if (!baseNPC)
		return nullptr;
	//return GetFaceNPC(baseNPC);
	if (GetLeveledActorBase(theActor)) {
		if (bIsTemplated)
			*bIsTemplated = true;
		return GetFaceNPC(baseNPC);
	}
	return baseNPC;
}

inline static int GetSex(RE::Actor* theActor)
{
	if (!theActor)
		return -1;
	auto baseForm = theActor->GetBaseObject();
	if (!baseForm)
		return -1;
	auto baseNPC = (RE::TESNPC*)baseForm;
	if (!baseNPC)
		return -1;
	if (baseNPC->faceNPC)
		return baseNPC->faceNPC->GetSex();
	return baseNPC->GetSex();
}

inline static RE::TESPackedFile* LookupTESFileByHexFormID(std::string hexFormID, int* pluginType)
{
    LogDebug("called | hexFormID [" + hexFormID + "]");
    if (!pluginType) {
        LogError("pluginType is nullptr");
        return nullptr;
    }
    if (hexFormID.size() != 8) {
        LogError("hexFormID.size != 8 | hexFormID [" + hexFormID + "] size [" + std::to_string(hexFormID.size()) + "]");
        return nullptr;
    }
    RE::TESDataHandler* dataHandler = RE::TESDataHandler::GetSingleton();
    if (!dataHandler) {
        LogError("dataHandler is nullptr");
        return nullptr;
    }
	std::string hexFormIDFull = hexFormID;
    if ((hexFormID.at(0) == 'F' || hexFormID.at(0) == 'f') && (hexFormID.at(1) == 'D' || hexFormID.at(1) == 'd')) {
        hexFormID = hexFormID.substr(0, 4);
    }
    else if ((hexFormID.at(0) == 'F' || hexFormID.at(0) == 'f') && (hexFormID.at(1) == 'E' || hexFormID.at(1) == 'e')) {
        hexFormID = hexFormID.substr(0, 5);
    }
    else {
        hexFormID = hexFormID.substr(0, 2);
    }
    hexFormID                 = ToLowerStr(hexFormID);
    std::vector<std::string> returnLines;
    for (uint32_t Index = 0; Index <= 2; Index++) {
        BSTArrayCustom<RE::TESPackedFile*>* theFiles = nullptr;
        if (Index == 0) {
            theFiles = reinterpret_cast<BSTArrayCustom<RE::TESPackedFile*>*>(&dataHandler->CompiledFileCollection.FileA);
        }
        else if (Index == 1) {
            theFiles = reinterpret_cast<BSTArrayCustom<RE::TESPackedFile*>*>(&dataHandler->CompiledFileCollection.SmallFileA);
        }
        else if (Index == 2) {
            theFiles = reinterpret_cast<BSTArrayCustom<RE::TESPackedFile*>*>(&dataHandler->CompiledFileCollection.MediumFileA);
        }
        if (!theFiles) {
            if (Index == 0) {
                LogWarning("theFiles (FileA) is nullptr, skipping this file array");
                continue;
            }
            else if (Index == 1) {
                LogWarning("theFiles (SmallFileA) is nullptr, skipping this file array");
                continue;
            }
            else if (Index == 2) {
                LogWarning("theFiles (MediumFileA) is nullptr, skipping this file array");
                continue;
            }
        }
        if (theFiles->size() <= 0) {
            if (Index == 0) {
                LogWarning("theFiles.size() (of FileA) <= 0, skipping this file array");
                continue;
            }
            else if (Index == 1) {
                LogWarning("theFiles.size() (of SmallFileA) <= 0, skipping this file array");
                continue;
            }
            else if (Index == 2) {
                LogWarning("theFiles.size() (of MediumFileA) <= 0, skipping this file array");
                continue;
            }
        }
		// LogInfo("beginning loop...");
for (uint32_t i = 0; i < theFiles->size(); i++) {
	auto loopFile = theFiles->at(i);
	if (!loopFile) {
		LogError("loopFile at (" + std::to_string(i) + ") is nullptr, skipping plugin file");
		continue;
	}
	auto        filePath = loopFile->filePath;
	std::string sFilePath = "";
	if (filePath) {
		sFilePath = filePath;
	}
	if (sFilePath.size() > 4) {
		std::string sLOPrefix;
		if (std::strcmp(sFilePath.c_str(), "Starfield.esm") == 0) {
			sLOPrefix = "00";
		}
		else {
			if (Index < 2)
				sLOPrefix = GetUIntFormIDAsHex((loopFile->cCompileIndex << 24) + (loopFile->sSmallFileCompileIndex << 12));
			else
				sLOPrefix = GetUIntFormIDAsHex((loopFile->cCompileIndex << 24) + (loopFile->cCompileIndex2 << 16));
			if (sLOPrefix.size() < 8) { // should be always 8 as it returned by GetUIntFormIDAsHex
				LogError("load order prefix couldn't be acquired for plugin file [" + GetObjectAddressAsHex(loopFile) + "] is empty, skipping plugin file [" + sFilePath + "]");
				continue;
			}
			if (Index == 1)
				sLOPrefix.erase(sLOPrefix.length() - 3);
			else if (Index == 2)
				sLOPrefix.erase(sLOPrefix.length() - 4);
			else
				sLOPrefix.erase(sLOPrefix.length() - 6);
		}
		if (std::strcmp(ToLowerStr(sLOPrefix).c_str(), hexFormID.c_str()) != 0) {
			LogDebug("sLOPrefix [" + sLOPrefix + "] is not (target prefix [" + hexFormID + "] of) hexFormID [" + hexFormIDFull + "], skipping plugin file [" + sFilePath + "]");
			continue;
		}
		LogDebug("sLOPrefix [" + sLOPrefix + "] is (target prefix [" + hexFormID + "] of) hexFormID [" + hexFormIDFull + "], returning plugin file [" + sFilePath + "]");
		if (Index == 0) {
			*pluginType = 1;
		}
		else if (Index == 1) {
			*pluginType = 2;
		}
		else if (Index == 2) {
			*pluginType = 3;
		}
		return loopFile;
	}
	else {
		LogError("name of plugin file [" + GetObjectAddressAsHex(loopFile) + "] is empty, skipping plugin file");
		continue;
	}
}
	}
	LogDebug("no TESFile could be found for target prefix [" + hexFormID + "] of hexFormID [" + hexFormIDFull + "]");
	return nullptr;
}

inline static RE::TESPackedFile* GetTESFileByModIndex(uint16_t* modindex, bool bReturnSourcePlugin = false) // "last overrider file" ( mod index is uint16_t since v1.14.70 )
{
	// 	(bReturnSourcePlugin must be set to false to return the last overrider in v1.13.61; in v1.12.36 this parameter wasn't needed to be speficied at all to get the last overrider...)
	if (!modindex)
		return nullptr;
	// REL::Relocation<uintptr_t> funcPtr{ REL::ID(1077894) }; // 0x14A12F0 in v1.12.36
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(1077899) }; // 0x14C8BA0 in v1.12.36
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<RE::TESPackedFile * (*)(uint16_t*, bool)>(addr);
	int64_t                    unk = 0;
	auto                       result = func(modindex, bReturnSourcePlugin);
	LogDebug("result --> " + GetObjectAddressAsHex(result) + " | params: modindex " + std::to_string(*modindex));
	return result;
}

inline static RE::TESPackedFile* GetTESFile(RE::TESForm* theForm, bool bReturnSourcePlugin = false)
{
	if (!theForm)
		return nullptr;
	return GetTESFileByModIndex(reinterpret_cast<uint16_t*>(reinterpret_cast<uintptr_t>(theForm) + 0x30), bReturnSourcePlugin);
}

inline static std::string LookupLastOverriderPlugin(RE::TESForm* theForm)
{
	if (!theForm)
		return "";
	auto file = GetTESFile(theForm, false);
	if (!file)
		return "";
	return file->filePath;
}

inline static std::string LookupSourcePlugin(RE::TESForm* theForm)
{
	if (!theForm)
		return "";
	auto file = GetTESFile(theForm, true);
	if (!file)
		return "";
	return file->filePath;
}

inline static std::map<uint32_t, RE::TESForm*> GetAllFormsMapAsSTDMap()
{
	std::map<uint32_t, RE::TESForm*> Result;
	const auto& [map, lock] = RE::TESForm::GetAllForms();
	RE::BSAutoReadLock l{ lock };
	if (map) {
		for (auto it = map->begin(); it != map->end(); ++it) {
			Result.try_emplace(it.operator*().Key, it.operator*().Value);
		}
	}
	return Result;
}

inline static bool PrintAllFormsMapToFile()
{
	const auto& [map, lock] = RE::TESForm::GetAllForms();
	RE::BSAutoReadLock l{ lock };
	if (!map)
		return false;
	std::string   fileName = "AllFormsMap_" + GetCurrentTimeAndDate(true) + ".txt";
	std::ofstream log(fileName, std::ios_base::app | std::ios_base::out);
	if (!log.is_open()) {
		LogError("std::ofstream error: !log.is_open()");
		return false;
	}
	if (log.fail()) {
		LogError("std::ofstream error: log.fail()");
		return false;
	}
	if (log.bad()) {
		LogError("std::ofstream error: log.bad()");
		return false;
	}
	size_t counter = 0;
	for (auto it = map->begin(); it != map->end(); ++it) {
		auto LoopForm = it.operator*().Value;
		if (LoopForm) {
			std::string sLog = "(" + std::to_string(counter) + ") | " + GetObjectAddressAsHex(LoopForm) + " [" + std::to_string(LoopForm->GetFormType()) + "] | [" + GetUIntFormIDAsHex(it.operator*().Key) + "]";
			log << sLog + "\n";
		}
		counter = counter + 1;
	}
	log.close();
	return true;
}

template <class T>
inline static std::vector<T*> GetAllFormsByType(int iFormType, std::string sLastOverriderPlugin = "")
{
	std::vector<T*> Result;
	if (iFormType < 0 || iFormType > static_cast<int>(RE::FormType::kGPOG))
		return Result;
	auto DataHandler = RE::TESDataHandler::GetSingleton();
	if (!DataHandler)
		return Result;
	if (iFormType == static_cast<int>(RE::FormType::kCELL)) {
		const auto& [map, lock] = RE::TESForm::GetAllForms();
		RE::BSAutoReadLock l{ lock };
		if (map) {
			for (auto it = map->begin(); it != map->end(); ++it) {
				auto LoopForm = it.operator*().Value;
				if (LoopForm && LoopForm->GetFormType() == RE::FormType::kCELL) {
					auto typedForm = reinterpret_cast<T*>(LoopForm);
					if (typedForm)
						Result.push_back(typedForm);
				}
			}
		}
		return Result;
	}
	auto AllFormsOfType = GetAsBSTArrayCustom(&DataHandler->pFormArray[iFormType].formArray);
	if (!AllFormsOfType)
		return Result;
	bool bLastOverriderDefined = !sLastOverriderPlugin.empty();
	for (auto& it : *AllFormsOfType) {
		if (!it)
			continue;
		auto form = it.get();
		if (!form)
			continue;
		auto typedForm = reinterpret_cast<T*>(form);
		if (!typedForm)
			continue;
		if (!bLastOverriderDefined)
			Result.push_back(typedForm);
		else {
			std::string lastOverrider = LookupLastOverriderPlugin(typedForm);
			if (!lastOverrider.empty() && std::strcmp(ToLowerStr(lastOverrider).c_str(), ToLowerStr(sLastOverriderPlugin).c_str()) == 0)
				Result.push_back(typedForm);
		}
	}
	return Result;
}

inline static std::vector<RE::TESObjectCELL*> GetLoadedCells()  // SEH exceptions
{
	std::vector<RE::TESObjectCELL*> Result;
	auto                            tes = RE::TESCustom::GetSingleton();
	std::string                     lastAddr;
	try {
		if (!tes || tes->loadedCellDB == 0)
			return Result;
		uintptr_t firstDBAddr = tes->loadedCellDB;
		uintptr_t currDBAddr = firstDBAddr;
		//LogInfo("firstDBAddr : " + GetAddressAsHex(firstDBAddr));
		for (uint32_t i = 0; i < 50; i++) {
			auto cellDB = reinterpret_cast<uintptr_t*>(currDBAddr);
			//LogInfo("loop at (" + std::to_string(i) + ")  -->  currAddr " + GetAddressAsHex(currDBAddr));
			currDBAddr = currDBAddr + 0x8;
			if (!cellDB)
				continue;
			//LogInfo("loop at (" + std::to_string(i) + ")  -->  *cellDB " + GetAddressAsHex(*cellDB));
			auto cellAddrPtr = reinterpret_cast<uintptr_t*>(*cellDB + 0x30);
			if (!cellAddrPtr)
				continue;
			if (*cellAddrPtr <= 10000000000 || *cellAddrPtr >= StarfieldBaseAddress)
				continue;
			//LogInfo("loop at (" + std::to_string(i) + ")  -->  cellAddr " + GetAddressAsHex(*cellAddrPtr));
			auto cell_vTableAddrPtr = reinterpret_cast<uintptr_t*>(*cellAddrPtr);
			if (!cell_vTableAddrPtr || *cell_vTableAddrPtr <= StarfieldBaseAddress)
				continue;
			//LogInfo("loop at (" + std::to_string(i) + ")  -->  cell_vTableAddr " + GetAddressAsHex(*cell_vTableAddrPtr));
			for (auto& j : RE::VTABLE::TESObjectCELL) {
				if (j.address() == *cell_vTableAddrPtr) {
			auto cell = reinterpret_cast<RE::TESObjectCELL*>(*cellAddrPtr);
			//LogInfo("loop at (" + std::to_string(i) + ")  -->  IS cell " + GetObjectAddressAsHex(cell));
			Result.push_back(cell);
				}
			}
		}
	} catch (...) {
		//LogError("exception : lastAddr " + lastAddr);
	}
	auto PlayerParentCell = RE::PlayerCharacter::GetSingleton()->parentCell;
	if (std::find(std::begin(Result), std::end(Result), PlayerParentCell) == Result.end())
		Result.push_back(PlayerParentCell);
	return Result;
}

inline static float GetGlobalTimeMultiplier()
{
	//  ( 0x5F5B700 in v1.12.36 or 0x6034980 in v1.13.61 is 763331 which returns the "target multiplier", so if we SetGlobalTimeMultiplier to 0.5, then 0.5 immediatelly)
	//  REL::ID 763332 returns the actual multiplier
	REL::Relocation<uintptr_t> timeMultiplierReloc{ REL::ID(763332) };  // 0x603497C in v1.13.61
	uintptr_t                  timeMultiplierAddr = timeMultiplierReloc.address();
	auto                       timeMultiplierPtr = reinterpret_cast<float*>(timeMultiplierAddr);
	if (!timeMultiplierPtr)
		return -1.00f;
	return *timeMultiplierPtr;
}

inline static float GetGlobalTimeMultiplierTarget()
{
	//  ( 0x5F5B700 in v1.12.36 or 0x6034980 in v1.13.61 is 763331 which returns the "target multiplier", so if we SetGlobalTimeMultiplier to 0.5, then 0.5 immediatelly)
	//  REL::ID 763332 returns the actual multiplier
	REL::Relocation<uintptr_t> timeMultiplierReloc{ REL::ID(763331) };  // 0x6034980 in v1.13.61
	uintptr_t                  timeMultiplierAddr = timeMultiplierReloc.address();
	auto                       timeMultiplierPtr = reinterpret_cast<float*>(timeMultiplierAddr);
	if (!timeMultiplierPtr)
		return -1.00f;
	return *timeMultiplierPtr;
}

inline static bool SetGlobalTimeMultiplierRAW(float fValue) {
	if (fValue < 0.0f || fValue > 100.0f)
		return false;
	REL::Relocation<uintptr_t> timeMultiplierReloc{ REL::ID(763331) };  // 0x5F5B700 in v1.12.36
	uintptr_t                  timeMultiplierAddr = timeMultiplierReloc.address();
	auto                       timeMultiplierPtr = reinterpret_cast<float*>(timeMultiplierAddr);
	if (!timeMultiplierPtr)
		return false;
	*timeMultiplierPtr = fValue;
	return true;
}

inline static void SetGlobalTimeMultiplier(float fGlobalTimeMultiplier, float fPlayerRelativeTimeMultiplier)
{
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(156294) };  // 0x280B25C in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<void (*)(uintptr_t, float, float)>(addr);
	func(0, fGlobalTimeMultiplier, fPlayerRelativeTimeMultiplier);
}

inline static bool SpawnDupe(RE::TESObjectREFR* theRef) {
	if (!theRef)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(110662) };		// 0x1B62DFC in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(uintptr_t, uintptr_t, RE::TESObjectREFR*)>(addr);
	return func(0, 0, theRef);
}

inline static bool MarkForDelete(RE::TESObjectREFR* theRef)
{
	if (!theRef)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(109975) };  // 0x1B2A7FC in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<bool (*)(uintptr_t, uintptr_t, RE::TESObjectREFR*)>(addr);
	return func(0, 0, theRef);
}

inline static bool ForcePersistent(RE::TESObjectREFR* theRef, bool bPersist, bool bSilent = true)
{
	if (!theRef)
		return false;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(110478) };  // 0x1B56194 in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	std::vector<BYTE>          consoleLogFuncCallBytes;
	if (bSilent) {
		consoleLogFuncCallBytes = ReadBytes(addr + 0x8F, 5);	// distance between the function address and the ConsoleLog call "(RefID) is now forced to be persistent" is 0x8F in v1.13.61 and v1.8.88 too
		if (consoleLogFuncCallBytes.size() != 5) {
			LogError("read bytes error (01)");
		} else {
			std::vector<BYTE> nop = { 0x90, 0x90, 0x90, 0x90, 0x90 };
			if (!WriteBytes(nop, addr + 0x8F)) {
				LogError("write bytes error (01)");
			}
		}
	}
	const auto                 func = reinterpret_cast<bool (*)(uintptr_t, uintptr_t, RE::TESObjectREFR*)>(addr);
	func(0, 0, theRef);
	if (bSilent) {
		if (consoleLogFuncCallBytes.size() != 5) {
			LogError("read bytes error (02)");
		} else {
			if (!WriteBytes(consoleLogFuncCallBytes, addr + 0x8F)) {
				LogError("write bytes error (02)");
			}
		}
	}
	return true;
}

inline static void Disable(RE::TESObjectREFR* theRef, bool bEnableState = false) {
	if (theRef) {
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(109212) };  // 0x1B15D60 in v1.14.70
		uintptr_t                  addr = funcPtr.address();
		const auto                 func = reinterpret_cast<void (*)(RE::TESObjectREFR*, bool)>(addr);
		func(theRef, bEnableState);
	}	
}

inline static void GameFadeOutFadeIn(char a1, char a2, float fFadeInFadeOutTime, char a4, float fWaitBeforeFadeTime, int64_t a6, char a7, int a8)
{                                                           // LoadScreenEndFunc params: GameFadeInFadeBack(0,1,uVar8,0,CONCAT44(uVar14,uVar1),0,1,4)
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(167295) };  // 0x2A7753C in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<uintptr_t (*)(char, char, float, char, float, int64_t, char, int)>(addr);
	func(a1, a2, fFadeInFadeOutTime, a4, fWaitBeforeFadeTime, a6, a7, a8);
}

inline static bool HasPromotedRefExtra(RE::TESObjectREFR* theRef)
{
	if (!theRef)
		return false;
	auto extraList = theRef->extraDataList.get();
	if (!extraList)
		return false;
	auto PromotedRefExtra = (RE::ExtraPromotedRef*)extraList->GetByType(RE::ExtraDataType::kPromotedRef);
	if (PromotedRefExtra)
		return true;
	return false;
}

inline static bool DoesNotHaveAliasExtraAndPromotedRefExtra(RE::TESObjectREFR* theRef)
{
	if (!theRef)
		return false;
	auto extraList = theRef->extraDataList.get();
	if (!extraList)
		return false;
	auto PromotedRefExtra = (RE::ExtraPromotedRef*)extraList->GetByType(RE::ExtraDataType::kPromotedRef);
	if (PromotedRefExtra)
		return false;
	auto AliasInstanceExtra = (RE::ExtraAliasInstanceArray*)extraList->GetByType(RE::ExtraDataType::kAliasInstanceArray);
	if (AliasInstanceExtra)
		return false;
	return true;
}

inline static RE::TESObjectCELL* GetExtraPersistentCell(RE::TESObjectREFR* theRef)
{
	if (!theRef)
		return nullptr;
	auto extraList = theRef->extraDataList.get();
	if (!extraList)
		return nullptr;
	auto Extra = (RE::ExtraPersistentCell*)extraList->GetByType(RE::ExtraDataType::kPersistentCell);
	if (Extra)
		return Extra->extraCell;
	return nullptr;
}

inline static bool HasExtraHeadingTargetExtra(RE::TESObjectREFR* theRef)
{
	if (!theRef)
		return false;
	auto extraList = theRef->extraDataList.get();
	if (!extraList)
		return false;
	auto PromotedRefExtra = (RE::ExtraHeadingTarget*)extraList->GetByType(RE::ExtraDataType::kHeadingTarget);
	if (PromotedRefExtra)
		return true;
	return false;
}

inline static std::vector<RE::TESObjectREFR*> GetReferencesInCell(RE::TESObjectCELL* theCell)
{
	std::vector<RE::TESObjectREFR*> Result;
	if (!theCell)
		return Result;
	auto cellRefs = GetAsBSTArrayCustom(&theCell->references);
	if (!cellRefs)
		return Result;
	for (auto& it : *cellRefs) {
		auto ref = it.get();
		if (!ref)
			continue;
		Result.push_back(ref);
	}
	return Result;
}

inline static uint32_t GetRefBaseObjectCountInCell(RE::TESObjectREFR* theRef, std::vector<RE::TESObjectREFR*> cellRefs, float fMaxDistance = -1.0f)
{
	if (!theRef || cellRefs.size() == 0)
		return 0;
	auto     baseObject = theRef->GetBaseObject();
	if (!baseObject)
		return 0;
	uint32_t count = 0;
	for (auto& i : cellRefs) {
		if (!i)
			continue;
		auto base = i->GetBaseObject();
		if (base && base == baseObject) {
			if (fMaxDistance == -1.0f || GetDistance(i, theRef) <= fMaxDistance)
				count = count + 1;
		}			
	}
	return count;
}

inline static std::vector<RE::TESObjectREFR*> GetLoadedReferences()
{
	std::vector<RE::TESObjectREFR*> Result;
	auto                            loadedCells = GetLoadedCells();
	for (uint32_t i = 0; i < loadedCells.size(); i++) {
		auto cell = loadedCells.at(i);
		if (!cell)
			continue;
		auto cellRefs = GetAsBSTArrayCustom(&cell->references);
		if (!cellRefs)
			return Result;
		for (auto& it : *cellRefs) {
			auto ref = it.get();
			if (!ref)
				continue;
			Result.push_back(ref);
		}
	}
	if (Result.size() > 0) {
		std::sort(Result.begin(), Result.end());
		Result.erase(std::unique(Result.begin(), Result.end()), Result.end());
	}
	return Result;
}

inline static std::vector<RE::SpellItem*> GetSpells(RE::Actor* theActor)
{
	std::vector<RE::SpellItem*> Result;
	if (!theActor)
		return Result;
	auto ActiveEffectListAddress = theActor->GetActiveEffectList();
	if (ActiveEffectListAddress <= 10000000000 || ActiveEffectListAddress >= StarfieldBaseAddress)
		return Result;
	RE::Custom::ActiveEffectList* ActiveEffectList = reinterpret_cast<RE::Custom::ActiveEffectList*>(ActiveEffectListAddress);
	if (!ActiveEffectList)
		return Result;
	auto list = &ActiveEffectList->data;
	if (!list)
		return Result;
	for (auto& it : *list) {
		auto sourceEffect = it->sourceEffect;
		if (!sourceEffect)
			continue;
		RE::TESForm* SpellForm = RE::TESForm::LookupByID(sourceEffect->formID);
		if (SpellForm && SpellForm->GetSavedFormType() == 28)
			Result.push_back((RE::SpellItem*)SpellForm);
	}
	return Result;
}

inline static std::vector<RE::TESFaction*> GetFactions(RE::Actor* theActor)
{
	std::vector<RE::TESFaction*> Result;
	if (!theActor)
		return Result;
	auto AllFormsOfType = GetAllFormsByType<RE::TESFaction>(13);
	if (AllFormsOfType.size() == 0)
		return Result;
	for (auto& it : AllFormsOfType) {
		if (it && theActor->IsInFaction(it))
			Result.push_back(it);
	}
	return Result;
}

inline static std::vector<RE::BGSKeyword*> GetKeywords(RE::TESObjectREFR* theRef)
{
	std::vector<RE::BGSKeyword*> Result;
	if (!theRef)
		return Result;
	auto AllFormsOfType = GetAllFormsByType<RE::BGSKeyword>(4);
	if (AllFormsOfType.size() == 0)
		return Result;
	for (auto& it : AllFormsOfType) {
		if (it && theRef->HasKeyword(it))
			Result.push_back(it);
	}
	return Result;
}

inline static std::vector<RE::EffectSetting*> GetMagicEffects(RE::Actor* theActor)
{
	std::vector<RE::EffectSetting*> Result;
	if (!theActor)
		return Result;
	auto ActiveEffectListAddress = theActor->GetActiveEffectList();
	if (ActiveEffectListAddress <= 10000000000 || ActiveEffectListAddress >= StarfieldBaseAddress)
		return Result;
	RE::Custom::ActiveEffectList* ActiveEffectList = reinterpret_cast<RE::Custom::ActiveEffectList*>(ActiveEffectListAddress);
	if (!ActiveEffectList)
		return Result;
	auto list = &ActiveEffectList->data;
	if (!list)
		return Result;
	for (auto& it : *list) {
		auto sourceEffect = it->sourceEffect;
		if (!sourceEffect || sourceEffect->effectList.size() == 0)
			continue;
		for (int i = 0; i < sourceEffect->effectList.size(); i++) {
			auto effectSetting = sourceEffect->effectList.at(i)->effectSetting;
			if (effectSetting)
				Result.push_back(effectSetting);
		}
	}
	return Result;
}

inline static uint32_t GetTESFileSubIndex(const RE::TESPackedFile* file)
{
    if (!file)
        return -1;
    if (!file->IsActive())
        return -1;
    if (file->IsLight()) {
        return file->sSmallFileCompileIndex;
    }
    else if (file->IsMedium()) {
        int32_t foundIndex = -1;
        auto    mediumMasters = GetAsBSTArrayCustom(&RE::TESDataHandler::GetSingleton()->CompiledFileCollection.MediumFileA);
        if (!mediumMasters || mediumMasters->size() == 0)
            return -1;
        for (uint32_t i = 0; i < mediumMasters->size(); ++i) {
            if (file == mediumMasters->at(i)) {
                foundIndex = i;
                break;
            }
        }
        return foundIndex;
    }
    return file->cCompileIndex;
}

inline static std::string GetPluginTypeAsStr(RE::TESPackedFile* theFile)
{
    if (!theFile)
        return "!!!ERROR!!!";
    if (theFile->IsLight())
        return "Small";
    else if (theFile->IsMedium())
        return "Medium";
    else
        return "Full";
}

inline static std::string GetPluginTypeByIntAsStr(int iPluginType)
{
    if (iPluginType == 1)
        return "Full";
    else if (iPluginType == 2)
        return "Small";
    else if (iPluginType == 3)
        return "Medium";
    else
        return "Unknown";
}

inline static int GetPluginTypeAsInt(RE::TESPackedFile* theFile)
{
   if (!theFile)
        return 0;
    if (theFile->IsLight())
        return 2;
    else if (theFile->IsMedium())
        return 3;
    else
        return 1;
}

inline static int GetPluginTypeByName(std::string sName)
{
	if (sName.empty())
		return false;
	auto DataHandler = RE::TESDataHandler::GetSingleton();
	if (!DataHandler)
		return false;
	for (int j = 1; j <= 3; j++) {
		BSTArrayCustom<RE::TESPackedFile*>* theArray = nullptr;
		if (j == 1)
			theArray = GetAsBSTArrayCustom(&DataHandler->CompiledFileCollection.FileA);
		else if (j == 2)
			theArray = GetAsBSTArrayCustom(&DataHandler->CompiledFileCollection.SmallFileA);
		else if (j == 3)
			theArray = GetAsBSTArrayCustom(&DataHandler->CompiledFileCollection.MediumFileA);
		if (theArray) {
			for (int i = 0; i < theArray->size(); i++) {
				auto file = theArray->at(i);
				if (!file)
					continue;
				std::string filename = file->filePath;
				if (filename.empty())
					continue;
				if (std::strcmp(ToLowerStr(filename).c_str(), ToLowerStr(std::string(sName.c_str())).c_str()) == 0) {
					return j;
				}
			}
		}
	}
	return -1;
}

inline static std::string GetLoadOrderPrefixAsStr(RE::TESPackedFile* file)
{
	if (!file)
		return "-01";
	std::string sFilePath = std::string(file->filePath);
	if (sFilePath.empty())
		return "-01";
	std::string sLOPrefix;
	if (std::strcmp(sFilePath.c_str(), "Starfield.esm") == 0) {
		sLOPrefix = "00";
	} else {
		auto PluginType = GetPluginTypeAsInt(file);
		if (PluginType < 1 || PluginType > 3)
			return "-01";
		if (PluginType < 3)
			sLOPrefix = GetUIntFormIDAsHex((file->cCompileIndex << 24) + (file->sSmallFileCompileIndex << 12));
		else
			sLOPrefix = GetUIntFormIDAsHex((file->cCompileIndex << 24) + (file->cCompileIndex2 << 16));
		if (sLOPrefix.size() < 8) {  // should be always 8 as it returned by GetUIntFormIDAsHex
			return "-01";
		}
		if (PluginType == 2)
			sLOPrefix.erase(sLOPrefix.length() - 3);
		else if (PluginType == 3)
			sLOPrefix.erase(sLOPrefix.length() - 4);
		else
			sLOPrefix.erase(sLOPrefix.length() - 6);
	}
	return sLOPrefix;
}

inline static std::string GetRAWHexFormID(std::string HexFormID, int PluginType) {
	if (HexFormID.size() < 8 || PluginType < 1 || PluginType > 3)
		return "";
	if (PluginType == 3) {
		HexFormID = HexFormID.substr(4, HexFormID.size() - 1);
	} else if (PluginType == 2) {
		HexFormID = HexFormID.substr(5, HexFormID.size() - 1);
	} else if (PluginType == 1) {
		HexFormID = HexFormID.substr(2, HexFormID.size() - 1);
	}
	return HexFormID;
}

inline static std::string GetPluginFileAuthorName(RE::TESPackedFile* file)
{
	if (!file)
		return "";
	auto pluginFileAddr = reinterpret_cast<uintptr_t>(file) + 0x21C;
	if (pluginFileAddr <= 10000000000 || pluginFileAddr >= StarfieldBaseAddress) {
		//	LogError("pluginFileAddr is out of range: " + GetAddressAsHex(pluginFileAddr));
		return "";
	}
	RE::BSString* bsAuthorName = reinterpret_cast<RE::BSString*>(&pluginFileAddr);
	if (!bsAuthorName)
		return "";
	auto chAuthorName = bsAuthorName->Get();
	if (!chAuthorName) 
		return "";
	return chAuthorName;
}

struct OverwrittenPluginData
{
    std::string PluginName{ "" };
    int         OverwrittenFormCount{ 0 };
	std::vector<std::string> OverwrittenFormHexFormIDs{};
};

struct PluginData
{
    std::string PluginName{ "" };
	std::string AuthorName{ "" };
    std::vector<std::string> Masters{};
//	std::vector<uint8_t>     ModIndexes{ 0 };  // occupied mod indexes
	std::vector<uint16_t>               ModIndexes{ 0 };  // occupied mod indexes	// 1.14.70
	std::vector<std::string>              PluginFlags{ };  // occupied mod indexes
	std::string                        PluginFlagsRAW{ 0 };
	std::string              LoadOrderPrefix{ "" };   // 0E, or FD001
	std::vector<std::string>              HexFormIDs{};		// forms defined in this plugin
    int         RecordCount{ 0 };
    float       Version{ 0 };
    int         PluginType{ 0 };
    std::vector<OverwrittenPluginData> OverwrittenPlugins{};

};

inline static uint16_t GetHighestModIndexInPluginData(PluginData* plugin)
{
	if (!plugin)
		return false;
	auto highestModIndex = *std::max_element(plugin->ModIndexes.begin(), plugin->ModIndexes.end());
	return highestModIndex;
}

inline static int32_t GetHighestModIndex() {
	REL::Relocation<uintptr_t> ptr{ REL::ID(1171737) };  // 0x6452970 in v1.12.36
	uintptr_t                  ptrAddr = ptr.address();
	auto                       valuePtr = reinterpret_cast<uint32_t*>(ptrAddr);
	if (!valuePtr)
		return -1;
	return *valuePtr - 1;
}

inline static int32_t GetModIndexCount()
{
	REL::Relocation<uintptr_t> ptr{ REL::ID(1171737) };  // 0x6452970 in v1.12.36
	uintptr_t                  ptrAddr = ptr.address();
	auto                       valuePtr = reinterpret_cast<uint32_t*>(ptrAddr);
	if (!valuePtr)
		return -1;
	return *valuePtr;
}

inline static int GetActivePluginCount()
{
	auto DataHandler = RE::TESDataHandler::GetSingleton();
	if (DataHandler)
		return (DataHandler->CompiledFileCollection.FileA.size() + DataHandler->CompiledFileCollection.MediumFileA.size() + DataHandler->CompiledFileCollection.SmallFileA.size());
	return -1;
}

inline static std::vector<std::string> GetActivePluginNames(std::vector<int> validPluginTypes)
{
	std::vector<std::string> Result;
	if (validPluginTypes.size() == 0)
		return Result;	
	auto                     DataHandler = RE::TESDataHandler::GetSingleton();
	if (!DataHandler)
		return Result;
	bool bCanReturnFull = std::find(std::begin(validPluginTypes), std::end(validPluginTypes), 1) < validPluginTypes.end();
	bool bCanReturnSmall = std::find(std::begin(validPluginTypes), std::end(validPluginTypes), 2) < validPluginTypes.end();
	bool bCanReturnMedium = std::find(std::begin(validPluginTypes), std::end(validPluginTypes), 3) < validPluginTypes.end();
	for (int j = 1; j <= 3; j++) {
		BSTArrayCustom<RE::TESPackedFile*>* theArray = nullptr;
		if (j == 1 && bCanReturnFull)
			theArray = GetAsBSTArrayCustom(&DataHandler->CompiledFileCollection.FileA);
		else if (j == 2 && bCanReturnSmall)
			theArray = GetAsBSTArrayCustom(&DataHandler->CompiledFileCollection.SmallFileA);
		else if (j == 3 && bCanReturnMedium)
			theArray = GetAsBSTArrayCustom(&DataHandler->CompiledFileCollection.MediumFileA);
		if (theArray) {
			for (int i = 0; i < theArray->size(); i++) {
				auto file = theArray->at(i);
				if (!file)
					continue;
				std::string filename = file->filePath;
				if (!filename.empty())
					Result.push_back(filename);
			}
		}
	}
	return Result;
}

inline static std::uint32_t GetPridRefHandle() {		// does not work with cursor selected ref
	REL::Relocation<uintptr_t> ptr{ REL::ID(831310) };  // 0x64531e4 in v1.12.36
	uintptr_t                  ptrAddr = ptr.address();
	auto                       valuePtr = reinterpret_cast<uint32_t*>(ptrAddr);
	if (!valuePtr)
		return -1;
	return *valuePtr;
}

inline static RE::TESObjectREFR* GetPridRef()		   // does not work with cursor selected ref
{
	return RE::GetReferenceByHandle(GetPridRefHandle());
}

inline static RE::TESObjectREFR* GetConsoleRef()
{
	return RE::GetReferenceByHandle(RE::ConsoleLog::GetSingleton()->pickedRefHandle);
}

inline static void ConsolePrint(std::string sText, RE::ConsoleLog* ConsoleLogPassThru = nullptr) {
	if (!ConsoleLogPassThru)
		ConsoleLogPassThru = RE::ConsoleLog::GetSingleton();
	ConsoleLogPassThru->Print(sText.c_str());
}

inline static uint16_t* GetModIndexPointer(RE::TESForm* theForm) {
	return reinterpret_cast<uint16_t*>((reinterpret_cast<uintptr_t>(theForm) + 0x30));
}

inline static std::vector<PluginData> GetOrderedPluginData()
{
	std::vector<PluginData> plugins;
	const auto& [map, lock] = RE::TESForm::GetAllForms();
	RE::BSAutoReadLock l{ lock };
	uint32_t           i = 0;
	if (!map) {
		LogError("FormMap is inaccessible");
		return plugins;
	}
	if (map->size() == 0) {
		LogError("FormMap is empty");
		return plugins;
	}
	auto StartTime = std::chrono::high_resolution_clock::now();
	for (auto it = map->begin(); it != map->end(); ++it) {
		auto FormID = it.operator*().Key;
		if ((FormID >> (8 * 3)) == 0xFF)  // IsCreated
			continue;
		std::string sHexFormID = GetUIntFormIDAsHex(FormID);
		auto form = it.operator*().Value;
		if (!form) {
			LogError("TESForm (ID: " + sHexFormID + " is nullptr, skipping");
			continue;
		}
		auto           ModIndexPointer = GetModIndexPointer(form);
		auto           tesfile = GetTESFileByModIndex(ModIndexPointer);  // "override plugin", actually determines form data
		if (!tesfile) {
			LogWarning("TESForm " + GetBasicFormData(form, true, true, true, true) + " has no override TESFile, skipping");		// warning because certain forms like TESForm [21C75F50530 | 00000390 | AVIF | 65535|0xFF | {unnamed} | Invulnerable] doesn't have tesfiles
			continue;
		}
		std::string sOverridePluginName = tesfile->filePath;
		if (sOverridePluginName.empty()) {
			LogError("TESForm " + GetBasicFormData(form, true, true, true, true) + " has override TESFile [" + GetObjectAddressAsHex(tesfile) + "] but this TESFile has no PluginName, skipping");
			continue;
		}
		auto        SourcePlugin = GetTESFileByModIndex(ModIndexPointer, true);
		if (!SourcePlugin) {
			LogWarning("TESForm " + GetBasicFormData(form, true, true, true, true) + " has no source TESFile, skipping");
			continue;
		}
		std::string sSourcePluginName = SourcePlugin->filePath;
		if (sSourcePluginName.empty()) {
			LogError("TESForm " + GetBasicFormData(form, true, true, true, true) + " has source TESFile [" + GetObjectAddressAsHex(tesfile) + "] but this TESFile has no PluginName, skipping");
			continue;
		}
		int  FailsafeCount = 0;
		int  MaxFailsafeCount = INT32_MAX;
		bool bPluginAlreadyAdded = false;
		bool bModIndexFound = false;
		for (auto& it : plugins) {
			if (std::strcmp(it.PluginName.c_str(), sOverridePluginName.c_str()) == 0) {
				bPluginAlreadyAdded = true;
				break;
			}
		}
		for (auto& it : plugins) {
			for (auto& it2 : it.ModIndexes) {
				if (it2 == form->loadOrderIndex) {
					bModIndexFound = true;
					break;
				}
			}
		}
		LogInfo("Crunching Plugin data by TESForm " + GetBasicFormData(form, true, true, true, true) + " [Source: " + sSourcePluginName + "] [Override: " + sOverridePluginName + "] [PluginsSize: " + std::to_string(plugins.size()) + "] [ModIndex: " + std::to_string(form->loadOrderIndex) + "]");
		if (bPluginAlreadyAdded && plugins.size() > 0) {
			bool bFoundAndIncrementedOverwrittenPlugin = false;
			for (uint32_t k = 0; k < plugins.size() && FailsafeCount < MaxFailsafeCount; k++) {  // loop the main plugins vector
				FailsafeCount = FailsafeCount + 1;
				//if (plugins.at(k).PluginName.empty() == false) {
				if (std::strcmp(plugins.at(k).PluginName.c_str(), sOverridePluginName.c_str()) == 0) {  // main plugins vector should contain the plugin of this form whose data is actually used to initialize the form (this plugin is the one the form was overwritten in; call it "initializer plugin")
					if (!bModIndexFound) {
						plugins.at(k).ModIndexes.push_back(form->loadOrderIndex);
					}
				if (std::strcmp(sSourcePluginName.c_str(), sOverridePluginName.c_str()) != 0) {  // means this is an overwritten form
					for (uint32_t l = 0; l < plugins.at(k).OverwrittenPlugins.size() && !bFoundAndIncrementedOverwrittenPlugin && FailsafeCount < MaxFailsafeCount; l++) {
						//if (!plugins.at(k).OverwrittenPlugins.at(l).PluginName.empty()) {
						if (std::strcmp(plugins.at(k).OverwrittenPlugins.at(l).PluginName.c_str(), sSourcePluginName.c_str()) == 0) {  // try to find the source plugin of this form (so the plugin the form is initially defined) in any OverwrittenPlugins vector of the main plugins vector
						// if found, increment the form count for this overwritten plugin
						int previousCount = plugins.at(k).OverwrittenPlugins.at(l).OverwrittenFormCount;
						plugins.at(k).OverwrittenPlugins.at(l).OverwrittenFormCount = previousCount + 1;
						plugins.at(k).OverwrittenPlugins.at(l).OverwrittenFormHexFormIDs.push_back(sHexFormID);
						bFoundAndIncrementedOverwrittenPlugin = true;
						break;
					}
					//}
				}
				if (!bFoundAndIncrementedOverwrittenPlugin) {  // add the source plugin of this form to the vector OverwrittenPlugins of the element (k) in the vector plugins
					OverwrittenPluginData data;
					data.PluginName = sSourcePluginName;
					data.OverwrittenFormCount = 1;
					std::vector<std::string> vec = { sHexFormID };
					data.OverwrittenFormHexFormIDs = vec;
					plugins.at(k).OverwrittenPlugins.push_back(data);
				}
					} else {  // means this form is defined in this plugin

				plugins.at(k).HexFormIDs.push_back(sHexFormID);
					}
				}
				//}
			}
		}
		if (!bPluginAlreadyAdded) {  // need to add the initializer ("override") plugin of this form to plugins
			PluginData plugin;
			plugin.PluginName = sOverridePluginName;
			plugin.AuthorName = GetPluginFileAuthorName(tesfile);
			//	std::vector<uint8_t> vec = { form->loadOrderIndex };
			std::vector<uint16_t> vec = { form->loadOrderIndex };  // v1.14.70
			plugin.ModIndexes = vec;
			std::vector<std::string> pluginFlags;
			if (tesfile->header.flags.any(RE::TESPackedFile::PLUGIN_HEADER::Flags::kESM)) {
				pluginFlags.push_back("ESM (" + std::format("{:x}", static_cast<uint32_t>(RE::TESPackedFile::PLUGIN_HEADER::Flags::kESM)) + ")");
			}
			if (tesfile->header.flags.any(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk2)) {
				pluginFlags.push_back("Unk2 (" + std::format("{:x}", static_cast<uint32_t>(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk2)) + ")");
			}
			if (tesfile->header.flags.any(RE::TESPackedFile::PLUGIN_HEADER::Flags::kActive)) {
				pluginFlags.push_back("Active (" + std::format("{:x}", static_cast<uint32_t>(RE::TESPackedFile::PLUGIN_HEADER::Flags::kActive)) + ")");
			}
			if (tesfile->header.flags.any(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk4)) {
				pluginFlags.push_back("Unk4 (" + std::format("{:x}", static_cast<uint32_t>(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk4)) + ")");
			}
			if (tesfile->header.flags.any(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk5)) {
				pluginFlags.push_back("Unk5 (" + std::format("{:x}", static_cast<uint32_t>(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk5)) + ")");
			}
			if (tesfile->header.flags.any(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk6)) {
				pluginFlags.push_back("Unk6 (" + std::format("{:x}", static_cast<uint32_t>(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk6)) + ")");
			}
			if (tesfile->header.flags.any(RE::TESPackedFile::PLUGIN_HEADER::Flags::kLocalized)) {
				pluginFlags.push_back("Localized (" + std::format("{:x}", static_cast<uint32_t>(RE::TESPackedFile::PLUGIN_HEADER::Flags::kLocalized)) + ")");
			}
			if (tesfile->header.flags.any(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk8)) {
				pluginFlags.push_back("Unk8 (" + std::format("{:x}", static_cast<uint32_t>(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk8)) + ")");
			}
			if (tesfile->header.flags.any(RE::TESPackedFile::PLUGIN_HEADER::Flags::kSmallFile)) {
				pluginFlags.push_back("Small (" + std::format("{:x}", static_cast<uint32_t>(RE::TESPackedFile::PLUGIN_HEADER::Flags::kSmallFile)) + ")");
			}
			if (tesfile->header.flags.any(RE::TESPackedFile::PLUGIN_HEADER::Flags::kMedium)) {
				pluginFlags.push_back("Medium (" + std::format("{:x}", static_cast<uint32_t>(RE::TESPackedFile::PLUGIN_HEADER::Flags::kMedium)) + ")");
			}
			if (tesfile->header.flags.any(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk11)) {
				pluginFlags.push_back("Unk11 (" + std::format("{:x}", static_cast<uint32_t>(RE::TESPackedFile::PLUGIN_HEADER::Flags::kUnk11)) + ")");
			}
			plugin.PluginFlagsRAW = GetUIntFormIDAsHex(tesfile->header.flags.underlying());
			plugin.PluginFlags = pluginFlags;
			plugin.PluginType = GetPluginTypeAsInt(tesfile);
			plugin.RecordCount = tesfile->header.numRecords;
			plugin.Version = tesfile->header.version;
			plugin.LoadOrderPrefix = GetLoadOrderPrefixAsStr(tesfile);
			std::vector<std::string> Masters;
			auto                     masterFiles = GetAsBSTArrayCustom(&tesfile->masterFiles);
			if (masterFiles && masterFiles->size() > 0) {
				for (uint32_t j = 0; j < masterFiles->size(); j++) {
					auto masterFile = masterFiles->at(j);
					if (masterFile) {
				std::string MasterName = masterFile->filePath;
				if (!MasterName.empty() && std::find(std::begin(Masters), std::end(Masters), MasterName) == Masters.end())
					Masters.push_back(MasterName);
					}
				}
			}
			plugin.Masters = Masters;
			if (std::strcmp(sSourcePluginName.c_str(), sOverridePluginName.c_str()) != 0) {  // means this is an overwritten form
				OverwrittenPluginData data;
				data.PluginName = sSourcePluginName;
				data.OverwrittenFormCount = 1;
				std::vector<std::string> vec = { sHexFormID };
				data.OverwrittenFormHexFormIDs = vec;
				plugin.OverwrittenPlugins.push_back(data);
			} else {  // means this form is defined in this plugin
				std::vector<std::string> vec = { sHexFormID };
				plugin.HexFormIDs = vec;
			}
			plugins.push_back(plugin);
		}
	}
	if (plugins.size() > 0) {
		struct
		{
			bool operator()(PluginData a, PluginData b) const { return GetHighestModIndexInPluginData(&a) < GetHighestModIndexInPluginData(&b); }
		} functor;
		std::sort(plugins.begin(), plugins.end(), functor);
	}
	auto                                    CompletionTime = std::chrono::high_resolution_clock::now();
	std::chrono::duration<long long, std::milli> elapsedTime = duration_cast<std::chrono::milliseconds>(CompletionTime - StartTime);
	LogInfo("completed in " + std::to_string(elapsedTime.count()) + " milliseconds");
	return plugins;
}

inline static RE::BGSKeyword* GetWeaponTypeUnarmedKeyword()  // WeaponTypeUnarmed [KYWD:0005240E]
{
	RE::TESForm* theForm = RE::TESForm::LookupByID(0x5240E);
	if (!theForm)
		return nullptr;
	if (theForm->GetSavedFormType() != 4)
		return nullptr;
	RE::BGSKeyword* theKeyword = (RE::BGSKeyword*)theForm;
	if (theKeyword != nullptr)
		return theKeyword;
	return nullptr;
}

inline static RE::BGSKeyword* GetAnimFaceArchetype(RE::Actor* theActor, std::string* ArchetypeEditorIDOut = nullptr)
{
	auto faceAnimNode = GetFaceGenAnimData(theActor);
	if (!faceAnimNode)
		return nullptr;
	std::string animKeywordName = faceAnimNode->animFaceArchetype.c_str();
	if (animKeywordName.empty())
		return nullptr;
	animKeywordName = ToLowerStr(animKeywordName);
	auto keywords = GetAllFormsByType<RE::BGSKeyword>(static_cast<int>(RE::FormType::kKYWD));
	for (uint32_t i = 0; i < keywords.size(); i++) {
		auto keyword = keywords.at(i);
		if (!keyword)
			continue;
		std::string editorID = GetFormEditorID(keyword);
		if (editorID.empty())
			continue;
		if (std::strcmp(ToLowerStr(editorID).c_str(), animKeywordName.c_str()) == 0) {
			if (ArchetypeEditorIDOut)
				*ArchetypeEditorIDOut = editorID;
			return keyword;
		}
	}
	return nullptr;
}

inline static bool ApplyFacialExpression(RE::Actor* theActor, RE::BGSFacialExpressionData* theFacialExpression)
{
	if (!theActor || !theFacialExpression)
		return false;
	auto faceAnimNode = GetFaceGenAnimData(theActor);
	if (!faceAnimNode)
		return false;
	faceAnimNode->browLowererL = theFacialExpression->browLowererL;
	faceAnimNode->browLowererR = theFacialExpression->browLowererR;
	faceAnimNode->cheekPuffL = theFacialExpression->cheekPuffL;
	faceAnimNode->cheekPuffR = theFacialExpression->cheekPuffR;
	faceAnimNode->cheekRaiseL = theFacialExpression->cheekRaiseL;
	faceAnimNode->cheekRaiseR = theFacialExpression->cheekRaiseR;
	faceAnimNode->cheekSuckL = theFacialExpression->cheekSuckL;
	faceAnimNode->cheekSuckR = theFacialExpression->cheekSuckR;
	faceAnimNode->chinRaise = theFacialExpression->chinRaise;
	faceAnimNode->chinRaiseUpperlipTweak = theFacialExpression->chinRaiseUpperlipTweak;
	faceAnimNode->c_eyeDown_eyeClosedL = theFacialExpression->c_eyeDown_eyeClosedL;
	faceAnimNode->c_eyeDown_eyeClosedR = theFacialExpression->c_eyeDown_eyeClosedR;
	faceAnimNode->c_eyeLeft_eyeClosedL = theFacialExpression->c_eyeLeft_eyeClosedL;
	faceAnimNode->c_eyeLeft_eyeClosedR = theFacialExpression->c_eyeLeft_eyeClosedR;
	faceAnimNode->c_eyeRight_eyeClosedL = theFacialExpression->c_eyeRight_eyeClosedL;
	faceAnimNode->c_eyeRight_eyeClosedR = theFacialExpression->c_eyeRight_eyeClosedR;
	faceAnimNode->c_eyeUp_eyeClosedL = theFacialExpression->c_eyeUp_eyeClosedL;
	faceAnimNode->c_eyeUp_eyeClosedR = theFacialExpression->c_eyeUp_eyeClosedR;
	faceAnimNode->c_eyesClosed50L = theFacialExpression->c_eyesClosed50L;
	faceAnimNode->c_eyesClosed50R = theFacialExpression->c_eyesClosed50R;
	faceAnimNode->c_JawDrop = theFacialExpression->c_JawDrop;
	faceAnimNode->c_squintL_cheekRaiserL = theFacialExpression->c_squintL_cheekRaiserL;
	faceAnimNode->c_squintR_cheekRaiserR = theFacialExpression->c_squintR_cheekRaiserR;
	faceAnimNode->dimplerL = theFacialExpression->dimplerL;
	faceAnimNode->dimplerR = theFacialExpression->dimplerR;
	faceAnimNode->eyeClosedL = theFacialExpression->eyeClosedL;
	faceAnimNode->eyeClosedR = theFacialExpression->eyeClosedR;
	faceAnimNode->eyeDown = theFacialExpression->eyeDown;
	faceAnimNode->eyeLeft = theFacialExpression->eyeLeft;
	faceAnimNode->eyeOpenL = theFacialExpression->eyeOpenL;
	faceAnimNode->eyeOpenR = theFacialExpression->eyeOpenR;
	faceAnimNode->eyeRight = theFacialExpression->eyeRight;
	faceAnimNode->eyeUp = theFacialExpression->eyeUp;
	faceAnimNode->innerBrowRaiseL = theFacialExpression->innerBrowRaiseL;
	faceAnimNode->innerBrowRaiseR = theFacialExpression->innerBrowRaiseR;
	faceAnimNode->jawClench = theFacialExpression->jawClench;
	faceAnimNode->jawLeft = theFacialExpression->jawLeft;
	faceAnimNode->jawOpen = theFacialExpression->jawOpen;
	faceAnimNode->jawRight = theFacialExpression->jawRight;
	faceAnimNode->jawThrust = theFacialExpression->jawThrust;
	faceAnimNode->lidTightenerL = theFacialExpression->lidTightenerL;
	faceAnimNode->lipCornerDepressL = theFacialExpression->lipCornerDepressL;
	faceAnimNode->lipCornerDepressR = theFacialExpression->lipCornerDepressR;
	faceAnimNode->lipCornerInL = theFacialExpression->lipCornerInL;
	faceAnimNode->lipCornerInR = theFacialExpression->lipCornerInR;
	faceAnimNode->lipCornerPullL = theFacialExpression->lipCornerPullL;
	faceAnimNode->lipCornerPullR = theFacialExpression->lipCornerPullR;
	faceAnimNode->lipPress = theFacialExpression->lipPress;
	faceAnimNode->lipPucker = theFacialExpression->lipPucker;
	faceAnimNode->lipStretchL = theFacialExpression->lipStretchL;
	faceAnimNode->lipStretchR = theFacialExpression->lipStretchR;
	faceAnimNode->lipTighten = theFacialExpression->lipTighten;
	faceAnimNode->lipZipperL = theFacialExpression->lipZipperL;
	faceAnimNode->lipZipperR = theFacialExpression->lipZipperR;
	faceAnimNode->lowerLipDepressL = theFacialExpression->lowerLipDepressL;
	faceAnimNode->lowerLipDepressR = theFacialExpression->lowerLipDepressR;
	faceAnimNode->lowerLipFunnel = theFacialExpression->lowerLipFunnel;
	faceAnimNode->lowerLipPuff = theFacialExpression->lowerLipPuff;
	faceAnimNode->lowerLipSuck = theFacialExpression->lowerLipSuck;
	faceAnimNode->lowerLipThickness = theFacialExpression->lowerLipThickness;
	faceAnimNode->lowerLipUpL = theFacialExpression->lowerLipUpL;
	faceAnimNode->lowerLipUpR = theFacialExpression->lowerLipUpR;
	faceAnimNode->nasolabialFurrowL = theFacialExpression->nasolabialFurrowL;
	faceAnimNode->nasolabialFurrowR = theFacialExpression->nasolabialFurrowR;
	faceAnimNode->neckFlexL = theFacialExpression->neckFlexL;
	faceAnimNode->neckFlexR = theFacialExpression->neckFlexR;
	faceAnimNode->noseDepressor = theFacialExpression->noseDepressor;
	faceAnimNode->noseWrinkleL = theFacialExpression->noseWrinkleL;
	faceAnimNode->noseWrinkleR = theFacialExpression->noseWrinkleR;
	faceAnimNode->nostrilCompressor = theFacialExpression->nostrilCompressor;
	faceAnimNode->nostrilDilator = theFacialExpression->nostrilDilator;
	faceAnimNode->outerBrowRaiseL = theFacialExpression->outerBrowRaiseL;
	faceAnimNode->outerBrowRaiseR = theFacialExpression->outerBrowRaiseR;
	faceAnimNode->sharpLipPullL = theFacialExpression->sharpLipPullL;
	faceAnimNode->sharpLipPullR = theFacialExpression->sharpLipPullR;
	faceAnimNode->squintL = theFacialExpression->squintL;
	faceAnimNode->squintR = theFacialExpression->squintR;
	faceAnimNode->swallow = theFacialExpression->swallow;
	faceAnimNode->upperLipDownL = theFacialExpression->upperLipDownL;
	faceAnimNode->upperLipDownR = theFacialExpression->upperLipDownR;
	faceAnimNode->upperLipFunnel = theFacialExpression->upperLipFunnel;
	faceAnimNode->upperLipPuff = theFacialExpression->upperLipPuff;
	faceAnimNode->upperLipRaiseL = theFacialExpression->upperLipRaiseL;
	faceAnimNode->upperLipRaiseR = theFacialExpression->upperLipRaiseR;
	faceAnimNode->upperLipSuck = theFacialExpression->upperLipSuck;
	faceAnimNode->upperLipThickness = theFacialExpression->upperLipThickness;
	faceAnimNode->tongueCurlDown = theFacialExpression->tongueCurlDown;
	faceAnimNode->tongueCurlUp = theFacialExpression->tongueCurlUp;
	faceAnimNode->tongueDown = theFacialExpression->tongueDown;
	faceAnimNode->tongueUp = theFacialExpression->tongueUp;
	faceAnimNode->tongueIn = theFacialExpression->tongueIn;
	faceAnimNode->tongueOut = theFacialExpression->tongueOut;
	faceAnimNode->tongueLeft = theFacialExpression->tongueLeft;
	faceAnimNode->tongueRight = theFacialExpression->tongueRight;
	faceAnimNode->tongueThick = theFacialExpression->tongueThick;
	faceAnimNode->tongueThinner = theFacialExpression->tongueThinner;
	faceAnimNode->LookDown = theFacialExpression->LookDown;
	faceAnimNode->LookUp = theFacialExpression->LookUp;
	faceAnimNode->LookRight = theFacialExpression->LookRight;
	faceAnimNode->LookLeft = theFacialExpression->LookLeft;
	return true;
}

inline static bool ApplyFacialExpressionPhotoMode(RE::Actor* theActor, RE::BGSFacialExpressionData* theFacialExpression) {
	if (!theActor || !theFacialExpression)
		return false;
	uintptr_t  out3D = 0;
	uintptr_t* out3DPtr = &out3D;
	theActor->Get3D(out3DPtr, false);
	if (!out3DPtr)
		return false;
	auto model = reinterpret_cast<RE::BSFadeNode*>(*out3DPtr);
	if (!model)
		return false;
	std::vector<std::pair<std::string, float>> morphMap;
	auto                                       bGotMorphMap = GetFacialExpressionDataAsMorphMap(theFacialExpression, &morphMap);
	if (!bGotMorphMap || morphMap.size() == 0)
		return false;
	float morphs[100]{};
	for (int i = 0; i < morphMap.size(); i++) {
		morphs[i] = morphMap.at(i).second;
	}
	REL::Relocation<uintptr_t> ptr{ REL::ID(1536429) };  // 0x1BEA5C0 in v1.12.36
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<void (*)(float[100], RE::BSFadeNode*)>(addr);
	func(morphs, model);
	return true;
}

inline static bool ApplyMorphsPhotoMode(RE::Actor* theActor, std::vector<float> morphsToApply)
{
	if (!theActor || morphsToApply.size() < 100)
		return false;
	uintptr_t  out3D = 0;
	uintptr_t* out3DPtr = &out3D;
	theActor->Get3D(out3DPtr, false);
	if (!out3DPtr)
		return false;
	auto model = reinterpret_cast<RE::BSFadeNode*>(*out3DPtr);
	if (!model)
		return false;
	float morphs[100]{};
	for (int i = 0; i < morphsToApply.size(); i++) {
		morphs[i] = morphsToApply.at(i);
	}
	REL::Relocation<uintptr_t> ptr{ REL::ID(1536429) };  // 0x1BEA5C0 in v1.12.36
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<void (*)(float[100], RE::BSFadeNode*)>(addr);
	func(morphs, model);
	return true;
}

inline static bool StoreFacialExpression(RE::Actor* theActor, RE::BGSFacialExpressionData* theFacialExpression)
{
	if (!theActor || !theFacialExpression)
		return false;
	auto faceAnimNode = GetFaceGenAnimData(theActor);
	if (!faceAnimNode)
		return false;
	theFacialExpression->browLowererL = faceAnimNode->browLowererL;
	theFacialExpression->browLowererR = faceAnimNode->browLowererR;
	theFacialExpression->cheekPuffL = faceAnimNode->cheekPuffL;
	theFacialExpression->cheekPuffR = faceAnimNode->cheekPuffR;
	theFacialExpression->cheekRaiseL = faceAnimNode->cheekRaiseL;
	theFacialExpression->cheekRaiseR = faceAnimNode->cheekRaiseR;
	theFacialExpression->cheekSuckL = faceAnimNode->cheekSuckL;
	theFacialExpression->cheekSuckR = faceAnimNode->cheekSuckR;
	theFacialExpression->chinRaise = faceAnimNode->chinRaise;
	theFacialExpression->chinRaiseUpperlipTweak = faceAnimNode->chinRaiseUpperlipTweak;
	theFacialExpression->c_eyeDown_eyeClosedL = faceAnimNode->c_eyeDown_eyeClosedL;
	theFacialExpression->c_eyeDown_eyeClosedR = faceAnimNode->c_eyeDown_eyeClosedR;
	theFacialExpression->c_eyeLeft_eyeClosedL = faceAnimNode->c_eyeLeft_eyeClosedL;
	theFacialExpression->c_eyeLeft_eyeClosedR = faceAnimNode->c_eyeLeft_eyeClosedR;
	theFacialExpression->c_eyeRight_eyeClosedL = faceAnimNode->c_eyeRight_eyeClosedL;
	theFacialExpression->c_eyeRight_eyeClosedR = faceAnimNode->c_eyeRight_eyeClosedR;
	theFacialExpression->c_eyeUp_eyeClosedL = faceAnimNode->c_eyeUp_eyeClosedL;
	theFacialExpression->c_eyeUp_eyeClosedR = faceAnimNode->c_eyeUp_eyeClosedR;
	theFacialExpression->c_eyesClosed50L = faceAnimNode->c_eyesClosed50L;
	theFacialExpression->c_eyesClosed50R = faceAnimNode->c_eyesClosed50R;
	theFacialExpression->c_JawDrop = faceAnimNode->c_JawDrop;
	theFacialExpression->c_squintL_cheekRaiserL = faceAnimNode->c_squintL_cheekRaiserL;
	theFacialExpression->c_squintR_cheekRaiserR = faceAnimNode->c_squintR_cheekRaiserR;
	theFacialExpression->dimplerL = faceAnimNode->dimplerL;
	theFacialExpression->dimplerR = faceAnimNode->dimplerR;
	theFacialExpression->eyeClosedL = faceAnimNode->eyeClosedL;
	theFacialExpression->eyeClosedR = faceAnimNode->eyeClosedR;
	theFacialExpression->eyeDown = faceAnimNode->eyeDown;
	theFacialExpression->eyeLeft = faceAnimNode->eyeLeft;
	theFacialExpression->eyeOpenL = faceAnimNode->eyeOpenL;
	theFacialExpression->eyeOpenR = faceAnimNode->eyeOpenR;
	theFacialExpression->eyeRight = faceAnimNode->eyeRight;
	theFacialExpression->eyeUp = faceAnimNode->eyeUp;
	theFacialExpression->innerBrowRaiseL = faceAnimNode->innerBrowRaiseL;
	theFacialExpression->innerBrowRaiseR = faceAnimNode->innerBrowRaiseR;
	theFacialExpression->jawClench = faceAnimNode->jawClench;
	theFacialExpression->jawLeft = faceAnimNode->jawLeft;
	theFacialExpression->jawOpen = faceAnimNode->jawOpen;
	theFacialExpression->jawRight = faceAnimNode->jawRight;
	theFacialExpression->jawThrust = faceAnimNode->jawThrust;
	theFacialExpression->lidTightenerL = faceAnimNode->lidTightenerL;
	theFacialExpression->lipCornerDepressL = faceAnimNode->lipCornerDepressL;
	theFacialExpression->lipCornerDepressR = faceAnimNode->lipCornerDepressR;
	theFacialExpression->lipCornerInL = faceAnimNode->lipCornerInL;
	theFacialExpression->lipCornerInR = faceAnimNode->lipCornerInR;
	theFacialExpression->lipCornerPullL = faceAnimNode->lipCornerPullL;
	theFacialExpression->lipCornerPullR = faceAnimNode->lipCornerPullR;
	theFacialExpression->lipPress = faceAnimNode->lipPress;
	theFacialExpression->lipPucker = faceAnimNode->lipPucker;
	theFacialExpression->lipStretchL = faceAnimNode->lipStretchL;
	theFacialExpression->lipStretchR = faceAnimNode->lipStretchR;
	theFacialExpression->lipTighten = faceAnimNode->lipTighten;
	theFacialExpression->lipZipperL = faceAnimNode->lipZipperL;
	theFacialExpression->lipZipperR = faceAnimNode->lipZipperR;
	theFacialExpression->lowerLipDepressL = faceAnimNode->lowerLipDepressL;
	theFacialExpression->lowerLipDepressR = faceAnimNode->lowerLipDepressR;
	theFacialExpression->lowerLipFunnel = faceAnimNode->lowerLipFunnel;
	theFacialExpression->lowerLipPuff = faceAnimNode->lowerLipPuff;
	theFacialExpression->lowerLipSuck = faceAnimNode->lowerLipSuck;
	theFacialExpression->lowerLipThickness = faceAnimNode->lowerLipThickness;
	theFacialExpression->lowerLipUpL = faceAnimNode->lowerLipUpL;
	theFacialExpression->lowerLipUpR = faceAnimNode->lowerLipUpR;
	theFacialExpression->nasolabialFurrowL = faceAnimNode->nasolabialFurrowL;
	theFacialExpression->nasolabialFurrowR = faceAnimNode->nasolabialFurrowR;
	theFacialExpression->neckFlexL = faceAnimNode->neckFlexL;
	theFacialExpression->neckFlexR = faceAnimNode->neckFlexR;
	theFacialExpression->noseDepressor = faceAnimNode->noseDepressor;
	theFacialExpression->noseWrinkleL = faceAnimNode->noseWrinkleL;
	theFacialExpression->noseWrinkleR = faceAnimNode->noseWrinkleR;
	theFacialExpression->nostrilCompressor = faceAnimNode->nostrilCompressor;
	theFacialExpression->nostrilDilator = faceAnimNode->nostrilDilator;
	theFacialExpression->outerBrowRaiseL = faceAnimNode->outerBrowRaiseL;
	theFacialExpression->outerBrowRaiseR = faceAnimNode->outerBrowRaiseR;
	theFacialExpression->sharpLipPullL = faceAnimNode->sharpLipPullL;
	theFacialExpression->sharpLipPullR = faceAnimNode->sharpLipPullR;
	theFacialExpression->squintL = faceAnimNode->squintL;
	theFacialExpression->squintR = faceAnimNode->squintR;
	theFacialExpression->swallow = faceAnimNode->swallow;
	theFacialExpression->upperLipDownL = faceAnimNode->upperLipDownL;
	theFacialExpression->upperLipDownR = faceAnimNode->upperLipDownR;
	theFacialExpression->upperLipFunnel = faceAnimNode->upperLipFunnel;
	theFacialExpression->upperLipPuff = faceAnimNode->upperLipPuff;
	theFacialExpression->upperLipRaiseL = faceAnimNode->upperLipRaiseL;
	theFacialExpression->upperLipRaiseR = faceAnimNode->upperLipRaiseR;
	theFacialExpression->upperLipSuck = faceAnimNode->upperLipSuck;
	theFacialExpression->upperLipThickness = faceAnimNode->upperLipThickness;
	theFacialExpression->tongueCurlDown = faceAnimNode->tongueCurlDown;
	theFacialExpression->tongueCurlUp = faceAnimNode->tongueCurlUp;
	theFacialExpression->tongueDown = faceAnimNode->tongueDown;
	theFacialExpression->tongueUp = faceAnimNode->tongueUp;
	theFacialExpression->tongueIn = faceAnimNode->tongueIn;
	theFacialExpression->tongueOut = faceAnimNode->tongueOut;
	theFacialExpression->tongueLeft = faceAnimNode->tongueLeft;
	theFacialExpression->tongueRight = faceAnimNode->tongueRight;
	theFacialExpression->tongueThick = faceAnimNode->tongueThick;
	theFacialExpression->tongueThinner = faceAnimNode->tongueThinner;
	theFacialExpression->LookDown = faceAnimNode->LookDown;
	theFacialExpression->LookUp = faceAnimNode->LookUp;
	theFacialExpression->LookRight = faceAnimNode->LookRight;
	theFacialExpression->LookLeft = faceAnimNode->LookLeft;
	return true;
}

inline static float ReadMorphValue(RE::BGSFacialExpressionData* theFacialExpression, std::string morphName)
{
	if (!theFacialExpression || morphName.empty())
		return -1.00f;
	morphName = ToLowerStr(morphName);
	if (std::strcmp("browlowererl", morphName.c_str()) == 0)
		return theFacialExpression->browLowererL;
	if (std::strcmp("browlowererr", morphName.c_str()) == 0)
		return theFacialExpression->browLowererR;
	if (std::strcmp("cheekpuffl", morphName.c_str()) == 0)
		return theFacialExpression->cheekPuffL;
	if (std::strcmp("cheekpuffr", morphName.c_str()) == 0)
		return theFacialExpression->cheekPuffR;
	if (std::strcmp("cheekraisel", morphName.c_str()) == 0)
		return theFacialExpression->cheekRaiseL;
	if (std::strcmp("cheekraiser", morphName.c_str()) == 0)
		return theFacialExpression->cheekRaiseR;
	if (std::strcmp("cheeksuckl", morphName.c_str()) == 0)
		return theFacialExpression->cheekSuckL;
	if (std::strcmp("cheeksuckr", morphName.c_str()) == 0)
		return theFacialExpression->cheekSuckR;
	if (std::strcmp("chinraise", morphName.c_str()) == 0)
		return theFacialExpression->chinRaise;
	if (std::strcmp("chinraiseupperliptweak", morphName.c_str()) == 0)
		return theFacialExpression->chinRaiseUpperlipTweak;
	if (std::strcmp("c_eyedown_eyeclosedl", morphName.c_str()) == 0)
		return theFacialExpression->c_eyeDown_eyeClosedL;
	if (std::strcmp("c_eyedown_eyeclosedr", morphName.c_str()) == 0)
		return theFacialExpression->c_eyeDown_eyeClosedR;
	if (std::strcmp("c_eyeleft_eyeclosedl", morphName.c_str()) == 0)
		return theFacialExpression->c_eyeLeft_eyeClosedL;
	if (std::strcmp("c_eyeleft_eyeclosedr", morphName.c_str()) == 0)
		return theFacialExpression->c_eyeLeft_eyeClosedR;
	if (std::strcmp("c_eyeright_eyeclosedl", morphName.c_str()) == 0)
		return theFacialExpression->c_eyeRight_eyeClosedL;
	if (std::strcmp("c_eyeright_eyeclosedr", morphName.c_str()) == 0)
		return theFacialExpression->c_eyeRight_eyeClosedR;
	if (std::strcmp("c_eyeup_eyeclosedl", morphName.c_str()) == 0)
		return theFacialExpression->c_eyeUp_eyeClosedL;
	if (std::strcmp("c_eyeup_eyeclosedr", morphName.c_str()) == 0)
		return theFacialExpression->c_eyeUp_eyeClosedR;
	if (std::strcmp("c_eyesclosed50l", morphName.c_str()) == 0)
		return theFacialExpression->c_eyesClosed50L;
	if (std::strcmp("c_eyesclosed50r", morphName.c_str()) == 0)
		return theFacialExpression->c_eyesClosed50R;
	if (std::strcmp("c_jawdrop", morphName.c_str()) == 0)
		return theFacialExpression->c_JawDrop;
	if (std::strcmp("c_squintl_cheekraiserl", morphName.c_str()) == 0)
		return theFacialExpression->c_squintL_cheekRaiserL;
	if (std::strcmp("c_squintr_cheekraiserr", morphName.c_str()) == 0)
		return theFacialExpression->c_squintR_cheekRaiserR;
	if (std::strcmp("dimplerl", morphName.c_str()) == 0)
		return theFacialExpression->dimplerL;
	if (std::strcmp("dimplerr", morphName.c_str()) == 0)
		return theFacialExpression->dimplerR;
	if (std::strcmp("eyeclosedl", morphName.c_str()) == 0)
		return theFacialExpression->eyeClosedL;
	if (std::strcmp("eyeclosedr", morphName.c_str()) == 0)
		return theFacialExpression->eyeClosedR;
	if (std::strcmp("eyedown", morphName.c_str()) == 0)
		return theFacialExpression->eyeDown;
	if (std::strcmp("eyeleft", morphName.c_str()) == 0)
		return theFacialExpression->eyeLeft;
	if (std::strcmp("eyeopenl", morphName.c_str()) == 0)
		return theFacialExpression->eyeOpenL;
	if (std::strcmp("eyeopenr", morphName.c_str()) == 0)
		return theFacialExpression->eyeOpenR;
	if (std::strcmp("eyeright", morphName.c_str()) == 0)
		return theFacialExpression->eyeRight;
	if (std::strcmp("eyeup", morphName.c_str()) == 0)
		return theFacialExpression->eyeUp;
	if (std::strcmp("innerbrowraisel", morphName.c_str()) == 0)
		return theFacialExpression->innerBrowRaiseL;
	if (std::strcmp("innerbrowraiser", morphName.c_str()) == 0)
		return theFacialExpression->innerBrowRaiseR;
	if (std::strcmp("jawclench", morphName.c_str()) == 0)
		return theFacialExpression->jawClench;
	if (std::strcmp("jawleft", morphName.c_str()) == 0)
		return theFacialExpression->jawLeft;
	if (std::strcmp("jawopen", morphName.c_str()) == 0)
		return theFacialExpression->jawOpen;
	if (std::strcmp("jawright", morphName.c_str()) == 0)
		return theFacialExpression->jawRight;
	if (std::strcmp("jawthrust", morphName.c_str()) == 0)
		return theFacialExpression->jawThrust;
	if (std::strcmp("lidtightenerl", morphName.c_str()) == 0)
		return theFacialExpression->lidTightenerL;
	if (std::strcmp("lipcornerdepressl", morphName.c_str()) == 0)
		return theFacialExpression->lipCornerDepressL;
	if (std::strcmp("lipcornerdepressr", morphName.c_str()) == 0)
		return theFacialExpression->lipCornerDepressR;
	if (std::strcmp("lipcornerinl", morphName.c_str()) == 0)
		return theFacialExpression->lipCornerInL;
	if (std::strcmp("lipcornerinr", morphName.c_str()) == 0)
		return theFacialExpression->lipCornerInR;
	if (std::strcmp("lipcornerpulll", morphName.c_str()) == 0)
		return theFacialExpression->lipCornerPullL;
	if (std::strcmp("lipcornerpullr", morphName.c_str()) == 0)
		return theFacialExpression->lipCornerPullR;
	if (std::strcmp("lippress", morphName.c_str()) == 0)
		return theFacialExpression->lipPress;
	if (std::strcmp("lippucker", morphName.c_str()) == 0)
		return theFacialExpression->lipPucker;
	if (std::strcmp("lipstretchl", morphName.c_str()) == 0)
		return theFacialExpression->lipStretchL;
	if (std::strcmp("lipstretchr", morphName.c_str()) == 0)
		return theFacialExpression->lipStretchR;
	if (std::strcmp("liptighten", morphName.c_str()) == 0)
		return theFacialExpression->lipTighten;
	if (std::strcmp("lipzipperl", morphName.c_str()) == 0)
		return theFacialExpression->lipZipperL;
	if (std::strcmp("lipzipperr", morphName.c_str()) == 0)
		return theFacialExpression->lipZipperR;
	if (std::strcmp("lowerlipdepressl", morphName.c_str()) == 0)
		return theFacialExpression->lowerLipDepressL;
	if (std::strcmp("lowerlipdepressr", morphName.c_str()) == 0)
		return theFacialExpression->lowerLipDepressR;
	if (std::strcmp("lowerlipfunnel", morphName.c_str()) == 0)
		return theFacialExpression->lowerLipFunnel;
	if (std::strcmp("lowerlippuff", morphName.c_str()) == 0)
		return theFacialExpression->lowerLipPuff;
	if (std::strcmp("lowerlipsuck", morphName.c_str()) == 0)
		return theFacialExpression->lowerLipSuck;
	if (std::strcmp("lowerlipthickness", morphName.c_str()) == 0)
		return theFacialExpression->lowerLipThickness;
	if (std::strcmp("lowerlipupl", morphName.c_str()) == 0)
		return theFacialExpression->lowerLipUpL;
	if (std::strcmp("lowerlipupr", morphName.c_str()) == 0)
		return theFacialExpression->lowerLipUpR;
	if (std::strcmp("nasolabialfurrowl", morphName.c_str()) == 0)
		return theFacialExpression->nasolabialFurrowL;
	if (std::strcmp("nasolabialfurrowr", morphName.c_str()) == 0)
		return theFacialExpression->nasolabialFurrowR;
	if (std::strcmp("neckflexl", morphName.c_str()) == 0)
		return theFacialExpression->neckFlexL;
	if (std::strcmp("neckflexr", morphName.c_str()) == 0)
		return theFacialExpression->neckFlexR;
	if (std::strcmp("nosedepressor", morphName.c_str()) == 0)
		return theFacialExpression->noseDepressor;
	if (std::strcmp("nosewrinklel", morphName.c_str()) == 0)
		return theFacialExpression->noseWrinkleL;
	if (std::strcmp("nosewrinkler", morphName.c_str()) == 0)
		return theFacialExpression->noseWrinkleR;
	if (std::strcmp("nostrilcompressor", morphName.c_str()) == 0)
		return theFacialExpression->nostrilCompressor;
	if (std::strcmp("nostrildilator", morphName.c_str()) == 0)
		return theFacialExpression->nostrilDilator;
	if (std::strcmp("outerbrowraisel", morphName.c_str()) == 0)
		return theFacialExpression->outerBrowRaiseL;
	if (std::strcmp("outerbrowraiser", morphName.c_str()) == 0)
		return theFacialExpression->outerBrowRaiseR;
	if (std::strcmp("sharplippulll", morphName.c_str()) == 0)
		return theFacialExpression->sharpLipPullL;
	if (std::strcmp("sharplippullr", morphName.c_str()) == 0)
		return theFacialExpression->sharpLipPullR;
	if (std::strcmp("squintl", morphName.c_str()) == 0)
		return theFacialExpression->squintL;
	if (std::strcmp("squintr", morphName.c_str()) == 0)
		return theFacialExpression->squintR;
	if (std::strcmp("swallow", morphName.c_str()) == 0)
		return theFacialExpression->swallow;
	if (std::strcmp("upperlipdownl", morphName.c_str()) == 0)
		return theFacialExpression->upperLipDownL;
	if (std::strcmp("upperlipdownr", morphName.c_str()) == 0)
		return theFacialExpression->upperLipDownR;
	if (std::strcmp("upperlipfunnel", morphName.c_str()) == 0)
		return theFacialExpression->upperLipFunnel;
	if (std::strcmp("upperlippuff", morphName.c_str()) == 0)
		return theFacialExpression->upperLipPuff;
	if (std::strcmp("upperlipraisel", morphName.c_str()) == 0)
		return theFacialExpression->upperLipRaiseL;
	if (std::strcmp("upperlipraiser", morphName.c_str()) == 0)
		return theFacialExpression->upperLipRaiseR;
	if (std::strcmp("upperlipsuck", morphName.c_str()) == 0)
		return theFacialExpression->upperLipSuck;
	if (std::strcmp("upperlipthickness", morphName.c_str()) == 0)
		return theFacialExpression->upperLipThickness;
	if (std::strcmp("tonguecurldown", morphName.c_str()) == 0)
		return theFacialExpression->tongueCurlDown;
	if (std::strcmp("tonguecurlup", morphName.c_str()) == 0)
		return theFacialExpression->tongueCurlUp;
	if (std::strcmp("tonguedown", morphName.c_str()) == 0)
		return theFacialExpression->tongueDown;
	if (std::strcmp("tongueup", morphName.c_str()) == 0)
		return theFacialExpression->tongueUp;
	if (std::strcmp("tonguein", morphName.c_str()) == 0)
		return theFacialExpression->tongueIn;
	if (std::strcmp("tongueout", morphName.c_str()) == 0)
		return theFacialExpression->tongueOut;
	if (std::strcmp("tongueleft", morphName.c_str()) == 0)
		return theFacialExpression->tongueLeft;
	if (std::strcmp("tongueright", morphName.c_str()) == 0)
		return theFacialExpression->tongueRight;
	if (std::strcmp("tonguethick", morphName.c_str()) == 0)
		return theFacialExpression->tongueThick;
	if (std::strcmp("tonguethinner", morphName.c_str()) == 0)
		return theFacialExpression->tongueThinner;
	if (std::strcmp("lookdown", morphName.c_str()) == 0)
		return theFacialExpression->LookDown;
	if (std::strcmp("lookup", morphName.c_str()) == 0)
		return theFacialExpression->LookUp;
	if (std::strcmp("lookright", morphName.c_str()) == 0)
		return theFacialExpression->LookRight;
	if (std::strcmp("lookleft", morphName.c_str()) == 0)
		return theFacialExpression->LookLeft;
	return -1.00f;
}

inline static bool WriteMorphValue(RE::BGSFacialExpressionData* theFacialExpression, std::string morphName, float morphValue)
{
	if (!theFacialExpression || morphName.empty() || morphValue < 0.00f || morphValue > 1.00f)
		return false;
	morphName = ToLowerStr(morphName);
	if (std::strcmp("browlowererl", morphName.c_str()) == 0) {
		theFacialExpression->browLowererL = morphValue;
		return true;
	}
	if (std::strcmp("browlowererr", morphName.c_str()) == 0) {
		theFacialExpression->browLowererR = morphValue;
		return true;
	}
	if (std::strcmp("cheekpuffl", morphName.c_str()) == 0) {
		theFacialExpression->cheekPuffL = morphValue;
		return true;
	}
	if (std::strcmp("cheekpuffr", morphName.c_str()) == 0) {
		theFacialExpression->cheekPuffR = morphValue;
		return true;
	}
	if (std::strcmp("cheekraisel", morphName.c_str()) == 0) {
		theFacialExpression->cheekRaiseL = morphValue;
		return true;
	}
	if (std::strcmp("cheekraiser", morphName.c_str()) == 0) {
		theFacialExpression->cheekRaiseR = morphValue;
		return true;
	}
	if (std::strcmp("cheeksuckl", morphName.c_str()) == 0) {
		theFacialExpression->cheekSuckL = morphValue;
		return true;
	}
	if (std::strcmp("cheeksuckr", morphName.c_str()) == 0) {
		theFacialExpression->cheekSuckR = morphValue;
		return true;
	}
	if (std::strcmp("chinraise", morphName.c_str()) == 0) {
		theFacialExpression->chinRaise = morphValue;
		return true;
	}
	if (std::strcmp("chinraiseupperliptweak", morphName.c_str()) == 0) {
		theFacialExpression->chinRaiseUpperlipTweak = morphValue;
		return true;
	}
	if (std::strcmp("c_eyedown_eyeclosedl", morphName.c_str()) == 0) {
		theFacialExpression->c_eyeDown_eyeClosedL = morphValue;
		return true;
	}
	if (std::strcmp("c_eyedown_eyeclosedr", morphName.c_str()) == 0) {
		theFacialExpression->c_eyeDown_eyeClosedR = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeleft_eyeclosedl", morphName.c_str()) == 0) {
		theFacialExpression->c_eyeLeft_eyeClosedL = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeleft_eyeclosedr", morphName.c_str()) == 0) {
		theFacialExpression->c_eyeLeft_eyeClosedR = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeright_eyeclosedl", morphName.c_str()) == 0) {
		theFacialExpression->c_eyeRight_eyeClosedL = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeright_eyeclosedr", morphName.c_str()) == 0) {
		theFacialExpression->c_eyeRight_eyeClosedR = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeup_eyeclosedl", morphName.c_str()) == 0) {
		theFacialExpression->c_eyeUp_eyeClosedL = morphValue;
		return true;
	}
	if (std::strcmp("c_eyeup_eyeclosedr", morphName.c_str()) == 0) {
		theFacialExpression->c_eyeUp_eyeClosedR = morphValue;
		return true;
	}
	if (std::strcmp("c_eyesclosed50l", morphName.c_str()) == 0) {
		theFacialExpression->c_eyesClosed50L = morphValue;
		return true;
	}
	if (std::strcmp("c_eyesclosed50r", morphName.c_str()) == 0) {
		theFacialExpression->c_eyesClosed50R = morphValue;
		return true;
	}
	if (std::strcmp("c_jawdrop", morphName.c_str()) == 0) {
		theFacialExpression->c_JawDrop = morphValue;
		return true;
	}
	if (std::strcmp("c_squintl_cheekraiserl", morphName.c_str()) == 0) {
		theFacialExpression->c_squintL_cheekRaiserL = morphValue;
		return true;
	}
	if (std::strcmp("c_squintr_cheekraiserr", morphName.c_str()) == 0) {
		theFacialExpression->c_squintR_cheekRaiserR = morphValue;
		return true;
	}
	if (std::strcmp("dimplerl", morphName.c_str()) == 0) {
		theFacialExpression->dimplerL = morphValue;
		return true;
	}
	if (std::strcmp("dimplerr", morphName.c_str()) == 0) {
		theFacialExpression->dimplerR = morphValue;
		return true;
	}
	if (std::strcmp("eyeclosedl", morphName.c_str()) == 0) {
		theFacialExpression->eyeClosedL = morphValue;
		return true;
	}
	if (std::strcmp("eyeclosedr", morphName.c_str()) == 0) {
		theFacialExpression->eyeClosedR = morphValue;
		return true;
	}
	if (std::strcmp("eyedown", morphName.c_str()) == 0) {
		theFacialExpression->eyeDown = morphValue;
		return true;
	}
	if (std::strcmp("eyeleft", morphName.c_str()) == 0) {
		theFacialExpression->eyeLeft = morphValue;
		return true;
	}
	if (std::strcmp("eyeopenl", morphName.c_str()) == 0) {
		theFacialExpression->eyeOpenL = morphValue;
		return true;
	}
	if (std::strcmp("eyeopenr", morphName.c_str()) == 0) {
		theFacialExpression->eyeOpenR = morphValue;
		return true;
	}
	if (std::strcmp("eyeright", morphName.c_str()) == 0) {
		theFacialExpression->eyeRight = morphValue;
		return true;
	}
	if (std::strcmp("eyeup", morphName.c_str()) == 0) {
		theFacialExpression->eyeUp = morphValue;
		return true;
	}
	if (std::strcmp("innerbrowraisel", morphName.c_str()) == 0) {
		theFacialExpression->innerBrowRaiseL = morphValue;
		return true;
	}
	if (std::strcmp("innerbrowraiser", morphName.c_str()) == 0) {
		theFacialExpression->innerBrowRaiseR = morphValue;
		return true;
	}
	if (std::strcmp("jawclench", morphName.c_str()) == 0) {
		theFacialExpression->jawClench = morphValue;
		return true;
	}
	if (std::strcmp("jawleft", morphName.c_str()) == 0) {
		theFacialExpression->jawLeft = morphValue;
		return true;
	}
	if (std::strcmp("jawopen", morphName.c_str()) == 0) {
		theFacialExpression->jawOpen = morphValue;
		return true;
	}
	if (std::strcmp("jawright", morphName.c_str()) == 0) {
		theFacialExpression->jawRight = morphValue;
		return true;
	}
	if (std::strcmp("jawthrust", morphName.c_str()) == 0) {
		theFacialExpression->jawThrust = morphValue;
		return true;
	}
	if (std::strcmp("lidtightenerl", morphName.c_str()) == 0) {
		theFacialExpression->lidTightenerL = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerdepressl", morphName.c_str()) == 0) {
		theFacialExpression->lipCornerDepressL = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerdepressr", morphName.c_str()) == 0) {
		theFacialExpression->lipCornerDepressR = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerinl", morphName.c_str()) == 0) {
		theFacialExpression->lipCornerInL = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerinr", morphName.c_str()) == 0) {
		theFacialExpression->lipCornerInR = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerpulll", morphName.c_str()) == 0) {
		theFacialExpression->lipCornerPullL = morphValue;
		return true;
	}
	if (std::strcmp("lipcornerpullr", morphName.c_str()) == 0) {
		theFacialExpression->lipCornerPullR = morphValue;
		return true;
	}
	if (std::strcmp("lippress", morphName.c_str()) == 0) {
		theFacialExpression->lipPress = morphValue;
		return true;
	}
	if (std::strcmp("lippucker", morphName.c_str()) == 0) {
		theFacialExpression->lipPucker = morphValue;
		return true;
	}
	if (std::strcmp("lipstretchl", morphName.c_str()) == 0) {
		theFacialExpression->lipStretchL = morphValue;
		return true;
	}
	if (std::strcmp("lipstretchr", morphName.c_str()) == 0) {
		theFacialExpression->lipStretchR = morphValue;
		return true;
	}
	if (std::strcmp("liptighten", morphName.c_str()) == 0) {
		theFacialExpression->lipTighten = morphValue;
		return true;
	}
	if (std::strcmp("lipzipperl", morphName.c_str()) == 0) {
		theFacialExpression->lipZipperL = morphValue;
		return true;
	}
	if (std::strcmp("lipzipperr", morphName.c_str()) == 0) {
		theFacialExpression->lipZipperR = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipdepressl", morphName.c_str()) == 0) {
		theFacialExpression->lowerLipDepressL = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipdepressr", morphName.c_str()) == 0) {
		theFacialExpression->lowerLipDepressR = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipfunnel", morphName.c_str()) == 0) {
		theFacialExpression->lowerLipFunnel = morphValue;
		return true;
	}
	if (std::strcmp("lowerlippuff", morphName.c_str()) == 0) {
		theFacialExpression->lowerLipPuff = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipsuck", morphName.c_str()) == 0) {
		theFacialExpression->lowerLipSuck = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipthickness", morphName.c_str()) == 0) {
		theFacialExpression->lowerLipThickness = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipupl", morphName.c_str()) == 0) {
		theFacialExpression->lowerLipUpL = morphValue;
		return true;
	}
	if (std::strcmp("lowerlipupr", morphName.c_str()) == 0) {
		theFacialExpression->lowerLipUpR = morphValue;
		return true;
	}
	if (std::strcmp("nasolabialfurrowl", morphName.c_str()) == 0) {
		theFacialExpression->nasolabialFurrowL = morphValue;
		return true;
	}
	if (std::strcmp("nasolabialfurrowr", morphName.c_str()) == 0) {
		theFacialExpression->nasolabialFurrowR = morphValue;
		return true;
	}
	if (std::strcmp("neckflexl", morphName.c_str()) == 0) {
		theFacialExpression->neckFlexL = morphValue;
		return true;
	}
	if (std::strcmp("neckflexr", morphName.c_str()) == 0) {
		theFacialExpression->neckFlexR = morphValue;
		return true;
	}
	if (std::strcmp("nosedepressor", morphName.c_str()) == 0) {
		theFacialExpression->noseDepressor = morphValue;
		return true;
	}
	if (std::strcmp("nosewrinklel", morphName.c_str()) == 0) {
		theFacialExpression->noseWrinkleL = morphValue;
		return true;
	}
	if (std::strcmp("nosewrinkler", morphName.c_str()) == 0) {
		theFacialExpression->noseWrinkleR = morphValue;
		return true;
	}
	if (std::strcmp("nostrilcompressor", morphName.c_str()) == 0) {
		theFacialExpression->nostrilCompressor = morphValue;
		return true;
	}
	if (std::strcmp("nostrildilator", morphName.c_str()) == 0) {
		theFacialExpression->nostrilDilator = morphValue;
		return true;
	}
	if (std::strcmp("outerbrowraisel", morphName.c_str()) == 0) {
		theFacialExpression->outerBrowRaiseL = morphValue;
		return true;
	}
	if (std::strcmp("outerbrowraiser", morphName.c_str()) == 0) {
		theFacialExpression->outerBrowRaiseR = morphValue;
		return true;
	}
	if (std::strcmp("sharplippulll", morphName.c_str()) == 0) {
		theFacialExpression->sharpLipPullL = morphValue;
		return true;
	}
	if (std::strcmp("sharplippullr", morphName.c_str()) == 0) {
		theFacialExpression->sharpLipPullR = morphValue;
		return true;
	}
	if (std::strcmp("squintl", morphName.c_str()) == 0) {
		theFacialExpression->squintL = morphValue;
		return true;
	}
	if (std::strcmp("squintr", morphName.c_str()) == 0) {
		theFacialExpression->squintR = morphValue;
		return true;
	}
	if (std::strcmp("swallow", morphName.c_str()) == 0) {
		theFacialExpression->swallow = morphValue;
		return true;
	}
	if (std::strcmp("upperlipdownl", morphName.c_str()) == 0) {
		theFacialExpression->upperLipDownL = morphValue;
		return true;
	}
	if (std::strcmp("upperlipdownr", morphName.c_str()) == 0) {
		theFacialExpression->upperLipDownR = morphValue;
		return true;
	}
	if (std::strcmp("upperlipfunnel", morphName.c_str()) == 0) {
		theFacialExpression->upperLipFunnel = morphValue;
		return true;
	}
	if (std::strcmp("upperlippuff", morphName.c_str()) == 0) {
		theFacialExpression->upperLipPuff = morphValue;
		return true;
	}
	if (std::strcmp("upperlipraisel", morphName.c_str()) == 0) {
		theFacialExpression->upperLipRaiseL = morphValue;
		return true;
	}
	if (std::strcmp("upperlipraiser", morphName.c_str()) == 0) {
		theFacialExpression->upperLipRaiseR = morphValue;
		return true;
	}
	if (std::strcmp("upperlipsuck", morphName.c_str()) == 0) {
		theFacialExpression->upperLipSuck = morphValue;
		return true;
	}
	if (std::strcmp("upperlipthickness", morphName.c_str()) == 0) {
		theFacialExpression->upperLipThickness = morphValue;
		return true;
	}
	if (std::strcmp("tonguecurldown", morphName.c_str()) == 0) {
		theFacialExpression->tongueCurlDown = morphValue;
		return true;
	}
	if (std::strcmp("tonguecurlup", morphName.c_str()) == 0) {
		theFacialExpression->tongueCurlUp = morphValue;
		return true;
	}
	if (std::strcmp("tonguedown", morphName.c_str()) == 0) {
		theFacialExpression->tongueDown = morphValue;
		return true;
	}
	if (std::strcmp("tongueup", morphName.c_str()) == 0) {
		theFacialExpression->tongueUp = morphValue;
		return true;
	}
	if (std::strcmp("tonguein", morphName.c_str()) == 0) {
		theFacialExpression->tongueIn = morphValue;
		return true;
	}
	if (std::strcmp("tongueout", morphName.c_str()) == 0) {
		theFacialExpression->tongueOut = morphValue;
		return true;
	}
	if (std::strcmp("tongueleft", morphName.c_str()) == 0) {
		theFacialExpression->tongueLeft = morphValue;
		return true;
	}
	if (std::strcmp("tongueright", morphName.c_str()) == 0) {
		theFacialExpression->tongueRight = morphValue;
		return true;
	}
	if (std::strcmp("tonguethick", morphName.c_str()) == 0) {
		theFacialExpression->tongueThick = morphValue;
		return true;
	}
	if (std::strcmp("tonguethinner", morphName.c_str()) == 0) {
		theFacialExpression->tongueThinner = morphValue;
		return true;
	}
	if (std::strcmp("lookdown", morphName.c_str()) == 0) {
		theFacialExpression->LookDown = morphValue;
		return true;
	}
	if (std::strcmp("lookup", morphName.c_str()) == 0) {
		theFacialExpression->LookUp = morphValue;
		return true;
	}
	if (std::strcmp("lookright", morphName.c_str()) == 0) {
		theFacialExpression->LookRight = morphValue;
		return true;
	}
	if (std::strcmp("lookleft", morphName.c_str()) == 0) {
		theFacialExpression->LookLeft = morphValue;
		return true;
	}
	return false;
}

inline static std::vector<RE::TESQuest*> GetAllRunningQuests()
{
	std::vector<RE::TESQuest*> Result;
	auto                       StoryTeller = RE::BGSStoryTellerCustom::GetSingleton();
	if (!StoryTeller)
		return Result;
	if (StoryTeller->runningQuests.size() == 0)
		return Result;
	for (auto& it : StoryTeller->runningQuests)
		Result.push_back(it);
	return Result;
}

inline static bool ConvertAddressFromFileToRelocationID(std::string File)
{
	if (File.empty())
		return false;
	std::error_code error;
	auto            theSize = std::filesystem::file_size(File, error);
	if (error)
		return false;
	if (std::filesystem::exists(File.c_str()) == false || std::filesystem::is_regular_file(File.c_str()) == false)
		return false;
	//std::string File = ".\\Data\\SFSE\\Plugins\\events.txt";
	if (std::filesystem::exists(File.c_str()) == false) {
		return false;
	}
	std::ifstream file(File);
	if (!file.is_open()) {
		return false;
	}
	if (file.bad()) {
		return false;
	}
	if (file.fail()) {
		return false;
	}
	std::vector<std::string> lines;
	std::string              sLine;
	while (std::getline(file, sLine)) {
		if (sLine.empty() == false) {
			const char* chLine = sLine.c_str();
			if (chLine) {
				lines.push_back(sLine);
			}
		}
		sLine = "";
		if (file.eof())
			break;
	}
	if (lines.empty())
		return false;
	for (uint32_t i = 0; i < lines.size(); i++) {
		unsigned int number = 0;
		try {
			number = std::stoul(lines.at(i), nullptr, 16);
			if (number == 0) {
				LogError("number == 0 at(" + std::to_string(i) + ") at line " + lines.at(i));
				continue;
			}

		} catch (...) {
			LogError("exception at(" + std::to_string(i) + ") at line " + lines.at(i));
			continue;
		}
		//auto off = REL::Offset::Offset(number);
		auto id = REL::database::Offset2ID()(number);
		LogInfo(std::to_string(id) + "|" + lines.at(i));
	}
	return true;
}

inline static std::string GetGameINISetting(std::string sSetting, int iSettingType)  // iSettingType: 1 = float, 2 = int, 3 = bool
{
	if (sSetting.empty() == false) {
		auto Set1 = RE::INISettingCollection::GetSingleton()->GetSetting(sSetting.c_str());
		if (Set1) {
			if (iSettingType == 1) {
				return std::to_string(Set1->GetFloat());
			} else if (iSettingType == 2) {
				return std::to_string(Set1->GetInt());
			} else if (iSettingType == 3) {
				return std::to_string(Set1->GetBool());
			} else if (iSettingType == 4) {
				return std::to_string(Set1->GetUInt());
			} else if (iSettingType == 5) {
				return Set1->GetString().data();
			}
		}
	}
	return "";
}

inline static std::string GetGameINIPrefSetting(std::string sSetting, int iSettingType)  // iSettingType: 1 = float, 2 = int, 3 = bool
{
	if (sSetting.empty() == false) {
		auto Set1 = RE::INIPrefSettingCollection::GetSingleton()->GetSetting(sSetting.c_str());
		if (Set1) {
			if (iSettingType == 1) {
				return std::to_string(Set1->GetFloat());
			} else if (iSettingType == 2) {
				return std::to_string(Set1->GetInt());
			} else if (iSettingType == 3) {
				return std::to_string(Set1->GetBool());
			} else if (iSettingType == 4) {
				return std::to_string(Set1->GetUInt());
			} else if (iSettingType == 5) {
				return Set1->GetString().data();
			}
		}
	}
	return "";
}

inline static bool SetGameINISetting(std::string sSetting, std::string sValue, int iSettingType)  // iSettingType: 1 = float, 2 = int, 3 = bool
{
	if (sSetting.empty() == false) {
		auto Set1 = RE::INISettingCollection::GetSingleton()->GetSetting(sSetting.c_str());
		if (Set1) {
			try {
				if (iSettingType == 1) {
					float fVal = std::stof(sValue);
					Set1->SetFloat(fVal);
					if (Set1->GetFloat() == fVal) {
						return true;
					}
				} else if (iSettingType == 2) {
					int32_t uVal = std::stoul(sValue);
					Set1->SetInt(uVal);
					if (Set1->GetInt() == uVal) {
						return true;
					}
				} else if (iSettingType == 3) {
					int32_t uVal = std::stoul(sValue);
					if (uVal == 0)
						Set1->SetBool(false);
					else
						Set1->SetBool(true);
					return true;
				} else if (iSettingType == 4) {
					uint32_t uVal = std::stoul(sValue);
					Set1->SetUInt(uVal);
					if (Set1->GetUInt() == uVal) {
						return true;
					}
				} else if (iSettingType == 5) {
					Set1->SetString(sValue.c_str());
					auto ch = Set1->GetString().data();
					if (!ch)
						return false;
					if (std::string(ch).empty() || std::strcmp(ToLowerStr(ch).c_str(), ToLowerStr(sValue).c_str()) == 0) {
						return true;
					}
				}
			}
			catch (...) {
				LogError("exception: sSetting [" + sSetting + "] sValue [" + sValue + "] iSettingType [" + std::to_string(iSettingType) + "]");
			}
		}
	}
	return false;
}

inline static bool SetGameINIPrefSetting(std::string sSetting, std::string sValue, int iSettingType)  // iSettingType: 1 = float, 2 = int, 3 = bool, 4 = uint
{
	if (sSetting.empty() == false) {
		auto Set1 = RE::INIPrefSettingCollection::GetSingleton()->GetSetting(sSetting.c_str());
		if (Set1) {
			try {
				if (iSettingType == 1) {
					float fVal = std::stof(sValue);
					Set1->SetFloat(fVal);
					if (Set1->GetFloat() == fVal) {
						return true;
					}
				} else if (iSettingType == 2) {
					int32_t uVal = std::stoul(sValue);
					Set1->SetInt(uVal);
					if (Set1->GetInt() == uVal) {
						return true;
					}
				} else if (iSettingType == 3) {
					int32_t uVal = std::stoul(sValue);
					if (uVal == 0)
						Set1->SetBool(false);
					else
						Set1->SetBool(true);
					return true;
				} else if (iSettingType == 4) {
					uint32_t uVal = std::stoul(sValue);
					Set1->SetUInt(uVal);
					if (Set1->GetUInt() == uVal) {
						return true;
					}
				} else if (iSettingType == 5) {
					Set1->SetString(sValue.c_str());
					auto ch = Set1->GetString().data();
					if (!ch)
						return false;
					if (std::string(ch).empty() || std::strcmp(ToLowerStr(ch).c_str(), ToLowerStr(sValue).c_str()) == 0) {
						return true;
					}
				}
			}
			catch (...) {
				LogError("exception: sSetting [" + sSetting + "] sValue [" + sValue + "] iSettingType [" + std::to_string(iSettingType) + "]");
			}
		}
	}
	return false;
}

inline static RE::Setting* GetGameSettingInternal(const char* settingName)
{
	if (!settingName)
		return nullptr;
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(88638) };
	uintptr_t                  addr = funcPtr.address();
	const auto func = reinterpret_cast<RE::Setting* (*)(RE::GameSettingCollection*, const char*)>(addr);
	return func(RE::GameSettingCollection::GetSingleton(), settingName);
}

inline static std::string GetGameSetting(std::string sSetting, int iSettingType)
{
	if (sSetting.empty() == false) {
		auto Set1 = GetGameSettingInternal(sSetting.c_str());
		if (Set1) {
			if (iSettingType == 1) {
				return std::to_string(Set1->GetFloat());
			} else if (iSettingType == 2) {
				return std::to_string(Set1->GetInt());
			} else if (iSettingType == 3) {
				return std::to_string(Set1->GetBool());
			} else if (iSettingType == 4) {
				return std::to_string(Set1->GetUInt());
			} else if (iSettingType == 5) {
				return Set1->GetString().data();
			}
		}
	}
	return "";
}

inline static bool SetGameSetting(std::string sSetting, std::string sValue, int iSettingType)
{
	if (sSetting.empty() == false) {
		auto Set1 = GetGameSettingInternal(sSetting.c_str());
		if (Set1) {
			try {
				if (iSettingType == 1) {
					float fVal = std::stof(sValue);
					Set1->SetFloat(fVal);
					if (Set1->GetFloat() == fVal) {
						return true;
					}
				} else if (iSettingType == 2) {
					int32_t uVal = std::stoul(sValue);
					Set1->SetInt(uVal);
					if (Set1->GetInt() == uVal) {
						return true;
					}
				} else if (iSettingType == 3) {
					int32_t uVal = std::stoul(sValue);
					if (uVal == 0)
						Set1->SetBool(false);
					else
						Set1->SetBool(true);
					return true;
				} else if (iSettingType == 4) {
					uint32_t uVal = std::stoul(sValue);
					Set1->SetUInt(uVal);
					if (Set1->GetUInt() == uVal) {
						return true;
					}
				} else if (iSettingType == 5) {
					Set1->SetString(sValue.c_str());
					auto chNewValue = Set1->GetString().data();
					if (!chNewValue)
						return false;
					if (std::string(chNewValue).empty() || std::strcmp(ToLowerStr(chNewValue).c_str(), ToLowerStr(sValue).c_str()) == 0)
						return true;
				}
			} catch (...) {
				LogError("exception: sSetting [" + sSetting + "] sValue [" + sValue + "] iSettingType [" + std::to_string(iSettingType) + "]");
			}
		}
	}
	return false;
}

inline static int32_t GetInterfaceLanguageIndex()
{
	std::string sLanguage = GetGameINISetting("sLanguage:General", 5);
	//if (sLanguage.size() != 2) {
	if (sLanguage.empty()) {	// new design since v1.14.70
	//	LogError("sINILanguage.size != 2 --> " + sLanguage);
		LogError("sINILanguage is empty");
		return -1;
	}
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(211747) };  // 0x38103AC  in v1.13.61
	uintptr_t                  addr = funcPtr.address();
	const auto                 func = reinterpret_cast<int32_t (*)(char*)>(addr);
	return func(sLanguage.data());
}

inline static void ShowMessageBox(std::string Message, bool bExit) {
	MessageBoxA(NULL, Message.c_str(), std::string(PluginVersionInfo::PROJECT.data() + std::string(" v") + PluginVersionInfo::NAME.data()).c_str(), NULL);
	if (bExit)
		std::exit(0);
}

inline static void ShowDebugMessageBox(std::string Message)
{
	REL::Relocation<uintptr_t> ptr{ REL::ID(170828) };  // 0x2B403A0 in v1.12.36
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<void (*)(uintptr_t, uintptr_t, uintptr_t, RE::BSFixedString*)>(addr);
	RE::BSFixedString msg(Message.c_str());
	func(0, 0, 0, &msg);
}

inline static bool PerformMinRequiredVersionCheck(const SFSE::LoadInterface* sfse, REL::Version MinRequiredSFSEVerison, REL::Version MinRequiredRuntimeVersion)
{
	auto DetectedSFSEVersion = REL::Version::unpack(sfse->SFSEVersion());
	auto DetectedRuntimeVersion = sfse->RuntimeVersion();
	if (DetectedRuntimeVersion < MinRequiredRuntimeVersion || DetectedSFSEVersion < MinRequiredSFSEVerison) {
		std::string sText;
		sText = "Detected Starfield version: " + DetectedRuntimeVersion.string() + "\n";
		sText = sText + "Minimum required Starfield version: " + MinRequiredRuntimeVersion.string() + "\n";
		sText = sText + "\n";
		sText = sText + "Detected SFSE version: " + DetectedSFSEVersion.string() + "\n";
		sText = sText + "Minimum required SFSE version: " + MinRequiredSFSEVerison.string() + "\n";
		sText = sText + "\n";
		sText = sText + "Errors:" + "\n";
		if (DetectedRuntimeVersion < MinRequiredRuntimeVersion)
			sText = sText + "--> detected Starfield version lower than the minimum required version" + "\n";
		if (DetectedSFSEVersion < MinRequiredSFSEVerison)
			sText = sText + "--> detected SFSE version is lower than the minimum required version" + "\n";
		ShowMessageBox(sText, false);
		return false;
	}
	return true;
}

inline static bool PerformSupportedVersionCheck(const SFSE::LoadInterface* sfse, REL::Version MinRequiredSFSEVerison, REL::Version SupportedRuntimeVersion)
{
	auto DetectedSFSEVersion = REL::Version::unpack(sfse->SFSEVersion());
	auto DetectedRuntimeVersion = sfse->RuntimeVersion();
	if (DetectedRuntimeVersion != SupportedRuntimeVersion || DetectedSFSEVersion < MinRequiredSFSEVerison) {
		std::string sText;
		sText = "Detected Starfield version: " + DetectedRuntimeVersion.string() + "\n";
		sText = sText + "Supported Starfield version: " + SupportedRuntimeVersion.string() + "\n";
		sText = sText + "\n";
		sText = sText + "Detected SFSE version: " + DetectedSFSEVersion.string() + "\n";
		sText = sText + "Minimum required SFSE version: " + MinRequiredSFSEVerison.string() + "\n";
		sText = sText + "\n";
		sText = sText + "Errors:" + "\n";
		if (DetectedRuntimeVersion != SupportedRuntimeVersion)
			sText = sText + "--> detected Starfield version is not the supported version" + "\n";
		if (DetectedSFSEVersion < MinRequiredSFSEVerison)
			sText = sText + "--> detected SFSE version is lower than the minimum required version" + "\n";
		ShowMessageBox(sText, false);
		return false;
	}
	return true;
}

inline static RE::BGSPackIn* GetGroupedPackIn(RE::TESObjectREFR* theRef)
{
    if (!theRef)
        return nullptr;
    auto extraListSmPtr = &theRef->extraDataList;
    if (!extraListSmPtr)
        return nullptr;
    auto extraList = theRef->extraDataList.get();
    if (!extraList)
        return nullptr;
    RE::BSExtraData* Extra = extraList->GetByType(RE::ExtraDataType::kGroupedPackin);
    if (!Extra)
        return nullptr;
    RE::ExtraGroupedPackin* theExtra = (RE::ExtraGroupedPackin*)Extra;
    if (!theExtra)
        return nullptr;
    auto Result = theExtra->groupedPackIn;
    if (Result != nullptr) {
        return Result;
    }
    return nullptr;
}

inline static RE::BGSPackIn* GetSourcePackIn(RE::TESObjectREFR* theRef)
{
    if (!theRef)
        return nullptr;
    auto extraListSmPtr = &theRef->extraDataList;
    if (!extraListSmPtr)
        return nullptr;
    auto extraList = theRef->extraDataList.get();
    if (!extraList)
        return nullptr;
    RE::BSExtraData* Extra = extraList->GetByType(RE::ExtraDataType::kSourcePackIn);
    if (!Extra)
        return nullptr;
    RE::ExtraSourcePackin* theExtra = (RE::ExtraSourcePackin*)Extra;
    if (!theExtra)
        return nullptr;
    auto Result = theExtra->sourcePackIn;
    if (Result != nullptr) {
        return Result;
    }
    return nullptr;
}

inline static RE::TESObjectREFR* GetWorkbenchMenuInventoryRendererRef(std::string sWorkbenchMenu)		// not suitable for Papyrus, not thread safe as the inventoryRef may get deleted
{
	if (sWorkbenchMenu.empty())
		return nullptr;
	auto wbMenu = GetMenu(sWorkbenchMenu);
	if (!wbMenu)
		return nullptr;
	auto MenuName = wbMenu->GetName();
	if (!MenuName)
		return nullptr;
	if (std::string(MenuName).empty())
		return nullptr;
	RE::TESObjectREFR* inventoryItemRef = nullptr;
	try {
		RE::UICellRenderer_InventoryItemCustom* InventoryItem = nullptr;
		if (std::strcmp(MenuName, "WeaponsCraftingMenu") == 0) {
			auto WPNMenu = (RE::WeaponsCraftingMenuCustom*)wbMenu;
			if (!WPNMenu)
				return nullptr;
			InventoryItem = WPNMenu->GetInventoryItem();
		} else if (std::strcmp(MenuName, "ArmorCraftingMenu") == 0) {
			auto ArmorMenu = (RE::ArmorCraftingMenuCustom*)wbMenu;
			if (!ArmorMenu)
				return nullptr;
			InventoryItem = ArmorMenu->GetInventoryItem();
		}
		if (!InventoryItem)
			return nullptr;
		inventoryItemRef = InventoryItem->GetInventoryItemRef();
	}
	catch (...) {
		LogError("exception | sWorkbenchMenu [" + sWorkbenchMenu + "]");
		return nullptr;
	}		
	if (inventoryItemRef)
		return inventoryItemRef;
	return nullptr;
}

inline static std::vector<RE::BGSKeyword*> GetAllKeywords()
{
    std::vector<RE::BGSKeyword*> Result;
    auto                         DataHandler = RE::TESDataHandler::GetSingleton();
    if (!DataHandler)
        return Result;
    auto AllKeywords = GetAsBSTArrayCustom(&DataHandler->pFormArray[4].formArray);
    if (AllKeywords->size() == 0) {
        return Result;
    }
    for (auto i : *AllKeywords) {
        auto form = i.get();
        if (form) {
            RE::BGSKeyword* j = (RE::BGSKeyword*)form;
            Result.push_back(j);
        }
    }
    return Result;
}

inline static std::vector<RE::TESFaction*> GetAllFactions()
{
    std::vector<RE::TESFaction*> Result;
    auto                         DataHandler = RE::TESDataHandler::GetSingleton();
    if (!DataHandler)
        return Result;
    auto AllFactions = GetAsBSTArrayCustom(&DataHandler->pFormArray[13].formArray);
    if (AllFactions->size() == 0) {
        return Result;
    }
    for (auto i : *AllFactions) {
        auto form = i.get();
        if (form) {
            RE::TESFaction* j = (RE::TESFaction*)form;
            Result.push_back(j);
        }
    }
    return Result;
}

inline static bool IsTrueForCondition(RE::TESCondition Condition, RE::TESObjectREFR* Reference)  // this function checks all "condition items", tested on BGSConditionForms
{
	//
	// uintptr_t  baseAddr     = (uintptr_t)GetModuleHandle("Starfield.exe"); // vanilla, non-CLib
	// uintptr_t  relativeAddr = baseAddr + 0x1C8DB84;                        // v1.9.67.
	// const auto func         = reinterpret_cast<int (*)(RE::TESCondition, RE::TESObjectREFR**)>(relativeAddr);
	// return func(Condition, Reference);
	//
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(116104) };
	uintptr_t                  addr = funcPtr.address();
	RE::TESObjectREFR** Subject = &Reference;
	const auto          func = reinterpret_cast<bool (*)(RE::TESCondition, RE::TESObjectREFR**)>(addr);
	auto                Result = func(Condition, Subject);
	return Result;
}

inline static BYTE IsTrueForConditionItem(RE::TESConditionItem* ConditionItem, RE::TESObjectREFR* Reference)  // can be used on individual condition items
{
	//
	// uintptr_t  relativeAddr = baseAddr + 0x1c54670;                        // v1.8.88
	//
	REL::Relocation<uintptr_t> funcPtr{ REL::ID(116127) };
	uintptr_t                  addr = funcPtr.address();
	RE::TESObjectREFR** Subject = &Reference;
	const auto          func = reinterpret_cast<BYTE (*)(RE::TESConditionItem*, RE::TESObjectREFR**)>(addr);
	auto                Result = func(ConditionItem, Subject);
	return Result;
}

inline static std::string GetLastErrorAsString()
{
	DWORD errorMessageID = ::GetLastError();
	if (errorMessageID == 0) {
		return std::string();
	}
	LPSTR       messageBuffer = nullptr;
	size_t      size = FormatMessageA(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			 NULL, errorMessageID, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPSTR)&messageBuffer, 0, NULL);
	std::string message(messageBuffer, size);
	LocalFree(messageBuffer);
	return message;
}

inline static bool InGameWorld()
{
    if (RE::UI::GetSingleton()->IsMenuOpen("MainMenu") == false) {
        auto PlayerActor = RE::PlayerCharacter::GetSingleton();
        if (PlayerActor && PlayerActor->parentCell)
            return true;
    }
    return false;
}

template <typename T>           // SEH Exceptions must be enabled !!!
inline T* ProtectPtr(T* test)
{
    if (test == NULL) {
        throw std::runtime_error("Nullptr exception");
    }
    return test;
}

inline static bool CanBePersistentPromoter(unsigned long long* unverifiedFormAddress, bool bPromoters) // unverifiedFormAddress should point to the vTable, not to RE::TESForm      // SEH Exceptions must be enabled!!!
{
    if (!unverifiedFormAddress)
        return false;
    unsigned long long* PtrCheck = nullptr;
    try {
        PtrCheck = ProtectPtr(unverifiedFormAddress);
    }
    catch (...) {
        LogError("PtrCheck exception");
        return false;
    }
    if (!PtrCheck)
        return false;
    for (auto& i : RE::VTABLE::TESForm)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESNPC)
        if (i.address() == *unverifiedFormAddress)
			return true;
	for (auto& i : RE::VTABLE::PlayerCharacter)
		if (i.address() == *unverifiedFormAddress)
			return true;
    for (auto& i : RE::VTABLE::BGSLocationRefType)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESFaction)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::EffectSetting)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::SpellItem)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESObjectACTI)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESObjectARMO)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESObjectBOOK)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESObjectCONT)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESObjectDOOR)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESObjectMISC)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSStaticCollection)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSPackIn)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSMovableStatic)
        if (i.address() == *unverifiedFormAddress)
			return true;
    for (auto& i : RE::VTABLE::TESFlora)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESFurniture)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESObjectWEAP)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESAmmo)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESNPC)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESLevCharacter)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSLevPackIn)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESKey)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::AlchemyItem)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSIdleMarker)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSNote)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSTerminal)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSGenericBaseForm)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSLevGenericBaseForm)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESObjectCELL)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESObjectREFR)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::Actor)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESWorldSpace)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESQuest)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESIdleForm)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESPackage)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESLevSpell)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::TESEffectShader)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSListForm)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSPerk)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSLocation)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSScene)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSReferenceGroup)
        if (i.address() == *unverifiedFormAddress)
            return true;
    for (auto& i : RE::VTABLE::BGSTerminalMenu)
        if (i.address() == *unverifiedFormAddress)
            return true;
    if (!bPromoters) {
        for (auto& i : RE::VTABLE::EnchantmentItem)
            if (i.address() == *unverifiedFormAddress)
                return true;
        for (auto& i : RE::VTABLE::TESObjectSTAT)
            if (i.address() == *unverifiedFormAddress)
                return true;
        for (auto& i : RE::VTABLE::TESFaction)
            if (i.address() == *unverifiedFormAddress)
                return true;
    }
    return false;
}

inline static bool IsInGodMode() {
	//REL::Relocation<uintptr_t> bGodModeReloc{ REL::ID(881134) };  // 0x6889249 in v1.12.36
	REL::Relocation<uintptr_t> bGodModeReloc{ REL::ID(2242333) };	// 0x696B4EC in v1.36.61 (probably due to compiler optimization)
	uintptr_t                  bGodModeAddr = bGodModeReloc.address();
	auto                       bGodModePtr = reinterpret_cast<bool*>(bGodModeAddr);
	if (bGodModePtr && *bGodModePtr)
		return true;
	return false;
}

inline static bool IsPlayerSpaceshipFlyingBackward()
{
	auto UISingleton = RE::UI::GetSingleton();
	if (UISingleton && UISingleton->IsMenuOpen("SpaceshipHudMenu")) {
		auto speedLabelText = GetAS3VariableAsString("SpaceshipHudMenu", "root1.Menu_mc.Reticle_mc.ShipReticle_mc.SpeedName_mc.ReverseBG_mc.visible", UISingleton);
		if (!speedLabelText.empty() && std::strcmp(speedLabelText.c_str(), "True") == 0)
			return true;
	}
	return false;
}

inline static int GetPlayerSpaceshipCurrentSpeed()
{
	auto UISingleton = RE::UI::GetSingleton();
	if (UISingleton && UISingleton->IsMenuOpen("SpaceshipHudMenu")) {
		auto speedLabelText = GetAS3VariableAsString("SpaceshipHudMenu", "root1.Menu_mc.Reticle_mc.ShipReticle_mc.SpeedName_mc.Button_mc.Label_mc.LabelInstance_mc.Label_tf.text", UISingleton);
		if (!speedLabelText.empty()) {
			const std::regex pattern("[^0-9]");
			std::string      numbers = std::regex_replace(speedLabelText, pattern, "");
			int              i = 0;
			try {
				i = std::stoi(numbers);
			} catch (...) {
				return -1;
			}
			return i;
		}
	}
	return -1;
}

inline static int GetPlayerSpaceshipWeaponCapacity(int aiWeaponIndex)
{
	if (aiWeaponIndex < 1 || aiWeaponIndex > 3)
		return -1;
	auto UISingleton = RE::UI::GetSingleton();
	if (UISingleton && UISingleton->IsMenuOpen("SpaceshipHudMenu")) {
		std::string weaponName;
		if (aiWeaponIndex == 1)
			weaponName = "WeaponLeft1Name_mc";
		else if (aiWeaponIndex == 2)
			weaponName = "WeaponTop1Name_mc";
		else if(aiWeaponIndex == 3)
			weaponName = "WeaponRight1Name_mc";
		auto Text = GetAS3VariableAsString("SpaceshipHudMenu", "root1.Menu_mc.Reticle_mc.ShipReticle_mc." + weaponName + ".Button_mc.Label_mc.LabelInstance_mc.Label_tf.text", UISingleton);
		if (!Text.empty()) {
			const std::regex pattern("[^0-9]");
			std::string      numbers = std::regex_replace(Text, pattern, "");
			int              i = 0;
			try {
				i = std::stoi(numbers);
			} catch (...) {
				return -1;
			}
			return i;
		}
	}
	return -1;
}

inline static std::string GetPlayerSpaceshipWeaponType(int aiWeaponIndex)
{
	if (aiWeaponIndex < 1 || aiWeaponIndex > 3)
		return "";
	auto UISingleton = RE::UI::GetSingleton();
	if (UISingleton && UISingleton->IsMenuOpen("SpaceshipHudMenu")) {
		std::string weaponName;
		if (aiWeaponIndex == 1)
			weaponName = "WeaponLeft1Name_mc";
		else if (aiWeaponIndex == 2)
			weaponName = "WeaponTop1Name_mc";
		else if (aiWeaponIndex == 3)
			weaponName = "WeaponRight1Name_mc";
		auto Text = GetAS3VariableAsString("SpaceshipHudMenu", "root1.Menu_mc.Reticle_mc.ShipReticle_mc." + weaponName + ".Button_mc.Label_mc.LabelInstance_mc.Label_tf.text", UISingleton);
		if (!Text.empty()) {
			auto isAlpha = std::remove_if(std::begin(Text), std::end(Text), [](char c) {
				return !isalpha(c) || isspace(c);
			});
			Text.erase(isAlpha, std::end(Text));
			return Text;
		}
	}
	return "";
}

inline static float GetPlayerSpaceshipMaxFuelRange()
{
	auto UISingleton = RE::UI::GetSingleton();
	if (UISingleton && UISingleton->IsMenuOpen("GalaxyStarMapMenu")) {
		auto Text = GetAS3VariableAsString("GalaxyStarMapMenu", "root1.Menu_mc.JumpData_mc.FuelMeter_mc.Data_mc.text_tf.text", UISingleton);
		if (!Text.empty()) {
			float f = 0;
			try {
				f = std::stof(Text);
			} catch (...) {
				return -1.00f;
			}
			return f;
		}
	}
	return -1.00f;
}

inline static float GetPlayerSpaceshipFuelConsumption()
{
	auto UISingleton = RE::UI::GetSingleton();
	if (UISingleton && UISingleton->IsMenuOpen("GalaxyStarMapMenu")) {
		auto Text = GetAS3VariableAsString("GalaxyStarMapMenu", "root1.Menu_mc.JumpData_mc.FuelMeter_mc.MeterAmount_mc.amount_tf.text", UISingleton);
		if (!Text.empty()) {
			float f = 0;
			try {
				f = std::stof(Text);
			} catch (...) {
				return -1.00f;
			}
			return f;
		}
	}
	return -1.00f;
}

inline static bool CopyInventoryItems(RE::TESObjectREFR* sourceRef, RE::TESObjectREFR* targetRef, std::vector<int> validFormTypes)
{
	if (!sourceRef || !targetRef || sourceRef->formID == targetRef->formID || validFormTypes.size() == 0)
		return false;
	auto WeaponTypeUnarmed = GetWeaponTypeUnarmedKeyword();
	if (!WeaponTypeUnarmed)
		return false;
	auto InventoryList = sourceRef->inventoryList.lock_read().operator->();
	if (!InventoryList)
		return false;
	uint32_t InventoryItemCount = InventoryList->data.size();
	if (InventoryItemCount == 0)
		return false;
	uint32_t uTransferCount = 0;
	uint32_t uSkippedCount = 0;
	bool     bCopyWeapons = std::find(std::begin(validFormTypes), std::end(validFormTypes), static_cast<int>(RE::FormType::kWEAP)) < validFormTypes.end();
	bool     bCopyArmors = std::find(std::begin(validFormTypes), std::end(validFormTypes), static_cast<int>(RE::FormType::kARMO)) < validFormTypes.end();
	bool     bCopyPotions = std::find(std::begin(validFormTypes), std::end(validFormTypes), static_cast<int>(RE::FormType::kALCH)) < validFormTypes.end();
	bool     bCopyMiscItems = std::find(std::begin(validFormTypes), std::end(validFormTypes), static_cast<int>(RE::FormType::kMISC)) < validFormTypes.end();
	bool     bCopyNotes = std::find(std::begin(validFormTypes), std::end(validFormTypes), static_cast<int>(RE::FormType::kNOTE)) < validFormTypes.end();
	bool     bCopyBooks = std::find(std::begin(validFormTypes), std::end(validFormTypes), static_cast<int>(RE::FormType::kBOOK)) < validFormTypes.end();
	bool     bCopyAmmo = std::find(std::begin(validFormTypes), std::end(validFormTypes), static_cast<int>(RE::FormType::kAMMO)) < validFormTypes.end();
	bool     bCopyKeys = std::find(std::begin(validFormTypes), std::end(validFormTypes), static_cast<int>(RE::FormType::kKEYM)) < validFormTypes.end();
	LogDebug("copying items from inventory of " + GetBasicFormData(sourceRef) + " to " + GetBasicFormData(targetRef) + "...");
	for (uint32_t i = 0; i < InventoryList->data.size(); i++) {
		for (uint32_t j = 0; j < InventoryList->data[i].stacks.size(); j++) {
			auto& ExtraData = InventoryList->data[i].stacks[j].extra;
			auto& Count = InventoryList->data[i].stacks[j].count;
			auto& ItemBoundObj = InventoryList->data[i].object;
			auto  ItemFormType = ItemBoundObj->GetSavedFormType();
			// Non-Playable flag
			auto Flags = ItemBoundObj->formFlags & 0xFF;
			if (Flags == 13) {
				//	LogWarning("        Skipping this Item [" + GetUIntFormIDAsHex(FormID) + "]. Non-Playable.");
				uSkippedCount = uSkippedCount + 1;
				continue;
			}
			bool bCanCopy = false;
			if (bCopyWeapons && ItemFormType == static_cast<int>(RE::FormType::kWEAP))
				bCanCopy = true;
			else if (bCopyArmors && ItemFormType == static_cast<int>(RE::FormType::kARMO))
				bCanCopy = true;
			else if (bCopyPotions && ItemFormType == static_cast<int>(RE::FormType::kALCH))
				bCanCopy = true;
			else if (bCopyMiscItems && ItemFormType == static_cast<int>(RE::FormType::kMISC))
				bCanCopy = true;
			else if (bCopyNotes && ItemFormType == static_cast<int>(RE::FormType::kNOTE))
				bCanCopy = true;
			else if (bCopyBooks && ItemFormType == static_cast<int>(RE::FormType::kBOOK))
				bCanCopy = true;
			else if (bCopyAmmo && ItemFormType == static_cast<int>(RE::FormType::kAMMO))
				bCanCopy = true;
			else if (bCopyKeys && ItemFormType == static_cast<int>(RE::FormType::kKEYM))
				bCanCopy = true;
			if (!bCanCopy)
				continue;
			// Unarmed weapons: do not transfer these
			if (ItemFormType == 48) {
				// BaseForm keywords
				if (HasKeyword(ItemBoundObj, WeaponTypeUnarmed)) {
					//	LogWarning("        Skipping this Item [" + GetUIntFormIDAsHex(FormID) + "]. BaseObject.HasKeyword(Unarmed weapon).");
					uSkippedCount = uSkippedCount + 1;
					continue;
				}
				// InstanceData keywords (WeaponTypeUnarmed shouldn't be instance data though)
				auto InstanceData = InventoryList->data[i].instanceData.get();
				if (InstanceData != nullptr) {
					auto KeywordData = InstanceData->GetKeywordData();
					if (KeywordData != nullptr) {
						bool bIsUnarmedWeapon = false;
						KeywordData->ForEachKeyword([&](const RE::BGSKeyword* keyword) {
							if (keyword != nullptr && keyword->formID == 0x5240E) {
								bIsUnarmedWeapon = true;
							}
							return RE::BSContainer::ForEachResult::kContinue;
						});
						if (bIsUnarmedWeapon) {
							//	LogWarning("        Skipping this Item [" + GetUIntFormIDAsHex(FormID) + "]. InstanceData.HasKeyword(Unarmed weapon).");
							uSkippedCount = uSkippedCount + 1;
							continue;
						}  // else
						//   LogInfo("        DEBUG: KeywordData is nullptr.");
					}  // else
					   //   LogInfo("        DEBUG: NOT Unarmed weapon.");
				}
				// else
				//     LogInfo("        DEBUG: InstanceData is nullptr.");
			}
			targetRef->AddObjectToContainer(ItemBoundObj, ExtraData, Count, sourceRef, RE::ITEM_TRANSFER_REASON::kScriptRemoveItem);
			uTransferCount = uTransferCount + 1;
			LogDebug("copying ItemBoundObj " + GetBasicFormData(ItemBoundObj, true, false, true) + " with count: " + std::to_string(Count));
		}
	}
	return (uTransferCount > 0);
}

inline static int GetStringOccuranceCountInString(std::string s1, std::string s2, int iStartAt, bool bToLower)
{
	if (s1.empty()  || s2.empty() || iStartAt < 0)
		return -1;
	if (bToLower) {
		s1 = ToLowerStr(s1);
		s2 = ToLowerStr(s2);
	}
	int iCount = 0;
	while ((iStartAt = s1.find(s2, iStartAt)) != std::string::npos) {
		++iCount;
		iStartAt += s2.length();
	}
	return iCount;
}

inline static std::vector<RE::TESObjectREFR*> SortReferencesByDistance(std::vector<RE::TESObjectREFR*> theRefs, float fDistance, bool bCloserThan)
{
	std::vector<RE::TESObjectREFR*> Result;
	if (theRefs.empty() || fDistance < 0.0f)
		return Result;
	auto PlayerChar = RE::PlayerCharacter::GetSingleton();
	for (auto& it : theRefs) {
		if (!it)
			continue;
		auto distance = GetDistance(PlayerChar, it);
		if (distance <= 0.0f)
			continue;
		if ((bCloserThan && distance <= fDistance) || (!bCloserThan && distance >= fDistance))
			Result.push_back(it);
	}
	if (Result.size() > 0) {
		std::sort(Result.begin(), Result.end());
		Result.erase(std::unique(Result.begin(), Result.end()), Result.end());
	}
	return Result;
}

inline static std::vector<RE::TESObjectREFR*> SortReferencesByName(std::vector<RE::TESObjectREFR*> theRefs, std::string sName, bool bExactMatch, bool bReversed)
{
	std::vector<RE::TESObjectREFR*> Result;
	if (theRefs.empty() || sName.empty())
		return Result;
	sName = ToLowerStr(sName);
	for (auto& it : theRefs) {
		if (!it)
			continue;
		std::string sRefName = GetReferenceName(it);
		if (sRefName.empty())
			continue;
		sRefName = ToLowerStr(sRefName);
		if (!bReversed) {
			if (bExactMatch && std::strcmp(sRefName.c_str(), sName.c_str()) == 0 || !bExactMatch && GetStringOccuranceCountInString(sRefName, sName, 0, false)) {
				Result.push_back(it);
			}
		} else {
			if (bExactMatch && std::strcmp(sRefName.c_str(), sName.c_str()) == 0 || !bExactMatch && GetStringOccuranceCountInString(sRefName, sName, 0, false)) {
			} else {
				Result.push_back(it);
			}
		}
	}
	if (Result.size() > 0) {
		std::sort(Result.begin(), Result.end());
		Result.erase(std::unique(Result.begin(), Result.end()), Result.end());
	}
	return Result;
}

inline static std::vector<RE::TESObjectREFR*> SortReferencesByKeywords(std::vector<RE::TESObjectREFR*> theRefs, std::vector<RE::BGSKeyword*> theKeywords, bool bMustHaveAll)
{
	std::vector<RE::TESObjectREFR*> Result;
	if (theRefs.empty() || theKeywords.empty())
		return Result;
	for (auto& it : theRefs) {
		if (!it)
			continue;
		uint32_t HasKeywordCount = 0;
		for (uint32_t j = 0; j < theKeywords.size(); j++) {
			auto keyword = theKeywords.at(j);
			if (!keyword)
				continue;
			if (it->HasKeyword(keyword)) {
				if (!bMustHaveAll)
					Result.push_back(it);
				else {
					HasKeywordCount = HasKeywordCount + 1;
					if (HasKeywordCount >= theKeywords.size())
						Result.push_back(it);
				}
			}
		}
	}
	if (Result.size() > 0) {
		std::sort(Result.begin(), Result.end());
		Result.erase(std::unique(Result.begin(), Result.end()), Result.end());
	}
	return Result;
}

inline static bool IsTrue(RE::BGSConditionForm* theConditionForm, RE::TESObjectREFR* theSubjectRef, RE::TESObjectREFR* theTargetRef = nullptr) {
	if (!theConditionForm || !theSubjectRef)
		return false;
	REL::Relocation<uintptr_t> ptr{ REL::ID(167706) };  // 0x2A27880 in v1.12.36
	uintptr_t                  addr = ptr.address();
	const auto                 func = reinterpret_cast<int64_t (*)(uintptr_t, uintptr_t, RE::BGSConditionForm*, RE::TESObjectREFR*, RE::TESObjectREFR*)>(addr);
	auto                       Result = func(0, 0, theConditionForm, theSubjectRef, theTargetRef);
	LogDebug("result --> [" + std::to_string(Result) + "] | params: theConditionForm [" + GetBasicFormData(theConditionForm) + "], theSubjectRef [" + GetBasicFormData(theSubjectRef) + "], theTargetRef [" + GetBasicFormData(theTargetRef) + "]");
	return (Result != 0);
}

inline static std::vector<RE::TESObjectREFR*> SortReferencesByConditions(std::vector<RE::TESObjectREFR*> theSubjectRefs, std::vector<RE::TESObjectREFR*> theTargetRefs, std::vector<RE::BGSConditionForm*> theConditions, bool bConjuntive)
{
	std::vector<RE::TESObjectREFR*> Result;
	if (theSubjectRefs.empty() || theConditions.empty())
		return Result;
	if (theTargetRefs.size() > 0 && theTargetRefs.size() != theSubjectRefs.size())
		return Result;
	for (uint32_t i = 0; i < theSubjectRefs.size(); i++) {
		auto ref = theSubjectRefs.at(i);
		if (!ref)
			continue;
		uint32_t TrueConditionCount = 0;
		for (auto& cond : theConditions) {
			if (!cond)
				continue;
			RE::TESObjectREFR* target = nullptr;
			if (theTargetRefs.size() > 0)
				target = theTargetRefs.at(i);
			if (IsTrue(cond, ref, target)) {
				if (!bConjuntive)
					Result.push_back(ref);
				else {
					TrueConditionCount = TrueConditionCount + 1;
					if (TrueConditionCount >= theConditions.size())
						Result.push_back(ref);
				}
			}
		}
	}
	if (Result.size() > 0) {
		std::sort(Result.begin(), Result.end());
		Result.erase(std::unique(Result.begin(), Result.end()), Result.end());
	}
	return Result;
}

inline static std::vector<RE::TESObjectREFR*> SortReferencesByDeleted(std::vector<RE::TESObjectREFR*> theRefs, bool bRemoveDeleted)
{
	std::vector<RE::TESObjectREFR*> Result;
	if (theRefs.empty())
		return Result;
	for (auto& it : theRefs) {
		if (!it)
			continue;
		if (bRemoveDeleted) {
			if (it->IsDeleted() == false)
				Result.push_back(it);
		} else {
			if (it->IsDeleted() == true)
				Result.push_back(it);
		}
	}
	if (Result.size() > 0) {
		std::sort(Result.begin(), Result.end());
		Result.erase(std::unique(Result.begin(), Result.end()), Result.end());
	}
	return Result;
}

inline static std::vector<RE::TESForm*> GetPersistencePromoters(RE::TESObjectREFR* theRef) // "it just works" // SEH Exceptions must be enabled !!!
{
    std::vector<RE::TESForm*> Promoters;
    if (!theRef)
        return Promoters;
    LogDebug("called for reference [" + GetFormIDAsHex(theRef) + " | " + GetAddressAsHex(reinterpret_cast<unsigned long long>(theRef)) + "].");
    auto extraListSmPtr = &theRef->extraDataList;
    if (!extraListSmPtr)
        return Promoters;
    auto extraList = theRef->extraDataList.get();
    if (!extraList)
        return Promoters;
    RE::BSExtraData* Extra = extraList->GetByType(RE::ExtraDataType::kPromotedRef);
    if (!Extra)
        return Promoters;
    RE::ExtraPromotedRef* theExtra = (RE::ExtraPromotedRef*)Extra;
    if (!theExtra)
        return Promoters;
    auto                promoterStorage    = theExtra->promoterStorage;
    unsigned long long* promoterStoragePtr = nullptr;
    if (promoterStorage <= 10000000000 || promoterStorage >= StarfieldBaseAddress) {
        LogWarning("promoterStorage address [" + GetAddressAsHex(promoterStorage) + "] is out of range.");
        return Promoters;
    }
    else {
        unsigned long long* promoterStoragePtr_check = reinterpret_cast<unsigned long long*>(promoterStorage);
        if (!promoterStoragePtr_check) {
            LogError("promoterStoragePtr of reference is nullptr.");
            return Promoters;
        }
        else {
            promoterStoragePtr = promoterStoragePtr_check;
            LogInfo("promoterStorage of reference starts at address " + GetAddressAsHex(promoterStorage));
        }
    }
    int                   iStep            = 0;
    unsigned long long    previous_address = 0;
  //  std::vector<uint32_t> excludedIDs      = { 0x28A, 0x28B, 0x28C, 0x28D, 0x28E, 0x28F };
    try {
        for (int i = 0; i < 500; i++) {
            if ((promoterStorage + iStep) <= 10000000000 || (promoterStorage + iStep) >= StarfieldBaseAddress) {
                LogWarning("address to process [" + GetAddressAsHex((promoterStorage + iStep)) + "] is out of range. Exiting loop...");

            }
            else
                LogInfo("address to process [" + GetAddressAsHex((promoterStorage + iStep)) + "] is within range. Processing...");
            unsigned long long* Form_Ptr = reinterpret_cast<unsigned long long*>(promoterStorage + iStep); // points to RE::TESForm*
            if (Form_Ptr) {
                unsigned long long Form_address = *ProtectPtr(Form_Ptr); // address of RE::TESForm*
                if (Form_address <= 10000000000 || Form_address >= StarfieldBaseAddress) {
                    LogWarning("Form_address [" + GetAddressAsHex(Form_address) + "] is out of range. Exiting loop...");
                    break;
                }
                else
                    LogInfo("Form_address [" + GetAddressAsHex(Form_address) + "] is within range. Processing...");
                if (previous_address == Form_address) {
                    LogWarning("previous_address is the current: " + GetAddressAsHex(Form_address) + ". Skipping...");
                    iStep = iStep + 0x10;
                    continue;
                }
                else
                    LogInfo("previous_address [" + GetAddressAsHex(previous_address) + "] is not the current: [" + GetAddressAsHex(Form_address) + "]. Processing...");
                unsigned long long* Form_vTable = reinterpret_cast<unsigned long long*>(Form_address);
                if (!Form_vTable) {
                    LogError("Form_vTable is nullptr of Form_address: " + GetAddressAsHex(Form_address));
                    break;
                }
                else
                    LogInfo("Form_vTable is not nullptr of Form_address [" + GetAddressAsHex(Form_address) + "]. Processing...");
                unsigned long long Form_vTable_address = 0;
                Form_vTable_address                    = *ProtectPtr(Form_vTable);
                if (Form_vTable_address <= StarfieldBaseAddress || Form_vTable_address > (StarfieldBaseAddress + 443306496))
                { // 443306496 = (Starfield.exe (1.10.32) number of bytes * 3)
                    LogError("Form_vTable is out of range: " + GetAddressAsHex(Form_vTable_address));
                    break;
                }
                else
                    LogInfo("Form_vTable is within range: " + GetAddressAsHex(Form_vTable_address) + ". Processing...");
                if (CanBePersistentPromoter(Form_vTable, true) == false) {
                    LogError("Form_Ptr points to an unsupported form: " + GetAddressAsHex(Form_address));
                    break;
                }
                else
                    LogInfo("Form_Ptr points to a supported form: " + GetAddressAsHex(Form_address) + ". Processing...");
                previous_address  = Form_address;
                RE::TESForm* Form = reinterpret_cast<RE::TESForm*>(Form_address);
                if (Form) {
                   // if (std::find(std::begin(excludedIDs), std::end(excludedIDs), Form->formID) < excludedIDs.end())
                   // {
                   //     LogWarning("skipping promoter Form [" + GetFormIDAsHex(Form) + "] at address: " + GetAddressAsHex(Form_address) + " due to its FormID is being excluded.");
                   // }
                   // else {
                        LogInfo("acquired promoter Form [" + GetFormIDAsHex(Form) + "] at address: " + GetAddressAsHex(Form_address));
                        Promoters.push_back(Form);
                   // }
                }
            }
            iStep = iStep + 0x10;
        }
    }
    catch (...) {
        LogError("exception while parsing promoter array.");
    }
    LogInfo("acquired (" + std::to_string(Promoters.size()) + ") promoter Forms in total.");
    return Promoters;
}

inline static bool IsPersistencePromotedBy(RE::TESObjectREFR* theRef, RE::TESForm* theOwner)
{
	if (theRef && theOwner) {
		auto extra = theRef->extraDataList.get();
		if (extra) {
			REL::Relocation<uintptr_t> ptr{ REL::ID(83349) };  // 0x1476334 in v1.14.74
			uintptr_t                  addr = ptr.address();
			const auto                 func = reinterpret_cast<bool (*)(RE::ExtraDataList*, RE::TESForm*)>(addr);
			return func(extra, theOwner);
		}
	}
	return false;
}

inline static bool PromoteReference(RE::TESObjectREFR* theRef, RE::TESForm* theOwner)
{
	if (theRef && theOwner) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(87197) };  // 0x1573474 in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<bool (*)(RE::BGSDynamicPersistenceManager*, RE::TESObjectREFR*, RE::TESForm*, int32_t)>(addr);
		func(RE::BGSDynamicPersistenceManager::GetSingleton(), theRef, theOwner, 1);
		return IsPersistencePromotedBy(theRef, theOwner);
	}
	return false;
}

inline static bool DemoteReference(RE::TESObjectREFR* theRef, RE::TESForm* theOwner)
{
	if (theRef && theOwner) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(87176) };  // 0x1571DD4 in v1.14.74	
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<bool (*)(RE::BGSDynamicPersistenceManager*, RE::TESObjectREFR*, RE::TESForm*, int32_t)>(addr);
		func(RE::BGSDynamicPersistenceManager::GetSingleton(), theRef, theOwner, 0);
		return !IsPersistencePromotedBy(theRef, theOwner);
	}
	return false;
}

inline static bool IsPathing(RE::Actor* theActor)
{
	if (theActor) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(151001) };  // 0x26837C0 in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<bool (*)(RE::Actor*)>(addr);
		return func(theActor);
	}
	return false;
}

inline static bool UpdateReference3D(RE::TESObjectREFR* theRef)
{
	if (theRef) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(106983) };  // 0x1AA9754 in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<void (*)(RE::TESObjectREFR*)>(addr);
		func(theRef);
		return true;
	}
	return false;
}

inline static bool CalculateTemplateForLeveledActor(RE::Actor* theActor)
{
	if (theActor) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(151179) };  // 0x2695A48 in v1.14.74
		uintptr_t                  addr = ptr.address();
		uint32_t                   handle = 0;
		const auto                 func = reinterpret_cast<bool (*)(RE::Actor*, uint32_t, uint32_t)>(addr);
		bool                       bCalculated = func(theActor, -1, handle);
		if (bCalculated)
			UpdateReference3D(theActor);
		return bCalculated;
	}
	return false;
}

inline static bool ChangeActorProcessLevel(RE::Actor* theActor, int processLevel)
{
	if (theActor) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(150499) };  // 0x2661FEC in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<bool (*)(RE::Actor*, int)>(addr);
		return func(theActor, processLevel);
	}
	return false;
}

inline static float GetGravJumpRange(RE::TESObjectREFR* theShipRef)
{
	if (theShipRef) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(168041) };  // 0x2B63B00 in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<float (*)(uintptr_t, uintptr_t, RE::TESObjectREFR**)>(addr);
		return func(0, 0, &theShipRef);
	}
	return -1.00f;
}

inline static float GetDistanceFromCelestialBody(RE::TESObjectREFR* theRef, RE::BGSPlanet::PlanetData* celestialBody, bool bSurface)
{
	if (theRef && celestialBody) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(108663) };  // 0x1AFFA40 in v1.14.74
		uintptr_t                  addr = ptr.address();
		float                      result = 0.0f;
		const auto                 func = reinterpret_cast<bool (*)(RE::TESObjectREFR**, RE::BGSPlanet::PlanetData*, int, float*)>(addr);
		func(&theRef, celestialBody, bSurface, &result);
		return result;
	}
	return -1.00f;
}

inline static float GetDistanceGalacticLightYears(RE::TESObjectREFR* theRef, RE::TESObjectREFR* theRef2)
{
	if (theRef && theRef2) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(108665) };  // 0x1AFFEA0 in v1.14.74
		uintptr_t                  addr = ptr.address();
		float                      result = 0.0f;
		const auto                 func = reinterpret_cast<bool (*)(RE::TESObjectREFR**, RE::TESObjectREFR*, int, float*)>(addr);
		func(&theRef, theRef2, 0, &result);
		return result;
	}
	return -1.00f;
}

inline static float GetFuelConsumption(RE::TESObjectREFR* theShipRef)
{
	if (theShipRef) {
		auto baseobject = theShipRef->GetBaseObject();
		if (baseobject && baseobject->GetSavedFormType() == static_cast<int>(RE::FormType::kGBFM)) {
			REL::Relocation<uintptr_t> ptr{ REL::ID(173760) };  // 0x2DAD930 in v1.14.74
			uintptr_t                  addr = ptr.address();
			const auto                 func = reinterpret_cast<float (*)(RE::TESObjectREFR*)>(addr);
			return func(theShipRef);
		}
	}
	return -1.00f;
}

inline static RE::Actor* GetSpaceshipOwner(RE::TESObjectREFR* theShipRef)
{
	if (theShipRef) {
		auto baseobject = theShipRef->GetBaseObject();
		if (baseobject && baseobject->GetSavedFormType() == static_cast<int>(RE::FormType::kGBFM)) {
			REL::Relocation<uintptr_t> ptr{ REL::ID(173833) };  // 0x2DB3E50 in v1.14.74
			uintptr_t                  addr = ptr.address();
			const auto                 func = reinterpret_cast<RE::Actor* (*)(RE::TESObjectREFR*)>(addr);
			return func(theShipRef);
		}
	}
	return nullptr;
}

inline static float GetWeightInContainer(RE::TESObjectREFR* theRef)
{
	if (theRef) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(106688) };  // 0x1A8FDCC in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<float (*)(RE::TESObjectREFR*)>(addr);
		return func(theRef);
	}
	return -1.00f;
}

inline static float GetShipMaxCargoWeight(RE::TESObjectREFR* theShipRef)
{
	if (theShipRef) {
		auto baseobject = theShipRef->GetBaseObject();
		if (baseobject && baseobject->GetSavedFormType() == static_cast<int>(RE::FormType::kGBFM)) {
			REL::Relocation<uintptr_t> ptr{ REL::ID(173848) };  // 0x2DB51D8 in v1.14.74
			uintptr_t                  addr = ptr.address();
			const auto                 func = reinterpret_cast<float (*)(RE::TESObjectREFR*)>(addr);
			return func(theShipRef);
		}
	}
	return -1.00f;
}

inline static RE::BSFaceGenNiNode* GetFaceGenNiNode(RE::Actor* theActor)
{
	if (!theActor)
		return nullptr;
	try {
		auto currentProcess = theActor->currentProcess;
		if (!currentProcess)
			return nullptr;
		auto middleHighProcess = currentProcess->middleHigh;
		if (!middleHighProcess)
			return nullptr;
		auto faceDB = middleHighProcess->faceDB;
		if (!faceDB)
			return nullptr;
		auto faceGenNode = faceDB->faceGenNode;
		if (!faceGenNode)
			return nullptr;
		return faceGenNode;
	} catch (...) {

	}
	return nullptr;
}

inline static bool GetEyeTrackHandle(RE::Actor* theActor, uint32_t* eyetrackHandleOut)
{
	if (!theActor || !eyetrackHandleOut)
		return false;
	try {
		auto currentProcess = theActor->currentProcess;
		if (!currentProcess)
			return false;
		auto highProcess = currentProcess->high;
		if (!highProcess)
			return false;
		auto eyetrackHandle = highProcess->eyetrackHandle;
		*eyetrackHandleOut = eyetrackHandle;
		return true;
	} catch (...) {

	}
	return false;
}

inline static bool GetHeadTrackRefHandle(RE::Actor* theActor, uint32_t* headtrackHandleOut)
{
	if (!theActor || !headtrackHandleOut)
		return false;
	try {
		auto currentProcess = theActor->currentProcess;
		if (!currentProcess)
			return false;
		auto highProcess = currentProcess->high;
		if (!highProcess)
			return false;
		auto eyetrackHandle = highProcess->headtrackHandle;
		*headtrackHandleOut = eyetrackHandle;
		return true;
	} catch (...) {
	}
	return false;
}

inline static RE::Actor* GetActorByEyeTrackHandle(uint32_t eyetrackHandle, RE::ProcessListsCustom* ProcessListsCustomPassThru = nullptr)
{
	if (eyetrackHandle == -1)
		return nullptr;
	if (!ProcessListsCustomPassThru)
		ProcessListsCustomPassThru = RE::ProcessListsCustom::GetSingleton();
	for (auto& actorhandle : ProcessListsCustomPassThru->highActorProcessHandles) {
		auto actorref = RE::GetReferenceByHandle(actorhandle);
		if (!actorref || actorref->GetSavedFormType() != static_cast<int>(RE::FormType::kACHR))
			continue;
		auto actor = (RE::Actor*)actorref;
		if (!actor)
			continue;
		uint32_t foundEyetrackHandle = 0;
		auto     bGotEyeTrackHandle = GetEyeTrackHandle(actor, &foundEyetrackHandle);
		if (!bGotEyeTrackHandle || foundEyetrackHandle == -1)
			continue;
		if (eyetrackHandle == foundEyetrackHandle)
			return actor;
	}
	return nullptr;
}

inline static RE::TESObjectREFR* GetHeadTrackTarget(RE::Actor* theActor, bool bCheckHighProcess = false)
{
	if (theActor && (!bCheckHighProcess || IsHighActor(theActor->nativeHandle, nullptr))) {
		uint32_t HeadTrackHandle = -1;
		auto     bGotHeadTrackHandle = GetHeadTrackRefHandle(theActor, &HeadTrackHandle);
		if (bGotHeadTrackHandle && HeadTrackHandle > 0)
			return RE::GetReferenceByHandle(HeadTrackHandle);
	}
	return nullptr;
}

inline static RE::BSFaceGenAnimationData* GetFaceGenAnimDataNative(RE::Actor* theActor)
{
	if (theActor && theActor->currentProcess) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(152838) };  // 0x272AB90 in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<RE::BSFaceGenAnimationData* (*)(RE::AIProcess*, RE::Actor*)>(addr);
		return func(theActor->currentProcess, theActor);
	}
	return nullptr;
}

inline static bool GetActorEyeTrackTargetEyes(RE::Actor* theActor, RE::NiPointer<RE::NiAVObject>* EyesOut)
{
	if (theActor && theActor->currentProcess) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(152391) };  // 0x26F9DC0 in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<void (*)(RE::Actor*, RE::NiPointer<RE::NiAVObject>*)>(addr);
		func(theActor, EyesOut);
		return true;
	}
	return false;
}

inline static bool SetEyeTrackingActive(RE::Actor* theActor, bool bActive)
{
	if (theActor && GetFaceGenAnimDataNative(theActor)) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(152614) };  // 0x2718798 in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<void (*)(RE::AIProcess*, bool, RE::Actor*)>(addr);
		func(theActor->currentProcess, bActive, theActor);
		return true;
	}
	return false;
}

inline static bool SetEyeTargetNative(RE::Actor* theActor, RE::NiAVObject* theTargetNode = nullptr)
{
	if (theActor) {
		auto Face = GetFaceGenAnimDataNative(theActor);
		if (!Face)
			return false;
		if (!theActor->currentProcess || !theActor->currentProcess->high)
			return false;
		REL::Relocation<uintptr_t> funcPtr{ REL::ID(152673) };  // 0x271A970 in v1.14.74
		uintptr_t                  addr = funcPtr.address();
		const auto                 func = reinterpret_cast<void (*)(RE::HighProcessData*, RE::Actor*, RE::NiAVObject*, RE::BSFaceGenAnimationData*)>(addr);
		func(theActor->currentProcess->high, theActor, theTargetNode, Face);
		return true;
	}
	return false;
}

inline static bool SetEyeTargetHelperShouldTargetWorldCam(RE::Actor* theActor, RE::Actor* theTargetActor)
{
	RE::PlayerCamera* PlayerCam = RE::PlayerCamera::GetSingleton();
	bool              bPlayerSourceAndTarget = theActor == theTargetActor && theTargetActor->formID == 0x14;
	bool              bIsInDialogueCamera = PlayerCam->IsInDialogueCamera();
	bool              bIsInFirstPerson = PlayerCam->IsInFirstPerson();
	if (bPlayerSourceAndTarget && (bIsInDialogueCamera || bIsInFirstPerson))
		return false;
	if (theTargetActor->formID == 0x14 && (bIsInDialogueCamera || bIsInFirstPerson))
		return true;
	return false;
}

inline static bool SetEyeTarget(RE::Actor* theActor, RE::Actor* theTargetActor, bool bSkipReset)
{
	if (!theActor || !theTargetActor || theActor == theTargetActor && theTargetActor->formID != 0x14)
		return false;
	auto TargetFaceNode = GetFaceGenNiNode(theActor);
	if (TargetFaceNode) {
		if (SetEyeTargetHelperShouldTargetWorldCam(theActor, theTargetActor)) {
			if (bSkipReset || SetEyeTrackingActive(theActor, false) && SetEyeTrackingActive(theActor, true))
				return SetEyeTargetNative(theActor, RE::Main::GetSingleton()->WorldCamera());
		} else {
			RE::NiPointer<RE::NiAVObject> EyesPtr;
			auto                          eyesPtr = GetActorEyeTrackTargetEyes(theTargetActor, &EyesPtr);
			auto                          Eyes = EyesPtr.get();
			if (Eyes) {
				if (bSkipReset || SetEyeTrackingActive(theActor, false) && SetEyeTrackingActive(theActor, true))
						return SetEyeTargetNative(theActor, Eyes);
			}
		}
	}
	return false;
}

inline static bool ClearEyeTracking(RE::Actor* theActor)
{
	if (theActor && GetFaceGenAnimDataNative(theActor)) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(152580) };  // 0x2715194 in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<void (*)(RE::AIProcess*, RE::Actor*)>(addr);
		func(theActor->currentProcess, theActor);
		return true;
	}
	return false;
}

inline static bool SetFaceAnimArchetype(RE::Actor* theActor, std::string AnimFaceArchetypeEditorID)
{
	if (theActor && GetFaceGenAnimDataNative(theActor) && !AnimFaceArchetypeEditorID.empty()) {
		REL::Relocation<uintptr_t> ptr{ REL::ID(152988) };  // 0x27336CC in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<char (*)(RE::AIProcess*, RE::Actor*, RE::BSFixedString*)>(addr);
		RE::BSFixedString          BSAnimFaceArchetypeEditorID = AnimFaceArchetypeEditorID;
		return func(theActor->currentProcess, theActor, &BSAnimFaceArchetypeEditorID) != 0;
	}
	return false;
}

inline static bool SetFaceAnimArchetypeByKeyword(RE::Actor* theActor, RE::BGSKeyword* theKeyword)
{
	if (theActor && theKeyword) {
		auto editorID = GetFormEditorID(theKeyword);
		if (!editorID.empty() && editorID.find("AnimFace") != std::string::npos)
			return SetFaceAnimArchetype(theActor, editorID);
	}
	return false;
}

inline static RE::BGSKeyword* GetSpeakingAnimArchetype(RE::Actor* theActor, std::string* ArchetypeEditorIDOut = nullptr)
{
	if (!theActor)
		return nullptr;
	auto keyword = theActor->speakingAnimFaceArchetype;
	if (!keyword)
		return nullptr;
	std::string editorID = GetFormEditorID(keyword);
	if (editorID.empty())
		return nullptr;
	if (ArchetypeEditorIDOut)
		*ArchetypeEditorIDOut = editorID;
	return keyword;
}

inline static RE::BGSKeyword* GetAnimFaceArchetypeEditorDefined(RE::TESNPC* theTESNPC, std::string* ArchetypeEditorIDOut = nullptr)
{
	if (theTESNPC) {
		auto KeywordForm = Runtime_DynamicCast<RE::TESForm, RE::BGSKeywordForm>(theTESNPC);
		if (!KeywordForm)
			return nullptr;
		for (uint32_t i = 0; i < KeywordForm->GetNumKeywords(); i++) {
			if (!KeywordForm->keywords[i])
				continue;
			std::string editorID = GetFormEditorID(KeywordForm->keywords[i]);
			if (editorID.empty())
				continue;
			std::string editorIDL = ToLowerStr(editorID);
			if (editorIDL.find("animface") == std::string::npos)
				continue;
			if (ArchetypeEditorIDOut)
				*ArchetypeEditorIDOut = editorID;
			return KeywordForm->keywords[i];
		}

	}
	return nullptr;
}

inline static RE::BGSKeyword* GetAnimFaceArchetypeReferenceKeyword(RE::Actor* theActor, std::string* ArchetypeEditorIDOut = nullptr)
{
	if (theActor) {
		auto AllFormsOfType = GetAllFormsByType<RE::BGSKeyword>(4);
		if (AllFormsOfType.size() == 0)
			return nullptr;
		for (auto& keyword : AllFormsOfType) {
			if (keyword && theActor->HasKeyword(keyword)) {
				std::string editorID = GetFormEditorID(keyword);
				if (editorID.empty())
					continue;
				std::string editorIDL = ToLowerStr(editorID);
				if (editorIDL.find("animface") == std::string::npos)
						continue;
				if (ArchetypeEditorIDOut)
					*ArchetypeEditorIDOut = editorID;
				return keyword;
			}
		}
	}
	return nullptr;
}

inline static int GetDontLoopEmotionsIndex(RE::BGSKeyword* theKeyword, RE::BGSListForm* DontLoopEmotionsPassThru = nullptr)
{
	if (!theKeyword)
		return -1;
	if (!DontLoopEmotionsPassThru)
		DontLoopEmotionsPassThru = (RE::BGSListForm*)RE::TESForm::LookupByID(0x00061E37);
	if (!DontLoopEmotionsPassThru)
		return -1;
	auto DontLoopEmotionsArray = GetAsBSTArrayCustom(&DontLoopEmotionsPassThru->arrayOfForms);
	if (!DontLoopEmotionsArray)
		return -1;
	int iIndex = 0;
	for (int i = 0; i < DontLoopEmotionsArray->size(); i++) {
		auto Emotion = DontLoopEmotionsArray->at(i);
		if (Emotion && Emotion->formID == theKeyword->formID)
			return i;
	}
	return -1;
}

inline static std::string GetFormDescription(RE::TESForm* theForm, std::pair<char*, uint32_t>* Dest)
{
	if (!theForm || !Dest || !Dest->first || Dest->second <= 0)
		return "";
	theForm->GetFormDetailedString(Dest->first, Dest->second);
	if (!Dest->first)
		return "";
	std::string result(Dest->first, Dest->second);
	return result;
}

inline static std::vector<RE::TESForm*> GetFormsByEditorID(std::string theEditorID, bool bUseAllFormsMap = false)
{
	std::vector<RE::TESForm*> Result;
	if (theEditorID.empty())
		return Result;
	theEditorID = ToLowerStr(theEditorID);
	if (bUseAllFormsMap) {
		const auto& [map, lock] = RE::TESForm::GetAllForms();
		RE::BSAutoReadLock l{ lock };
		if (map) {
			for (auto it = map->begin(); it != map->end(); ++it) {
				auto LoopForm = it.operator*().Value;
				if (!LoopForm)
					continue;
				auto EditorID = GetFormEditorID(LoopForm);
				if (EditorID.empty())
					continue;
				EditorID = ToLowerStr(EditorID);
				if (std::strcmp(theEditorID.c_str(), EditorID.c_str()) == 0)
					Result.push_back(LoopForm);
			}
		}
	} else {
		for (int i = static_cast<int>(RE::FormType::kKYWD); i < static_cast<int>(RE::FormType::kTotal); i++) {
			auto AllForms = GetAllFormsByType<RE::TESForm>(i);
			for (auto& LoopForm : AllForms) {
				if (!LoopForm)
					continue;
				auto EditorID = GetFormEditorID(LoopForm);
				if (EditorID.empty())
					continue;
				EditorID = ToLowerStr(EditorID);
				if (std::strcmp(theEditorID.c_str(), EditorID.c_str()) == 0)
					Result.push_back(LoopForm);
			}
		}
	}
	if (Result.size() > 0) {
		std::sort(Result.begin(), Result.end());
		Result.erase(std::unique(Result.begin(), Result.end()), Result.end());
	}
	return Result;
}

inline static RE::BGSKeyword* GetWorkshopItemKeyword()
{
	REL::Relocation<uintptr_t> ptr{ REL::ID(856389) };  // 0x668CB90 in v1.14.74
	uintptr_t                  addr = ptr.address();
	auto                       WorkshopItemKeyword = reinterpret_cast<RE::BGSKeyword**>(addr);
	if (!WorkshopItemKeyword || !*WorkshopItemKeyword)
		return nullptr;
	return *WorkshopItemKeyword;
}

inline static RE::BGSKeyword* GetWorkshopKeyword()
{
	REL::Relocation<uintptr_t> ptr{ REL::ID(856347) };  // 0x668C9B0 in v1.14.74
	uintptr_t                  addr = ptr.address();
	auto                       WorkshopKeyword = reinterpret_cast<RE::BGSKeyword**>(addr);
	if (!WorkshopKeyword || !*WorkshopKeyword)
		return nullptr;
	return *WorkshopKeyword;
}
	
inline static bool IsWorkshopItem(RE::TESObjectREFR* theRef)
{
	if (theRef) {
		auto WSItemKeyword = GetWorkshopItemKeyword();
		if (!WSItemKeyword)
			return false;
		auto WSKeyword = GetWorkshopKeyword();
		if (!WSKeyword)
			return false;
		auto LinkedWS = theRef->GetLinkedRef(WSItemKeyword);
		if (!LinkedWS)
			return false;
		return LinkedWS->HasKeyword(WSKeyword);
	}
	return false;
}

inline static std::vector<RE::TESTopic*> GetAllTopicsByOwnerQuest(RE::TESQuest* theQuest)
{
	std::vector<RE::TESTopic*> Result;
	if (theQuest) {
		auto AllTopics = GetAllFormsByType<RE::TESTopic>(static_cast<int>(RE::FormType::kDIAL));
		for (auto& Topic : AllTopics) {
			if (Topic && Topic->ownerQuest && Topic->ownerQuest->formID == theQuest->formID)
				Result.push_back(Topic);
		}
	}
	return Result;
}

inline static std::vector<RE::TESTopicInfo*> GetAllTopicInfos(RE::TESTopic* theTopic, bool bLog = false)
{
	std::vector<RE::TESTopicInfo*> Result;
	if (theTopic && theTopic->numTopicInfos > 0 && theTopic->topicInfos) {
		try {
			RE::TESTopicInfo* LastTopicInfo = nullptr;
			for (int i = 0; i < theTopic->numTopicInfos; i++) {
				if (bLog) {
					LogInfo("theTopic " + GetBasicFormData(theTopic, false, false, true, true) + " | (" + std::to_string(i) + "/" + std::to_string(theTopic->numTopicInfos) + ")");
				}
				Result.push_back(theTopic->topicInfos[i]);
			}
		}
		catch (...) {
			if (bLog) {
				LogError("exception | theTopic " + GetBasicFormData(theTopic, false, false, true, true));
			}
			if (Result.size() > 0)
				Result.clear();
		}
	}
	return Result;
}

inline static RE::TESTopicInfo* GetLastSaidTopicInfo(RE::Actor* theActor, bool bCheckIsTalking = false, bool bLog = false)
{
	if (theActor && theActor->currentProcess && theActor->currentProcess->high) {
		auto& bsLastSaidResponseText = theActor->currentProcess->high->lastSaidResponseText;
		if (!bsLastSaidResponseText.c_str() || bsLastSaidResponseText.size() == 0)
			return nullptr;
		if (bLog) {
			LogInfo("theActor " + GetBasicReferenceData(theActor, false, false, true, true) + " | bsLastSaidResponseText: " + bsLastSaidResponseText.c_str());
		}
		auto AllTopics = GetAllFormsByType<RE::TESTopic>(static_cast<int>(RE::FormType::kDIAL));
		for (auto& Topic : AllTopics) {
			auto AllTopicInfos = GetAllTopicInfos(Topic);
			RE::TESResponse* CurrentResponse = nullptr;
			for (auto& TopicInfo : AllTopicInfos) {
				int iMaxResponse = INT16_MAX;
				for (int i = 0; i < iMaxResponse; i++) {
					if (!CurrentResponse)
						CurrentResponse = TopicInfo->responses;
					else
						CurrentResponse = CurrentResponse->next;
					if (!CurrentResponse) {
						if (bLog) {
							LogInfo("   (" + std::to_string(i) + ") CurrentResponse is nullptr");
						}
						break;
					}
					else {
						if (bLog) {
							LogInfo("   (" + std::to_string(i) + ") CurrentResponse: " + CurrentResponse->responseText.c_str());
						}
					}
					auto& bsResponseText = CurrentResponse->responseText;
					if (!bsResponseText.c_str() || bsResponseText.size() == 0)
						continue;
					if (std::strcmp(bsLastSaidResponseText.c_str(), bsResponseText.c_str()) != 0)
						continue;
					if (!bCheckIsTalking || IsTalking(theActor)) {
						if (bLog) {
							LogInfo("   bsLastSaidResponseText: " + bsLastSaidResponseText.c_str() + " | Return " + GetBasicFormData(TopicInfo, false, false, true, true));
						}
						return TopicInfo;
					}
					else {
						if (bLog) {
							LogInfo("   bsLastSaidResponseText: " + bsLastSaidResponseText.c_str() + " | Return nullptr due to bCheckIsTalking");
						}
						return nullptr;
					}
				}
			}
		}
	}
	if (bLog) {
		LogInfo("theActor " + GetBasicReferenceData(theActor, false, false, true, true) + " | TopicInfo could not be found");
	}
	return nullptr;
}

inline static RE::TESResponse* GetNthResponse(RE::TESTopicInfo* theTopicInfo, int iResponseIndex, bool bGetlast = false)
{
	if (theTopicInfo && (iResponseIndex >= 0 || bGetlast))
	{
		RE::TESResponse* CurentResponse = nullptr;
		RE::TESResponse*      LastResponse = nullptr;
		if (!bGetlast) {
			for (int32_t i = 0; i <= iResponseIndex; i++) {
				if (!LastResponse) {
					if (i == 0)
						LastResponse = theTopicInfo->responses;
				}
				else {
					LastResponse = LastResponse->next;
				}
				if (!LastResponse)
					return nullptr;
				else
					CurentResponse = LastResponse;
			}
		}
		else {
			for (int32_t i = 0; i < INT16_MAX; i++) {
				if (!CurentResponse) {
					if (i == 0) {
						CurentResponse = theTopicInfo->responses;
						if (!CurentResponse->next)
							return CurentResponse;
					}
				} else {
					if (CurentResponse->next)
						CurentResponse = CurentResponse->next;
					else
						return CurentResponse;
				}
			}
		}
		return CurentResponse;
	}
	return nullptr;
}

inline static std::string GetNthResponseText(RE::TESTopicInfo* theTopicInfo, int iResponseIndex, bool bGetlast = false)
{
	if (theTopicInfo && (iResponseIndex >= 0 || bGetlast)) {
		auto Response = GetNthResponse(theTopicInfo, iResponseIndex, bGetlast);
		if (Response)
			return Response->responseText.c_str();
	}
	return "";
}

inline static RE::BGSKeyword* GetNthResponseAnimFaceArchetype(RE::TESTopicInfo* theTopicInfo, int iResponseIndex, bool bGetlast = false)
{
	if (theTopicInfo && (iResponseIndex >= 0 || bGetlast)) {
		auto Response = GetNthResponse(theTopicInfo, iResponseIndex, bGetlast);
		if (Response)
			return Response->animFaceArchetype;
	}
	return nullptr;
}

inline static RE::BGSKeyword* GetLastSaidTopicInfoAnimArchetypeKeyword(RE::Actor* theActor, bool bLog = false)
{
	if (theActor) {
		auto LastSaidTopicInfo = GetLastSaidTopicInfo(theActor);
		if (!LastSaidTopicInfo) {
			if (bLog) {
				LogError("LastSaidTopicInfo is nullptr for actor " + GetBasicReferenceData(theActor, false, false, true, true));
			}
			return nullptr;
		} else {
			if (bLog) {
				LogInfo("LastSaidTopicInfo is [" + GetBasicFormData(LastSaidTopicInfo, false, false, true, true) + "] for actor " + GetBasicReferenceData(theActor, false, false, true, true));
			}
		}
		auto LastResponse = GetNthResponse(LastSaidTopicInfo, -1, true);
		if (!LastResponse) {
			if (bLog) {
				LogError("LastResponse is nullptr for actor " + GetBasicReferenceData(theActor, false, false, true, true));
			}
			return nullptr;
		} else {
			if (bLog) {
				LogInfo("LastResponse is [" + LastResponse->responseText.c_str() + "] for actor " + GetBasicReferenceData(theActor, false, false, true, true));
			}
		}
		return LastResponse->animFaceArchetype;
	}
	return nullptr;
}

inline static bool SayDialogueTopic(RE::TESObjectREFR* theRef, RE::TESTopic* theTopic, RE::TESObjectREFR* akTarget = nullptr, RE::Actor* akActorToSpeakAs = nullptr, bool abSpeakInPlayersHead = false)
{
	if (theRef && theTopic)
	{
		REL::Relocation<uintptr_t> ptr{ REL::ID(172343) };  // 0x2CF55E0 in v1.14.74
		uintptr_t                  addr = ptr.address();
		const auto                 func = reinterpret_cast<void (*)(RE::TESObjectREFR*, RE::TESTopic*, uintptr_t, RE::Actor*, RE::TESObjectREFR*, bool)>(addr);
		func(theRef, theTopic, 0, akActorToSpeakAs, akTarget, abSpeakInPlayersHead);
		return true;
	}
	return false;
}

inline static bool IsCrowdActor(RE::Actor* theActor)
{
	return theActor && theActor->boolFlags2.any(RE::Actor::BOOL_FLAGS2::kCrowd);
}


