#pragma once


namespace Cassiopeia
{
	inline static REL::Version StoredSFSEVerion;
	inline static REL::Version StoredStarfieldVerion;
	struct PressedKey
	{
		int iKeyCode{};
		float fHoldTime{};
		int   iDeviceIndex{};
		std::string sControlName{};
		std::string sKeyName{};
	};

	inline static std::vector<PressedKey> PressedKeys;  // v2.3

	inline static bool IsMenuOpen_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sName)
	{
		return (sName.size() > 0 && RE::UI::GetSingleton()->IsMenuOpen(sName));
	}
	inline static std::string GetReferenceName_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return GetReferenceName(theRef);	 
	}
	inline static float GetKnockStateEnum_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetKnockStateEnum(theActor);
	}
	inline static float GetActorGunState_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetActorGunState(theActor);
	}
	inline static std::string GetOverrideName_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return GetOverrideName(theRef);
	}
	inline static bool SetDisplayName_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef, std::string sName)
	{
		return SetReferenceName(theRef, sName);
	}
	inline static std::string GetTESFullName_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		return GetTESFullName(theForm);
	}
	inline static bool SetTESFullName_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm, std::string sName)
	{
		return SetTESFullName(theForm, sName);
	}
	inline static std::vector<RE::Actor*> GetVisibleActors_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetVisibleActors();
	}
	inline static void SetHelmetLight_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, bool bState)
	{
		SetFlashlightState(theActor, bState);
	}
	inline static RE::TESNPC* GetAppearanceSource_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetAppearanceSource(theActor);
	}
	inline static std::vector<RE::TESQuest*> GetAliasHolderQuests_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return GetAliasHolderQuests(theRef);
	}
	inline static void SetTemporaryReference_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef, bool bSet)
	{
		if (theRef)
			SetTemporaryReference(theRef, bSet);
	}
	inline static bool IsTemporaryReference_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return IsTemporaryReference(theRef);
	}
	inline static bool IsAnyCompanionTalking_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return IsAnyCompanionTalking();
	}
	inline static std::vector<RE::Actor*> GetActorsDetectedBy_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, bool bMustHaveLOS)
	{
		return GetActorsDetectedBy(theActor, bMustHaveLOS);
	}
	inline static std::vector<RE::Actor*> GetActorsDetecting_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, bool bMustHaveLOS)
	{
		return GetActorsDetecting(theActor, bMustHaveLOS);
	}
	inline static std::vector<RE::Actor*> GetHighActors_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetHighActors();
	}
	inline static std::vector<RE::SpellItem*> GetSpells_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetSpells(theActor);
	}
	inline static std::vector<RE::TESFaction*> GetFactions_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetFactions(theActor);
	}
	inline static std::vector<RE::BGSKeyword*> GetKeywords_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return GetKeywords(theRef);
	}
	inline static std::vector<RE::EffectSetting*> GetMagicEffects_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetMagicEffects(theActor);
	}
	inline static std::vector<RE::TESForm*> GetInventoryItems_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return GetInventoryItems(theRef, false);
	}
	inline static std::vector<RE::TESForm*> GetEquippedInventoryItems_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetInventoryItems(theActor, true);
	}
	inline static int AddPerkToAll_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::vector<RE::Actor*> theActors, RE::BGSPerk* thePerk)
	{
		return AddPerkToAll(theActors, thePerk);
	}
	inline static int RemovePerkFromAll_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::vector<RE::Actor*> theActors, RE::BGSPerk* thePerk)
	{
		return RemovePerkFromAll(theActors, thePerk);
	}
	inline static int IsPersistent_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string HexFormID)
	{
		return IsReferencePersistentByHexFormID(HexFormID);
	}
	inline static bool GetIsFormFlagSet_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm, int theFlag)
	{
		if (!theForm || theFlag <= 0 || theFlag >= INT32_MAX) {
			return false;
		}
		int FormFlag = static_cast<int>(theForm->formFlags);
		if ((FormFlag & theFlag) == theFlag)
			return true;
		return false;
	}
	inline static int GetFormFlagsAsInt_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		if (!theForm)
			return 0;
		return static_cast<int>(theForm->formFlags);
	}
	inline static std::string GetFormFlagsAsHex_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		if (!theForm)
			return "";
		return std::format("0x{:x}", theForm->formFlags);
	}
	inline static bool SetFormFlag_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm, bool bSet, int theFlag)
	{
		if (!theForm || theFlag <= 0 || theFlag >= INT32_MAX)
			return false;
		if (bSet) {
			theForm->formFlags |= theFlag;
			if ((theForm->formFlags & theFlag) != 0)
				return true;
		} else {
			theForm->formFlags &= ~theFlag;
			if ((theForm->formFlags & theFlag) == 0)
				return true;
		}
		return false;
	}
	inline static bool GetIsChangeFlagSet_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm, int theFlag)
	{
		if (!theForm || theFlag <= 0 || theFlag >= INT32_MAX)
			return false;
		int ChangeFlag = static_cast<int>(theForm->formChangeFlags);
		if ((ChangeFlag & theFlag) == theFlag)
			return true;
		return false;
	}
	inline static int GetChangeFlagsAsInt_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		if (!theForm)
			return 0;
		return static_cast<int>(theForm->formChangeFlags);
	}
	inline static std::string GetChangeFlagsAsHex_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		if (!theForm) {
			return "";
		}
		return std::format("0x{:x}", theForm->formChangeFlags);
	}
	inline static bool SetChangeFlag_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm, bool bSet, int theFlag)
	{
		if (!theForm || theFlag <= 0 || theFlag >= INT32_MAX)
			return false;
		if (bSet) {
			theForm->formChangeFlags |= theFlag;
			if ((theForm->formChangeFlags & theFlag) != 0)
				return true;
		} else {
			theForm->formChangeFlags &= ~theFlag;
			if ((theForm->formChangeFlags & theFlag) == 0)
				return true;
		}
		return false;
	}
	inline static int SetBit_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int number, int bit)
	{
		number |= bit;
		return number;
	}
	inline static int UnsetBit_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int number, int bit)
	{
		number &= ~bit;
		return number;
	}
	inline static int BitwiseAnd_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int number1, int number2)
	{
		auto result = number1 & number2;
		return result;
	}
	inline static int BitwiseOr_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int number1, int number2)
	{
		auto result = number1 | number2;
		return result;
	}
	inline static int BitwiseNot_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int number)
	{
		auto result = ~number;
		return result;
	}
	inline static int BitwiseXor_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int number1, int number2)
	{
		auto result = number1 ^ number2;
		return result;
	}
	inline static int BitwiseLeftShift_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int number1, int number2)
	{
		auto result = number1 << number2;
		return result;
	}
	inline static int BitwiseRightShift_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int number1, int number2)
	{
		auto result = number1 >> number2;
		return result;
	}
	inline static int GetActivePluginCount_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetActivePluginCount();
	}
	inline static std::vector<std::string> GetActivePlugins_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		std::vector<int> types = { 1, 2, 3 };
		return GetActivePluginNames(types);
	}
	inline static int GetPluginType_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sName)
	{
		return GetPluginTypeByName(sName);
	}
	inline static bool IsFullMaster_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sName)
	{
		return (GetPluginTypeByName(sName) == 1);
	}
	inline static bool IsSmallMaster_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sName)
	{
		return (GetPluginTypeByName(sName) == 2);
	}
	inline static bool IsMediumMaster_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sName)
	{
		return (GetPluginTypeByName(sName) == 3);
	}
	inline static RE::TESObjectREFR* GetConsoleRef_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetConsoleRef();
	}
	inline static std::string GetFormTypeAsString_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		if (theForm)
			return std::to_string(theForm->GetFormType());
		return "";
	}
	inline static int GetFormTypeAsInt_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		if (!theForm)
			return -1;
		return static_cast<int>(theForm->GetFormType());
	}
	inline static std::vector<RE::TESForm*> GetAllFormsByFormType_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int iFormType, std::string sLastOverrider)
	{
		return GetAllFormsByType<RE::TESForm>(iFormType, sLastOverrider.c_str());
	}
	inline static std::string LookupLastOverriderPlugin_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		return LookupLastOverriderPlugin(theForm);
	}
	inline static std::uint32_t GetReferenceHandle_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		if (!theRef)
			return 0;
		return theRef->nativeHandle;
	}
	inline static RE::TESObjectREFR* GetReferenceByHandle_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::uint32_t handle)
	{
		return RE::GetReferenceByHandle(handle);
	}
	inline static std::vector<RE::TESObjectREFR*> GetReferencesInCell_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectCELL* theCell)
	{
		return GetReferencesInCell(theCell);
	}
	inline static bool IsInPhotoMode_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto camera = RE::PlayerCamera::GetSingleton();
		if (camera)
			return camera->QCameraEquals(RE::CameraState::kPhotoMode);	
		return false;
	}
	inline static bool IsInAutoVanityMode_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto camera = RE::PlayerCamera::GetSingleton();
		if (camera)
			return camera->QCameraEquals(RE::CameraState::kAutoVanity);
		return false;
	}
	inline static bool IsInFirstPerson_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto camera = RE::PlayerCamera::GetSingleton();
		if (camera)
			return camera->QCameraEquals(RE::CameraState::kFirstPerson);
		return false;
	}
	inline static bool IsInThirdPerson_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto camera = RE::PlayerCamera::GetSingleton();
		if (camera)
			return camera->QCameraEquals(RE::CameraState::kThirdPerson);
		return false;
	}
	/*
	inline static bool IsInFreeFlyCam_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto camera = RE::PlayerCamera::GetSingleton();
		if (camera)
			return camera->QCameraEquals(RE::CameraState::kFreeFly);
		return false;
	}
	*/
	inline static bool IsInIronSightsCam_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto camera = RE::PlayerCamera::GetSingleton();
		if (camera)
			return camera->QCameraEquals(RE::CameraState::kIronSights);
		return false;
	}
	inline static bool IsInShipFarTravelCam_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto camera = RE::PlayerCamera::GetSingleton();
		if (camera)
			return camera->QCameraEquals(RE::CameraState::kShipFarTravel); 
		return false;
	}
	inline static bool IsInFlightCam_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto camera = RE::PlayerCamera::GetSingleton();
		if (camera)
			return camera->QCameraEquals(RE::CameraState::kFlightCamera);
		return false;
	}
	inline static bool IsInShipActionCam_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto camera = RE::PlayerCamera::GetSingleton();
		if (camera)
			return camera->QCameraEquals(RE::CameraState::kShipAction);
		return false;
	}
	inline static bool IsInShipTargetingCam_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto camera = RE::PlayerCamera::GetSingleton();
		if (camera)
			return camera->QCameraEquals(RE::CameraState::kShipTargeting);
		return false;
	}
	inline static bool IsInShipCombatOrbitCam_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto camera = RE::PlayerCamera::GetSingleton();
		if (camera)
			return camera->QCameraEquals(RE::CameraState::kShipCombatOrbit);
		return false;
	}
	inline static int GetSex_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetSex(theActor);
	}
	inline static std::vector<RE::TESForm*> GetFormListAllForms_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSListForm* theList)
	{
		std::vector<RE::TESForm*> Result;
		if (!theList)
			return Result;
		if (theList->scriptAddedTempForms) {
			auto theArray = GetAsBSTArrayCustom(theList->scriptAddedTempForms);
			if (theArray) {
				for (auto& it : *theArray) {
					if (it == 0)
						continue;
					auto form = RE::TESForm::LookupByID(it);
					if (form)
						Result.push_back(form);
				}
			}
		}
		auto theArray = GetAsBSTArrayCustom(&theList->arrayOfForms);
		if (!theArray)
			return Result;

		for (auto& it : *theArray) {
			if (it)
				Result.push_back(it);
		}
		return Result;
	}
	inline static bool SetGameSettingFloat_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sSetting, float fValue)
	{
		if (sSetting.empty())
			return false;
		return SetGameSetting(sSetting, std::to_string(fValue), 1);
	}
	inline static bool SetGameSettingInt_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sSetting, int iValue)
	{
		if (sSetting.empty())
			return false;
		return SetGameSetting(sSetting, std::to_string(iValue), 2);
	}
	inline static bool SetGameSettingBool_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sSetting, bool bValue)
	{
		if (sSetting.empty())
			return false;
		return SetGameSetting(sSetting, std::to_string(bValue), 3);
	}
	inline static bool SetGameSettingUInt_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sSetting, std::uint32_t uValue)
	{
		if (sSetting.empty())
			return false;
		return SetGameSetting(sSetting, std::to_string(uValue), 4);
	}
	inline static bool SetGameSettingString_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sSetting, std::string sValue)
	{
		if (sSetting.empty())
			return false;
		return SetGameSetting(sSetting, sValue, 5);
	}
	inline static float GetINISettingFloat_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sSetting)
	{
		if (sSetting.empty())
			return false;
		auto value = GetGameINISetting(sSetting, 1);
		if (value.empty())
			value = GetGameINIPrefSetting(sSetting, 1);
		float Result = 0.00f;
		try {
			Result = std::stof(value);
		}
		catch (...) {
			return 0.00f;
		}
		return Result;
	}
	inline static int GetINISettingInt_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sSetting)
	{
		if (sSetting.empty())
			return false;
		auto value = GetGameINISetting(sSetting, 2);
		if (value.empty())
			value = GetGameINIPrefSetting(sSetting, 2);
		int Result = 0;
		try {
			Result = std::stoi(value);
		} catch (...) {
			return 0;
		}
		return Result;
	}
	inline static bool GetINISettingBool_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sSetting)
	{
		if (sSetting.empty())
			return false;
		auto value = GetGameINISetting(sSetting, 3);
		if (value.empty())
			value = GetGameINIPrefSetting(sSetting, 3);
		if (!value.empty() && std::strcmp(value.c_str(), "1") == 0)
			return true;
		return false;
	}
	inline static std::uint32_t GetINISettingUInt_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sSetting)
	{
		if (sSetting.empty())
			return false;
		auto value = GetGameINISetting(sSetting, 4);
		if (value.empty())
			value = GetGameINIPrefSetting(sSetting, 4);
		std::uint32_t Result = 0;
		try {
			Result = std::stoul(value);
		} catch (...) {
			return 0;
		}
		return Result;
	}
	inline static std::string GetINISettingString_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sSetting)
	{
		if (sSetting.empty())
			return "";
		auto value = GetGameINISetting(sSetting, 5);
		if (value.empty())
			value = GetGameINIPrefSetting(sSetting, 5);
		return value;
	}
	inline static std::vector<RE::TESForm*> GetFormsByTESFullName_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sName, int iFormType)
	{
		std::vector<RE::TESForm*> Result;
		if (sName.empty())
			return Result;
		auto DataHandler = RE::TESDataHandler::GetSingleton();
		if (!DataHandler)
			return Result;
		for (int i = 0; i <= static_cast<int>(RE::FormType::kGPOG); i++) {
			auto AllFormsOfType = GetAsBSTArrayCustom(&DataHandler->pFormArray[i].formArray);
			if (!AllFormsOfType)
				continue;
			for (int j = 0; j < AllFormsOfType->size(); j++) {
				auto form = AllFormsOfType->at(j).get();
				if (!form)
					continue;
				if (iFormType >= 0 && form->GetSavedFormType() != iFormType)
					continue;
				auto sFullName = GetTESFullName(form);
				if (sFullName.empty())
					continue;
				if (std::strcmp(ToLowerStr(sFullName).c_str(), ToLowerStr(sName.c_str()).c_str()) == 0)
					Result.push_back(form);
			}
		}
		if (Result.size() > 0) {
			std::sort(Result.begin(), Result.end());
			Result.erase(std::unique(Result.begin(), Result.end()), Result.end());
		}
		return Result;
	}
	inline static std::vector<RE::TESForm*> GetOutfitForms_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSOutfit* theOutfit)
	{
		std::vector<RE::TESForm*> Result;
		if (!theOutfit)
			return Result;
		auto theArray = GetAsBSTArrayCustom(&theOutfit->outfitItems);
		if (!theArray)
			return Result;
		for (auto& it : *theArray)
			Result.push_back(it);
		return Result;
	}
	inline static bool AddToOutfitForms_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSOutfit* theOutfit, RE::TESForm* outfitToAdd)
	{
		if (!theOutfit || !outfitToAdd)
			return false;
		if (std::find(std::begin(theOutfit->outfitItems), std::end(theOutfit->outfitItems), outfitToAdd) < theOutfit->outfitItems.end())
			return false;
		theOutfit->outfitItems.push_back(outfitToAdd);
		if (std::find(std::begin(theOutfit->outfitItems), std::end(theOutfit->outfitItems), outfitToAdd) < theOutfit->outfitItems.end())
			return true;
		return false;
	}
	inline static bool RemoveOutfitForm_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSOutfit* theOutfit, RE::TESForm* outfitToRemove)
	{
		if (!theOutfit || !outfitToRemove)
			return false;
		auto iter = std::find(theOutfit->outfitItems.begin(), theOutfit->outfitItems.end(), outfitToRemove);
		if (iter != theOutfit->outfitItems.end()) {
			theOutfit->outfitItems.erase(iter);
			return true;
		}
		return false;
	}
	inline static bool RemoveNthOutfitForm_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSOutfit* theOutfit, int aiIndex)
	{
		if (!theOutfit || aiIndex < 0 || aiIndex > INT32_MAX)
			return false;
		uint32_t    size = theOutfit->outfitItems.size();
		if (aiIndex >= size)
			return false;
		theOutfit->outfitItems.erase(theOutfit->outfitItems.begin() + aiIndex);
		return true;
	}
	inline static bool RemoveAllOutfitForms_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSOutfit* theOutfit)
	{
		if (!theOutfit)
			return false;
		theOutfit->outfitItems.clear();
		if (theOutfit->outfitItems.empty())
			return true;
		return false;
	}
	inline static int EvaluatePackageForAll_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::vector<RE::Actor*> theActors, bool bResetAI)
	{
		return EvaluatePackageForAll(theActors, bResetAI);
	}
	inline static bool DoesFileExist_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string FilePath, std::string FileName)
	{
		return DoesFileExistEx(FilePath, FileName);
	}
	inline static bool DoesIniExist_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string INIPath, std::string ININame)
	{
		return DoesIniExistEx(INIPath, ININame);
	}
	inline static bool WriteIni_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string INIPath, std::string ININame, std::string Section, std::string Key, std::string Value)
	{
		return WriteIniEx(INIPath, ININame, Section, Key, Value);
	}
	inline static std::string ReadIni_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string INIPath, std::string ININame, std::string Section, std::string Key)
	{
		return ReadIniEx(INIPath, ININame, Section, Key);
	}
	inline static int GetCassiopeiaPapyrusExtenderVersion_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		const std::regex pattern("[^0-9]");
		std::string version = std::regex_replace(PluginVersionInfo::NAME.data(), pattern, "");
		int              iVersion = 0;
		try {
			iVersion = std::stoi(version);
		}
		catch (...) {
			return 0;
		}
		return iVersion;
	}
	inline static std::string GetPluginFileAuthorName_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sName)
	{
		if (sName.empty())
			return "";
		int  iPluginType = 0;
		auto theFile = LookupTESFileByName(sName, &iPluginType);
		if (theFile)
			return GetPluginFileAuthorName(theFile);		
		return "";
	}
	inline static std::uint32_t HexToInt_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sHex)
	{
		if (sHex.empty())
			return 0;
		sHex.erase(std::remove_if(sHex.begin(), sHex.end(), ::isspace), sHex.end());
		unsigned int i = 0;
		try {
			i = std::stoul(sHex, nullptr, 16);
		} catch (...) {
			return 0;
		}
		return i;
	}
	inline static RE::TESObjectREFR* GetCrosshairRef_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetCrosshairRef();
	}
	//
	// v1.1 from here
	//
	inline static bool IsJumping_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsJumping(theActor);
	}
	inline static bool UpdateAppearance_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, int iFlags, bool bRaceChange)
	{
		return UpdateAppearance(theActor, false, iFlags, bRaceChange);
	}
	inline static bool UpdateChargenAppearance_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return UpdateChargenAppearance(theActor);
	}
	inline static bool SetSkinTone_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, int iSkinToneIndex)
	{
		return SetSkinTone(theActor, iSkinToneIndex);
	}
	inline static int GetSkinTone_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetSkinTone(theActor);
	}
	inline static RE::Actor* GetLastSLMTarget_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetLastShowLooksMenuTargetEx();
	}
	inline static std::vector<RE::BGSMod::Attachment::Mod*> GetReferenceMods_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef, bool bExcludeModColls)
	{
		return GetObjectMods(theRef, bExcludeModColls);
	}
	inline static bool IsMovingForward_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsMovingForward(theActor);
	}
	inline static bool IsMovingBackward_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsMovingBackward(theActor);
	}
	inline static bool IsMovingLeft_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsMovingLeft(theActor);
	}
	inline static bool IsMovingRight_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsMovingRight(theActor);
	}
	inline static bool IsWalking_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsWalking(theActor);
	}
	inline static bool IsStaggered_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsStaggered(theActor);
	}
	inline static bool IsSwimming_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsSwimming(theActor);
	}
	inline static bool IsInWater_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsInWater(theActor);
	}
	inline static bool IsInCombatSearch_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsInCombatSearch(theActor);
	}
	inline static bool IsMurderAlarmed_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsMurderAlarmed(theActor);
	}
	inline static bool IsParalyzed_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsParalyzed(theActor);
	}
	inline static bool DoesAffectStealthMeter_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return DoesAffectStealthMeter(theActor);
	}
	inline static bool IsUnderwater_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsUnderwater(theActor);
	}
	inline static bool IsSpacesuitHelmetVisible_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsSpacesuitHelmetVisible(theActor);
	}
	inline static bool IsSpacesuitHelmetLightOn_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsSpacesuitHelmetLightOn(theActor);
	}
	//
	// v1.2 from here
	//
	inline static bool IsInGodMode_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return IsInGodMode();
	}
	inline static int GetPlayerSpaceshipCurrentSpeed_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetPlayerSpaceshipCurrentSpeed();
	}
	inline static std::string GetPlayerSpaceshipWeaponType_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int iWeaponIndex)
	{
		return GetPlayerSpaceshipWeaponType(iWeaponIndex);
	}
	inline static int GetPlayerSpaceshipWeaponCapacity_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int iWeaponIndex)
	{
		return GetPlayerSpaceshipWeaponCapacity(iWeaponIndex);
	}
	inline static bool IsGlobalAIDetectionOn_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		auto processLists = RE::ProcessListsCustom::GetSingleton();
		return processLists && processLists->bGlobalDetectionOn;
	}
	inline static float GetPlayerSpaceshipMaxFuelRange_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetPlayerSpaceshipMaxFuelRange();
	}
	inline static float GetPlayerSpaceshipFuelConsumption_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetPlayerSpaceshipFuelConsumption();
	}
	inline static bool IsPlayerSpaceshipFlyingBackward_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return IsPlayerSpaceshipFlyingBackward();
	}
	inline static std::vector<RE::Actor*> GetPhotoModeActors_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetPhotoModeActors();
	}
	inline static bool ClearAllAliases_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESQuest* theQuest)
	{
		return ClearAllAliases(theQuest);
	}
	inline static bool PrintToConsoleLog_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sText)
	{
		if (sText.empty())
			return false;
		RE::ConsoleLog::GetSingleton()->Print(sText.c_str());
		return true;
	}
	inline static bool ClearConsoleLog_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return InvokeAS3Function("Console", "root1.AnimHolder_mc.Menu_mc.ClearHistory");
	}
	inline static bool IsModCollection_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSMod::Attachment::Mod* theMod)
	{
		return IsModCollection(theMod);
	}
	inline static bool IsLooseMod_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectMISC* theMiscMod)
	{
		return IsLooseMod(theMiscMod);
	}
	inline static bool CopyInventoryItems_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* sourceRef, RE::TESObjectREFR* targetRef, std::vector<int> validFormTypes)
	{
		return CopyInventoryItems(sourceRef, targetRef, validFormTypes);
	}
	inline static std::string GetHexFormID_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		if (!theForm || theForm->formID == 0)
			return "00000000";
		return GetFormIDAsHex(theForm, true);
	}
	//
	// v1.3 from here
	//
	inline static bool RegisterForNativeEvent_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string scriptName, std::string eventName, std::vector<RE::TESForm*> filter)
	{
		if (scriptName.empty() || eventName.empty())
			return false;
		auto manager = CassiopeiaEvents::GetEventManager();
		if (!manager)
			return false;
		scriptName = ToLowerStr(scriptName);
		eventName = ToLowerStr(eventName);
		if (!manager->IsValidEventName(eventName)) {
			LogError("unknown event name '" + eventName + "'");
			return false;
		}
		return manager->Register(scriptName, eventName, filter);
	}
	inline static bool UnregisterForNativeEvent_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string scriptName, std::string eventName)
	{
		if (scriptName.empty() || eventName.empty())
			return false;
		auto manager = CassiopeiaEvents::GetEventManager();
		if (!manager)
			return false;
		scriptName = ToLowerStr(scriptName);
		eventName = ToLowerStr(eventName);
		if (!manager->IsValidEventName(eventName)) {
			LogError("unknown event name '" + eventName + "'");
			return false;
		}
		return manager->Unregister(scriptName, eventName);
	}
	inline static bool AddNativeEventFilter_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string scriptName, std::string eventName, std::vector<RE::TESForm*> filter)
	{
		if (scriptName.empty() || eventName.empty() || filter.size() == 0)
			return false;
		auto manager = CassiopeiaEvents::GetEventManager();
		if (!manager)
			return false;
		eventName = ToLowerStr(eventName);
		scriptName = ToLowerStr(scriptName);
		// filterable events
		if (std::strcmp(eventName.c_str(), ToLowerStr("TESEquipEvent").c_str()) == 0)
			return CassiopeiaEvents::GetEventManager()->AddFilter(scriptName, eventName, filter);
		if (std::strcmp(eventName.c_str(), ToLowerStr("ReferenceDetach").c_str()) == 0)
			return CassiopeiaEvents::GetEventManager()->AddFilter(scriptName, eventName, filter);
		if (std::strcmp(eventName.c_str(), ToLowerStr("ReferenceSet3d").c_str()) == 0)
			return CassiopeiaEvents::GetEventManager()->AddFilter(scriptName, eventName, filter);
		if (std::strcmp(eventName.c_str(), ToLowerStr("TESCombatEvent").c_str()) == 0)
			return CassiopeiaEvents::GetEventManager()->AddFilter(scriptName, eventName, filter);
		if (std::strcmp(eventName.c_str(), ToLowerStr("ActorCellChangeEvent").c_str()) == 0)
			return CassiopeiaEvents::GetEventManager()->AddFilter(scriptName, eventName, filter);
		if (std::strcmp(eventName.c_str(), ToLowerStr("TESCellFullyLoadedEvent").c_str()) == 0)
			return CassiopeiaEvents::GetEventManager()->AddFilter(scriptName, eventName, filter);
		if (std::strcmp(eventName.c_str(), ToLowerStr("TESContainerChangedEvent").c_str()) == 0)
			return CassiopeiaEvents::GetEventManager()->AddFilter(scriptName, eventName, filter);
		if (std::strcmp(eventName.c_str(), ToLowerStr("TESObjectLoadedEvent").c_str()) == 0)
			return CassiopeiaEvents::GetEventManager()->AddFilter(scriptName, eventName, filter);
		if (std::strcmp(eventName.c_str(), ToLowerStr("TESActivateEvent").c_str()) == 0)	// v1.8
			return CassiopeiaEvents::GetEventManager()->AddFilter(scriptName, eventName, filter);
		else if (!manager->IsValidEventName(eventName)) {
			LogError("unknown event name '" + eventName + "'");
		} else {
			LogError("no filter is implemented for event '" + eventName + "'");
		}	
		return false;
	}
	inline static bool RemoveNativeEventFilter_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string scriptName, std::string eventName, std::vector<RE::TESForm*> filter)
	{
		if (scriptName.empty() || eventName.empty() || filter.size() == 0)
			return false;
		auto manager = CassiopeiaEvents::GetEventManager();
		if (!manager)
			return false;
		scriptName = ToLowerStr(scriptName);
		eventName = ToLowerStr(eventName);
		if (!manager->IsValidEventName(eventName)) {
			LogError("unknown event name '" + eventName + "'");
			return false;
		}
		return manager->RemoveFilter(scriptName, eventName, filter);
	}
	inline static bool IsRegisteredForNativeEvent_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string scriptName, std::string eventName)
	{
		if (scriptName.empty() || eventName.empty())
			return false;
		auto manager = CassiopeiaEvents::GetEventManager();
		if (!manager)
			return false;
		scriptName = ToLowerStr(scriptName);
		eventName = ToLowerStr(eventName);
		if (!manager->IsValidEventName(eventName)) {
			LogError("unknown event name '" + eventName + "'");
			return false;
		}
		return manager->IsRegistered(scriptName, eventName);
	}
	inline static std::vector<RE::TESForm*> GetNativeEventFilteredForms_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string scriptName, std::string eventName)
	{
		std::vector<RE::TESForm*> Result;
		if (scriptName.empty() || eventName.empty())
			return Result;
		auto manager = CassiopeiaEvents::GetEventManager();
		if (!manager)
			return Result;
		scriptName = ToLowerStr(scriptName);
		eventName = ToLowerStr(eventName);
		if (!manager->IsValidEventName(eventName)) {
			LogError("unknown event name '" + eventName + "'");
			return Result;
		}
		return manager->GetFilter(scriptName, eventName);
	}
	inline static bool UnregisterForAllNativeEvents_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string scriptName)
	{
		if (scriptName.empty())
			return false;
		auto manager = CassiopeiaEvents::GetEventManager();
		if (!manager)
			return false;
		scriptName = ToLowerStr(scriptName);
		return manager->UnregisterForAll(scriptName);
	}
	inline static int RegisterForAllNativeEvents_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string scriptName)
	{
		if (scriptName.empty())
			return -1;
		auto manager = CassiopeiaEvents::GetEventManager();
		if (!manager)
			return -1;
		scriptName = ToLowerStr(scriptName);
		if (manager->allEventNames.size() == 0) {
			LogError("allEventNames.size == 0");
			return -1;
		}
		std::vector<RE::TESForm*> f;
		int                       i = 0;
		for (auto& it : manager->allEventNames) {
			bool bRegistered = manager->Register(scriptName, it, f);
			if (bRegistered)
				i = i + 1;
			if (bRegistered) {
				LogInfo("script '" + scriptName + "' is now registered for event '" + it + "'");
			} else {
				LogWarning("script '" + scriptName + "' couldn't be registered for event '" + it + "' | is already registered ? " + std::to_string(manager->IsRegistered(scriptName, it, true)));
			}			
		}
		return i;
	}
	inline static bool ConvertAddressFromFileToRelocationID_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string File)
	{
		return ConvertAddressFromFileToRelocationID(File);
	}
	inline static std::vector<RE::TESQuest*> GetAllRunningQuests_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetAllRunningQuests();
	}
	inline static std::string GetAS3VariableAsString_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string menuName, std::string varPath)
	{
		return GetAS3VariableAsString(menuName, varPath);
	}
	//
	// v1.4 from here
	//
	inline static bool IsCrimeToActivate_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* activatedRef)
	{
		return (activatedRef && activatedRef->IsCrimeToActivate());
	}
	inline static std::vector<RE::TESObjectCELL*> GetLoadedCells_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetLoadedCells();
	}
	inline static std::vector<RE::TESObjectREFR*> GetLoadedReferences_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetLoadedReferences();
	}
	inline static std::vector<RE::TESObjectREFR*> SortReferencesByDeleted_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::vector<RE::TESObjectREFR*> theRefs, bool bRemoveDeleted)
	{
		return SortReferencesByDeleted(theRefs, bRemoveDeleted);
	}
	inline static std::vector<RE::TESObjectREFR*> SortReferencesByName_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::vector<RE::TESObjectREFR*> theRefs, std::string sName, bool bExactMatch, bool bReversed)
	{
		return SortReferencesByName(theRefs, sName, bExactMatch, bReversed);
	}
	inline static std::vector<RE::TESObjectREFR*> SortReferencesByKeywords_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::vector<RE::TESObjectREFR*> theRefs, std::vector<RE::BGSKeyword*> theKeywords, bool bMustHaveAll)
	{
		return SortReferencesByKeywords(theRefs, theKeywords, bMustHaveAll);
	}
	/*
	inline static std::vector<RE::Actor*> GetFactionMembers_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESFaction* theFaction)
	{
		return GetFactionMembers(theFaction);
	}
	inline static std::vector<RE::TESObjectREFR*> FindAllReferencesWithItem_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::vector<RE::TESForm*> theItems, float fDistance, bool bMustHaveAll)
	{
		return FindAllReferencesWithItem(theItems, fDistance, bMustHaveAll);
	}
	*/
	inline static std::vector<RE::TESObjectREFR*> SortReferencesByConditions_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::vector<RE::TESObjectREFR*> theSubjectRefs, std::vector<RE::TESObjectREFR*> theTargetRefs, std::vector<RE::BGSConditionForm*> theConditions, bool bConjuntive)
	{
		return SortReferencesByConditions(theSubjectRefs, theTargetRefs, theConditions, bConjuntive);
	}
	inline static std::vector<RE::TESObjectREFR*> SortReferencesByDistance_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::vector<RE::TESObjectREFR*> theRefs, float fDistance, bool bConjuntive)
	{
		return SortReferencesByDistance(theRefs, fDistance, bConjuntive);
	}
	//
	// v1.5 from here
	//
	inline static float GetMorphValue_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, std::string morphName)
	{
		return GetMorphValue(theActor, morphName);
	}
	inline static bool ExportMorphMap_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return ExportMorphMap(theActor);
	}	
	inline static bool SetMorphValue_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, std::string morphName, float morphValue)
	{
		if (!theActor || morphName.empty() || morphValue < 0.0f || morphValue > 1.0f)
			return false;
		return SetMorphValue(theActor, morphName, morphValue);
	}
	inline static bool SetMorphValues_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, std::vector<std::string> morphNames, std::vector<float> morphValues)
	{
		if (!theActor || morphNames.empty() || morphNames.size() != morphValues.size())
			return false;
		int iCounter = 0;
		for (int i = 0; i < morphNames.size(); i++) {
			if (SetMorphValue(theActor, morphNames.at(i), morphValues.at(i)))
				iCounter = iCounter + 1;
		}
		return (iCounter == morphNames.size());
	}
	inline static bool CopyFacialExpression_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActorToCopyFrom, RE::Actor* theActorToCopyTo)
	{
		return CopyFacialExpression(theActorToCopyFrom, theActorToCopyTo);
	}
	inline static RE::BGSKeyword* GetAnimFaceArchetype_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetAnimFaceArchetype(theActor);
	}
	inline static bool ApplyFacialExpression_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, RE::TESForm* theFacialExpression)
	{
		if (theFacialExpression && theFacialExpression->GetFormType() == RE::FormType::kFXPD) {
			auto facialExpression = (RE::BGSFacialExpressionData*)theFacialExpression;
			if (facialExpression)
				return ApplyFacialExpression(theActor, facialExpression);
		}
		return false;
	}
	inline static bool ResetFacialExpression_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return ResetFacialExpression(theActor);
	}
	inline static std::vector<float> ReadFacialExpressionDataMorphValues_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theFacialExpression)
	{
		if (theFacialExpression && theFacialExpression->GetFormType() == RE::FormType::kFXPD) {
			auto facialExpression = (RE::BGSFacialExpressionData*)theFacialExpression;
			if (facialExpression)
				return ReadFacialExpressionDataMorphValues(facialExpression);
		}
		std::vector<float> empty;
		return empty;
	}
	inline static std::vector<std::string> ReadFacialExpressionDataMorphNames_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theFacialExpression)
	{
		if (theFacialExpression && theFacialExpression->GetFormType() == RE::FormType::kFXPD) {
			auto facialExpression = (RE::BGSFacialExpressionData*)theFacialExpression;
			if (facialExpression)
				return ReadFacialExpressionDataMorphNames(facialExpression);
		}
		std::vector<std::string> empty;
		return empty;
	}
	inline static bool StoreFacialExpression_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, RE::TESForm* theFacialExpression)
	{
		if (theFacialExpression && theFacialExpression->GetFormType() == RE::FormType::kFXPD) {
			auto facialExpression = (RE::BGSFacialExpressionData*)theFacialExpression;
			if (facialExpression)
				return StoreFacialExpression(theActor, facialExpression);
		}
		return false;
	}
	inline static bool WriteMorphValue_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theFacialExpression, std::string morphName, float morphValue)
	{
		if (theFacialExpression && theFacialExpression->GetFormType() == RE::FormType::kFXPD) {
			auto facialExpression = (RE::BGSFacialExpressionData*)theFacialExpression;
			if (facialExpression)
				return WriteMorphValue(facialExpression, morphName, morphValue);
		}
		return false;
	}
	inline static float ReadMorphValue_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theFacialExpression, std::string morphName)
	{
		if (theFacialExpression && theFacialExpression->GetFormType() == RE::FormType::kFXPD) {
			auto facialExpression = (RE::BGSFacialExpressionData*)theFacialExpression;
			if (facialExpression)
				return ReadMorphValue(facialExpression, morphName);
		}
		return -1.00f;
	}
	//
	// v1.6 from here
	//
	inline static std::vector<float> GetMorphValues_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetMorphValues(theActor);
	}
	inline static std::vector<RE::Actor*> GetSortedHighActors_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetSortedHighActors();
	}
	//
	// v1.7 from here
	//
	inline static float GetGlobalTimeMultiplier_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetGlobalTimeMultiplier();
	}
	inline static float GetGlobalTimeMultiplierTarget_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetGlobalTimeMultiplierTarget();
	}
	inline static bool SetGlobalTimeMultiplier_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, float globalTimeMultiplier, float playerRelativeTimeMultiplier)
	{
		if (globalTimeMultiplier < 0.0f || playerRelativeTimeMultiplier < 0.0f)
			return false;
		SetGlobalTimeMultiplier(globalTimeMultiplier, playerRelativeTimeMultiplier);
		return true;
	}
	inline static void PlayMenuSound_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string soundName)
	{
		if (soundName.empty() == false)
			PlayMenuSound(soundName, 1.0);
	}
	inline static bool AddKeywordToForm_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm, RE::BGSKeyword* theKeyword)
	{
		return AddKeywordToForm(theForm, theKeyword);
	}
	inline static bool RemoveKeywordFromForm_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm, RE::BGSKeyword* theKeyword)
	{
		return RemoveKeywordFromForm(theForm, theKeyword);
	}
	inline static bool SetModelVisible_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef, bool visible)
	{
		return SetModelVisible(theRef, visible);
	}
	inline static bool IsInVehicle_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsInVehicle(theActor) == 1.00f;
	}
	inline static void EnableLogging_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, bool bEnable)
	{
		if (!bLogging && bEnable) {
			bLogging = true;
			LogInfo("logging was requested to be turned on");
		} else if (bLogging && !bEnable) {
			LogInfo("logging was requested to be turned off");
			bLogging = false;
		}
	}
	inline static bool HasAnimGraphManager_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return theRef && Is3DLoaded(theRef) && Get3DModel(theRef) && (RE::IAnimationGraphManagerHolder*)theRef;
	}
	inline static std::string LookupSourcePlugin_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		return LookupSourcePlugin(theForm);
	}
	//
	// v1.8 from here
	//
	inline static bool IsKeyDown_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int iKeyCode)
	{
		if (iKeyCode <= 0)
			return false;
		for (auto& i : Cassiopeia::PressedKeys) {
			if (i.iKeyCode == iKeyCode) {
				return true;
			}
		}
		return false;
	}
	inline static int GetLeveledCharacterModifier_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		if (theActor)
			return GetLeveledCharacterModifier(theActor);
		return 4;
	}
	inline static bool ShowWindowsMessageBox_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string text)
	{
		if (!text.empty()) {
			ShowMessageBox(text, false);
			return true;
		}
		return false;
	}
	inline static int GetSFSEVersionAsInt_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		const std::regex pattern("[^0-9]");
		std::string s = std::regex_replace(StoredSFSEVerion.string(), pattern, "");
		int              i = -1;
		try {
			i = std::stoi(s);
		}
		catch (...) {
			return -1;
		}
		return i;
	}
	inline static std::string GetSFSEVersionAsString_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return StoredSFSEVerion.string();
	}
	inline static int GetStarfieldVersionAsInt_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		const std::regex pattern("[^0-9]");
		std::string      s = std::regex_replace(StoredStarfieldVerion.string(), pattern, "");
		int              i = -1;
		try {
			i = std::stoi(s);
		} catch (...) {
			return -1;
		}
		return i;
	}
	inline static std::string GetStarfieldVersionAsString_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return StoredStarfieldVerion.string();
	}
	//
	// v1.9 from here
	//
	inline static RE::BGSPackIn* GetSourcePackIn_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return GetSourcePackIn(theRef);
	}
	inline static RE::BGSPackIn* GetGroupedPackIn_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return GetGroupedPackIn(theRef);
	}
	inline static bool ForcePersistent_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef, bool bPersist, bool bSilent)
	{
		bool bInitialLogging = bLogging;
		bool bInitialDebugLogging = bDebugLogging;
		bLogging = false;
		bDebugLogging = false;
		auto promoters = GetPersistencePromoters(theRef);
		bool bIsAlreadyForcedToBePersistent = false;
		for (auto& i : promoters) {
			if (i == theRef) {
				bIsAlreadyForcedToBePersistent = true;
				break;
			}
		}
		if (bIsAlreadyForcedToBePersistent != bPersist) {
			bool bResult = ForcePersistent(theRef, bPersist, bSilent);
			bLogging = bInitialLogging;
			bDebugLogging = bInitialDebugLogging;
			return bResult;
		}
		bLogging = bInitialLogging;
		bDebugLogging = bInitialDebugLogging;
		return false;
	}
	inline static bool AreHostileActorsNearCustom_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, float fDistance)
	{
		return AreHostileActorsNearCustom(fDistance, theActor);
	}
	inline static bool IsCarryable_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		if (theRef && theRef->GetBaseObject())
			return CanBePlacedInContainerByFormType(static_cast<int>(theRef->GetBaseObject()->GetFormType()));
		return false;
	}
	//
	// v2.1 from here
	//
	inline static bool ResetInventory_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef, bool bLeveledOnly, bool bSkipDefaultOutfit)
	{
		if (theRef && GetFadeNode(theRef)) {
			theRef->ResetInventory(bLeveledOnly, bSkipDefaultOutfit, true);
			return true;
		}
		return false;
	}
	inline static RE::TESObjectMISC* GetLooseMod_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSMod::Attachment::Mod* theObjectMod)
	{
		return GetLooseMod(theObjectMod);		
	}
	inline static bool IsCrowdActor_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsCrowdActor(theActor);
	}
	inline static bool SetForceSneak_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, bool bForceSneak)
	{
		return SetForceSneak(theActor, bForceSneak);
	}
	inline static int GetVehicleCameraState_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetVehicleCameraState();
	}
	inline static bool IsOnPlayerHomeSpaceship_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return theRef && IsReferenceOnPlayerHomeSpaceShip(theRef);
	}
	inline static bool IsAliasedRef_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return theRef && HasAliasExtraInstanceData(theRef);
	}
	inline static bool IsHarvested_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return theRef && IsHarvested(theRef);
	}
	inline static bool IsCreated_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		return theForm && GetIsCreatedForm(theForm);
	}
	inline static RE::TESObjectREFR* GetPlayerHomeSpaceshipPilotSeatRef_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetPlayerHomeshipPilotSeatRef();
	}
	inline static bool IsPromotedPersistent_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string HexFormID)
	{
		std::vector<int> FormTypes = { static_cast<int>(RE::FormType::kREFR),
			static_cast<int>(RE::FormType::kACHR) };
		auto             theRef = GetFormByHexFormID <RE::TESObjectREFR>(HexFormID, FormTypes);
		return theRef && IsReferencePersistent(theRef) && HasPromotedRefExtra(theRef);
	}
	inline static RE::TESForm* GetDefaultObjectForm_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theDefaultObject)
	{
		if (theDefaultObject && theDefaultObject->GetFormType() == RE::FormType::kDFOB) {
			auto DefaultObject = (RE::BGSDefaultObject*)theDefaultObject;
			if (DefaultObject)
				return DefaultObject->object;
		}
		return nullptr;
	}
	inline static bool SetDefaultObjectForm_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theDefaultObject, RE::TESForm* theForm)
	{
		if (theDefaultObject && theDefaultObject->GetFormType() == RE::FormType::kDFOB) {
			auto DefaultObject = (RE::BGSDefaultObject*)theDefaultObject;
			if (DefaultObject) {
				DefaultObject->object = theForm;
				return true;
			}
		}
		return false;
	}
	inline static int GetInterfaceLanguageIndex_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetInterfaceLanguageIndex();
	}
	inline static RE::TESObjectCELL* GetPersistentCell_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return GetExtraPersistentCell(theRef);
	}
	//
	// v2.2 from here
	//
	inline static std::vector<int> GetUTHourPerLocalDay_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		std::vector<int> Result;
		auto fTime = GetUTHourPerLocalDay();
		if (fTime != -1.00f) {
			int iHour = static_cast<int>(fTime);
			int iMinute = static_cast<int>(round((fTime - static_cast<float>(iHour)) * 60.0f));
			Result.push_back(iHour);
			Result.push_back(iMinute);
		}
		return Result;
	}
	inline static std::vector<int> GetUTHourPerLocalHour_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, bool bIgnorefMaxUTHourPerLocalHourGameSetting)
	{
		std::vector<int> Result;
		auto             fTime = GetUTHourPerLocalHour(bIgnorefMaxUTHourPerLocalHourGameSetting);
		if (fTime != -1.00f) {
			int iHour = static_cast<int>(fTime);
			int iMinute = static_cast<int>(round((fTime - static_cast<float>(iHour)) * 60.0f));
			Result.push_back(iHour);
			Result.push_back(iMinute);
		}
		return Result;
	}
	inline static std::vector<int> GetGameDate_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return to_vector(GetGameDate());
	}
	inline static RE::Actor* GetActorReference_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSRefAlias* theRefAlias)
	{
		if (theRefAlias) {
			auto AliasRef = GetReference(theRefAlias);
			if (AliasRef && AliasRef->GetSavedFormType() == 75) {
				auto AliasActorRef = (RE::Actor*)AliasRef;
				if (AliasActorRef)
					return AliasActorRef;
			}
		}
		return nullptr;
	}
	inline static std::vector<RE::TESObjectREFR*> CreateReferencesAtCoordinates_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theBaseObject, int Count, float fXPos, float fYPos, float fZPos, float fXRot, float fYRot, float fZRot, RE::TESObjectCELL* theCell, RE::TESWorldSpace* theWorldSpace, bool bForcePersistent, bool bInitiallyDisabled, bool bDeleteWhenAble)
	{
		std::vector<RE::TESObjectREFR*> Result;
		if (!theBaseObject || Count <= 0)
			return Result;
		auto BoundObj = (RE::TESBoundObject*)theBaseObject;
		if (!BoundObj)
			return Result;
		auto PlayerParentCell = RE::PlayerCharacter::GetSingleton()->parentCell;
		if (!PlayerParentCell)
			return Result;
		for (int i = 0; i < Count; i++) {
			auto NewREFRData = new RE::NEW_REFR_DATA();
			if (!NewREFRData)
				return Result;
			RE::NiPoint3 Pos;
			Pos.x = fXPos;
			Pos.y = fYPos;
			Pos.z = fZPos;
			RE::NiPoint3 Rot;
			Rot.x = fXRot * static_cast<float>(0.0174532925);
			Rot.y = fYRot * static_cast<float>(0.0174532925);
			Rot.z = fZRot * static_cast<float>(0.0174532925);
			auto     PlayerChar = RE::PlayerCharacter::GetSingleton();
			auto     World = PlayerChar->GetParentWorldSpace();
			uint32_t u = 0;
			if (World) {
				CreateNewREFRData(NewREFRData, BoundObj, &Pos, &Rot, nullptr, World, 0, 0, 0, u & 0xffffffffffffff00, 1, nullptr, 0, 0, 0, 0, 0);
			} else {
				CreateNewREFRData(NewREFRData, BoundObj, &Pos, &Rot, PlayerParentCell, nullptr, 0, 0, 0, u & 0xffffffffffffff00, 1, nullptr, 0, 0, 0, 0, 0);
			}
			if (bInitiallyDisabled)
				bool b = NewREFRData->SetInitiallyDisabled(true);
			uint32_t handle = 0;
			CreateReference(RE::TESDataHandler::GetSingleton(), &handle, *NewREFRData);
			delete NewREFRData;
			if (handle == 0)
				return Result;
			auto CreatedRef = RE::GetReferenceByHandle(handle);
			if (!CreatedRef)
				return Result;
			if (bForcePersistent)
				ForcePersistent(CreatedRef, true);
			if (bDeleteWhenAble) {
				SetTemporaryReference(CreatedRef, true);
				if (!IsTemporaryReference(CreatedRef)) {
					LogError("CreatedRef " + GetBasicReferenceData(CreatedRef, true, true, true, true) + " is not Temporary even though bDeleteWhenAble is true");
				}
			}
			Result.push_back(CreatedRef);
		}
		return Result;
	}
	inline static bool EnableDistantLOD_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, bool bEnable)
	{
		auto LodManager = RE::BGSLODManager::GetSingleton();
		if (LodManager->bDistantLODDisabled == !bEnable)
			return false;
		LodManager->bDistantLODDisabled = !bEnable;
		return true;
	}
	inline static std::vector<float> GetReferenceBounds_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		std::vector<float> Result;
		if (theRef) {
			auto Length = GetLength(theRef);
			auto Width = GetWidth(theRef);
			auto Height = GetHeight(theRef);
			Result.push_back(Length);
			Result.push_back(Width);
			Result.push_back(Height);
		}		
		return Result;
	}
	inline static std::vector<RE::BGSBaseAlias*> GetAliases_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		std::vector<RE::BGSBaseAlias*> Result;
		if (theRef) {
			auto aliases = GetAliases(theRef);
			for (auto& i : aliases) {
				auto alias = std::get<1>(i);
				if (!alias || (std::find(std::begin(Result), std::end(Result), alias) < Result.end()))
					continue;
				Result.push_back(alias);
			}
		}
		return Result;
	}
	inline static std::string GetAliasName_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSBaseAlias* theAlias)
	{
		if (theAlias)
			return theAlias->aliasName.c_str();
		return "";
	}
	inline static int GetAliasIndex_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSBaseAlias* theAlias)
	{
		if (theAlias && theAlias->aliasIndex <= INT32_MAX)
			return theAlias->aliasIndex;
		return -1;
	}
	inline static bool SetAS3Variable_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string menuName, std::string varPath, std::string newValue)
	{
		return SetAS3Variable(menuName, varPath, newValue);
	}
	inline static std::string GetAllFormsMapSize_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		const auto& [map, lock] = RE::TESForm::GetAllForms();
		RE::BSAutoReadLock l{ lock };
		if (map)
			return std::to_string(map->size());
		return "";
	}
	inline static void PrintAllFormsMapToFile_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		PrintAllFormsMapToFile();
	}
	//
	// v2.3 from here
	//
	inline static bool IsControlDown_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sControlName)
	{
		if (sControlName.empty())
			return false;
		for (auto& i : Cassiopeia::PressedKeys) {
			if (std::strcmp(ToLowerStr(sControlName).c_str(), ToLowerStr(i.sControlName).c_str()) == 0) {
				return true;
			}
		}
		return false;
	}
	inline static void DumpControlMapInfo_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, bool bDumpMemoryAddresses)
	{
		DumpControlMapInfo(bDumpMemoryAddresses);
	}
	inline static float GetHoldTimeByKeyCode_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int iKeyCode)
	{
		int iDeviceIndex = 0;
		if (!IsMouseWheelOrMovement(iKeyCode) && iKeyCode >= SFSE::InputMap::kMacro_GamepadOffset)
			iDeviceIndex = 2;
		else if (iKeyCode >= SFSE::InputMap::kMacro_MouseButtonOffset)
			iDeviceIndex = 1;
		for (auto& i : Cassiopeia::PressedKeys) {
			if (i.iKeyCode == iKeyCode && i.iDeviceIndex == iDeviceIndex) {
				return i.fHoldTime;
			}
		}
		return -1.0f;
	}
	inline static float GetHoldTimeByControlName_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sControlName)
	{
		if (sControlName.empty())
			return -1.00f;
		for (auto& i : Cassiopeia::PressedKeys) {
			if (std::strcmp(ToLowerStr(sControlName).c_str(), ToLowerStr(i.sControlName).c_str()) == 0) {
				return i.fHoldTime;
			}
		}
		return -1.0f;
	}
	inline static std::string GetControlNameByKeyCode_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int iKeyCode, int iControlMappingIndex)
	{
		int iDeviceIndex = 0;
		if (!IsMouseWheelOrMovement(iKeyCode) && iKeyCode >= SFSE::InputMap::kMacro_GamepadOffset)
			iDeviceIndex = 2;
		else if (iKeyCode >= SFSE::InputMap::kMacro_MouseButtonOffset)
			iDeviceIndex = 1;
		return GetControlNameByKeyCode(iKeyCode, iDeviceIndex, iControlMappingIndex);
	}
	inline static std::string GetKeyNameByKeyCode_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, int iKeyCode)
	{
		int iDeviceIndex = 0;
		if (!IsMouseWheelOrMovement(iKeyCode) && iKeyCode >= SFSE::InputMap::kMacro_GamepadOffset)
			iDeviceIndex = 2;
		else if (iKeyCode >= SFSE::InputMap::kMacro_MouseButtonOffset)
			iDeviceIndex = 1;
		return GetKeyNameByKeyCode(iKeyCode, iDeviceIndex);
	}
	inline static std::string GetCharAt_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sInput, int iIndex)
	{
		if (iIndex < 0 || sInput.empty() || iIndex >= sInput.size())
			return "";
		auto ch = sInput.at(iIndex);
		std::string s = &ch;
		return s;
	}
	inline static std::string SubStr_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sInput, int iOff, int iCount)
	{
		if (iOff < 0 || iCount < 0 || sInput.empty() || iOff >= sInput.size())
			return "";
		if (iCount >= sInput.size())
			return sInput;
		sInput = sInput.substr(iOff, iCount);
		return sInput;
	}
	inline static std::string EraseStr_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sInput, int iOff, int iCount)
	{
		if (iOff < 0 || iCount < 0 || sInput.empty() || iOff >= sInput.size())
			return "";
		if (iCount >= sInput.size())
			iCount = sInput.size() - 1;
		sInput = sInput.erase(iOff, iCount);
		return sInput;
	}
	inline static int FindStr_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sInput, std::string sToFind)
	{
		if (sInput.empty() || sToFind.empty())
			return -1;
		size_t pos = ToLowerStr(sInput).find(ToLowerStr(sToFind));
		return pos;
	}
	inline static std::string MergeStr_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::vector<std::string> sInput)
	{
		if (sInput.size() == 0)
			return "";
		std::string Result;
		for (auto& s : sInput)
			Result = Result + s;
		return Result;
	}
	inline static std::vector<std::string> SplitStr_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sInput, std::string sDelim)
	{
		std::vector<std::string> Result;
		if (sInput.empty() || sDelim.empty())
			return Result;
		sInput = ToLowerStr(sInput);
		sDelim = ToLowerStr(sDelim);
		size_t      pos_start = 0, pos_end = 0, delim_len = sDelim.length();
		std::string              str;
		while ((pos_end = sInput.find(sDelim, pos_start)) != std::string::npos) {
			str = sInput.substr(pos_start, pos_end - pos_start);
			pos_start = pos_end + delim_len;
			Result.push_back(str);
		}
		Result.push_back(sInput.substr(pos_start));
		return Result;
	}
	inline static std::string ReplaceStr_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sInput, std::string sFrom, std::string sTo)
	{
		if (sInput.empty())
			return "";
		if (sFrom.empty())
			return sInput;
		sInput = ToLowerStr(sInput);
		sFrom = ToLowerStr(sFrom);
		sTo = ToLowerStr(sTo);
		if (!sTo.empty()) {
			std::string Result;
			Result.reserve(sInput.length());
			std::string::size_type lastPos = 0;
			std::string::size_type findPos;
			while (std::string::npos != (findPos = sInput.find(sFrom, lastPos))) {
				Result.append(sInput, lastPos, findPos - lastPos);
				Result += sTo;
				lastPos = findPos + sFrom.length();
			}
			Result += sInput.substr(lastPos);
			sInput.swap(Result);
		} else {
			std::string::size_type i = sInput.find(sFrom);
			if (i != std::string::npos)
				sInput.erase(i, sFrom.length());
		}
		return sInput;
	}
	//
	// v2.5 from here
	//
	inline static void DumpMenuFlags_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sMenuName)
	{
		if (sMenuName.empty() || !RE::UI::GetSingleton()->IsMenuOpen(sMenuName)) {
			LogError("sMenuName [" + sMenuName + "] is either empty or there is no open IMenu with this name");
			return;
		}
		auto Menu = GetMenu(sMenuName);
		if (!Menu) {
			LogError("Menu with sMenuName [" + sMenuName + "] is nullptr");
			return;
		}
		LogInfo("Menu [" + sMenuName + "] flags ------->");
		LogInfo("1 << 0 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag0)));
		LogInfo("1 << 1 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag1)));
		LogInfo("1 << 2 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag2)));
		LogInfo("1 << 3 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::ShowCursor)));
		LogInfo("1 << 4 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag4)));
		LogInfo("1 << 5 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag5)));
		LogInfo("1 << 6 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag6)));
		LogInfo("1 << 7 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag7)));
		LogInfo("1 << 8 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag8)));
		LogInfo("1 << 9 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag9)));
		LogInfo("1 << 10 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag10)));
		LogInfo("1 << 11 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag11)));
		LogInfo("1 << 12 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag12)));
		LogInfo("1 << 13 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag13)));
		LogInfo("1 << 14 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag14)));
		LogInfo("1 << 15 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag15)));
		LogInfo("1 << 16 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag16)));
		LogInfo("1 << 17 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag17)));
		LogInfo("1 << 18 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag18)));
		LogInfo("1 << 19 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag19)));
		LogInfo("1 << 20 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag20)));
		LogInfo("1 << 21 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag21)));
		LogInfo("1 << 22 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag22)));
		LogInfo("1 << 23 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag23)));
		LogInfo("1 << 24 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag24)));
		LogInfo("1 << 25 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag25)));
		LogInfo("1 << 26 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag26)));
		LogInfo("1 << 27 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag27)));
		LogInfo("1 << 28 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag28)));
		LogInfo("1 << 29 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag29)));
		LogInfo("1 << 30 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag30)));
		LogInfo("1 << 31 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag31)));
		LogInfo("1 << 32 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag32)));
		LogInfo("1 << 33 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag33)));
		LogInfo("1 << 34 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag34)));
		LogInfo("1 << 35 " + std::to_string(Menu->flags.any(RE::IMenu::Flag::Flag35)));
		LogInfo("Menu [" + sMenuName + "] flags <-------");

	}
	inline static bool OpenMenu_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sMenuName)
	{
		if (sMenuName.empty() || RE::UI::GetSingleton()->IsMenuOpen(sMenuName))
			return false;
		auto allMenus = GetAllMenuNames();
		if (std::find(std::begin(allMenus), std::end(allMenus), sMenuName) == allMenus.end())
			return false;
		RE::UIMessageQueue::GetSingleton()->AddMessage(sMenuName, RE::UIMessage::kShow);
		return true;
	}
	inline static bool CloseMenu_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string sMenuName)
	{
		if (sMenuName.empty() || !RE::UI::GetSingleton()->IsMenuOpen(sMenuName))
			return false;
		auto allMenus = GetAllMenuNames();
		if (std::find(std::begin(allMenus), std::end(allMenus), sMenuName) == allMenus.end())
			return false;
		RE::UIMessageQueue::GetSingleton()->AddMessage(sMenuName, RE::UIMessage::kHide);
		return true;
	}
	//
	// v2.6 from here
	//
	inline static bool PromoteReference_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef, RE::TESForm* theOwner)
	{
		return PromoteReference(theRef, theOwner);
	}
	inline static bool DemoteReference_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef, RE::TESForm* theOwner)
	{
		return DemoteReference(theRef, theOwner);
	}
	inline static bool IsPersistencePromotedBy_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef, RE::TESForm* theOwner)
	{
		return IsPersistencePromotedBy(theRef, theOwner);
	}
	inline static bool IsPathing_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return IsPathing(theActor);
	}
	inline static bool CalculateTemplateForLeveledActor_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return CalculateTemplateForLeveledActor(theActor);
	}
	inline static bool GetUsesLeveledTemplate_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, int iTemplateFlag)
	{
		if (theActor) {
			auto BaseNPC = (RE::TESNPC*)theActor->GetBaseObject();
			if (BaseNPC && BaseNPC->GetSavedFormType() == static_cast<int>(RE::FormType::kNPC_))
				return BaseNPC->GetUsesLeveledTemplate(iTemplateFlag);
		}
		return false;
	}
	inline static bool ChangeActorProcessLevel_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, int iProcessLevel)
	{
		return ChangeActorProcessLevel(theActor, iProcessLevel);
	}
	inline static bool UpdateReference3D_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return UpdateReference3D(theRef);
	}
	inline static float GetDistanceFromCelestialBody_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef, RE::BGSPlanet::PlanetData* celestialBody, bool bSurface)
	{
		return GetDistanceFromCelestialBody(theRef, celestialBody, bSurface);
	}
	inline static float GetDistanceGalacticLightYears_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef, RE::TESObjectREFR* theRef2)
	{
		return GetDistanceGalacticLightYears(theRef, theRef2);
	}
	//
	// v2.7 from here
	//
	inline static bool SetEyeTarget_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, RE::Actor* theTargetActor, bool bReset)
	{
		return SetEyeTarget(theActor, theTargetActor, bReset == false);
	}
	inline static bool ClearEyeTracking_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return ClearEyeTracking(theActor);
	}
	inline static bool SetEyeTrackingActive_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, bool bActive)
	{
		return SetEyeTrackingActive(theActor, bActive);
	}
	inline static RE::TESObjectREFR* GetHeadTrackTarget_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetHeadTrackTarget(theActor, true);
	}
	inline static RE::BGSKeyword* GetSpeakingAnimArchetype_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetSpeakingAnimArchetype(theActor);
	}
	inline static RE::BGSKeyword* GetAnimFaceArchetypeEditorDefined_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		if (theActor) {
			auto baseactor = (RE::TESNPC*)theActor->GetBaseObject();
			if (baseactor)
				return GetAnimFaceArchetypeEditorDefined(baseactor);
		}
		return nullptr;
	}
	inline static bool SetFaceAnimArchetype_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor, RE::BGSKeyword* theKeyword)
	{
		return SetFaceAnimArchetypeByKeyword(theActor, theKeyword);
	}
	inline static std::string GetFormDescription_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		if (theForm) {
			char chDest[255]{};
			std::pair<char*, uint32_t> Dest = std::make_pair(chDest, 255);
			return GetFormDescription(theForm, &Dest);
		}
		return "";
	}
	inline static std::vector<RE::TESForm*> GetFormsByEditorID_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, std::string theEditorID, bool bUseAllFormsMap)
	{
		return GetFormsByEditorID(theEditorID, bUseAllFormsMap);
	}
	inline static std::string GetFormEditorID_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESForm* theForm)
	{
		return GetFormEditorID(theForm);
	}
	inline static int GetDontLoopEmotionsIndex_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::BGSKeyword* theKeyword)
	{
		return GetDontLoopEmotionsIndex(theKeyword);
	}
	inline static RE::BGSKeyword* GetWorkshopItemKeyword_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetWorkshopItemKeyword();
	}
	inline static RE::BGSKeyword* GetWorkshopKeyword_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate)
	{
		return GetWorkshopKeyword();
	}
	inline static bool IsWorkshopItem_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESObjectREFR* theRef)
	{
		return IsWorkshopItem(theRef);
	}
	inline static std::vector<RE::TESTopicInfo*> GetAllTopicInfos_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESTopic* theTopic)
	{
		return GetAllTopicInfos(theTopic);
	}
	inline static int GetNumTopicInfos_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESTopic* theTopic)
	{
		if (theTopic)
			return theTopic->numTopicInfos;
		return -1;
	}
	inline static std::vector<RE::TESTopic*> GetAllTopicsByOwnerQuest_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESQuest* theQuest)
	{
		return GetAllTopicsByOwnerQuest(theQuest);
	}
	inline static RE::TESTopicInfo* GetLastSaidTopicInfo_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetLastSaidTopicInfo(theActor);
	}
	inline static std::string GetNthResponseText_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESTopicInfo* theTopicInfo, int iResponseIndex, bool bGetlast = false)
	{
		return GetNthResponseText(theTopicInfo, iResponseIndex, bGetlast);
	}
	inline static RE::BGSKeyword* GetNthResponseAnimFaceArchetype_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::TESTopicInfo* theTopicInfo, int iResponseIndex, bool bGetlast = false)
	{
		return GetNthResponseAnimFaceArchetype(theTopicInfo, iResponseIndex, bGetlast);
	}
	inline static RE::BGSKeyword* GetLastSaidTopicInfoAnimArchetypeKeyword_Cassiopeia(RE::BSScript::IVirtualMachine& vm, std::uint32_t stackID, std::monostate, RE::Actor* theActor)
	{
		return GetLastSaidTopicInfoAnimArchetypeKeyword(theActor);
	}









	inline static int RegisterPapyrusFunctions(RE::BSScript::IVirtualMachine* vm)
	{
		const char* ScriptName = "CassiopeiaPapyrusExtender";
		auto        lineB = __LINE__ + 1;
		vm->BindNativeMethod(ScriptName, "IsMenuOpen", &IsMenuOpen_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetReferenceName", &GetReferenceName_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetOverrideName", &GetOverrideName_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetDisplayName", &SetDisplayName_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetTESFullName", &GetTESFullName_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetTESFullName", &SetTESFullName_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetCrosshairRef", &GetCrosshairRef_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetVisibleActors", &GetVisibleActors_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetHelmetLight", &SetHelmetLight_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAppearanceSource", &GetAppearanceSource_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAliasHolderQuests", &GetAliasHolderQuests_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetTemporaryReference", &SetTemporaryReference_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsTemporaryReference", &IsTemporaryReference_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsAnyCompanionTalking", &IsAnyCompanionTalking_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetActorsDetectedBy", &GetActorsDetectedBy_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetActorsDetecting", &GetActorsDetecting_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetHighActors", &GetHighActors_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetSpells", &GetSpells_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetFactions", &GetFactions_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetKeywords", &GetKeywords_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetMagicEffects", &GetMagicEffects_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetInventoryItems", &GetInventoryItems_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetEquippedInventoryItems", &GetEquippedInventoryItems_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "AddPerkToAll", &AddPerkToAll_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "RemovePerkFromAll", &RemovePerkFromAll_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsPersistent", &IsPersistent_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetIsFormFlagSet", &GetIsFormFlagSet_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetFormFlagsAsInt", &GetFormFlagsAsInt_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetFormFlagsAsHex", &GetFormFlagsAsHex_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetFormFlag", &SetFormFlag_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetIsChangeFlagSet", &GetIsChangeFlagSet_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetChangeFlagsAsInt", &GetChangeFlagsAsInt_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetChangeFlagsAsHex", &GetChangeFlagsAsHex_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetChangeFlag", &SetChangeFlag_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetBit", &SetBit_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "UnsetBit", &UnsetBit_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "BitwiseAnd", &BitwiseAnd_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "BitwiseOr", &BitwiseOr_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "BitwiseNot", &BitwiseNot_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "BitwiseXor", &BitwiseXor_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "BitwiseLeftShift", &BitwiseLeftShift_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "BitwiseRightShift", &BitwiseRightShift_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetActivePluginCount", &GetActivePluginCount_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetActivePlugins", &GetActivePlugins_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetPluginType", &GetPluginType_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsFullMaster", &IsFullMaster_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsSmallMaster", &IsSmallMaster_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsMediumMaster", &IsMediumMaster_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetConsoleRef", &GetConsoleRef_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetFormTypeAsString", &GetFormTypeAsString_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetFormTypeAsInt", &GetFormTypeAsInt_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAllFormsByFormType", &GetAllFormsByFormType_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "LookupLastOverriderPlugin", &LookupLastOverriderPlugin_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetReferenceHandle", &GetReferenceHandle_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetReferenceByHandle", &GetReferenceByHandle_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetReferencesInCell", &GetReferencesInCell_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInPhotoMode", &IsInPhotoMode_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInAutoVanityMode", &IsInAutoVanityMode_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInFirstPerson", &IsInFirstPerson_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInThirdPerson", &IsInThirdPerson_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInIronSightsCam", &IsInIronSightsCam_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInFlightCam", &IsInFlightCam_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInShipTargetingCam", &IsInShipTargetingCam_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInShipCombatOrbitCam", &IsInShipCombatOrbitCam_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInShipFarTravelCam", &IsInShipFarTravelCam_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInShipActionCam", &IsInShipActionCam_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetSex", &GetSex_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetFormListAllForms", &GetFormListAllForms_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetGameSettingFloat", &SetGameSettingFloat_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetGameSettingInt", &SetGameSettingInt_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetGameSettingBool", &SetGameSettingBool_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetGameSettingUInt", &SetGameSettingUInt_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetGameSettingString", &SetGameSettingString_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetINISettingFloat", &GetINISettingFloat_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetINISettingInt", &GetINISettingInt_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetINISettingBool", &GetINISettingBool_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetINISettingUInt", &GetINISettingUInt_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetINISettingString", &GetINISettingString_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetPluginFileAuthorName", &GetPluginFileAuthorName_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetFormsByTESFullName", &GetFormsByTESFullName_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetOutfitForms", &GetOutfitForms_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "AddToOutfitForms", &AddToOutfitForms_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "RemoveOutfitForm", &RemoveOutfitForm_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "RemoveNthOutfitForm", &RemoveNthOutfitForm_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "RemoveAllOutfitForms", &RemoveAllOutfitForms_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "EvaluatePackageForAll", &EvaluatePackageForAll_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "DoesFileExist", &DoesFileExist_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "DoesIniExist", &DoesIniExist_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "WriteIni", &WriteIni_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ReadIni", &ReadIni_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetCassiopeiaPapyrusExtenderVersion", &GetCassiopeiaPapyrusExtenderVersion_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "HexToInt", &HexToInt_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsSwimming", &IsSwimming_Cassiopeia, true, false);  // v1.1 from here
		vm->BindNativeMethod(ScriptName, "IsInWater", &IsInWater_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInCombatSearch", &IsInCombatSearch_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsMurderAlarmed", &IsMurderAlarmed_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsParalyzed", &IsParalyzed_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "DoesAffectStealthMeter", &DoesAffectStealthMeter_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsUnderwater", &IsUnderwater_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsSpacesuitHelmetVisible", &IsSpacesuitHelmetVisible_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsSpacesuitHelmetLightOn", &IsSpacesuitHelmetLightOn_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsJumping", &IsJumping_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "UpdateAppearance", &UpdateAppearance_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "UpdateChargenAppearance", &UpdateChargenAppearance_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetSkinTone", &SetSkinTone_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetSkinTone", &GetSkinTone_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetLastSLMTarget", &GetLastSLMTarget_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetReferenceMods", &GetReferenceMods_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsMovingForward", &IsMovingForward_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsMovingBackward", &IsMovingBackward_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsMovingLeft", &IsMovingLeft_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsMovingRight", &IsMovingRight_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsWalking", &IsWalking_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsStaggered", &IsStaggered_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetKnockStateEnum", &GetKnockStateEnum_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetActorGunState", &GetActorGunState_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInGodMode", &IsInGodMode_Cassiopeia, true, false);						// v1.2 from here
		vm->BindNativeMethod(ScriptName, "GetPlayerSpaceshipCurrentSpeed", &GetPlayerSpaceshipCurrentSpeed_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetPlayerSpaceshipWeaponCapacity", &GetPlayerSpaceshipWeaponCapacity_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetPlayerSpaceshipWeaponType", &GetPlayerSpaceshipWeaponType_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsGlobalAIDetectionOn", &IsGlobalAIDetectionOn_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetPlayerSpaceshipMaxFuelRange", &GetPlayerSpaceshipMaxFuelRange_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetPlayerSpaceshipFuelConsumption", &GetPlayerSpaceshipFuelConsumption_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsPlayerSpaceshipFlyingBackward", &IsPlayerSpaceshipFlyingBackward_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetPhotoModeActors", &GetPhotoModeActors_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ClearAllAliases", &ClearAllAliases_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "PrintToConsoleLog", &PrintToConsoleLog_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ClearConsoleLog", &ClearConsoleLog_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsModCollection", &IsModCollection_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsLooseMod", &IsLooseMod_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "CopyInventoryItems", &CopyInventoryItems_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetHexFormID", &GetHexFormID_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "RegisterForNativeEvent", &RegisterForNativeEvent_Cassiopeia, true, false);			// v1.3 from here
		vm->BindNativeMethod(ScriptName, "UnregisterForNativeEvent", &UnregisterForNativeEvent_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "RegisterForAllNativeEvents", &RegisterForAllNativeEvents_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsRegisteredForNativeEvent", &IsRegisteredForNativeEvent_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "UnregisterForAllNativeEvents", &UnregisterForAllNativeEvents_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "AddNativeEventFilter", &AddNativeEventFilter_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "RemoveNativeEventFilter", &RemoveNativeEventFilter_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetNativeEventFilteredForms", &GetNativeEventFilteredForms_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ConvertAddressFromFileToRelocationID", &ConvertAddressFromFileToRelocationID_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAllRunningQuests", &GetAllRunningQuests_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAS3VariableAsString", &GetAS3VariableAsString_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsCrimeToActivate", &IsCrimeToActivate_Cassiopeia, true, false);		// v1.4 from here
		vm->BindNativeMethod(ScriptName, "GetLoadedCells", &GetLoadedCells_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetLoadedReferences", &GetLoadedReferences_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SortReferencesByDeleted", &SortReferencesByDeleted_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SortReferencesByName", &SortReferencesByName_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SortReferencesByKeywords", &SortReferencesByKeywords_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SortReferencesByConditions", &SortReferencesByConditions_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SortReferencesByDistance", &SortReferencesByDistance_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetMorphValue", &SetMorphValue_Cassiopeia, true, false);			// v1.5 from here
		vm->BindNativeMethod(ScriptName, "GetMorphValue", &GetMorphValue_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ExportMorphMap", &ExportMorphMap_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetMorphValues", &SetMorphValues_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "CopyFacialExpression", &CopyFacialExpression_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAnimFaceArchetype", &GetAnimFaceArchetype_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ApplyFacialExpression", &ApplyFacialExpression_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ResetFacialExpression", &ResetFacialExpression_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ReadFacialExpressionDataMorphValues", &ReadFacialExpressionDataMorphValues_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ReadFacialExpressionDataMorphNames", &ReadFacialExpressionDataMorphNames_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "StoreFacialExpression", &StoreFacialExpression_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "WriteMorphValue", &WriteMorphValue_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ReadMorphValue", &ReadMorphValue_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetMorphValues", &GetMorphValues_Cassiopeia, true, false);  // v1.6 from here
		vm->BindNativeMethod(ScriptName, "GetSortedHighActors", &GetSortedHighActors_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetGlobalTimeMultiplier", &SetGlobalTimeMultiplier_Cassiopeia, true, false);  // v1.7 from here
		vm->BindNativeMethod(ScriptName, "GetGlobalTimeMultiplier", &GetGlobalTimeMultiplier_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetGlobalTimeMultiplierTarget", &GetGlobalTimeMultiplierTarget_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "PlayMenuSound", &PlayMenuSound_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "AddKeywordToForm", &AddKeywordToForm_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "RemoveKeywordFromForm", &RemoveKeywordFromForm_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetModelVisible", &SetModelVisible_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsInVehicle", &IsInVehicle_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "EnableLogging", &EnableLogging_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "HasAnimGraphManager", &HasAnimGraphManager_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "LookupSourcePlugin", &LookupSourcePlugin_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetLeveledCharacterModifier", &GetLeveledCharacterModifier_Cassiopeia, true, false);  // v1.8 from here
		vm->BindNativeMethod(ScriptName, "IsKeyDown", &IsKeyDown_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetSFSEVersionAsInt", &GetSFSEVersionAsInt_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetSFSEVersionAsString", &GetSFSEVersionAsString_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetStarfieldVersionAsInt", &GetStarfieldVersionAsInt_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetStarfieldVersionAsString", &GetStarfieldVersionAsString_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetSourcePackIn", &GetSourcePackIn_Cassiopeia, true, false);  // v1.9 from here
		vm->BindNativeMethod(ScriptName, "GetGroupedPackIn", &GetGroupedPackIn_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ForcePersistent", &ForcePersistent_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "AreHostileActorsNearCustom", &AreHostileActorsNearCustom_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsCarryable", &IsCarryable_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ResetInventory", &ResetInventory_Cassiopeia, true, false);  // v2.1 from here
		vm->BindNativeMethod(ScriptName, "GetLooseMod", &GetLooseMod_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsCrowdActor", &IsCrowdActor_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetForceSneak", &SetForceSneak_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetVehicleCameraState", &GetVehicleCameraState_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsOnPlayerHomeSpaceship", &IsOnPlayerHomeSpaceship_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsAliasedRef", &IsAliasedRef_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsHarvested", &IsHarvested_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsCreated", &IsCreated_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetPlayerHomeSpaceshipPilotSeatRef", &GetPlayerHomeSpaceshipPilotSeatRef_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsPromotedPersistent", &IsPromotedPersistent_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetDefaultObjectForm", &GetDefaultObjectForm_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetDefaultObjectForm", &SetDefaultObjectForm_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetInterfaceLanguageIndex", &GetInterfaceLanguageIndex_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetPersistentCell", &GetPersistentCell_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetUTHourPerLocalDay", &GetUTHourPerLocalDay_Cassiopeia, true, false);  // v2.2 from here
		vm->BindNativeMethod(ScriptName, "GetUTHourPerLocalHour", &GetUTHourPerLocalHour_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetGameDate", &GetGameDate_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetActorReference", &GetActorReference_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "CreateReferencesAtCoordinates", &CreateReferencesAtCoordinates_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "EnableDistantLOD", &EnableDistantLOD_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetReferenceBounds", &GetReferenceBounds_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAliases", &GetAliases_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAliasName", &GetAliasName_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAliasIndex", &GetAliasIndex_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetAS3Variable", &SetAS3Variable_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAllFormsMapSize", &GetAllFormsMapSize_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "PrintAllFormsMapToFile", &PrintAllFormsMapToFile_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "DumpControlMapInfo", &DumpControlMapInfo_Cassiopeia, true, false);  // v2.3 from here
		vm->BindNativeMethod(ScriptName, "IsControlDown", &IsControlDown_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetHoldTimeByKeyCode", &GetHoldTimeByKeyCode_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetHoldTimeByControlName", &GetHoldTimeByControlName_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetControlNameByKeyCode", &GetControlNameByKeyCode_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetKeyNameByKeyCode", &GetKeyNameByKeyCode_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetCharAt", &GetCharAt_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SubStr", &SubStr_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "EraseStr", &EraseStr_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "FindStr", &FindStr_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "MergeStr", &MergeStr_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SplitStr", &SplitStr_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ReplaceStr", &ReplaceStr_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "DumpMenuFlags", &DumpMenuFlags_Cassiopeia, true, false);  // v2.5 from here
		vm->BindNativeMethod(ScriptName, "OpenMenu", &OpenMenu_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "CloseMenu", &CloseMenu_Cassiopeia, true, false); 
		vm->BindNativeMethod(ScriptName, "PromoteReference", &PromoteReference_Cassiopeia, true, false);  // v2.6 from here
		vm->BindNativeMethod(ScriptName, "DemoteReference", &DemoteReference_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsPersistencePromotedBy", &IsPersistencePromotedBy_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsPathing", &IsPathing_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "CalculateTemplateForLeveledActor", &CalculateTemplateForLeveledActor_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "ChangeActorProcessLevel", &ChangeActorProcessLevel_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "UpdateReference3D", &UpdateReference3D_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetDistanceFromCelestialBody", &GetDistanceFromCelestialBody_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetDistanceGalacticLightYears", &GetDistanceGalacticLightYears_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetUsesLeveledTemplate", &GetUsesLeveledTemplate_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetEyeTarget", &SetEyeTarget_Cassiopeia, true, false);	// v2.7 from here
		vm->BindNativeMethod(ScriptName, "ClearEyeTracking", &ClearEyeTracking_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetEyeTrackingActive", &SetEyeTrackingActive_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetHeadTrackTarget", &GetHeadTrackTarget_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetSpeakingAnimArchetype", &GetSpeakingAnimArchetype_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAnimFaceArchetypeEditorDefined", &GetAnimFaceArchetypeEditorDefined_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "SetFaceAnimArchetype", &SetFaceAnimArchetype_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetFormsByEditorID", &GetFormsByEditorID_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetFormDescription", &GetFormDescription_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetFormEditorID", &GetFormEditorID_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetDontLoopEmotionsIndex", &GetDontLoopEmotionsIndex_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetWorkshopItemKeyword", &GetWorkshopItemKeyword_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetWorkshopKeyword", &GetWorkshopKeyword_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "IsWorkshopItem", &IsWorkshopItem_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAllTopicInfos", &GetAllTopicInfos_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetNumTopicInfos", &GetNumTopicInfos_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetAllTopicsByOwnerQuest", &GetAllTopicsByOwnerQuest_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetLastSaidTopicInfo", &GetLastSaidTopicInfo_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetNthResponseText", &GetNthResponseText_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetNthResponseAnimFaceArchetype", &GetNthResponseAnimFaceArchetype_Cassiopeia, true, false);
		vm->BindNativeMethod(ScriptName, "GetLastSaidTopicInfoAnimArchetypeKeyword", &GetLastSaidTopicInfoAnimArchetypeKeyword_Cassiopeia, true, false);
		auto lineE = __LINE__;
		return lineE - lineB;
	}

	inline static void RegisterPapyrusScripts(RE::BSScript::IVirtualMachine** vm)
	{
		LogInfo("registering scripts...");
		if (!vm || !*vm) {
			LogError("vm is nullptr");
			std::exit(0);
		}
		auto nativeFuncCount = RegisterPapyrusFunctions(*vm);
		LogInfo("registered " + std::to_string(nativeFuncCount) + " native functions");
	}

}

