Scriptname UCW_MainQuestScript extends Quest

Armor Property Clothes_Chronomark_Mq101 Auto Const

Idle Property idledoorwatch Auto Const

Idle Property idleexaminewatch Auto Const

Idle Property idletakewatch Auto Const

Armor Property UCW_ChronomarkWatch_SS Auto Const

Armor Property UCW_Chronomark_NoSS Auto Const

Actor Property PlayerRef Auto Const

Potion Property UCW_WatchCheckPotion Auto Const

GameplayOption Property UCW_CheckWatchPeriod Auto Const

GameplayOption Property UCW_CheckWatchAnimDisp Auto Const

float UCW_WatchDuration = 6.0 ; Number is in seconds
bool UCW_AnimDispType = false 

int TimerID_Watch = 1

Event OnQuestInit()
    Debug.Trace("[UCW] Quest Started")
    ; Self.registerForGameplayOptionChangedEvent()
    Game.SetCharGenHUDMode(3)

    if !CheckPlayerHasPotion()
        Game.GetPlayer().AddItem(UCW_WatchCheckPotion, 1, true)
        Debug.Trace("[UCW] Added UCW_WatchCheckPotion to player on quest start")
    endif

    ; if UCW_CheckWatchPeriod
    ;     UCW_WatchDuration = UCW_CheckWatchPeriod.GetValue()*60
    ;     Debug.Trace("[UCW] Initial watch duration from GameplayOption: " + UCW_WatchDuration)
    ; endif

EndEvent

; Event OnGameplayOptionChanged(GameplayOption[] aChangedOptions)
;     if aChangedOptions.Find(UCW_CheckWatchPeriod) >= 0
;         UCW_WatchDuration = UCW_CheckWatchPeriod.GetValue()*60
;         Debug.Trace("[UCW] Updated watch duration from GameplayOption: " + UCW_WatchDuration)
;     endif

;     if aChangedOptions.Find(UCW_CheckWatchAnimDisp) >= 0
;         UCW_AnimDispType = UCW_CheckWatchAnimDisp.GetValue()
;         Debug.Trace("[UCW] Updated check watch animation: " + UCW_CheckWatchAnimDisp)
;     endif

;     ; GameplayOption.NotifyGameplayOptionUpdateFinished()
; EndEvent

Function ucw_checkwatch(Actor akCaller)
    Debug.Trace("[UCW] ucw_checkwatch Called")
    Actor player = Game.GetPlayer()
    if akCaller != player
        Debug.Trace("[UCW] ucw_checkwatch called by non-player: " + akCaller)
        return
    endif
    Game.ForceFirstPerson()

    ;play wait if player has weapon out
    If PlayerREF.IsWeaponDrawn()
        PlayerREF.SheatheWeapon()
        Utility.Wait(2.0)
    EndIf

    Utility.Wait(0.1)

    ; If !(UCW_CheckWatchAnimDisp.GetValue())
    ;     int iSpacesuitSlot = 35
    ;     if player.WornCoversBipedSlot(iSpacesuitSlot)
    ;         player.EquipItem(UCW_ChronomarkWatch_SS, true, true)
    ;         Debug.Trace("[UCW] Spacesuit watch equipped")
    ;     else
    ;         player.EquipItem(Clothes_Chronomark_Mq101, true, true)
    ;         Debug.Trace("[UCW] Clothes watch equipped")
    ;     endif
    ;     player.PlayIdle(idleexaminewatch)
    ; ElseIf (true)
    ;     player.PlayIdle(idletakewatch)
    ; EndIf
    
    If (UCW_CheckWatchAnimDisp.GetValue())
        int iSpacesuitSlot = 35
        if player.WornCoversBipedSlot(iSpacesuitSlot)
            player.PlayIdle(idletakewatch)
            Debug.Trace("[UCW] Spacesuit watch idle played")
        else
            player.EquipItem(UCW_Chronomark_NoSS, true, true)
            player.PlayIdle(idleexaminewatch)
            Debug.Trace("[UCW] Clothes watch equipped")
        endif
    Else
        player.PlayIdle(idletakewatch)
        Debug.Trace("[UCW] Player choose to non adaptive play idle")
    EndIf
    


    
    Utility.Wait(5)
    Game.SetCharGenHUDMode(0)
    
    float duration = UCW_CheckWatchPeriod.GetValue() * 60.0
    if duration < 0.5
        duration = 5
    endif

    CancelTimer(TimerID_Watch)
    Utility.Wait(1)
    Debug.Trace("[UCW] CancelTimer(TimerID_Watch) called. Starting new timer for " + duration + " sec")
    ; StartTimer(UCW_CheckWatchPeriod.GetValue()*60.0, TimerID_Watch)
    StartTimer(duration, TimerID_Watch)
EndFunction

Event OnTimer(int aiTimerID)
    if aiTimerID == TimerID_Watch
        Game.SetCharGenHUDMode(3) ; 隐藏手表UI
        Debug.Trace("[UCW] Watch HUD hidden after " + UCW_CheckWatchPeriod.GetValue()*60.0 + " seconds, (TimerID=" + aiTimerID + ")")
    endif
EndEvent

bool Function CheckPlayerHasPotion()
    Actor player = Game.GetPlayer()
    if player.GetItemCount(UCW_WatchCheckPotion) > 0
        return true
    else
        return false
    endif
EndFunction








