ScriptName ChangeYourOutfit_MainQuest Extends Quest

Perk Property ChangeYourOutfit_Perk Auto Const mandatory
FormList Property PlayerCurrentEquipped Auto
FormList Property ArmorKeywordList Const Auto
GlobalVariable Property ChangeYourOutfit_EventLock Auto Const

Form[] Property MannequinItems Auto

Bool[] MannequinPrevSlotState
Bool[] MannequinCurrSlotState
Bool[] PlayerPrevSlotState
Bool[] PlayerCurrSlotState

Event OnQuestInit()
    Actor Player_Ref = Game.GetPlayer()
    Debug.Trace("[ChangeYourOutfit]: Perk added to player")
	AddInteractPerk()
    MannequinPrevSlotState = new Bool[64]
    MannequinCurrSlotState = new Bool[64]
    PlayerPrevSlotState = new Bool[64]
    PlayerCurrSlotState = new Bool[64]
    
EndEvent

Function AddInteractPerk()
    Actor Player_Ref = Game.GetPlayer()
	If !Player_Ref.HasPerk(ChangeYourOutfit_Perk)
		Player_Ref.AddPerk(ChangeYourOutfit_Perk, False)		
	EndIf	
EndFunction

Function EnsureSlotArraysInitialized()
    if MannequinPrevSlotState == None
        MannequinPrevSlotState = new Bool[64]
    endif
    if MannequinCurrSlotState == None
        MannequinCurrSlotState = new Bool[64]
    endif
    if PlayerPrevSlotState == None
        PlayerPrevSlotState = new Bool[64]
    endif
    if PlayerCurrSlotState == None
        PlayerCurrSlotState = new Bool[64]
    endif
EndFunction


Function DoSwap(ObjectReference akMannequin)
    EnsureSlotArraysInitialized()
    Actor Player_Ref = Game.GetPlayer()
    Actor MannequinActor = akMannequin as Actor
    MannequinItems = new Form[0]
    Debug.Trace("[ChangeYourOutfit]: Swap triggered")
    DebugPrintFormList(PlayerCurrentEquipped, "[ChangeYourOutfit]: <Before Swap> Player Current equippedList contents")
    RegisterForRemoteEvent((akMannequin as Actor), "OnItemUnequipped")
    TransferFormListToMannequin(PlayerCurrentEquipped,akMannequin)
    Utility.Wait(0.5)
    EquipItemList(Player_Ref, MannequinItems)
    Debug.Trace("[ChangeYourOutfit]: Should done equipping player, check event")
    UnregisterForRemoteEvent((akMannequin as Actor), "OnItemUnequipped")
    DebugPrintFormList(PlayerCurrentEquipped, "[ChangeYourOutfit]: <Done Swap> Player Current equippedList contents")
EndFunction

Function DoStore(ObjectReference akMannequin)
    EnsureSlotArraysInitialized()
    Actor Player_Ref = Game.GetPlayer()
    Actor MannequinActor = akMannequin as Actor
    ; MannequinItems = new Form[0]
    Debug.Trace("[ChangeYourOutfit]: Store triggered")
    StorePlayerItems(PlayerCurrentEquipped,akMannequin)
    Utility.Wait(0.5)
    Debug.Trace("[ChangeYourOutfit]: Should done storing player outfit")
EndFunction

Function DoRetrieve(ObjectReference akMannequin)
    EnsureSlotArraysInitialized()
    Actor Player_Ref = Game.GetPlayer()
    Actor MannequinActor = akMannequin as Actor
    MannequinItems = new Form[0]
    Debug.Trace("[ChangeYourOutfit]: Retrieve triggered")
    RegisterForRemoteEvent((akMannequin as Actor), "OnItemUnequipped")
    RetrieveMannqItems(akMannequin)
    Utility.Wait(0.5)
    EquipItemList(Player_Ref, MannequinItems)
    Debug.Trace("[ChangeYourOutfit]: Should done retrieving outfit from mannequin, check event")
    UnregisterForRemoteEvent((akMannequin as Actor), "OnItemUnequipped")
    DebugPrintFormList(PlayerCurrentEquipped, "[ChangeYourOutfit]: <Done retrieve> Player Current equippedList contents")
EndFunction

Function RecordMannequinSlotState(Actor mannequin, Bool[] stateArray)
    int i = 0
    while i < 64
        stateArray[i] = mannequin.WornCoversBipedSlot(i)
        i += 1
    endwhile
EndFunction

Function RecordPlayerSlotState(Actor player, Bool[] stateArray)
    int i = 0
    while i < 64
        stateArray[i] = player.WornCoversBipedSlot(i)
        i += 1
    endwhile
EndFunction


Bool Function ArrayHasForm(Form[] arr, Form target) 
    int i = 0
    while i < arr.Length
        if arr[i] == target
            return true
        endif
        i += 1
    endwhile
    return false
EndFunction

Event Actor.OnItemUnequipped(Actor akSender, Form akBaseObject, ObjectReference akReference)
    Actor Player_Ref = Game.GetPlayer()
    if !ArrayHasForm(MannequinItems,akBaseObject)
        AddMannequinItem(akBaseObject)
        akSender.RemoveItem(akBaseObject, 1, true, Player_Ref)
        Debug.Trace("[ChangeYourOutfit]: <FromEvent> Mannequin unequipped, transferred to player inv and and added to the MannequinItems list: " + akBaseObject)
    endif
EndEvent

Function TransferFormListToMannequin(FormList equippedList, ObjectReference akMannequin)
    ; ChangeYourOutfit_EventLock.SetValueInt(0)
    Actor Player_Ref = Game.GetPlayer()
    Actor mannequinActor = akMannequin as Actor
    int count = equippedList.GetSize()
    int i = count-1
    While i >= 0
        Form item = equippedList.GetAt(i)
        RecordMannequinSlotState(mannequinActor, MannequinPrevSlotState)
        RecordPlayerSlotState(Player_Ref, PlayerPrevSlotState)
        Debug.Trace("[ChangeYourOutfit]: Current item processing: " + item + ". Should be player's ["+ i+ "]th item in the list.")
        DebugPrintFormList(equippedList, "[ChangeYourOutfit]: Player Current equippedList contents")
        
        RecordMannequinSlotState(mannequinActor, MannequinPrevSlotState)
        Bool[] PlayerMannequinDiffSlot = GetSlotDifference(PlayerPrevSlotState, MannequinPrevSlotState)
        if Player_Ref.IsEquipped(item)
            Player_Ref.UnequipItem(item)
        endif
        RecordPlayerSlotState(Player_Ref, PlayerCurrSlotState)
        
        Bool[] CurrItemSlots = GetSlotDifference(PlayerPrevSlotState, PlayerCurrSlotState)

        if ShouldReturnToPlayer(PlayerMannequinDiffSlot, CurrItemSlots)
            Player_Ref.EquipItem(item)
        else
            ; 保留在 mannequin
            Player_Ref.RemoveItem(item, 1, true, mannequinActor)
            mannequinActor.EquipItem(item)
            Debug.Trace("[ChangeYourOutfit]: Just transferred " + item + " from player to mannequin")
        endif
       
        i -= 1
    EndWhile
    ; equippedList.Revert()
    ; ChangeYourOutfit_EventLock.SetValueInt(1)
EndFunction

Function StorePlayerItems(FormList equippedList, ObjectReference akMannequin)
    Actor Player_Ref = Game.GetPlayer()
    Actor mannequinActor = akMannequin as Actor
    mannequinActor.UnequipAll()
    int count = equippedList.GetSize()
    int i = count-1
    While i >= 0
        Form item = equippedList.GetAt(i)
        Debug.Trace("[ChangeYourOutfit]: Current item processing: " + item + ". Should be player's ["+ i+ "]th item in the list.")
        Player_Ref.RemoveItem(item, 1, true, mannequinActor)
        mannequinActor.EquipItem(item)
        Debug.Trace("[ChangeYourOutfit]: Just transferred " + item + " from player to mannequin")
        i -= 1
    EndWhile
EndFunction

Function RetrieveMannqItems(ObjectReference akMannequin)
    Actor Player_Ref = Game.GetPlayer()
    Actor mannequinActor = akMannequin as Actor
    Player_Ref.UnequipAll()
    int i = 0
    While i < 64
        If (mannequinActor.WornCoversBipedSlot(i))
            mannequinActor.UnequipItemSlot(i)
        EndIf
        i += 1
    EndWhile
EndFunction

Bool[] Function GetSlotDifference(Bool[] a, Bool[] b)
    Bool[] diff = new Bool[64]
    int i = 0
    while i < 64
        if a[i] && !b[i]
            diff[i] = true
        endif
        i += 1
    endwhile
    return diff
EndFunction

Bool Function ShouldReturnToPlayer(Bool[] PlayerMannequinDiffSlot, Bool[] CurrItemUsedSlot)
    int i = 0
    while i < 64
        if CurrItemUsedSlot[i] && !PlayerMannequinDiffSlot[i]
            return false
        endif
        i += 1
    endwhile
    return true
EndFunction

Function DebugPrintFormList(FormList flist, String prefix)
    int count = flist.GetSize()
    int i = 0
    while i < count
        Form entry = flist.GetAt(i)
        Debug.Trace(prefix + " [" + i + "]: " + entry)
        i += 1
    endwhile
EndFunction



Function EquipItemList(Actor who, Form[] items)
    int i = 0
    While i < items.Length
        who.EquipItem(items[i])
        i += 1
    EndWhile
    Debug.Trace("[ChangeYourOutfit]: Player equipped items form the mannequin: " + items)
EndFunction

Function AddMannequinItem(Form akItem)
    int len = MannequinItems.Length
    Form[] temp = new Form[len + 1]
    int i = 0
    While i < len
        temp[i] = MannequinItems[i]
        i += 1
    EndWhile
    temp[len] = akItem
    MannequinItems = temp
EndFunction


