
-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local helper = require('scenario/scenariohelper')

local random = math.random

local breakTimer = 0
local fireTimer = 0
local running = false

local minSpeed = 0 --km/h
local startBeamBreaking = false
local groupsToBreak = nil
local groupBreakCounter = 1
local vehicle = nil

local function shuffle(array)
    local n, j, k = #array
    for i=1, n do
        j,k = random(n), random(n)
        array[j],array[k] = array[k],array[j]
    end
    return array
end

local function onRaceStart()
    local groupsToBreakPartOne = {
        "semi_windshield_L",
        "semi_windshield_R",
        "semi_engine_intake",
        "semi_backlight",
        "funnel_L",
        "funnel_R",
        "funnel_B",
        "chute",
        "semi_visor_R",
        "semi_visor_M",
        "semi_visor_L",
        "semi_sidestep_c_R",
        "semi_sidestep_c_L",
        "semi_sidestep_b_R",
        "semi_sidestep_b_L",
        "semi_sidestep_a_R",
        "semi_sidestep_a_L",
        "semi_radtube_R",
        "semi_radtube_L",
        "semi_radiator_R",
        "semi_radiator_L",
        "semi_mirror_R_b",
        "semi_mirror_R_a",
        "semi_mirror_L_b",
        "semi_mirror_L_a",
        "semi_horn_R_b",
        "semi_horn_L_b",
        "semi_horn_R_a",
        "semi_horn_L_a",
        "semi_exhauststack_c",
        "semi_exhauststack_b_R",
        "semi_exhauststack_a_R",
        "semi_doorlatch_R",
        "semi_doorlatch_L",
        "semi_doorhinge_R_a",
        "semi_doorhinge_L_a",
        "semi_doorglass_R",
        "semi_doorglass_L",
        "semi_bumper_F_r",
        "semi_bumper_F_l"
    }

    local groupsToBreakPartTwo = {
        "semi_fueltank_b_R",
        "semi_fueltank_b_L",
        "semi_fueltank_a_R",
        "semi_fueltank_a_L",
        "semi_hoodhinge_L",
        "semi_hoodhinge_R",
        "semi_hoodlatch_L",
        "semi_hoodlatch_R",
        "semi_daycabmount_RR",
        "semi_daycabmount_RL",
        "semi_daycabmount_FR",
        "semi_daycabmount_FL",
        "drum_F",
        "drum_R",
    }

    local groupsToBreakPartThree = {
        "semi_transmission_a",
        "leaf_RL_1",
        "leaf_RL2",
        "leaf_RR_1",
        "semi_wheel_FR",
        "semi_wheel_FL",
        "semi_steering",
        "semi_wheel_RL_1",
        "semi_wheel_RL_2",
        "semi_wheel_RR_1",
        "semi_wheel_RL_2"
    }

    math.randomseed(os.time()) --init random with a somewhat random seed
    groupsToBreakPartOne = shuffle(groupsToBreakPartOne)
    groupsToBreakPartTwo = shuffle(groupsToBreakPartTwo)
    groupsToBreakPartThree = shuffle(groupsToBreakPartThree)

    groupsToBreak = {}

    for _,g in pairs(groupsToBreakPartOne) do
        table.insert(groupsToBreak, g)
    end

    for _,g in pairs(groupsToBreakPartTwo) do
        table.insert(groupsToBreak, g)
    end

    for _,g in pairs(groupsToBreakPartThree) do
        table.insert(groupsToBreak, g)
    end

    vehicle = helper.getVehicleByName('scenario_player0')
    helper.trackVehicle('scenario_player0', 'mixer')

    breakTimer = 0
    groupBreakCounter = 1
    startBeamBreaking = false
    running = true
end

local function onRaceWaypointReached(data)
  local playerVehicleId = be:getPlayerVehicleID(0)
  if data.vehicleId == playerVehicleId then
    if data.waypointName == "speed_wp_1" then
      startBeamBreaking = true
      minSpeed = 55 --first stage minimum speed
    elseif data.waypointName == "speed_wp_11" then
      minSpeed = 70 --increase the minimum speed as there's a long semi-straight ahead
    end
  end
end

local function onRaceTick(raceTickTime)
    if not running or not vehicle then
        return true
    end

    local vehicleData = map.objects[map.objectNames['mixer']]
    if startBeamBreaking and vehicleData.vel:length() < minSpeed / 3.6 then
        breakTimer = breakTimer + raceTickTime
        if breakTimer >= 1.5 then
            helper.queueLuaCommand(vehicle, 'beamstate.breakBreakGroup("'..groupsToBreak[groupBreakCounter]..'")')
            helper.queueLuaCommand(vehicle,
                [[for k,v in pairs(v.data.beams) do
                    if v.breakGroup == "]]..groupsToBreak[groupBreakCounter]..[[" then
                        obj:addParticleByNodesRelative(v.id1, v.id2, 20, 1, 0, 20)
                        obj:addParticleByNodesRelative(v.id2, v.id1, 10, 1, 0, 20)
                        obj:addParticleByNodesRelative(v.id1, v.id2, 5, 1, 0, 20)
                        obj:addParticleByNodesRelative(v.id2, v.id1, 10, 1, 0, 1)
                        obj:addParticleByNodesRelative(v.id1, v.id2, 10, 1, 0, 1)
                        obj:addParticleByNodesRelative(v.id2, v.id1, 10, 1, 0, 1)
                    end
                end]])


            groupBreakCounter = groupBreakCounter + 1
            if groupBreakCounter > #groupsToBreak then
                startBeamBreaking = false
                scenario_scenarios.finish({failed = "scenarios.east_coast_usa.minimum_speed.fail.msg"})
            end

            breakTimer = 0
        end
    else
        breakTimer = 0
    end

    if groupBreakCounter > 40 then
        fireTimer = fireTimer + raceTickTime
        if fireTimer >= 1 then
            local igniteChance = random(100)
            if igniteChance >= 95 then
                helper.queueLuaCommand(vehicle, 'fire.igniteRandomNode()')
            end
            fireTimer = 0
        end
    end
end

M.onRaceStart = onRaceStart
M.onRaceWaypointReached = onRaceWaypointReached
M.onRaceTick = onRaceTick

return M
