-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local playerInstance = 'scenario_player0'
local running = false

local autoConnectTrailer = true
local messageDelayTimer = 0
local displayedCouplingInfo = false
local trailerAttached = false
local attemptedAutoAttach = false
local attemptTimer = 0

local function onRaceStart()
  running = true
  messageDelayTimer = 0

end

local function onCouplerAttached(objId1, objId2)
  --log('I', logTag,'onCouplerAttached called... objId1: '..objId1..' objId2: '..objId2)
  Engine.Audio.playOnce('AudioGui','event:>Vehicle>Coupler_Attach_2D')

  trailerAttached = true
  messageDelayTimer = 0
  autoConnectTrailer = false
  attemptedAutoAttach = false
end

local function onCouplerDetached(objId1, objId2)
  --log('I', logTag,'onCouplerDetached called... objId1: '..objId1..' objId2: '..objId2)
  Engine.Audio.playOnce('AudioGui','event:>Vehicle>Coupler_Detach_2D')
  trailerAttached = false
  messageDelayTimer = 1
end

local function onPreRender(dt) -- Shows the start messages to couple the trailer
  if not running then
    return
  end

  local playerVehicle = scenetree.findObject(playerInstance)
  local trailer = scenetree.findObject('trailer')

  if playerVehicle and trailer then
    messageDelayTimer = messageDelayTimer + dt
    if autoConnectTrailer and messageDelayTimer >= 1 then
      ui_message("scenarios.utah.chapter_2.chapter_2_4_delivery.drive_in_reverse.msg", 1, 'CHAPTER_2_4_DELIVERY', nil)
      messageDelayTimer = messageDelayTimer - 1
    elseif not autoConnectTrailer and not displayedCouplingInfo and messageDelayTimer >= 1 then
      ui_message("scenarios.utah.chapter_2.chapter_2_4_delivery.trailer_controls.msg", 10, 'CHAPTER_2_4_DELIVERY', nil)
      messageDelayTimer = messageDelayTimer - 1
      displayedCouplingInfo = true
    elseif not trailerAttached and not autoConnectTrailer and messageDelayTimer >= 1 then
      ui_message("scenarios.utah.chapter_2.chapter_2_4_delivery.attach_trailer.msg", 1, 'CHAPTER_2_4_DELIVERY', nil)
      messageDelayTimer = messageDelayTimer - 1
    end

  local trailerPos = trailer:getPosition()
    local distanceToTrailer = (playerVehicle:getPosition() - trailerPos):len()
    -- log('I', logTag, 'distanceToTrailer: '..distanceToTrailer)
    if autoConnectTrailer and not attemptedAutoAttach and not trailerAttached and distanceToTrailer <= 15 then
      -- log('D', logTag,'Auto attaching couplters...')
      playerVehicle:queueLuaCommand('beamstate.toggleCouplers()')
      attemptedAutoAttach = true
      attemptTimer = 0
    end

    if attemptedAutoAttach then
      attemptTimer = attemptTimer + dt
      if not trailerAttached and attemptTimer >= 0.25 and distanceToTrailer >= 20 then
        --log('D', logTag,'Auto deattaching couplters...')
        playerVehicle:queueLuaCommand('beamstate.toggleCouplers()')
        attemptedAutoAttach = false
      end
    end

  end
end

M.onPreRender = onPreRender
M.onRaceStart = onRaceStart
M.onCouplerAttached = onCouplerAttached
M.onCouplerDetached = onCouplerDetached
M.onPreRender = onPreRender

return M
