--Created by Inn0centJok3r
--DO NOT USE WITHOUT PERMISSION! ASK ME AT https://www.beamng.com/members/inn0centjok3r.318168/
local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local speed = 0
local speedFactor = 1
local lowDragModeSpeed = 250

local function updateGFX(dt)
	speed = electrics.values.airspeed * 3.6
	if speed >= lowDragModeSpeed and electrics.values.brake <= 0.2 then
		electrics.values.deoWingState = -1
	elseif speed >= 20 and electrics.values.brake > 0.2 then
		if speed < lowDragModeSpeed then
			speedFactor = 1
		else
			speedFactor = clamp(1 - (speed - lowDragModeSpeed) / 50, -1, 1)
		end
		electrics.values.deoWingState = 1 * electrics.values.brake * speedFactor
	else
		electrics.values.deoWingState = 0
	end
end

local function init(jbeamData)
	speed = 0
	electrics.values.deoWingState = 0
	speedFactor = 1
	lowDragModeSpeed = jbeamData.lowDragSettingSpeed or 250
end

local function reset()
	speed = 0
	electrics.values.deoWingState = 0
	speedFactor = 1
end

-- public interface
M.reset   = reset
M.init    = init
M.updateGFX = updateGFX
return M