--Created by Inn0centJok3r
--DO NOT USE WITHOUT PERMISSION! ASK ME AT https://www.beamng.com/members/inn0centjok3r.318168/
local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local gaugesScreenName = nil
local htmlPath = nil

local updateTimer = 0
local updateFPS = 30
local invFPS = 1 / updateFPS
local engineType = "empty"

local function updateGFX(dt)
  updateTimer = updateTimer + dt

  if updateTimer > invFPS then

    local data = {}

	data.engineType = engineType
	--print(engineType)
    data.topscreenunit = settings.getValue("uiUnitLength") or "metric"

	if data.topscreenunit ~= "metric" or data.topscreenunit == nil then
		data.dategauge = os.date("%m") .. "." .. os.date("%d") .. "." .. os.date("%Y")
	else
		data.dategauge = os.date("%d") .. "." .. os.date("%m") .. "." .. os.date("%Y") -- the correct way to make a date.  https://www.gammon.com.au/scripts/doc.php?lua=os.date useful page for date function
	end

    data.fuelgauge = math.ceil(electrics.values["fuel"] * 100)

	data.speedometergauge =  electrics.values["wheelspeed"] * 3.6
	data.ignitionLevel = electrics.values["ignitionLevel"]
		
	if electrics.values["gear"] == 0 then
		data.geargauge =  "N"
	elseif electrics.values["gear"] == -1 then
		data.geargauge =  "R"
	else
		data.geargauge =  electrics.values["gear"]
	end

    --dump(data)
    htmlTexture.call(gaugesScreenName, "update", data)
    updateTimer = 0
  end
end

local function init(jbeamData)
    device = powertrain.getDevice("mainEngine") or powertrain.getDevice("frontMotor")
	if device ~= nil then
		engineType = device.type
	end
	gaugesScreenName = jbeamData.materialName
	htmlPath = jbeamData.htmlPath
	local width = jbeamData.textureWidth or 512
	local height = jbeamData.textureHeight or 256

    htmlTexture.create(gaugesScreenName, htmlPath, width, height, updateFPS, "automatic")
    htmlTexture.call(gaugesScreenName, "init")
end

M.init = init
M.updateGFX = updateGFX

return M
