--Created by Inn0centJok3r
--DO NOT USE WITHOUT PERMISSION! ASK ME AT https://www.beamng.com/members/inn0centjok3r.318168/
--Modified 2-step lua code
local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local engine = nil

local rpmToAV = 0.104719755
local need_to_reset = false
local tempRevLimiterAV = 0
local tempRevLimiterRPM = 0

local function updateGFX(dt)
  if electrics.values['gear'] == "P" then
    engine:setTempRevLimiter(tempRevLimiterAV)
	need_to_reset = true
  elseif need_to_reset == true and electrics.values['gear'] ~= "P" then
      engine:resetTempRevLimiter()
	  need_to_reset = false
  end
end

local function reset()
  if engine then
    engine:resetTempRevLimiter()
	need_to_reset = false
  end
end

local function init(jbeamData)
  local engineName = jbeamData.engineName or "mainEngine"
  engine = powertrain.getDevice(engineName)
  M.updateGFX = engine and updateGFX or nop

  tempRevLimiterRPM = (jbeamData.rpmLimit or 2000)
  tempRevLimiterAV = tempRevLimiterRPM * rpmToAV

end

M.init = init
M.reset = reset
M.updateGFX = nop

return M
