--Created by Inn0centJok3r
--DO NOT USE WITHOUT PERMISSION! ASK ME AT https://www.beamng.com/members/inn0centjok3r.318168/
local M = {}
M.type = "auxiliary"
M.relevantDevice = nil
--checkengineCustom logic can be found in dangertomanufold.lua . It's for the cool little airplane gauge light, so that it doesnt overlap with the check engine one.

local timerTurnOff = 0

local inAir1 = false
local inAir2 = false
local inAir3 = false
local inAir4 = false
local device = nil
local timerLight = 0
local timerWarning = 0
local invertAilerons = false

local function init(jbeamData)
	electrics.values.controlaile = 0
    timerTurnOff = 0
    inAir1 = false
    inAir2 = false
    inAir3 = false
    inAir4 = false
	electrics.values["plane_beacon"] = 0
	timerLight = 0
	electrics.values["flightMode"] = 0
	electrics.values["plane_navlight"] = 0
	timerWarning = 6
	
	invertAilerons = jbeamData.invertAilerons or false

end

local function updateGFX(dt)

if electrics.values["engineRunning"] == 1 or electrics.values["flightMode"] == 1 then			--timing for beacon light
	timerLight = timerLight + dt
	electrics.values["plane_navlight"] = 1

		if timerLight >= 1 and electrics.values["plane_beacon"] == 0 then
			electrics.values["plane_beacon"] = 1
			timerLight = 0
		elseif timerLight >= 0.2 and electrics.values["plane_beacon"] == 1 then
			electrics.values["plane_beacon"] = 0
			timerLight = 0
		end
else
	electrics.values["plane_beacon"] = 0
	timerLight = 0
	electrics.values["plane_navlight"] = 0
end

if electrics.values.airspeed > 100 then	--wings get unstable above these speeds
	timerWarning = timerWarning + dt
	if timerWarning >= 6 then
		guihooks.message("WARNING! Danger to wings! Slow down (Max speed:380km/h)", 6, "vehicle.vertexPlane.danger", "warning") 
		timerWarning = 0
	end
else
	timerWarning = 6
end 

if electrics.values.steering == nil then return end

	if invertAilerons == true then 
	electrics.values.controlaile = - electrics.values.steering / 140	--Steering controls ailerons / roll. Easier controls
	else
	electrics.values.controlaile = electrics.values.steering / 140	--Steering controls ailerons / roll. Easier controls
	end
	
	device = powertrain.getDevice("mainEngine")
	if device == nil then return end

		if electrics.values.airspeed > 34 and electrics.values.wheelspeed > 0.1 then --To automatically turn off the engine in air
			inAir1 = false
			inAir2 = false
			inAir3 = false
			inAir4 = false

			for wi, wd in pairs(wheels.wheels) do
				if wd.lastSlip == 0 and not inAir1 and not inAir2 and not inAir3 and not inAir4 then
					inAir1 = true
				elseif wd.lastSlip == 0 and inAir1 and not inAir2 and not inAir3 and not inAir4 then
					inAir2 = true
				elseif wd.lastSlip == 0 and inAir1 and inAir2 and not inAir3 and not inAir4 then
					inAir3 = true 
				elseif wd.lastSlip == 0 and inAir1 and inAir2 and inAir3 and not inAir4 then
					inAir4 = true
					else
						inAir1 = false
						inAir2 = false
						inAir3 = false
						inAir4 = false
					end
				end
				if inAir1 and inAir2 and inAir3 and inAir4 then
					timerTurnOff = timerTurnOff + dt
					if timerTurnOff >= 4 then
						if device.isDisabled == false then
							guihooks.message("Engine automatically disabled (In Flight)", 6, "vehicle.vertexPlane.flying", "flight_takeoff") 
						end
						  device.outputTorqueState = 0
						  device.isDisabled = true
						  device.starterDisabled = true
						timerTurnOff = 0
						electrics.values["flightMode"] = 1
					end
					else
						  device.outputTorqueState = 1
						  device.isDisabled = false
						  device.starterDisabled = false
						timerTurnOff = 0
						electrics.values["flightMode"] = 0
				end
				
			end

end

local function reset()
	electrics.values.controlaile = 0
    timerTurnOff = 0
	inAir1 = false
	inAir2 = false
	inAir3 = false
	inAir4 = false
	electrics.values["plane_beacon"] = 0
	timerLight = 0
	electrics.values["plane_navlight"] = 0
	electrics.values["flightMode"] = 0
	timerWarning = 6
	
	--invertAilerons = jbeamData.invertAilerons or false
end

-- public interface
M.reset   = reset
M.init    = init
M.updateGFX = updateGFX
return M