-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local timer = 0
local registeredVehicles = {}

M.h = 0
M.v = 1
M.off = false

local function setOn(objId, on)
    registeredVehicles[objId].off = not on
end

local function setH(objId, h)
    registeredVehicles[objId].h = h
end

local function setV(objId, v)
    registeredVehicles[objId].v = v
end

local function updateColor(objId)
    if not registeredVehicles[objId] then return end
    local r,g,b = HSVtoRGB(registeredVehicles[objId].h, 1, registeredVehicles[objId].off and 0 or registeredVehicles[objId].v)
    core_vehicle_manager.liveUpdateVehicleColors(objId, nil, 2, {baseColor={r, g, b, 1}})
end

local function sendColor(objId)
    registeredVehicles[objId] = registeredVehicles[objId] or {}

    local veh = scenetree.findObject(objId)
    local color = veh.colorPalette0:toTable()
    local h, _, v = RGBtoHSV(color[1],color[2],color[3])
    h = h>0.9 and h-1 or h

    if not registeredVehicles[objId].off then
        setH(objId, h)
        setV(objId, v)
    end

    -- unfortunately the vlua v.data.paints gave me the wrong data
    -- enjoy this ig
    veh:queueLuaCommand([[
        local controller = screenManager;
        controller.setSetting("settings.ambient_color", ]]..registeredVehicles[objId].h..[[);
        controller.setSetting("settings.ambient_brightness", ]]..registeredVehicles[objId].v..[[);
        controller.setSetting("settings.ambient_color_original", ]]..registeredVehicles[objId].h..[[);
        controller.setSetting("settings.ambient_brightness_original", ]]..registeredVehicles[objId].v..[[);

        controller.execFunc("s.ambient_color = ]]..registeredVehicles[objId].h..[[");
        controller.execFunc("s.ambient_brightness = ]]..registeredVehicles[objId].v..[[");

        screenManager.sendUpdateCmd("ambient");
    ]])

    updateColor(objId)
end

local function onDespawnObject(id, reloading)
    --if reloading and registeredVehicles[id] and be:getPlayerVehicleID(0) == id then
    --    local r,g,b = HSVtoRGB(M.h, 1, M.v)
    --    core_vehicle_manager.liveUpdateVehicleColors(id, nil, 2, {baseColor={r, g, b, 1}})
    --end
end

local function onVehicleDestroyed(vid)
    registeredVehicles[vid] = nil
    if not next(registeredVehicles) then
        extensions.unload("zeit_vestangnewScreenInteract")
    end
end

M.setOn = setOn
M.setV = setV
M.setH = setH
M.onDespawnObject = onDespawnObject
M.onVehicleDestroyed = onVehicleDestroyed
M.sendColor = sendColor
M.updateColor = updateColor

--[[
local function onUpdate(dtReal, dtSim, dtRaw)
    if not id then return end

    timer = (timer+dtSim*0.5)%25
    local color = rainbowColor(timer, 25, 1)
    core_vehicle_manager.liveUpdateVehicleColors(id, nil, 2, {baseColor=color})
end

local function onVehicleSwitched(_, newId)
    local newObj = be:getObjectByID(newId)
    if newObj and newObj.jbeam == "vestangnew" then
        id = newId
    end
end

local function onExtensionLoaded()
    onVehicleSwitched(_, be:getPlayerVehicleID(0) or 0)
end

M.onUpdate = onUpdate
M.onVehicleSwitched = onVehicleSwitched
M.onExtensionLoaded = onExtensionLoaded
]]

return M