-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local vehicle = nil
local registeredVehicles = {}

local function renderCam(target, pos, rot)
    if not vehicle then return end

    vehicle:renderCameraToMaterial(target,
        pos,
        QuatF(rot.x, rot.y, rot.z, rot.w),
        Point2I(512, 256),
        70,
        Point2F(0.1, 100)
    )
end

local function setFocusCar(id)
    vehicle = scenetree.findObject(id)
    registeredVehicles[id] = true
end

local function onVehicleDestroyed(vid)
    if vehicle and vehicle:getId() == vid then
        vehicle = nil
    end
    registeredVehicles[vid] = nil
    if not next(registeredVehicles) then
        extensions.unload("zeit_vestangnewReverseCam")
    end
end

M.renderCam = renderCam
M.setFocusCar = setFocusCar
M.onVehicleDestroyed = onVehicleDestroyed

return M