local M = {}
local volume, pitch = 11, 1
local camNode = 0
local timer = 0
local lastDoorState = false
local doorChimePlaying = false
local nextDoorChimeTime = 0
local chimeDuration = 2

local function inside()
    local cam = obj:getCameraPosition()
    local seat = obj:getPosition() + obj:getNodePosition(camNode)
    return cam and seat and cam:distance(seat) <= 0.6
end

local function update(dt)
    local anyDoorOpen = (electrics.values['doorFLCoupler_notAttached'] == 1 or 
                         electrics.values['doorFRCoupler_notAttached'] == 1 or 
                         electrics.values['doorRLCoupler_notAttached'] == 1 or 
                         electrics.values['doorRRCoupler_notAttached'] == 1 or
						 electrics.values['trunkCoupler_notAttached'] == 1 or 
						 electrics.values['hoodLatchCoupler_notAttached'] == 1)

    local ignitionOn = (electrics.values['ignitionLevel'] > 0)
    local doorChimeActive = ignitionOn and anyDoorOpen
    
    if inside() then
        if doorChimeActive then
            if not doorChimePlaying then
                obj:playSFXOnce("chimeOn.wav", camNode, volume, pitch)
                doorChimePlaying = true
                nextDoorChimeTime = timer + chimeDuration
            elseif timer >= nextDoorChimeTime then
                obj:playSFXOnce("chimeOn.wav", camNode, volume, pitch)
                nextDoorChimeTime = timer + chimeDuration
            end
        end
    else
        doorChimePlaying = false
    end
    timer = timer + dt
    lastDoorState = doorChimeActive
end

local function init()
    camNode = beamstate.nodeNameMap["driver"] or 0
    obj:createSFXSource("vehicles/vestangnew/art/sound/doorchime.wav", "Audio2D", "chimeOn.wav", -1)
    obj:createSFXSource("vehicles/vestangnew/art/sound/doorchime.wav", "Audio2D", "chimeOff.wav", -1)
end

M.onInit = init
M.updateGFX = update
return M