-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local registeredVehicles = {}
local vehicle = nil
local lastTargetPos = vec3()
local naviSearch
local pois
local facilities

local mode = 0

local function onUpdate(dt)
    if not vehicle then return end

    if core_groundMarkers then
        local targetPos = core_groundMarkers.getTargetPos()
        if lastTargetPos and not targetPos then
            if mode == 0 then
                vehicle:queueLuaCommand([[
                    controller.getControllerSafe("gauges/customModules/moreNavigationData").setEndPoint(nil)
                ]])
            else
                vehicle:queueLuaCommand([[
                    screenManager.setEndPoint(nil)
                ]])
            end
        elseif targetPos ~= lastTargetPos then
            if mode == 0 then
                vehicle:queueLuaCommand([[
                    controller.getControllerSafe("gauges/customModules/moreNavigationData").setEndPoint(]]..tostring(targetPos)..[[)
                ]])
            else
                vehicle:queueLuaCommand([[
                    screenManager.setEndPoint(]]..tostring(targetPos)..[[)
                ]])
            end
        end
        lastTargetPos = targetPos
    end
end

local function navigateTo(pos)
    core_groundMarkers.setFocus(pos)
end

local function getAvgOfAllVec3(arr)
    local i = 0
    local tempVec = vec3()
    for _,v in ipairs(arr) do
        i = i + 1
        tempVec.x = tempVec.x+v[1]
        tempVec.y = tempVec.y+v[2]
        tempVec.z = tempVec.z+v[3]
    end
    tempVec.x = tempVec.x / i
    tempVec.y = tempVec.y / i
    tempVec.z = tempVec.z / i
    return tempVec
end

local function getNavDestinationsJob(job)
    local stopTimer = hptimer()
    -- this shit takes some time so...
    pois = deepcopy(gameplay_rawPois and gameplay_rawPois.getRawPoiListByLevel(getCurrentLevelIdentifier()) or {})
    job.yield()
    facilities = deepcopy(freeroam_facilities.getFacilities(getCurrentLevelIdentifier()) or {})
    job.yield()

    local searchList = arrayConcat(facilities.deliveryProviders, facilities.dealerships)

    -- we only have to *search*, not load the entire thing - that would be a waste of processing power
    local zoneFile
    local dir = path.split(getMissionFilename())
    if dir then
        zoneFile = dir.."city.sites.json"
        if zoneFile and FS:fileExists(zoneFile) then
            zoneFile = jsonReadFile(zoneFile) or {}
            local zones = zoneFile.zones
            if zones then
                searchList = arrayConcat(searchList, zones)
            end
        end
    end

    pois = arrayConcat(pois, searchList)

    local search = naviSearch
    local yields = 0
    local results = {}
    job.yield()

    local priorityMatch = {
        name = 100,
        translationId = 100,
        energyType = 80,
        tags = 60,
        description = 50,
        energyTypes = 50,
        id = 30,
        type = 10,
        facility = 0,
        data = 0,
        missionName = 60,
        missionType = 40,
        missionDescription = 10,
    }

    local function searchTbl(tbl, tblKey)
        local foundScore = 0
        for k,v in pairs(tbl) do
            if priorityMatch[k] then
                if type(v) == "string" then
                    if translateLanguage(v, v, true):gsub("[%c%p%s%z]", ""):lower():match(search) then
                        if type(k) == "number" and tblKey then
                            foundScore = foundScore+priorityMatch[tblKey]
                        else
                            foundScore = foundScore+priorityMatch[k]
                        end
                    end
                elseif type(v) == "table" and not tableIsArraySlow(v) then
                    foundScore = foundScore+searchTbl(v, k)
                end
            end
            if stopTimer:stop() > 0.15 then
                job.yield()
                yields = yields + 1
                stopTimer:reset()
            end
        end
        return foundScore
    end

    -- deepsearch
    local playerPos = vehicle and vehicle:getPosition() or false
    local nameFound = {}

    for _,poi in ipairs(pois) do
        local origPoi = poi
        poi = poi.data or poi
        if poi.type == "mission" then
            local file = jsonReadFile("/gameplay/missions/"..poi.missionId.."/info.json")
            if file then
                poi.missionName = translateLanguage(file.name, file.name, true)
                poi.missionType = file.missionType
                poi.missionDescription = translateLanguage(file.description, file.description, true)
                poi.pos = vec3(file.startTrigger.pos[1],file.startTrigger.pos[2],file.startTrigger.pos[3])
            end
        end

        local foundScore = searchTbl(poi)
        if foundScore >= 10 then
            local poiName
            local pos

            if poi.facility then
                poiName = translateLanguage(poi.facility.name,poi.facility.name,true)
                pos = origPoi.markerInfo.bigmapMarker.pos
            elseif poi.type == "spawnPoint" then
                pos = scenetree.findObject(poi.objectname):getPosition()
                poiName = translateLanguage(poi.translationId,poi.translationId,true)
            elseif poi.type == "mission" then
                pos = poi.pos
                poiName = poi.missionName
            else
                if poi.name then
                    if poi.type then
                        poiName = translateLanguage(poi.name,poi.name,true)
                        local zone = gameplay_sites_sitesManager.loadSites(poi.sitesFile)
                        local parkingSpotName = poi.parkingSpotNames[1] or poi.dropOffSpotNames[1] or poi.pickUpSpotNames[1]
                        pos = zone.parkingSpots.byName[parkingSpotName].pos
                    else
                        poiName = translateLanguage(poi.name,poi.name,true)

                        if not nameFound[poiName] then
                            pos = getAvgOfAllVec3(poi.vertices)
                            local closestPoint = map.findClosestRoad(pos)
                            if closestPoint then
                                pos = map.getMap().nodes[closestPoint].pos
                            end
                        end
                    end
                end
            end

            if pos then
                playerPos = playerPos or pos
                local distance = playerPos:distance(pos)
                foundScore = foundScore + math.max(1000-distance, 0)

                if poiName and not nameFound[poiName] then
                    nameFound[poiName] = true
                    results[#results+1] = {poiName, foundScore, distance, pos}
                end
                job.yield()
            end
        end
        if #results == 30 then
            break
        end
    end

    table.sort(results, function(a,b)
        return b[2] < a[2]
    end)

    if vehicle then
        if mode == 0 then
            vehicle:queueLuaCommand([[
                controller.getControllerSafe("gauges/customModules/moreNavigationData").destinationCallback("]]..lpack.encode(results)..[[")
            ]])
        else
            vehicle:queueLuaCommand([[
                screenManager.destinationCallback("]]..lpack.encode(results)..[[")
            ]])
        end
    end
end

local function getNavDestinations(search)
    --if not vehicle then return end
    naviSearch = search:gsub("[%c%p%s%z]", ""):lower()
    core_jobsystem.create(getNavDestinationsJob)
end

local function setUseMode(newmode)
    mode = newmode
end

local function setFocusCar(id)
    vehicle = scenetree.findObject(id)
    registeredVehicles[id] = true
end

local function onVehicleDestroyed(vid)
    if vehicle and vehicle:getId() == vid then
        vehicle = nil
    end
    registeredVehicles[vid] = nil
    if not next(registeredVehicles) then
        extensions.unload("zeit_vestangnewMoreNavi")
    end
end

local function onExtensionLoaded()
end

M.onUpdate = onUpdate
M.onExtensionLoaded = onExtensionLoaded
M.getNavDestinations = getNavDestinations
M.setFocusCar = setFocusCar
M.navigateTo = navigateTo
M.setUseMode = setUseMode
M.onVehicleDestroyed = onVehicleDestroyed

return M