-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local autoHeadlightsEnabled = false
local autoHeadlightsData = {}

local lastValue = -1

local function zeitADASUpdate(dt, mailboxData)
    if not autoHeadlightsEnabled then return end

    local ownVeh = mailboxData[objectId] or {}
    mailboxData[objectId] = nil
    if not next(ownVeh) or not ownVeh.ambColor then return end

    -- Определяем, достаточно ли темно
    local lightBaseVal = ownVeh.ambColor < 0.7 and 1 or 0

    -- Устанавливаем свет в зависимости от времени суток
    if lightBaseVal ~= lastValue then
        electrics.setLightsState(lightBaseVal)
        lastValue = lightBaseVal
    end
end

local function setComponentActive(active)
    autoHeadlightsEnabled = active
end

local function init(jbeamData)
    autoHeadlightsEnabled = next(jbeamData) ~= nil
    autoHeadlightsData = jbeamData
end

M.init = init
M.setComponentActive = setComponentActive
M.zeitADASUpdate = zeitADASUpdate

return M