-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local htmlTexture = require("htmlTexture")

local updateTimer = 0
local updateFPS = 60


local vehicleID = obj:getID()



local alreadyParked = 1;
local alreadyParkedMajor = 1;
local alreadyHigh = 0;


local function onInit()
    
	htmlTexture.create("@sat_gauges_screen", "local://local/vehicles/common/vw_screens/gauges_screen/gauges_screen.html", 544, 128, 30, 'automatic')
	htmlTexture.create("@sat_gauges_screen_d", "local://local/vehicles/common/vw_screens/gauges_screen/gauges_screen_d.html", 1024, 256, 30, 'automatic')
	htmlTexture.create("@sat_gauges_screencenter", "local://local/vehicles/sat/gauges_screen/gauges_screen_center.html", 512, 512, 30,'automatic')

	
	--Init function for dashboard
    htmlTexture.call("@sat_gauges_screen", "init")
	htmlTexture.call("@sat_gauges_screen_d", "init")
	htmlTexture.call("@sat_gauges_screencenter", "init")

end

local function onReset()
    onInit()
end



local function updateGFX(dt)


	--Dashboard
	local wSpeed = math.floor( electrics.values.wheelspeed * 3.6 or 0)  
	local nspeed = electrics.values.vwDigitalSpeedo
	local rpm = math.floor( electrics.values.rpm + 0.5 or 0)
	local gear = electrics.values.gear
	local parked = math.floor(electrics.values.parkingbrake + 0.5 or 0)
	local high = math.floor(electrics.values.highbeam + 0.5 or 0)
	local indicatorL = electrics.values.signal_L
	local indicatorR = electrics.values.signal_R
	local tcs = electrics.values.tcs
	local esc = electrics.values.esc
	local igni = electrics.values.ignition 
	local temp = math.floor(obj:getEnvTemperature() - 273.15) 
	local time = os.date("%H") .. ":" .. os.date("%M")

	
	
	--Checking if gear == null to prevent any issues

	htmlTexture.call("@sat_gauges_screen", "updateGear", gear)
	htmlTexture.call("@sat_gauges_screen_d", "updateGear", gear)
	htmlTexture.call("@sat_gauges_screencenter", "updateGear", gear)

	
	htmlTexture.call("@sat_gauges_screen", "updateSpeed", wSpeed)
	htmlTexture.call("@sat_gauges_screen_d", "updateSpeed", wSpeed)
	htmlTexture.call("@sat_gauges_screencenter", "updateSpeed", wSpeed)
	
	htmlTexture.call("@sat_gauges_screen", "updateSpeedN", nspeed)
	htmlTexture.call("@sat_gauges_screen_d", "updateSpeedN", nspeed)
	
	htmlTexture.call("@sat_gauges_screen", "updateRPM", rpm)
	htmlTexture.call("@sat_gauges_screen_d", "updateRPM", rpm)
	
	htmlTexture.call("@sat_gauges_screen", "updateTcs", {tcs=tcs,esc=esc})
	htmlTexture.call("@sat_gauges_screen_d", "updateTcs", {tcs=tcs,esc=esc})
	
	htmlTexture.call("@sat_gauges_screen", "updateTemp", {temp})
	htmlTexture.call("@sat_gauges_screen_d", "updateTemp", {temp})
	htmlTexture.call("@sat_gauges_screencenter", "updateTemp", {temp})
	
	htmlTexture.call("@sat_gauges_screen", "updateTime", {time})
	htmlTexture.call("@sat_gauges_screen_d", "updateTime", {time})
	htmlTexture.call("@sat_gauges_screencenter", "updateTime", {time})

	
	if (high < 0.5) then
		--headLights are turned off
		if (alreadyHigh == 1) then
			--Headlights were turned off this cycle
			
			htmlTexture.call("@sat_gauges_screen", "updateHeadLightsOff")
			htmlTexture.call("@sat_gauges_screen_d", "updateHeadLightsOff")
			alreadyHigh = 0
		end
	else
		--headlights are turned on
		if (alreadyHigh == 0) then
			--Headlights were turned on this cycle
			htmlTexture.call("@sat_gauges_screen", "updateHeadLightsOn")
			htmlTexture.call("@sat_gauges_screen_d", "updateHeadLightsOn")
			alreadyHigh = 1
		end
	end
	
	if (parked < 0.5) then
		--If parking brake is off
		if (alreadyParked == 1) then
			--parking brake was turned off this cycle therefore disable warning
			htmlTexture.call("@sat_gauges_screen", "updateParkingBrakeOff")
			htmlTexture.call("@sat_gauges_screen_d", "updateParkingBrakeOff")
			alreadyParked = 0
		end
	else
		--If parking brake is on
		
		--If RPM goes over 1000 while parking brake is on display major warning
		if (rpm > 1000) then
			htmlTexture.call("@sat_gauges_screen", "updateParkingBrakeMajor")
			htmlTexture.call("@sat_gauges_screen_d", "updateParkingBrakeMajor")
		end
		
		if (rpm < 1000) then
			htmlTexture.call("@sat_gauges_screen", "updateParkingBrakeMajorOff")
			htmlTexture.call("@sat_gauges_screen_d", "updateParkingBrakeMajorOff")
		end
		
		if (alreadyParked == 0) then
			--Parking brake was turned on this cycle therefore enable warning
			htmlTexture.call("@sat_gauges_screen", "updateParkingBrakeOn")
			htmlTexture.call("@sat_gauges_screen_d", "updateParkingBrakeOn")
			alreadyParked = 1
		end	

	
	end
	
	
	
	
end



-- public interface
M.onInit    = onInit
M.onReset   = onReset
M.updateGFX = updateGFX

return M
