-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 0
local textureHeight = 0
local textureFPS = 0
local updateTimer = 0
local updateFPS = 15
local invFPS = 1 / updateFPS
local gpsData = {x = 0, y = 0, rotation = 0, zoom = 1}
local daxx = {}
local engineRunningCache = 1
local temp = math.floor(obj:getEnvTemperature() - 273.15) 

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS and playerInfo.anyPlayerSeated then
    local pos = obj:getPosition()
    local rotation = math.deg(obj:getDirection()) + 180
    local speed = electrics.values.airspeed * 3.6
    local zoom = math.min(150 + speed * 1.5, 250)

    gpsData.x = pos.x
    gpsData.y = pos.y
    gpsData.rotation = rotation
    gpsData.zoom = zoom

    daxx.temp = obj:getEnvTemperature() - 273.15

    daxx.time = os.date("%H") .. ":" .. os.date("%M")


    htmlTexture.call(screenMaterialName, "map.updateData", gpsData)
    htmlTexture.call(screenMaterialName, "updateStats", daxx)
	htmlTexture.call(screenMaterialName, "updateTemp", temp)

	if electrics.values["engineRunning"] ~= engineRunningCache then
		daxx.engineRunning = electrics.values["engineRunning"]
		htmlTexture.call(screenMaterialName, "updateBootscreen", daxx)
		engineRunningCache = electrics.values["engineRunning"]
	end
    updateTimer = 0
  end
end

local function init(jbeamData)
  screenMaterialName = jbeamData.screenMaterialName or "@tcross_gps_screen"
  htmlFilePath = jbeamData.htmlFilePath or "local://local/vehicles/common/vw_screens/VW_navi_screen.html"
  textureWidth = jbeamData.textureWidth or 512
  textureHeight = jbeamData.textureHeight or 256
  textureFPS = jbeamData.textureFPS or 30

  htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
  obj:queueGameEngineLua(string.format("extensions.ui_uinavi.requestVehicleDashboardMap(%q)", screenMaterialName))
end

M.init = init
M.reset = nop -- this is needed so that we do not call init when reseting
M.updateGFX = updateGFX

return M
