local M = {}

-- Set the light activation threshold (0.2 = 20% ambient light)
local lightThreshold = 0.2

-- Set the light state to off by default
local lightState = false

-- Register a function that will be called every time the game updates
-- The function checks the ambient light level and turns the lights on or off as necessary
local function checkLightLevel(dt)
    -- Get the current ambient light level
    local ambientLight = obj:getField("environment.brightness")

    -- Check if the light level is below the threshold and the vehicle is moving
    if ambientLight < lightThreshold then
        -- Check if the lights are already on
        if not lightState then
            -- Turn the lights on
            electrics.values.lowhighbeam = 1
            lightState = true
        end
    else
        -- Check if the lights are already off
        if lightState then
            -- Turn the lights off
            electrics.values.lowhighbeam = 0
            lightState = false
        end
    end
end

-- Register the checkLightLevel function to be called every frame
-- This will make sure that the light level is checked continuously while the game is running

M.onUpdate = checkLightLevel

return M