local M = {}

local function updateGFX(dt)
    local speed = electrics.values.wheelspeed * 3.6  -- تحويل السرعة من m/s إلى km/h
    local rpm = electrics.values.rpm or 0

    local transitionSpeed = 160         -- سرعة بداية التخفيف
    local rpmThreshold = 4100           -- الحد اللي يبدأ بعده تخفيف الـ RPM
    local slowdownFactor = 0.5          -- نسبة التخفيف

    local adjustedSpeed
    local adjustedRPM

    -- تخفيف السرعة بعد 160 كم/س
    if speed <= transitionSpeed then
        adjustedSpeed = speed
    else
        local excess = speed - transitionSpeed
        adjustedSpeed = transitionSpeed + (excess * slowdownFactor)
    end

    -- تخفيف الـ RPM بعد 4000 دورة
    if rpm <= rpmThreshold then
        adjustedRPM = rpm
    else
        local excess = rpm - rpmThreshold
        adjustedRPM = rpmThreshold + (excess * slowdownFactor)
    end

    -- تحديث القيم للعدادات
    electrics.values.gauge1 = adjustedSpeed
    electrics.values.gaugeRPM = adjustedRPM  -- تأكد إنك تستخدم هذا الاسم في ملفات الطبلون
end

M.updateGFX = updateGFX

return M
