local M = {}

local flashInterval = 0.5  -- الفاصل الزمني للتبديل بين التشغيل والانطفاء (0.5 ثانية)

-- متغيرات الوميض للمبة بين 120-160 كم/س
local lamp120_160Timer = 0
local lamp120_160Flashing = false

-- متغيرات الوميض للمبة فوق 160 كم/س
local lamp160PlusTimer = 0
local lamp160PlusFlashing = false

local function updateGFX(dt)
    local currentSpeed = electrics.values.wheelspeed * 3.6 -- تحويل السرعة إلى كم/س

    -------------------------------------------------------
    -- لمبة تومض (فلاش) بين 120-160 كم/س (Lamp_120KM2)
    if currentSpeed >= 120 and currentSpeed < 160 then
        lamp120_160Timer = lamp120_160Timer + dt
        if lamp120_160Timer >= flashInterval then
            lamp120_160Flashing = not lamp120_160Flashing
            lamp120_160Timer = 0  -- إعادة تعيين المؤقت
        end
        electrics.values.Lamp_120KM2 = lamp120_160Flashing and 1 or 0
    else
        electrics.values.Lamp_120KM2 = 0
        lamp120_160Timer = 0
        lamp120_160Flashing = false
    end

    -------------------------------------------------------
    -- لمبة تومض (فلاش) فوق 160 كم/س (Lamp_160KM)
    if currentSpeed >= 160 then
        lamp160PlusTimer = lamp160PlusTimer + dt
        if lamp160PlusTimer >= flashInterval then
            lamp160PlusFlashing = not lamp160PlusFlashing
            lamp160PlusTimer = 0  -- إعادة تعيين المؤقت
        end
        electrics.values.Lamp_160KM = lamp160PlusFlashing and 1 or 0
    else
        electrics.values.Lamp_160KM = 0
        lamp160PlusTimer = 0
        lamp160PlusFlashing = false
    end

    -------------------------------------------------------
    -- لمبة ثابتة لا تومض (مثلاً Lamp_120KM) تعمل في نفس نطاق 120-160 كم/س
    if currentSpeed >= 120 and currentSpeed < 160 then
        electrics.values.Lamp_120KM = 1
    else
        electrics.values.Lamp_120KM = 0
    end
end

M.updateGFX = updateGFX

return M
