-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local gear_A = 0
local gearIndex = 0

local function onInit()
  electrics.values['disp_P'] = 0
  electrics.values['disp_N'] = 0
  electrics.values['disp_Na'] = 0
end

local function reset()
  onInit()
end

local function updateGFX(dt)
  -- تأكد إن السيارة شغالة
  local ignition = electrics.values.ignitionLevel or 0
  if ignition < 2 then
    electrics.values['disp_P'] = 0
    electrics.values['disp_N'] = 0
    electrics.values['disp_Na'] = 0
    return
  end

  gearIndex = electrics.values.gearIndex or 0
  gear_A = electrics.values['gear_A'] or 0

  -- Park (أوتوماتيك فقط)
  if gear_A < 0.05 then
    electrics.values['disp_P'] = 1
  else
    electrics.values['disp_P'] = 0
  end

  -- Neutral (يدوي)
  if gearIndex >= -0.5 and gearIndex < 0.5 then
    electrics.values['disp_N'] = 1
  else
    electrics.values['disp_N'] = 0
  end

  -- Neutral (أوتوماتيك)
  if gear_A >= 0.15 and gear_A < 0.25 then
    electrics.values['disp_Na'] = 1
  else
    electrics.values['disp_Na'] = 0
  end
end

-- public interface
M.onInit    = onInit
M.reset     = reset
M.updateGFX = updateGFX

return M
