local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local electricsName = nil
local isWarning = false
local beepLoopName = nil
local beepLoop = nil
local beepVolume = 1
local tick = 0
local soundNode = 0
local isPlaying = false  -- متغير للتحقق إذا كان الصوت قد تم تشغيله بالفعل

local function updateGFX(dt)
  tick = tick + dt
  if tick >= 0.5 then
    tick = 0
    local wheelspeed = electrics.values.wheelspeed or 0

    if wheelspeed > 50 and wheelspeed < 88.888 then
      if not isPlaying then  -- تحقق إذا كان الصوت غير مشغل بالفعل
        obj:setVolume(beepLoop, beepVolume)
        obj:cutSFX(beepLoop)
        obj:playSFX(beepLoop)
        isPlaying = true  -- تعيين أن الصوت يتم تشغيله
        isWarning = true
      end
    else
      if isPlaying then  -- تحقق إذا كان الصوت مشغل بالفعل
        obj:stopSFX(beepLoop)
        isPlaying = false  -- تعيين أن الصوت تم إيقافه
        isWarning = false
      end
    end
  end
end

local function reset()
  isWarning = false
  tick = 0
  isPlaying = false  -- إعادة تعيين حالة التشغيل عند إعادة التعيين
end

local function init(jbeamData)
  electricsName = "wheelspeed"
  beepLoopName = jbeamData.beepLoopName or "art/sound/AhMeD711_antl.wav"
  beepVolume = jbeamData.beepVolume or 1

  if jbeamData.soundNode_nodes and type(jbeamData.soundNode_nodes) == "table" and type(jbeamData.soundNode_nodes[1]) == "number" then
    soundNode = jbeamData.soundNode_nodes[1]
  else
    soundNode = 0
  end

  isWarning = false
  isPlaying = false  -- تعيين المتغير عند التهيئة
end

local function initSounds()
  beepLoop = obj:createSFXSource2(beepLoopName, "AudioDefaultLoop3D", "180kphBeep", soundNode, 0)
end

M.init = init
M.initSounds = initSounds
M.reset = reset
M.updateGFX = updateGFX

return M
