local M = {}

local flashInterval = 0.5  -- الفاصل الزمني للوميض
local timeElapsed = 0      -- الوقت المنقضي لوميض اللمبة
local totalEngineTime = 0  -- الوقت الإجمالي منذ تشغيل المحرك
local isFlashing = false   -- حالة الوميض

local function updateGFX(dt)
    local running = electrics.values.running
    local ignition = electrics.values.ignitionLevel or 0

    if ignition < 2 then
        -- السيارة طافية بالكامل
        electrics.values.SeatbeltLight = 0
        isFlashing = false
        timeElapsed = 0
        totalEngineTime = 0
        return
    end

    if running then
        totalEngineTime = totalEngineTime + dt

        if totalEngineTime <= 15 then
            timeElapsed = timeElapsed + dt

            if timeElapsed >= flashInterval then
                isFlashing = not isFlashing
                electrics.values.SeatbeltLight = isFlashing and 1 or 0
                timeElapsed = 0
            end
        else
            electrics.values.SeatbeltLight = 1
        end
    else
        -- إذا السيارة على السلف لكن المحرك مو شغال
        electrics.values.SeatbeltLight = 0
        isFlashing = false
        timeElapsed = 0
        totalEngineTime = 0
    end
end

M.updateGFX = updateGFX

return M
