-- Script to play a chime sound when the engine starts (engineRunning = 1)

local M = {}

local soundConfig = {
  ignition_chime = {
    path = "/vehicles/QE1_SIERRA_24/art/sound/QE1sierra_13rstart_sound.wav",
    description = "Audio2D",
    volume = 6,
    pitch = 1
  }
}

local driverNodeCid = 0
local camPos
local combinedPos
local isInside = false
local chimePlayed = false
local chimeCount = 0
local chimeTimer = 0
local chimeInterval = 1

local function isCamInside()
  camPos = obj:getCameraPosition()
  if driverNodeCid and driverNodeCid > 0 then
    combinedPos = obj:getPosition() + obj:getNodePosition(driverNodeCid)
    isInside = combinedPos and (camPos:distance(combinedPos) <= 0.6) or false
  else
    isInside = false
  end
  return isInside
end

local function updateGFX(dt)
  if isCamInside() then
    if electrics.values.ignitionLevel >= 2 and not chimePlayed and not chimePlayed then
      chimeCount = 0
      chimeTimer = 0
      chimePlayed = true
    elseif electrics.values.ignitionLevel < 2 then
      chimePlayed = false
    end
  end
  
  if chimePlayed and chimeCount < 5 then
    chimeTimer = chimeTimer + dt
    if chimeTimer >= chimeInterval then
      obj:playSFXOnce(soundConfig.ignition_chime.name, driverNodeCid, soundConfig.ignition_chime.volume, soundConfig.ignition_chime.pitch)
      chimeCount = chimeCount + 1
      chimeTimer = 0
    end
  end
end

local function onInit()
  driverNodeCid = beamstate.nodeNameMap and beamstate.nodeNameMap["driver"]
if not driverNodeCid then driverNodeCid = 0 end

  local osTime = tostring(os.time())
  for k, v in pairs(soundConfig) do
    local uniqueName = "custom_" .. osTime .. "_" .. k
    soundConfig[k] = {
      sound = obj:createSFXSource(v.path, v.description, uniqueName, -1),
      name = uniqueName,
      volume = v.volume or 1,
      pitch = v.pitch or 1,
      node = beamstate.nodeNameMap and beamstate.nodeNameMap[tostring(v.node)],
    }
  end
end

M.onInit = onInit
M.updateGFX = updateGFX

return M
