local M = {}
M.type = "auxiliary"

local slideSmoother = nil
local tiltSmoother = nil

local tilt_sunroof_var = 0
local slide_sunroof_var = 0

local function init()
    slideSmoother = newTemporalSmoothing(0.25, 0.25)
    tiltSmoother = newTemporalSmoothing(1.0, 1.0)
end

local function reset()
    electrics.values.lifter = 0
    electrics.values.lifter_input = 0

    electrics.values.slide_sunroof = 0.0
    electrics.values.tilt_sunroof = 0.0
    electrics.values.sunroof_position = 0.0

    tilt_sunroof_var = 0
    slide_sunroof_var = 0
end

local function updateGFX(dt)
    electrics.values.lifter = electrics.values.lifter_input

    if electrics.values.sunroof_position < -1.0 then
        electrics.values.sunroof_position = -1.0
    end
    if electrics.values.sunroof_position > 2.0 then
        electrics.values.sunroof_position = 2.0
    end

    if electrics.values.sunroof_position == -1 then
        if electrics.values.slide_sunroof == 0.0 then
            tilt_sunroof_var = 1.0
            slide_sunroof_var = 0.0
        end
    end
    if electrics.values.sunroof_position == 0 then
        if electrics.values.slide_sunroof == 0.0 then
            tilt_sunroof_var = 0.0
        end
        slide_sunroof_var = 0.0
    end
   
    electrics.values.tilt_sunroof = tiltSmoother:getUncapped(tilt_sunroof_var, dt)
    electrics.values.slide_sunroof = slideSmoother:getUncapped(slide_sunroof_var, dt)

end

M.onInit    = init
M.onReset   = reset
M.updateGFX = updateGFX

return M