//-----------------------------------------------------------------------------
// Copyright (c) 2012 GarageGames, LLC
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//-----------------------------------------------------------------------------

// This is the default save location for any ForestBrush(s) created in 
// the Forest Editor.
// This script is executed from ForestEditorPlugin::onWorldEditorStartup().

//--- OBJECT WRITE BEGIN ---
new SimGroup(ForestBrushGroup) {
   canSave = "1";
   canSaveDynamicFields = "1";

   new ForestBrush() {
      internalName = "Bushes_huge";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_beech_bush_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_e";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_e";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.32";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Bushes_large";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_oak_bush_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_bush_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_bush_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_bush_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_bush_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_b";
         probability = "3";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.3";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_bush_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_c";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Bushes_small";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_aspen_bush_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_a";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_bush_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_bush_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "rocks_01_a_large";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "rock_01_a_large_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "rocks_01_a_small";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "rock_01_a_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "LargerBushes";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "LargerBushes";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_blocker_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Rock";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tunnelrock";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "DRI_rock_c";
         probability = "1";
         rotationRange = "120";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tunneltopper";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "DRI_rock_f";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "trees";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "Element";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
};
//--- OBJECT WRITE END ---
