-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

-- Reset the electric values for all actions
local function onReset()
  electrics.values['air_sus2'] = 0
  electrics.values['air_sus2_input'] = 0
end

local function updateLifterValue(lifterKey, inputKey, dt)
  electrics.values[lifterKey] = math.min(1, math.max(0, electrics.values[lifterKey] + electrics.values[inputKey] * dt * 0.2))
end

local function updateGFX(dt) 
  updateLifterValue('air_sus2', 'air_sus2_input', dt)

end

local function air_sus22(wheel, value)
    electrics.values.air_sus2_input = value

end


M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.air_sus22 = air_sus22

return M
