local M = {}
M.type = "auxilliary"
M.relevantDevice = nil

local driverHealth = nil
local driverDeformGroup = nil
local driverState = "healthy"

local function updateGFX(dt) 
	--Check if driver has been "damaged"
    driverHealth = beamstate.deformGroupDamage[driverDeformGroup] and beamstate.deformGroupDamage[driverDeformGroup].damage or 0
	if driverHealth >= 0.01 and driverState == "healthy" then
		guihooks.message("Driver hurt", 4, "vehicle.vertexDriver.ouchies", "mood_bad") 
		driverState = "ouch"
	end
end

local function init(jbeamData) 
	--Get deformGroup name for panel damage
	driverDeformGroup = jbeamData.driverDeformGroup or "driver"
	driverState = "healthy"
end

local function reset() 
	driverState = "healthy"
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX

return M